/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifEquationUtils {
    private CifEquationUtils() {
    }

    public static List<Equation> getEquations(PositionObject var) {
        Assert.check((var instanceof AlgVariable || var instanceof ContVariable ? 1 : 0) != 0);
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        for (Equation eq : comp.getEquations()) {
            if (eq.getVariable() != var) continue;
            return Lists.list((Object)eq);
        }
        if (!(comp instanceof Automaton)) {
            return Lists.list();
        }
        Automaton aut = (Automaton)comp;
        List eqns = Lists.listc((int)aut.getLocations().size());
        block1: for (Location loc : aut.getLocations()) {
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                eqns.add(eq);
                continue block1;
            }
        }
        return eqns;
    }

    public static List<Expression> getValuesForAlgVar(AlgVariable var, boolean allowIncomplete) {
        if (var.getValue() != null) {
            return Lists.list((Object)var.getValue());
        }
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        for (Equation eq : comp.getEquations()) {
            if (eq.getVariable() != var) continue;
            return Lists.list((Object)eq.getValue());
        }
        if (!(comp instanceof Automaton)) {
            if (!allowIncomplete) {
                String msg = "No value found for alg var: " + var;
                throw new RuntimeException(msg);
            }
            return Lists.list();
        }
        Automaton aut = (Automaton)comp;
        List values = Lists.listc((int)aut.getLocations().size());
        for (Location loc : aut.getLocations()) {
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                values.add(eq.getValue());
                found = true;
                break;
            }
            if (found || allowIncomplete) continue;
            String msg = "No value found for alg var: " + var;
            throw new RuntimeException(msg);
        }
        return values;
    }

    public static List<Expression> getDerivativesForContVar(ContVariable var, boolean allowIncomplete) {
        if (var.getDerivative() != null) {
            return Lists.list((Object)var.getDerivative());
        }
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        for (Equation eq : comp.getEquations()) {
            if (eq.getVariable() != var) continue;
            return Lists.list((Object)eq.getValue());
        }
        if (!(comp instanceof Automaton)) {
            if (!allowIncomplete) {
                String msg = "No der found for cont var: " + var;
                throw new RuntimeException(msg);
            }
            return Lists.list();
        }
        Automaton aut = (Automaton)comp;
        List values = Lists.listc((int)aut.getLocations().size());
        for (Location loc : aut.getLocations()) {
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                values.add(eq.getValue());
                found = true;
                break;
            }
            if (found || allowIncomplete) continue;
            String msg = "No der found for cont var: " + var;
            throw new RuntimeException(msg);
        }
        return values;
    }

    public static Expression getSingleValueForAlgVar(AlgVariable var) {
        if (var.getValue() != null) {
            return var.getValue();
        }
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        for (Equation eq : comp.getEquations()) {
            if (eq.getVariable() != var) continue;
            return eq.getValue();
        }
        Automaton aut = (Automaton)comp;
        List values = Lists.listc((int)aut.getLocations().size());
        for (Location loc : aut.getLocations()) {
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                values.add(eq.getValue());
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("No value found for alg var: " + var);
        }
        if (values.size() == 1) {
            return (Expression)Lists.first((List)values);
        }
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType((CifType)EMFHelper.deepclone((EObject)var.getType()));
        Location loc0 = (Location)Lists.first((List)aut.getLocations());
        Expression value0 = (Expression)Lists.first((List)values);
        LocationExpression guard0 = CifConstructors.newLocationExpression();
        guard0.setType((CifType)CifConstructors.newBoolType());
        guard0.setLocation(loc0);
        ifExpr.getGuards().add((Object)guard0);
        ifExpr.setThen((Expression)EMFHelper.deepclone((EObject)value0));
        int i = 1;
        while (i < values.size() - 1) {
            Location loc = (Location)aut.getLocations().get(i);
            Expression value = (Expression)values.get(i);
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            ifExpr.getElifs().add((Object)elifExpr);
            LocationExpression guard = CifConstructors.newLocationExpression();
            guard.setType((CifType)CifConstructors.newBoolType());
            guard.setLocation(loc);
            elifExpr.getGuards().add((Object)guard);
            elifExpr.setThen((Expression)EMFHelper.deepclone((EObject)value));
            ++i;
        }
        ifExpr.setElse((Expression)EMFHelper.deepclone((EObject)((Expression)Lists.last((List)values))));
        return ifExpr;
    }

    public static Expression getSingleDerivativeForContVar(ContVariable var) {
        if (var.getDerivative() != null) {
            return var.getDerivative();
        }
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        for (Equation eq : comp.getEquations()) {
            if (eq.getVariable() != var) continue;
            return eq.getValue();
        }
        Automaton aut = (Automaton)comp;
        List values = Lists.listc((int)aut.getLocations().size());
        for (Location loc : aut.getLocations()) {
            boolean found = false;
            for (Equation eq : loc.getEquations()) {
                if (eq.getVariable() != var) continue;
                values.add(eq.getValue());
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("No der found for cont var: " + var);
        }
        if (values.size() == 1) {
            return (Expression)Lists.first((List)values);
        }
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType((CifType)CifConstructors.newRealType());
        Location loc0 = (Location)Lists.first((List)aut.getLocations());
        Expression value0 = (Expression)Lists.first((List)values);
        LocationExpression guard0 = CifConstructors.newLocationExpression();
        guard0.setType((CifType)CifConstructors.newBoolType());
        guard0.setLocation(loc0);
        ifExpr.getGuards().add((Object)guard0);
        ifExpr.setThen((Expression)EMFHelper.deepclone((EObject)value0));
        int i = 1;
        while (i < values.size() - 1) {
            Location loc = (Location)aut.getLocations().get(i);
            Expression value = (Expression)values.get(i);
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            ifExpr.getElifs().add((Object)elifExpr);
            LocationExpression guard = CifConstructors.newLocationExpression();
            guard.setType((CifType)CifConstructors.newBoolType());
            guard.setLocation(loc);
            elifExpr.getGuards().add((Object)guard);
            elifExpr.setThen((Expression)EMFHelper.deepclone((EObject)value));
            ++i;
        }
        ifExpr.setElse((Expression)EMFHelper.deepclone((EObject)((Expression)Lists.last((List)values))));
        return ifExpr;
    }

    public static boolean hasLocationEquations(PositionObject var) {
        Assert.check((var instanceof AlgVariable || var instanceof ContVariable ? 1 : 0) != 0);
        ComplexComponent comp = (ComplexComponent)var.eContainer();
        if (!(comp instanceof Automaton)) {
            return false;
        }
        Automaton aut = (Automaton)comp;
        Location loc = (Location)Lists.first((List)aut.getLocations());
        for (Equation eq : loc.getEquations()) {
            if (eq.getVariable() != var) continue;
            return true;
        }
        return false;
    }
}

