/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.Associativity;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BaseFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.parser.CifScanner;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifTextUtils {
    private static Set<String> keywords = null;

    private CifTextUtils() {
    }

    public static final Set<String> getKeywords() {
        String kw;
        Set rslt = keywords;
        if (rslt != null) {
            return rslt;
        }
        rslt = Sets.set();
        String[] stringArray = CifScanner.getKeywords((String)"Keywords");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            rslt.add(kw);
            ++n2;
        }
        stringArray = CifScanner.getKeywords((String)"SupKind");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            rslt.add(kw);
            ++n2;
        }
        stringArray = CifScanner.getKeywords((String)"StdLibFunction");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            rslt.add(kw);
            ++n2;
        }
        stringArray = CifScanner.getKeywords((String)"Operator");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            kw = stringArray[n2];
            rslt.add(kw);
            ++n2;
        }
        keywords = rslt;
        return rslt;
    }

    public static String escapeIdentifier(String id) {
        return CifTextUtils.getKeywords().contains(id) ? "$" + id : id;
    }

    public static String kindToStr(SupKind kind) {
        Assert.check((kind != SupKind.NONE ? 1 : 0) != 0);
        return kind.getName().toLowerCase(Locale.US);
    }

    public static String controllabilityToStr(Boolean ctrl) {
        return ctrl == null ? "event" : (ctrl != false ? "controllable" : "uncontrollable");
    }

    public static String typeToStr(CifType type) {
        if (type instanceof BoolType) {
            return "bool";
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless(itype)) {
                return "int";
            }
            return Strings.fmt((String)"int[%s..%s]", (Object[])new Object[]{Numbers.formatNumber((int)itype.getLower()), Numbers.formatNumber((int)itype.getUpper())});
        }
        if (type instanceof TypeRef) {
            return CifTextUtils.typeToStr(((TypeRef)type).getType().getType());
        }
        if (type instanceof EnumType) {
            EnumType etype = (EnumType)type;
            EnumDecl edecl = etype.getEnum();
            return CifTextUtils.getAbsName((PositionObject)edecl);
        }
        if (type instanceof RealType) {
            return "real";
        }
        if (type instanceof StringType) {
            return "string";
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            String elemTxt = CifTextUtils.typeToStr(ltype.getElementType());
            if (CifTypeUtils.isRangeless(ltype)) {
                return "list " + elemTxt;
            }
            if (ltype.getLower().equals(ltype.getUpper())) {
                return Strings.fmt((String)"list[%s] %s", (Object[])new Object[]{Numbers.formatNumber((int)ltype.getLower()), elemTxt});
            }
            return Strings.fmt((String)"list[%s..%s] %s", (Object[])new Object[]{Numbers.formatNumber((int)ltype.getLower()), Numbers.formatNumber((int)ltype.getUpper()), elemTxt});
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            return "set " + CifTextUtils.typeToStr(stype.getElementType());
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            List paramTypes = Lists.listc((int)ftype.getParamTypes().size());
            for (CifType paramType : ftype.getParamTypes()) {
                paramTypes.add(CifTextUtils.typeToStr(paramType));
            }
            return "func " + CifTextUtils.typeToStr(ftype.getReturnType()) + "(" + StringUtils.join((Collection)paramTypes, (String)", ") + ")";
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            return "dict(" + CifTextUtils.typeToStr(dtype.getKeyType()) + ":" + CifTextUtils.typeToStr(dtype.getValueType()) + ")";
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            List fields = Lists.listc((int)ttype.getFields().size());
            for (Field field : ttype.getFields()) {
                String ftype = CifTextUtils.typeToStr(field.getType());
                if (field.getName() == null) {
                    fields.add(ftype);
                    continue;
                }
                fields.add(String.valueOf(ftype) + " " + field.getName());
            }
            return "tuple(" + StringUtils.join((Collection)fields, (String)"; ") + ")";
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            return "dist " + CifTextUtils.typeToStr(dtype.getSampleType());
        }
        if (type instanceof ComponentDefType) {
            ComponentDefType dtype = (ComponentDefType)type;
            ComponentDef cdef = dtype.getDefinition();
            return CifTextUtils.getAbsName((PositionObject)cdef);
        }
        if (type instanceof ComponentType) {
            ComponentType ctype = (ComponentType)type;
            Component component = ctype.getComponent();
            return CifTextUtils.getAbsName((PositionObject)component);
        }
        if (type instanceof CompInstWrapType) {
            return CifTextUtils.typeToStr(((CompInstWrapType)type).getReference());
        }
        if (type instanceof CompParamWrapType) {
            return CifTextUtils.typeToStr(((CompParamWrapType)type).getReference());
        }
        if (type instanceof VoidType) {
            return "void";
        }
        throw new RuntimeException("Unknown CIF type: " + type);
    }

    public static String exprsToStr(List<Expression> exprs) {
        List txts = Lists.listc((int)exprs.size());
        for (Expression expr : exprs) {
            txts.add(CifTextUtils.exprToStr(expr));
        }
        return StringUtils.join((Collection)txts, (String)", ");
    }

    public static String exprToStr(Expression expr) {
        if (expr instanceof BoolExpression) {
            boolean value = ((BoolExpression)expr).isValue();
            return CifMath.boolToStr(value);
        }
        if (expr instanceof IntExpression) {
            int value = ((IntExpression)expr).getValue();
            return CifMath.intToStr(value);
        }
        if (expr instanceof RealExpression) {
            String value = ((RealExpression)expr).getValue();
            return value;
        }
        if (expr instanceof StringExpression) {
            String value = ((StringExpression)expr).getValue();
            return "\"" + Strings.escape((String)value) + "\"";
        }
        if (expr instanceof TimeExpression) {
            return "time";
        }
        if (expr instanceof CastExpression) {
            int childStrength;
            CastExpression cexpr = (CastExpression)expr;
            String childTxt = CifTextUtils.exprToStr(cexpr.getChild());
            int castStrength = CifTextUtils.getBindingStrength(expr);
            if (castStrength > (childStrength = CifTextUtils.getBindingStrength(cexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            return "<" + CifTextUtils.typeToStr(cexpr.getType()) + ">" + childTxt;
        }
        if (expr instanceof UnaryExpression) {
            int childStrength;
            UnaryExpression uexpr = (UnaryExpression)expr;
            String childTxt = CifTextUtils.exprToStr(uexpr.getChild());
            String opTxt = CifTextUtils.operatorToStr(uexpr.getOperator());
            int opStrength = CifTextUtils.getBindingStrength(expr);
            if (opStrength > (childStrength = CifTextUtils.getBindingStrength(uexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            } else if (StringUtils.isAlpha((String)StringUtils.right((String)opTxt, (int)1))) {
                opTxt = String.valueOf(opTxt) + " ";
            }
            return String.valueOf(opTxt) + childTxt;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            BinaryOperator op = bexpr.getOperator();
            String opTxt = CifTextUtils.operatorToStr(op);
            int opStrength = CifTextUtils.getBindingStrength(expr);
            int leftStrength = CifTextUtils.getBindingStrength(bexpr.getLeft());
            int rightStrength = CifTextUtils.getBindingStrength(bexpr.getRight());
            String leftTxt = CifTextUtils.exprToStr(bexpr.getLeft());
            if (opStrength > leftStrength || opStrength == leftStrength && CifTextUtils.getAssociativity(op) != Associativity.LEFT) {
                leftTxt = "(" + leftTxt + ")";
            }
            String rightTxt = CifTextUtils.exprToStr(bexpr.getRight());
            if (opStrength > rightStrength || opStrength == rightStrength && CifTextUtils.getAssociativity(op) != Associativity.RIGHT) {
                rightTxt = "(" + rightTxt + ")";
            }
            return String.valueOf(leftTxt) + " " + opTxt + " " + rightTxt;
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            StringBuilder txt = new StringBuilder();
            txt.append("if ");
            txt.append(CifTextUtils.exprsToStr((List<Expression>)ifExpr.getGuards()));
            txt.append(": ");
            txt.append(CifTextUtils.exprToStr(ifExpr.getThen()));
            for (ElifExpression elif : ifExpr.getElifs()) {
                txt.append(" elif ");
                txt.append(CifTextUtils.exprsToStr((List<Expression>)elif.getGuards()));
                txt.append(": ");
                txt.append(CifTextUtils.exprToStr(elif.getThen()));
            }
            txt.append(" else ");
            txt.append(CifTextUtils.exprToStr(ifExpr.getElse()));
            txt.append(" end");
            return txt.toString();
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            boolean autRef = CifTypeUtils.isAutRefExpr(switchExpr.getValue());
            StringBuilder txt = new StringBuilder();
            txt.append("switch ");
            txt.append(CifTextUtils.exprToStr(switchExpr.getValue()));
            txt.append(": ");
            for (SwitchCase cse : switchExpr.getCases()) {
                Expression key = cse.getKey();
                if (key == null) {
                    txt.append("else ");
                } else {
                    txt.append("case ");
                    if (autRef) {
                        Expression locRef = CifTypeUtils.unwrapExpression(key);
                        Location loc = ((LocationExpression)locRef).getLocation();
                        String locName = loc.getName();
                        Assert.notNull((Object)locName);
                        txt.append(CifTextUtils.escapeIdentifier(locName));
                    } else {
                        txt.append(CifTextUtils.exprToStr(key));
                    }
                    txt.append(": ");
                }
                txt.append(CifTextUtils.exprToStr(cse.getValue()));
                txt.append(" ");
            }
            txt.append("end");
            return txt.toString();
        }
        if (expr instanceof ProjectionExpression) {
            int childStrength;
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            String childTxt = CifTextUtils.exprToStr(pexpr.getChild());
            int projStrength = CifTextUtils.getBindingStrength(expr);
            if (projStrength > (childStrength = CifTextUtils.getBindingStrength(pexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            return String.valueOf(childTxt) + "[" + CifTextUtils.exprToStr(pexpr.getIndex()) + "]";
        }
        if (expr instanceof SliceExpression) {
            int childStrength;
            SliceExpression sexpr = (SliceExpression)expr;
            String childTxt = CifTextUtils.exprToStr(sexpr.getChild());
            int sliceStrength = CifTextUtils.getBindingStrength(expr);
            if (sliceStrength > (childStrength = CifTextUtils.getBindingStrength(sexpr.getChild()))) {
                childTxt = "(" + childTxt + ")";
            }
            StringBuilder txt = new StringBuilder();
            txt.append(childTxt);
            txt.append("[");
            if (sexpr.getBegin() != null) {
                txt.append(CifTextUtils.exprToStr(sexpr.getBegin()));
            }
            txt.append(":");
            if (sexpr.getEnd() != null) {
                txt.append(CifTextUtils.exprToStr(sexpr.getEnd()));
            }
            txt.append("]");
            return txt.toString();
        }
        if (expr instanceof FunctionCallExpression) {
            int funcStrength;
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            String funcTxt = CifTextUtils.exprToStr(fexpr.getFunction());
            int callStrength = CifTextUtils.getBindingStrength(expr);
            if (callStrength > (funcStrength = CifTextUtils.getBindingStrength(fexpr.getFunction()))) {
                funcTxt = "(" + funcTxt + ")";
            }
            return String.valueOf(funcTxt) + "(" + CifTextUtils.exprsToStr((List<Expression>)fexpr.getParams()) + ")";
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            return "[" + CifTextUtils.exprsToStr((List<Expression>)lexpr.getElements()) + "]";
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            return "{" + CifTextUtils.exprsToStr((List<Expression>)sexpr.getElements()) + "}";
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            return "(" + CifTextUtils.exprsToStr((List<Expression>)texpr.getFields()) + ")";
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            StringBuilder txt = new StringBuilder();
            txt.append("{");
            boolean first = true;
            for (DictPair pair : dexpr.getPairs()) {
                if (first) {
                    first = false;
                } else {
                    txt.append(", ");
                }
                txt.append(CifTextUtils.exprToStr(pair.getKey()));
                txt.append(": ");
                txt.append(CifTextUtils.exprToStr(pair.getValue()));
            }
            txt.append("}");
            return txt.toString();
        }
        if (expr instanceof ConstantExpression) {
            Constant refObj = ((ConstantExpression)expr).getConstant();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable refObj = ((DiscVariableExpression)expr).getVariable();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable refObj = ((AlgVariableExpression)expr).getVariable();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cvexpr = (ContVariableExpression)expr;
            ContVariable refObj = cvexpr.getVariable();
            String rslt = CifTextUtils.getAbsName((PositionObject)refObj);
            if (cvexpr.isDerivative()) {
                rslt = String.valueOf(rslt) + "'";
            }
            return rslt;
        }
        if (expr instanceof TauExpression) {
            return "tau";
        }
        if (expr instanceof LocationExpression) {
            Location refObj = ((LocationExpression)expr).getLocation();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral refObj = ((EnumLiteralExpression)expr).getLiteral();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof EventExpression) {
            Event refObj = ((EventExpression)expr).getEvent();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof FieldExpression) {
            Field field = ((FieldExpression)expr).getField();
            Assert.notNull((Object)field.getName());
            return field.getName();
        }
        if (expr instanceof StdLibFunctionExpression) {
            StdLibFunctionExpression fexpr = (StdLibFunctionExpression)expr;
            return CifTextUtils.functionToStr(fexpr.getFunction());
        }
        if (expr instanceof FunctionExpression) {
            Function refObj = ((FunctionExpression)expr).getFunction();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable refObj = ((InputVariableExpression)expr).getVariable();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof ComponentExpression) {
            Component refObj = ((ComponentExpression)expr).getComponent();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof CompParamExpression) {
            ComponentParameter refObj = ((CompParamExpression)expr).getParameter();
            return CifTextUtils.getAbsName((PositionObject)refObj);
        }
        if (expr instanceof CompInstWrapExpression) {
            CompInstWrapExpression wrapper = (CompInstWrapExpression)expr;
            return CifTextUtils.exprToStr(wrapper.getReference());
        }
        if (expr instanceof CompParamWrapExpression) {
            CompParamWrapExpression wrapper = (CompParamWrapExpression)expr;
            return CifTextUtils.exprToStr(wrapper.getReference());
        }
        if (expr instanceof ReceivedExpression) {
            return "?";
        }
        if (expr instanceof SelfExpression) {
            return "self";
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static String operatorToStr(UnaryOperator op) {
        switch (op) {
            case INVERSE: {
                return "not";
            }
            case NEGATE: {
                return "-";
            }
            case PLUS: {
                return "+";
            }
            case SAMPLE: {
                return "sample";
            }
        }
        throw new RuntimeException("Unknown unop: " + op);
    }

    public static String operatorToStr(BinaryOperator op) {
        switch (op) {
            case ADDITION: {
                return "+";
            }
            case BI_CONDITIONAL: {
                return "<=>";
            }
            case CONJUNCTION: {
                return "and";
            }
            case DISJUNCTION: {
                return "or";
            }
            case DIVISION: {
                return "/";
            }
            case ELEMENT_OF: {
                return "in";
            }
            case EQUAL: {
                return "=";
            }
            case GREATER_EQUAL: {
                return ">=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case IMPLICATION: {
                return "=>";
            }
            case INTEGER_DIVISION: {
                return "div";
            }
            case LESS_EQUAL: {
                return "<=";
            }
            case LESS_THAN: {
                return "<";
            }
            case MODULUS: {
                return "mod";
            }
            case MULTIPLICATION: {
                return "*";
            }
            case SUBSET: {
                return "sub";
            }
            case SUBTRACTION: {
                return "-";
            }
            case UNEQUAL: {
                return "!=";
            }
        }
        throw new RuntimeException("Unknown binop: " + op);
    }

    public static String functionToStr(StdLibFunction func) {
        switch (func) {
            case ACOSH: {
                return "acosh";
            }
            case ACOS: {
                return "acos";
            }
            case ASINH: {
                return "asinh";
            }
            case ASIN: {
                return "asin";
            }
            case ATANH: {
                return "atanh";
            }
            case ATAN: {
                return "atan";
            }
            case COSH: {
                return "cosh";
            }
            case COS: {
                return "cos";
            }
            case SINH: {
                return "sinh";
            }
            case SIN: {
                return "sin";
            }
            case TANH: {
                return "tanh";
            }
            case TAN: {
                return "tan";
            }
            case ABS: {
                return "abs";
            }
            case CBRT: {
                return "cbrt";
            }
            case CEIL: {
                return "ceil";
            }
            case DELETE: {
                return "del";
            }
            case EMPTY: {
                return "empty";
            }
            case EXP: {
                return "exp";
            }
            case FLOOR: {
                return "floor";
            }
            case FORMAT: {
                return "fmt";
            }
            case LN: {
                return "ln";
            }
            case LOG: {
                return "log";
            }
            case MAXIMUM: {
                return "max";
            }
            case MINIMUM: {
                return "min";
            }
            case POP: {
                return "pop";
            }
            case POWER: {
                return "pow";
            }
            case ROUND: {
                return "round";
            }
            case SCALE: {
                return "scale";
            }
            case SIGN: {
                return "sign";
            }
            case SIZE: {
                return "size";
            }
            case SQRT: {
                return "sqrt";
            }
            case BERNOULLI: {
                return "bernoulli";
            }
            case BETA: {
                return "beta";
            }
            case BINOMIAL: {
                return "binomial";
            }
            case CONSTANT: {
                return "constant";
            }
            case ERLANG: {
                return "erlang";
            }
            case EXPONENTIAL: {
                return "exponential";
            }
            case GAMMA: {
                return "gamma";
            }
            case GEOMETRIC: {
                return "geometric";
            }
            case LOG_NORMAL: {
                return "lognormal";
            }
            case NORMAL: {
                return "normal";
            }
            case POISSON: {
                return "poisson";
            }
            case RANDOM: {
                return "random";
            }
            case TRIANGLE: {
                return "triangle";
            }
            case UNIFORM: {
                return "uniform";
            }
            case WEIBULL: {
                return "weibull";
            }
        }
        throw new RuntimeException("Unknown stdlib: " + func);
    }

    public static Associativity getAssociativity(BinaryOperator op) {
        switch (op) {
            case ADDITION: {
                return Associativity.LEFT;
            }
            case BI_CONDITIONAL: {
                return Associativity.NONE;
            }
            case CONJUNCTION: {
                return Associativity.LEFT;
            }
            case DISJUNCTION: {
                return Associativity.LEFT;
            }
            case DIVISION: {
                return Associativity.LEFT;
            }
            case ELEMENT_OF: {
                return Associativity.LEFT;
            }
            case EQUAL: {
                return Associativity.LEFT;
            }
            case GREATER_EQUAL: {
                return Associativity.LEFT;
            }
            case GREATER_THAN: {
                return Associativity.LEFT;
            }
            case IMPLICATION: {
                return Associativity.NONE;
            }
            case INTEGER_DIVISION: {
                return Associativity.LEFT;
            }
            case LESS_EQUAL: {
                return Associativity.LEFT;
            }
            case LESS_THAN: {
                return Associativity.LEFT;
            }
            case MODULUS: {
                return Associativity.LEFT;
            }
            case MULTIPLICATION: {
                return Associativity.LEFT;
            }
            case SUBSET: {
                return Associativity.LEFT;
            }
            case SUBTRACTION: {
                return Associativity.LEFT;
            }
            case UNEQUAL: {
                return Associativity.LEFT;
            }
        }
        throw new RuntimeException("Unknown binop: " + op);
    }

    public static int getBindingStrength(Expression expr) {
        if (expr instanceof BoolExpression) {
            return 8;
        }
        if (expr instanceof IntExpression) {
            return 8;
        }
        if (expr instanceof RealExpression) {
            return 8;
        }
        if (expr instanceof StringExpression) {
            return 8;
        }
        if (expr instanceof TimeExpression) {
            return 8;
        }
        if (expr instanceof CastExpression) {
            return 8;
        }
        if (expr instanceof ReceivedExpression) {
            return 8;
        }
        if (expr instanceof UnaryExpression) {
            UnaryOperator op = ((UnaryExpression)expr).getOperator();
            switch (op) {
                case INVERSE: {
                    return 6;
                }
                case NEGATE: {
                    return 6;
                }
                case PLUS: {
                    return 6;
                }
                case SAMPLE: {
                    return 6;
                }
            }
            throw new RuntimeException("Unknown unary op: " + op);
        }
        if (expr instanceof BinaryExpression) {
            BinaryOperator op = ((BinaryExpression)expr).getOperator();
            switch (op) {
                case IMPLICATION: 
                case BI_CONDITIONAL: {
                    return 0;
                }
                case DISJUNCTION: {
                    return 1;
                }
                case CONJUNCTION: {
                    return 2;
                }
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: 
                case SUBSET: 
                case ELEMENT_OF: {
                    return 3;
                }
                case SUBTRACTION: 
                case ADDITION: {
                    return 4;
                }
                case MODULUS: 
                case INTEGER_DIVISION: 
                case MULTIPLICATION: 
                case DIVISION: {
                    return 5;
                }
            }
            throw new RuntimeException("Unknown unary op: " + op);
        }
        if (expr instanceof IfExpression) {
            return 8;
        }
        if (expr instanceof SwitchExpression) {
            return 8;
        }
        if (expr instanceof ProjectionExpression) {
            return 7;
        }
        if (expr instanceof SliceExpression) {
            return 7;
        }
        if (expr instanceof FunctionCallExpression) {
            return 7;
        }
        if (expr instanceof ListExpression || expr instanceof SetExpression || expr instanceof TupleExpression || expr instanceof DictExpression) {
            return 8;
        }
        if (expr instanceof ConstantExpression || expr instanceof DiscVariableExpression || expr instanceof AlgVariableExpression || expr instanceof ContVariableExpression || expr instanceof TauExpression || expr instanceof LocationExpression || expr instanceof EnumLiteralExpression || expr instanceof EventExpression || expr instanceof FieldExpression || expr instanceof BaseFunctionExpression || expr instanceof InputVariableExpression || expr instanceof ComponentExpression || expr instanceof CompParamExpression || expr instanceof CompInstWrapExpression || expr instanceof CompParamWrapExpression || expr instanceof SelfExpression) {
            return 8;
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static String invToStr(Invariant inv, boolean inclPrefix) {
        StringBuilder txt = new StringBuilder();
        if (inclPrefix) {
            if (inv.getSupKind() != SupKind.NONE) {
                txt.append(CifTextUtils.kindToStr(inv.getSupKind()));
                txt.append(" ");
            }
            txt.append("invariant ");
        }
        switch (inv.getInvKind()) {
            case STATE: {
                txt.append(CifTextUtils.exprToStr(inv.getPredicate()));
                return txt.toString();
            }
            case EVENT_DISABLES: {
                txt.append(CifTextUtils.exprToStr(inv.getPredicate()));
                txt.append(" disables ");
                txt.append(CifTextUtils.exprToStr(inv.getEvent()));
                return txt.toString();
            }
            case EVENT_NEEDS: {
                txt.append(CifTextUtils.exprToStr(inv.getEvent()));
                txt.append(" needs ");
                txt.append(CifTextUtils.exprToStr(inv.getPredicate()));
                return txt.toString();
            }
        }
        throw new RuntimeException("Unknown inv kind: " + inv.getInvKind());
    }

    public static String getAbsName(PositionObject obj) {
        return CifTextUtils.getAbsName(obj, true);
    }

    public static String getAbsName(PositionObject obj, boolean escape) {
        if (obj instanceof Specification) {
            return "";
        }
        String name = CifTextUtils.getName(obj);
        if (escape) {
            name = CifTextUtils.escapeIdentifier(name);
        }
        StringBuilder rslt = new StringBuilder();
        rslt.append(name);
        PositionObject parent = (PositionObject)obj.eContainer();
        if (obj instanceof ComponentParameter) {
            parent = ((ComponentDef)parent).getBody();
        } else if (parent instanceof Parameter) {
            parent = ((ComponentDef)parent.eContainer()).getBody();
        }
        while (!(parent instanceof Specification)) {
            if (parent instanceof Component || parent instanceof Function) {
                String parentName = CifTextUtils.getName(parent);
                if (escape) {
                    parentName = CifTextUtils.escapeIdentifier(parentName);
                }
                rslt.insert(0, String.valueOf(parentName) + ".");
            }
            parent = (PositionObject)parent.eContainer();
        }
        return rslt.toString();
    }

    public static String getName(PositionObject obj) {
        if (obj instanceof Component) {
            return ((Component)obj).getName();
        }
        if (obj instanceof ComponentDef) {
            return ((ComponentDef)obj).getBody().getName();
        }
        if (obj instanceof ComponentParameter) {
            return ((ComponentParameter)obj).getName();
        }
        if (obj instanceof EventParameter) {
            return ((EventParameter)obj).getEvent().getName();
        }
        if (obj instanceof LocationParameter) {
            return ((LocationParameter)obj).getLocation().getName();
        }
        if (obj instanceof AlgParameter) {
            return ((AlgParameter)obj).getVariable().getName();
        }
        if (obj instanceof Declaration) {
            return ((Declaration)obj).getName();
        }
        if (obj instanceof EnumLiteral) {
            return ((EnumLiteral)obj).getName();
        }
        if (obj instanceof Location) {
            String name = ((Location)obj).getName();
            Assert.notNull((Object)name);
            return name;
        }
        if (obj instanceof FunctionParameter) {
            return ((FunctionParameter)obj).getParameter().getName();
        }
        if (obj instanceof Field) {
            String msg = "Fields unsupported: caller should handle them as a special case.";
            throw new RuntimeException(msg);
        }
        throw new IllegalArgumentException("Unknown named obj: " + obj);
    }

    public static String getNameForRefExpr(Expression expr) {
        expr = CifTypeUtils.unwrapExpression(expr);
        PositionObject obj = CifScopeUtils.getRefObjFromRef(expr);
        return CifTextUtils.getName(obj);
    }

    public static String getLocationText1(Location loc) {
        EObject parent = loc.eContainer();
        Assert.check((boolean)(parent instanceof Automaton));
        Automaton aut = (Automaton)parent;
        if (loc.getName() != null) {
            return Strings.fmt((String)"location \"%s\" of automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getName((PositionObject)loc), CifTextUtils.getAbsName((PositionObject)aut)});
        }
        return Strings.fmt((String)"location of automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
    }

    public static String getLocationText2(Location loc) {
        EObject parent = loc.eContainer();
        Assert.check((boolean)(parent instanceof Automaton));
        Automaton aut = (Automaton)parent;
        if (loc.getName() != null) {
            return Strings.fmt((String)"location \"%s\" of automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getName((PositionObject)loc), CifTextUtils.getAbsName((PositionObject)aut)});
        }
        return Strings.fmt((String)"the location of automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
    }

    public static String getComponentText1(ComplexComponent comp) {
        if (comp instanceof Specification) {
            return "specification";
        }
        if (comp instanceof Automaton) {
            return Strings.fmt((String)"automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)comp)});
        }
        return Strings.fmt((String)"group \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)comp)});
    }

    public static String getComponentText2(ComplexComponent comp) {
        if (comp instanceof Specification) {
            return "the top level scope of the specification";
        }
        if (comp instanceof Automaton) {
            return Strings.fmt((String)"automaton \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)comp)});
        }
        return Strings.fmt((String)"group \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)comp)});
    }
}

