/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.finiteresponse;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifSortUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.controllercheck.finiteresponse.EventLoop;
import org.eclipse.escet.cif.controllercheck.finiteresponse.EventLoopSearch;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.CifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.multivaluetrees.MvSpecBuilder;
import org.eclipse.escet.cif.controllercheck.options.PrintControlLoopsOutputOption;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FiniteResponseChecker {
    private final AppEnvData env = AppEnv.getData();
    private List<Automaton> automata = Lists.list();
    private List<Declaration> variables = Lists.list();
    private Set<Event> controllableEvents = Sets.set();
    private boolean controllableEventsChanged = true;
    private Map<Event, Set<Declaration>> eventVarUpdate;
    private VarInfo[] nonCtrlIndependentVarsInfos = null;
    private Map<Event, Node> globalGuards;
    private MvSpecBuilder builder;

    public boolean checkSystem(Specification spec) {
        int oldSize;
        CifCollectUtils.collectAutomata((ComplexComponent)spec, this.automata);
        CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, this.variables);
        CifCollectUtils.collectControllableEvents((ComplexComponent)spec, this.controllableEvents);
        this.eventVarUpdate = this.collectEventVarUpdate();
        if (this.env.isTerminationRequested()) {
            return false;
        }
        if (this.automata.isEmpty()) {
            OutputProvider.warn((String)"The specification contains 0 automata.");
            OutputProvider.out();
            OutputProvider.out((String)"CONCLUSION:");
            OutputProvider.iout();
            OutputProvider.out((String)"The specification has finite response.");
            OutputProvider.dout();
            return true;
        }
        if (this.controllableEvents.isEmpty()) {
            OutputProvider.warn((String)"The specification contains 0 controllable events.");
            OutputProvider.out();
            OutputProvider.out((String)"CONCLUSION:");
            OutputProvider.iout();
            OutputProvider.out((String)"The specification has finite response.");
            OutputProvider.dout();
            return true;
        }
        boolean readIndex = false;
        boolean writeIndex = true;
        CifVarInfoBuilder cifVarInfoBuilder = new CifVarInfoBuilder(2);
        cifVarInfoBuilder.addVariablesGroupOnVariable(this.variables);
        this.builder = new MvSpecBuilder(cifVarInfoBuilder, 0, 1);
        if (this.env.isTerminationRequested()) {
            return false;
        }
        this.globalGuards = this.collectGlobalGuards(this.controllableEvents);
        if (this.env.isTerminationRequested()) {
            return false;
        }
        Iterator<Event> evtIterator = this.controllableEvents.iterator();
        while (evtIterator.hasNext()) {
            Event evt = evtIterator.next();
            Node n = this.globalGuards.get(evt);
            Assert.notNull((Object)n);
            if (n != Tree.ZERO) continue;
            evtIterator.remove();
        }
        if (this.env.isTerminationRequested()) {
            return false;
        }
        int iterationNumber = 1;
        do {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Iteration %d.", (Object[])new Object[]{iterationNumber});
            ++iterationNumber;
            oldSize = this.controllableEvents.size();
            OutputProvider.idbg();
            for (Automaton aut : this.automata) {
                this.checkAutomaton(aut);
                if (!this.env.isTerminationRequested()) continue;
                OutputProvider.ddbg();
                return false;
            }
            OutputProvider.ddbg();
        } while (oldSize != this.controllableEvents.size() && !this.controllableEvents.isEmpty());
        OutputProvider.dbg();
        OutputProvider.out((String)"CONCLUSION:");
        OutputProvider.iout();
        if (!this.controllableEvents.isEmpty()) {
            OutputProvider.out((String)"ERROR, the specification may NOT have finite response.");
            OutputProvider.out();
            OutputProvider.out((String)"At least one controllable-event loop was found.");
            if (PrintControlLoopsOutputOption.isPrintControlLoopsEnabled()) {
                OutputProvider.out((String)"The following events might still occur in a controllable-event loop:");
                OutputProvider.iout();
                List orderedEvents = Lists.set2list(this.controllableEvents);
                CifSortUtils.sortCifObjects((List)orderedEvents);
                for (Event event : orderedEvents) {
                    OutputProvider.out((String)"- %s", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                }
                OutputProvider.dout();
            }
        } else {
            OutputProvider.out((String)"The specification has finite response.");
        }
        OutputProvider.dout();
        return this.controllableEvents.isEmpty();
    }

    private void checkAutomaton(Automaton aut) {
        if (Sets.isEmptyIntersection((Set)CifEventUtils.getAlphabet((Automaton)aut), this.controllableEvents)) {
            return;
        }
        Set<EventLoop> controllableEventLoops = EventLoopSearch.searchEventLoops(aut, this.controllableEvents, this.env);
        if (this.env.isTerminationRequested()) {
            return;
        }
        if (this.controllableEventsChanged) {
            this.controllableEventsChanged = false;
            BitSet bits = new BitSet(this.builder.cifVarInfoBuilder.varInfos.size());
            for (Event evt : this.controllableEvents) {
                for (Declaration var : this.eventVarUpdate.getOrDefault(evt, Sets.set())) {
                    VarInfo varInfo = this.builder.cifVarInfoBuilder.getVarInfo(var, 0);
                    bits.set(varInfo.level);
                }
            }
            this.nonCtrlIndependentVarsInfos = new VarInfo[bits.cardinality()];
            int nextFree = 0;
            int level = bits.nextSetBit(0);
            while (level >= 0) {
                this.nonCtrlIndependentVarsInfos[nextFree] = (VarInfo)this.builder.cifVarInfoBuilder.varInfos.get(level);
                ++nextFree;
                level = bits.nextSetBit(level + 1);
            }
        }
        if (this.env.isTerminationRequested()) {
            return;
        }
        Set eventsInPotentialControllableLoops = Sets.set();
        if (!controllableEventLoops.isEmpty()) {
            OutputProvider.dbg((String)"The following events have been encountered in a controllable-event loop of automaton %s:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            OutputProvider.idbg();
            for (EventLoop controllableEventLoop : controllableEventLoops) {
                if (this.isUnconnectable(controllableEventLoop, this.nonCtrlIndependentVarsInfos)) {
                    OutputProvider.dbg((String)"%s, which is controllable unconnectable.", (Object[])new Object[]{controllableEventLoop.toString()});
                } else {
                    OutputProvider.dbg((String)"%s, which is not controllable unconnectable.", (Object[])new Object[]{controllableEventLoop.toString()});
                    eventsInPotentialControllableLoops.addAll(controllableEventLoop.events);
                }
                if (!this.env.isTerminationRequested()) continue;
                OutputProvider.ddbg();
                return;
            }
            OutputProvider.ddbg();
        }
        Set eventsInAlphabetNotInLoop = Sets.difference((Set)CifEventUtils.getAlphabet((Automaton)aut), (Set)eventsInPotentialControllableLoops);
        this.controllableEventsChanged = this.controllableEvents.removeAll(eventsInAlphabetNotInLoop);
    }

    private boolean isUnconnectable(EventLoop controllableEventLoop, VarInfo[] nonCtrlIndependentVarsInfos) {
        Node n = Tree.ONE;
        for (Event evt : controllableEventLoop.events) {
            Node g = this.globalGuards.get(evt);
            Node gAbstract = this.builder.tree.variableAbstractions(g, nonCtrlIndependentVarsInfos);
            if ((n = this.builder.tree.conjunct(n, gAbstract)) != Tree.ZERO) continue;
            return true;
        }
        return false;
    }

    private Map<Event, Set<Declaration>> collectEventVarUpdate() {
        Map eventVarUpdate = Maps.map();
        for (Automaton aut : this.automata) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    for (Update update : edge.getUpdates()) {
                        if (update instanceof Assignment) {
                            Assignment assignment = (Assignment)update;
                            this.collectEventsAddressable(assignment.getAddressable(), CifEventUtils.getEvents((Edge)edge), eventVarUpdate);
                            continue;
                        }
                        Assert.fail((Object)("Unexpected update encountered: " + update.toString()));
                    }
                }
            }
        }
        return eventVarUpdate;
    }

    private void collectEventsAddressable(Expression addressable, Set<Event> events, Map<Event, Set<Declaration>> eventVarUpdate) {
        if (addressable instanceof DiscVariableExpression) {
            DiscVariable adressedVar = ((DiscVariableExpression)addressable).getVariable();
            for (Event evt : events) {
                Set<Declaration> vars = eventVarUpdate.getOrDefault(evt, Sets.set());
                vars.add((Declaration)adressedVar);
                eventVarUpdate.put(evt, vars);
            }
        } else {
            Assert.fail((Object)("Unexpected addressable encountered: " + addressable.toString()));
        }
    }

    private Map<Event, Node> collectGlobalGuards(Set<Event> events) {
        Map eventsGlobalGuards = Maps.mapc((int)events.size());
        for (Event evt : events) {
            eventsGlobalGuards.put(evt, Lists.list());
        }
        for (Automaton aut : this.automata) {
            Set controllableAlphabet = Sets.intersection((Set)CifEventUtils.getAlphabet((Automaton)aut), events);
            Map eventsAutGuards = Maps.mapc((int)controllableAlphabet.size());
            for (Event evt : controllableAlphabet) {
                eventsAutGuards.put(evt, Lists.list());
            }
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    Set intersection = Sets.intersection((Set)CifEventUtils.getEvents((Edge)edge), (Set)controllableAlphabet);
                    if (intersection.isEmpty()) continue;
                    for (Event evt : intersection) {
                        List eventAutGuards = (List)eventsAutGuards.get(evt);
                        eventAutGuards.add(CifValueUtils.createConjunction((List)EMFHelper.deepclone((List)edge.getGuards())));
                    }
                }
            }
            for (Map.Entry entry : eventsAutGuards.entrySet()) {
                List eventglobalGuards = (List)eventsGlobalGuards.get(entry.getKey());
                eventglobalGuards.add(CifValueUtils.createDisjunction((List)((List)entry.getValue())));
            }
            if (!this.env.isTerminationRequested()) continue;
            return null;
        }
        Map eventNode = Maps.mapc((int)events.size());
        for (Event event : events) {
            List eventGlobalGuards = (List)eventsGlobalGuards.get(event);
            Node nodeGuard = eventGlobalGuards.isEmpty() ? Tree.ZERO : this.builder.getExpressionConvertor().convert(eventGlobalGuards).get(1);
            eventNode.put(event, nodeGuard);
        }
        return eventNode;
    }
}

