/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDD;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.options.BddSimplify;
import org.eclipse.escet.cif.datasynth.options.BddSimplifyOption;
import org.eclipse.escet.cif.datasynth.options.EventWarnOption;
import org.eclipse.escet.cif.datasynth.options.ForwardReachOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifDataSynthesis {
    private CifDataSynthesis() {
    }

    public static void synthesize(SynthesisAutomaton aut, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing) {
        boolean doForward = ForwardReachOption.isEnabled();
        if (doTiming) {
            timing.preSynth.start();
        }
        try {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.checkSystem(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.applyStateEvtExclPlants(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.applyStateReqInvs(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.applyVarRanges(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.applyStateEvtExclReqs(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (EventWarnOption.isEnabled()) {
                CifDataSynthesis.checkInputEdges(aut);
            }
            for (SynthesisEdge edge : aut.edges) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                edge.initApply(doForward);
            }
        }
        finally {
            if (doTiming) {
                timing.preSynth.stop();
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (doTiming) {
            timing.main.start();
        }
        try {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.synthesizeFixedPoints(aut, doForward, dbgEnabled, doTiming, timing);
        }
        finally {
            if (doTiming) {
                timing.main.stop();
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (doTiming) {
            timing.postSynth.start();
        }
        try {
            boolean emptySup;
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.determineCtrlSysGuards(aut, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            for (SynthesisEdge edge : aut.edges) {
                edge.cleanupApply();
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Final synthesis result:");
                OutputProvider.dbg((String)aut.toString(1));
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            boolean bl = emptySup = !CifDataSynthesis.checkInitStatePresent(aut, doForward, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.printNumberStates(aut, emptySup, doForward, dbgEnabled);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            CifDataSynthesis.determineOutputInitial(aut, dbgEnabled);
            if (emptySup) {
                throw new InvalidInputException("Empty supervisor.");
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            Map<Event, BDD> ctrlGuards = CifDataSynthesis.determineGuards(aut, aut.controllables, false);
            if (EventWarnOption.isEnabled()) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                CifDataSynthesis.checkOutputEdges(aut, ctrlGuards);
            }
        }
        finally {
            if (doTiming) {
                timing.postSynth.stop();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkSystem(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            for (BDD bDD : aut.reqInvsComps) {
                OutputProvider.dbg((String)"Invariant (component state req invariant):   %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (components state req invariant):  %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInvComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.reqInvsLocs) {
                OutputProvider.dbg((String)"Invariant (location state req invariant):    %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Invariant (locations state req invariant):   %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInvLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Invariant (system state req invariant):      %s", (Object[])new Object[]{BddUtils.bddToStr(aut.reqInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.reqInv.isZero()) {
            OutputProvider.warn((String)"The controlled system has no states (taking into account only the state requirement invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            void var2_7;
            OutputProvider.dbg();
            boolean bl = false;
            while (var2_7 < aut.variables.length) {
                SynthesisVariable var = aut.variables[var2_7];
                if (var instanceof SynthesisDiscVariable) {
                    String nr = String.valueOf((int)var2_7);
                    OutputProvider.dbg((String)"Initial   (discrete variable %s):%s%s", (Object[])new Object[]{nr, Strings.spaces((int)(14 - nr.length())), BddUtils.bddToStr(aut.initialsVars.get((int)var2_7), aut)});
                }
                ++var2_7;
            }
            OutputProvider.dbg((String)"Initial   (discrete variables):              %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialVars, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.initialsComps) {
                OutputProvider.dbg((String)"Initial   (component init predicate):        %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Initial   (components init predicate):       %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.initialsLocs) {
                OutputProvider.dbg((String)"Initial   (aut/locs init predicate):         %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Initial   (auts/locs init predicate):        %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial   (uncontrolled system):             %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialUnctrl, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial   (system, combined init/req inv):   %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialReqInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.initialUnctrl.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no initial state (taking into account only initialization).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!aut.initialUnctrl.isZero() && !aut.reqInv.isZero() && aut.initialReqInv.isZero()) {
            OutputProvider.warn((String)"The controlled system has no initial state (taking into account both initialization and state requirement invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            for (BDD bDD : aut.markedsComps) {
                OutputProvider.dbg((String)"Marked    (component marker predicate):      %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Marked    (components marker predicate):     %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedComps, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            for (BDD bDD : aut.markedsLocs) {
                OutputProvider.dbg((String)"Marked    (aut/locs marker predicate):       %s", (Object[])new Object[]{BddUtils.bddToStr(bDD, aut)});
            }
            OutputProvider.dbg((String)"Marked    (auts/locs marker predicate):      %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedLocs, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Marked    (uncontrolled system):             %s", (Object[])new Object[]{BddUtils.bddToStr(aut.marked, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Marked    (system, combined marked/req inv): %s", (Object[])new Object[]{BddUtils.bddToStr(aut.markedReqInv, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (aut.marked.isZero()) {
            OutputProvider.warn((String)"The uncontrolled system has no marked state (taking into account only marking).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (!aut.marked.isZero() && !aut.reqInv.isZero() && aut.markedReqInv.isZero()) {
            OutputProvider.warn((String)"The controlled system has no marked state (taking into account both marking and state requirement invariants).");
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"State/event exclusion plants:");
            if (aut.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"  None");
            }
            for (Map.Entry entry : aut.stateEvtExclPlantLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                OutputProvider.dbg((String)"  Event \"%s\" needs:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    OutputProvider.dbg((String)"    %s", (Object[])new Object[]{BddUtils.bddToStr(pred, aut)});
                }
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"State/event exclusion requirements:");
            if (aut.stateEvtExclReqLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"  None");
            }
            for (Map.Entry entry : aut.stateEvtExclReqLists.entrySet()) {
                if (((List)entry.getValue()).isEmpty()) continue;
                OutputProvider.dbg((String)"  Event \"%s\" needs:", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))});
                for (BDD pred : (List)entry.getValue()) {
                    OutputProvider.dbg((String)"    %s", (Object[])new Object[]{BddUtils.bddToStr(pred, aut)});
                }
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            if (aut.stateEvtExclPlantLists.values().stream().flatMap(x -> x.stream()).findAny().isEmpty()) {
                OutputProvider.dbg((String)"Uncontrolled system:");
            } else {
                OutputProvider.dbg((String)"Uncontrolled system (state/event exclusion plants not applied yet):");
            }
            OutputProvider.dbg((String)aut.toString(1));
        }
        for (BDD bDD : aut.reqInvsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.reqInvsLocs) {
            bDD.free();
        }
        aut.reqInvComps.free();
        aut.reqInvLocs.free();
        for (BDD bDD : aut.initialsVars) {
            if (bDD == null) continue;
            bDD.free();
        }
        for (BDD bDD : aut.initialsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.initialsLocs) {
            bDD.free();
        }
        aut.initialVars.free();
        aut.initialComps.free();
        aut.initialLocs.free();
        aut.initialReqInv.free();
        for (BDD bDD : aut.markedsComps) {
            bDD.free();
        }
        for (BDD bDD : aut.markedsLocs) {
            bDD.free();
        }
        aut.markedComps.free();
        aut.markedLocs.free();
        aut.markedReqInv.free();
        for (List list : aut.stateEvtExclPlantLists.values()) {
            for (BDD pred : list) {
                pred.free();
            }
        }
        for (List list : aut.stateEvtExclReqLists.values()) {
            for (BDD pred : list) {
                pred.free();
            }
        }
        aut.reqInvsComps = null;
        aut.reqInvComps = null;
        aut.reqInvsLocs = null;
        aut.reqInvLocs = null;
        aut.initialsVars = null;
        aut.initialVars = null;
        aut.initialsComps = null;
        aut.initialComps = null;
        aut.initialsLocs = null;
        aut.initialLocs = null;
        aut.initialReqInv = null;
        aut.markedsComps = null;
        aut.markedComps = null;
        aut.markedsLocs = null;
        aut.markedLocs = null;
        aut.markedReqInv = null;
        aut.stateEvtExclPlantLists = null;
        aut.stateEvtExclReqLists = null;
    }

    private static void applyStateEvtExclPlants(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting behavior using state/event exclusion plants.");
        }
        boolean firstDbg = true;
        boolean guardChanged = false;
        for (SynthesisEdge edge : aut.edges) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD plant = aut.stateEvtExclPlants.get(edge.event);
            if (plant == null || plant.isOne() || edge.guard.isZero()) continue;
            BDD newGuard = edge.guard.and(plant);
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                if (firstDbg) {
                    firstDbg = false;
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Edge %s: guard: %s -> %s [plant: %s].", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut), BddUtils.bddToStr(plant, aut)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardChanged = true;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && guardChanged) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Uncontrolled system:");
            OutputProvider.dbg((String)aut.toString(1, guardChanged));
        }
    }

    private static void applyStateReqInvs(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        aut.ctrlBeh = aut.reqInv.id();
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Initialized controlled-behavior predicate using invariants: %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut)});
        }
    }

    private static void applyVarRanges(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Extending controlled-behavior predicate using variable ranges.");
        }
        boolean firstDbg = true;
        boolean changed = false;
        SynthesisVariable[] synthesisVariableArray = aut.variables;
        int n = aut.variables.length;
        int n2 = 0;
        while (n2 < n) {
            SynthesisVariable var = synthesisVariableArray[n2];
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD range = BddUtils.getVarDomain(var, false, aut.factory);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newCtrlBeh = aut.ctrlBeh.and(range);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                range.free();
            } else {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (dbgEnabled) {
                    if (firstDbg) {
                        firstDbg = false;
                        OutputProvider.dbg();
                    }
                    OutputProvider.dbg((String)"Controlled behavior: %s -> %s [range: %s, variable: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut), BddUtils.bddToStr(range, aut), var.toString(0, "")});
                }
                range.free();
                aut.ctrlBeh.free();
                aut.ctrlBeh = newCtrlBeh;
                changed = true;
            }
            ++n2;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && changed) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Extended controlled-behavior predicate using variable ranges: %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut)});
        }
    }

    private static void applyStateEvtExclReqs(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricting behavior using state/event exclusion requirements.");
        }
        boolean firstDbg = true;
        boolean changed = false;
        boolean guardChanged = false;
        for (SynthesisEdge edge : aut.edges) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD req = aut.stateEvtExclReqs.get(edge.event);
            if (req == null || req.isOne()) continue;
            if (edge.event.getControllable().booleanValue()) {
                BDD newGuard = edge.guard.and(req);
                if (edge.guard.equals((Object)newGuard)) {
                    newGuard.free();
                    continue;
                }
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (dbgEnabled) {
                    if (firstDbg) {
                        firstDbg = false;
                        OutputProvider.dbg();
                    }
                    OutputProvider.dbg((String)"Edge %s: guard: %s -> %s [requirement: %s].", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut), BddUtils.bddToStr(req, aut)});
                }
                edge.guard.free();
                edge.guard = newGuard;
                changed = true;
                guardChanged = true;
                continue;
            }
            BDD reqGood = edge.guard.imp(req);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newCtrlBeh = aut.ctrlBeh.id().andWith(reqGood);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                continue;
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                if (firstDbg) {
                    firstDbg = false;
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Controlled behavior: %s -> %s [requirement: %s, edge: %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut), BddUtils.bddToStr(req, aut), edge.toString(0, "")});
            }
            aut.ctrlBeh.free();
            aut.ctrlBeh = newCtrlBeh;
            changed = true;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled && changed) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Restricted behavior using state/event exclusion requirements:");
            OutputProvider.dbg((String)aut.toString(1, guardChanged));
        }
        for (BDD bdd : aut.stateEvtExclReqs.values()) {
            bdd.free();
        }
        aut.stateEvtExclReqs = null;
    }

    private static void checkInputEdges(SynthesisAutomaton aut) {
        aut.disabledEvents = Sets.setc((int)aut.alphabet.size());
        for (Event event : aut.alphabet) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.inputVarEvents.contains(event)) continue;
            if (aut.eventEdges.get(event) == null) {
                aut.disabledEvents.add(event);
                continue;
            }
            if (aut.stateEvtExclPlants.get(event).isZero()) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion plants.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            if (event.getControllable().booleanValue() && aut.stateEvtExclsReqInvs.get(event).isZero()) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only state/event exclusion requirements.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            if (aut.eventEdges.get(event).stream().filter(edge -> !edge.origGuard.isZero()).count() == 0L) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account only automaton guards.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            if (aut.eventEdges.get(event).stream().filter(edge -> !edge.guard.isZero()).count() == 0L) {
                OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account automaton guards and state/event exclusion invariants.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            boolean alwaysDisabled = true;
            for (SynthesisEdge edge2 : aut.eventEdges.get(event)) {
                BDD enabledExpression = edge2.guard.and(aut.reqInv);
                if (enabledExpression.isZero()) continue;
                enabledExpression.free();
                alwaysDisabled = false;
                break;
            }
            if (!alwaysDisabled) continue;
            OutputProvider.warn((String)"Event \"%s\" is never enabled in the input specification, taking into account automaton guards and invariants.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            aut.disabledEvents.add(event);
        }
    }

    private static void synthesizeFixedPoints(SynthesisAutomaton aut, boolean doForward, boolean dbgEnabled, boolean doTiming, CifDataSynthesisTiming timing) {
        int reachabilityCount = 0;
        ++reachabilityCount;
        ++reachabilityCount;
        if (doForward) {
            ++reachabilityCount;
        }
        int stableCount = reachabilityCount - 1;
        int round = 0;
        int unchanged = 0;
        while (true) {
            boolean noInit;
            BDD init;
            BDD nonBlock;
            ++round;
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: started.", (Object[])new Object[]{round});
            }
            if (doTiming) {
                timing.mainBwMarked.start();
            }
            try {
                nonBlock = CifDataSynthesis.reachability(aut.marked.id(), false, false, true, true, aut.ctrlBeh, aut, dbgEnabled, "backward controlled-behavior", "marker", "current/previous controlled-behavior", round);
            }
            finally {
                if (doTiming) {
                    timing.mainBwMarked.stop();
                }
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.ctrlBeh.equals((Object)nonBlock)) {
                nonBlock.free();
                ++unchanged;
            } else {
                if (dbgEnabled) {
                    OutputProvider.dbg((String)"Controlled behavior: %s -> %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(nonBlock, aut)});
                }
                aut.ctrlBeh.free();
                aut.ctrlBeh = nonBlock;
                unchanged = 0;
            }
            if (aut.ctrlBeh.isZero()) {
                if (!dbgEnabled) break;
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: finished, all states are bad.", (Object[])new Object[]{round});
                break;
            }
            if (round > 1 && unchanged >= stableCount) {
                if (!dbgEnabled) break;
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: finished, controlled behavior is stable.", (Object[])new Object[]{round});
                break;
            }
            if (unchanged == 0) {
                BDD init2 = aut.initialUnctrl.and(aut.ctrlBeh);
                boolean noInit2 = init2.isZero();
                init2.free();
                if (noInit2) {
                    if (!dbgEnabled) break;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, no initialization possible.", (Object[])new Object[]{round});
                    break;
                }
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD badState = aut.ctrlBeh.not();
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (doTiming) {
                timing.mainBwBadState.start();
            }
            try {
                badState = CifDataSynthesis.reachability(badState, true, false, false, true, null, aut, dbgEnabled, "backward uncontrolled bad-state", "current/previous controlled behavior", null, round);
            }
            finally {
                if (doTiming) {
                    timing.mainBwBadState.stop();
                }
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newCtrlBeh = badState.not();
            badState.free();
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                newCtrlBeh.free();
                ++unchanged;
            } else {
                if (dbgEnabled) {
                    OutputProvider.dbg((String)"Controlled behavior: %s -> %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut)});
                }
                aut.ctrlBeh.free();
                aut.ctrlBeh = newCtrlBeh;
                unchanged = 0;
            }
            if (doForward) {
                if (aut.ctrlBeh.isZero()) {
                    if (!dbgEnabled) break;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, all states are bad.", (Object[])new Object[]{round});
                    break;
                }
                if (round > 1 && unchanged >= stableCount) {
                    if (!dbgEnabled) break;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, controlled behavior is stable.", (Object[])new Object[]{round});
                    break;
                }
                if (unchanged == 0) {
                    init = aut.initialUnctrl.and(aut.ctrlBeh);
                    noInit = init.isZero();
                    init.free();
                    if (noInit) {
                        if (!dbgEnabled) break;
                        OutputProvider.dbg();
                        OutputProvider.dbg((String)"Round %d: finished, no initialization possible.", (Object[])new Object[]{round});
                        break;
                    }
                }
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (doTiming) {
                    timing.mainFwInit.start();
                }
                try {
                    newCtrlBeh = CifDataSynthesis.reachability(aut.initialUnctrl.id(), false, true, true, true, aut.ctrlBeh, aut, dbgEnabled, "forward controlled-behavior", "initialization", "current/previous controlled-behavior", round);
                }
                finally {
                    if (doTiming) {
                        timing.mainFwInit.stop();
                    }
                }
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (aut.ctrlBeh.equals((Object)newCtrlBeh)) {
                    newCtrlBeh.free();
                    ++unchanged;
                } else {
                    if (dbgEnabled) {
                        OutputProvider.dbg((String)"Controlled behavior: %s -> %s.", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut), BddUtils.bddToStr(newCtrlBeh, aut)});
                    }
                    aut.ctrlBeh.free();
                    aut.ctrlBeh = newCtrlBeh;
                    unchanged = 0;
                }
            }
            if (aut.ctrlBeh.isZero()) {
                if (!dbgEnabled) break;
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: finished, all states are bad.", (Object[])new Object[]{round});
                break;
            }
            if (unchanged >= stableCount) {
                if (!dbgEnabled) break;
                OutputProvider.dbg();
                OutputProvider.dbg((String)"Round %d: finished, controlled behavior is stable.", (Object[])new Object[]{round});
                break;
            }
            if (!doForward && unchanged == 0) {
                init = aut.initialUnctrl.and(aut.ctrlBeh);
                noInit = init.isZero();
                init.free();
                if (noInit) {
                    if (!dbgEnabled) break;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Round %d: finished, no initialization possible.", (Object[])new Object[]{round});
                    break;
                }
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (!dbgEnabled) continue;
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Round %d: finished, need another round.", (Object[])new Object[]{round});
        }
    }

    private static BDD reachability(BDD pred, boolean bad, boolean forward, boolean ctrl, boolean unctrl, BDD restriction, SynthesisAutomaton aut, boolean dbgEnabled, String predName, String initName, String restrictionName, int round) {
        boolean fixedPoint;
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Round %d: computing %s predicate.", (Object[])new Object[]{round, predName});
            OutputProvider.dbg((String)"%s: %s [%s predicate]", (Object[])new Object[]{Strings.makeInitialUppercase((String)predName), BddUtils.bddToStr(pred, aut), initName});
        }
        boolean changed = false;
        if (restriction != null) {
            BDD restrictedPred = pred.and(restriction);
            if (aut.env.isTerminationRequested()) {
                return null;
            }
            if (pred.equals((Object)restrictedPred)) {
                restrictedPred.free();
            } else {
                if (aut.env.isTerminationRequested()) {
                    return null;
                }
                if (dbgEnabled) {
                    Assert.notNull((Object)restrictionName);
                    OutputProvider.dbg((String)"%s: %s -> %s [restricted to %s predicate: %s]", (Object[])new Object[]{Strings.makeInitialUppercase((String)predName), BddUtils.bddToStr(pred, aut), BddUtils.bddToStr(restrictedPred, aut), restrictionName, BddUtils.bddToStr(restriction, aut)});
                }
                pred.free();
                pred = restrictedPred;
                changed = true;
            }
        }
        for (SynthesisEdge edge : aut.edges) {
            edge.preApply(forward, restriction);
        }
        int iter = 0;
        do {
            ++iter;
            if (dbgEnabled) {
                OutputProvider.dbg((String)"%s reachability: iteration %d.", (Object[])new Object[]{forward ? "Forward" : "Backward", iter});
            }
            if (aut.env.isTerminationRequested()) {
                return null;
            }
            BDD oldPred = pred.id();
            for (SynthesisEdge edge : aut.edges) {
                if (!ctrl && edge.event.getControllable().booleanValue() || !unctrl && !edge.event.getControllable().booleanValue()) continue;
                if (aut.env.isTerminationRequested()) {
                    return null;
                }
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, bad, forward, restriction);
                if (aut.env.isTerminationRequested()) {
                    return null;
                }
                BDD newPred = pred.id().orWith(updPred);
                if (aut.env.isTerminationRequested()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) {
                    newPred.free();
                    continue;
                }
                if (aut.env.isTerminationRequested()) {
                    return null;
                }
                if (dbgEnabled) {
                    String restrTxt;
                    if (restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{restrictionName, BddUtils.bddToStr(restriction, aut)});
                    }
                    OutputProvider.dbg((String)"%s: %s -> %s [%s reach with edge: %s%s]", (Object[])new Object[]{Strings.makeInitialUppercase((String)predName), BddUtils.bddToStr(pred, aut), BddUtils.bddToStr(newPred, aut), forward ? "forward" : "backward", edge.toString(0, ""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
            }
            fixedPoint = pred.equals((Object)oldPred);
            oldPred.free();
        } while (!fixedPoint);
        for (SynthesisEdge edge : aut.edges) {
            edge.postApply(forward);
        }
        if (aut.env.isTerminationRequested()) {
            return null;
        }
        if (dbgEnabled && changed) {
            OutputProvider.dbg((String)"%s: %s [fixed point].", (Object[])new Object[]{Strings.makeInitialUppercase((String)predName), BddUtils.bddToStr(pred, aut)});
        }
        return pred;
    }

    private static void determineCtrlSysGuards(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Computing controlled system guards.");
        }
        boolean guardUpdated = false;
        for (SynthesisEdge edge : aut.edges) {
            if (!edge.event.getControllable().booleanValue()) continue;
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD updPred = aut.ctrlBeh.id();
            edge.preApply(false, null);
            updPred = edge.apply(updPred, false, false, null);
            edge.postApply(false);
            edge.cleanupApply();
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                if (!guardUpdated) {
                    OutputProvider.dbg();
                }
                OutputProvider.dbg((String)"Edge %s: guard: %s -> %s.", (Object[])new Object[]{edge.toString(0, ""), BddUtils.bddToStr(edge.guard, aut), BddUtils.bddToStr(newGuard, aut)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardUpdated = true;
        }
    }

    private static boolean checkInitStatePresent(SynthesisAutomaton aut, boolean doForward, boolean dbgEnabled) {
        BDD initialUnctrl = aut.initialUnctrl;
        aut.initialCtrl = initialUnctrl.and(aut.ctrlBeh);
        if (aut.env.isTerminationRequested()) {
            return true;
        }
        boolean emptySup = aut.initialCtrl.isZero();
        return !emptySup;
    }

    private static void printNumberStates(SynthesisAutomaton aut, boolean emptySup, boolean doForward, boolean dbgEnabled) {
        double nr;
        if (!dbgEnabled) {
            return;
        }
        if (emptySup) {
            nr = 0.0;
        } else if (aut.variables.length == 0) {
            Assert.check((aut.ctrlBeh.isZero() || aut.ctrlBeh.isOne() ? 1 : 0) != 0);
            nr = aut.ctrlBeh.isOne() ? 1 : 0;
        } else {
            nr = aut.ctrlBeh.satCount(aut.varSetOld);
        }
        Assert.check((emptySup || nr > 0.0 ? 1 : 0) != 0);
        boolean isExact = emptySup || doForward;
        OutputProvider.dbg();
        OutputProvider.dbg((String)"Controlled system:                     %s %,.0f state%s.", (Object[])new Object[]{isExact ? "exactly" : "at most", nr, nr == 1.0 ? "" : "s"});
    }

    private static void determineOutputInitial(SynthesisAutomaton aut, boolean dbgEnabled) {
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"Initial (synthesis result):            %s", (Object[])new Object[]{BddUtils.bddToStr(aut.ctrlBeh, aut)});
            OutputProvider.dbg((String)"Initial (uncontrolled system):         %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialUnctrl, aut)});
            OutputProvider.dbg((String)"Initial (controlled system):           %s", (Object[])new Object[]{BddUtils.bddToStr(aut.initialCtrl, aut)});
        }
        EnumSet<BddSimplify> simplifications = BddSimplifyOption.getSimplifications();
        boolean dbgPrinted = false;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        BDD initialUnctrl = aut.initialUnctrl;
        BDD initialCtrl = aut.initialCtrl;
        BDD initialRemoved = initialUnctrl.id().andWith(initialCtrl.not());
        if (aut.env.isTerminationRequested()) {
            return;
        }
        BDD initialAdded = initialRemoved.not();
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Initial (removed by supervisor):       %s", (Object[])new Object[]{BddUtils.bddToStr(initialRemoved, aut)});
            OutputProvider.dbg((String)"Initial (added by supervisor):         %s", (Object[])new Object[]{BddUtils.bddToStr(initialAdded, aut)});
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        aut.initialOutput = null;
        if (!initialRemoved.isZero()) {
            aut.initialOutput = initialCtrl.id();
            if (simplifications.contains((Object)BddSimplify.INITIAL_UNCTRL)) {
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                BDD newInitial = aut.initialOutput.simplify(initialUnctrl);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                if (dbgEnabled && !aut.initialOutput.equals((Object)newInitial)) {
                    if (!dbgPrinted) {
                        dbgPrinted = true;
                        OutputProvider.dbg();
                        OutputProvider.dbg((String)"Simplification of controlled system under the assumption of the uncontrolled system:");
                    }
                    OutputProvider.dbg((String)"  Initial: %s -> %s [assume %s].", (Object[])new Object[]{BddUtils.bddToStr(aut.initialOutput, aut), BddUtils.bddToStr(newInitial, aut), BddUtils.bddToStr(initialUnctrl, aut)});
                }
                aut.initialOutput.free();
                aut.initialOutput = newInitial;
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        initialCtrl.free();
        initialUnctrl.free();
        initialRemoved.free();
        initialAdded.free();
    }

    private static Map<Event, BDD> determineGuards(SynthesisAutomaton aut, Set<Event> events, boolean useOrigGuards) {
        Map guards = Maps.mapc((int)events.size());
        for (Event event : events) {
            guards.put(event, aut.factory.zero());
        }
        for (SynthesisEdge synthEdge : aut.edges) {
            if (!events.contains(synthEdge.event)) continue;
            if (aut.env.isTerminationRequested()) {
                return null;
            }
            BDD guard = (BDD)guards.get(synthEdge.event);
            guard = useOrigGuards ? guard.orWith(synthEdge.origGuard) : guard.orWith(synthEdge.guard);
            guards.put(synthEdge.event, guard);
        }
        return guards;
    }

    private static void checkOutputEdges(SynthesisAutomaton aut, Map<Event, BDD> ctrlGuards) {
        Set uncontrollables = Sets.difference(aut.alphabet, (Set[])new Set[]{aut.controllables, aut.inputVarEvents});
        Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(aut, uncontrollables, false);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(aut, ctrlGuards);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        CifDataSynthesis.warnEventsDisabled(aut, unctrlGuards);
        if (aut.env.isTerminationRequested()) {
            return;
        }
        for (BDD bdd : unctrlGuards.values()) {
            bdd.free();
        }
    }

    private static void warnEventsDisabled(SynthesisAutomaton aut, Map<Event, BDD> guards) {
        for (Event event : guards.keySet()) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD ctrlBehGuard = guards.get(event).and(aut.ctrlBeh);
            if (ctrlBehGuard.isZero() && !aut.disabledEvents.contains(event)) {
                OutputProvider.warn((String)"Event \"%s\" is disabled in the controlled system.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                aut.disabledEvents.add(event);
                continue;
            }
            ctrlBehGuard.free();
        }
    }

    private static void determineOutputGuards(SynthesisAutomaton aut, Map<Event, BDD> ctrlGuards, boolean dbgEnabled) {
        BDD extra;
        BDD assumption;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        EnumSet<BddSimplify> simplifications = BddSimplifyOption.getSimplifications();
        List assumptionTxts = Lists.list();
        Map assumptions = Maps.mapc((int)aut.controllables.size());
        for (Event controllable : aut.controllables) {
            assumptions.put(controllable, aut.factory.one());
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_PLANTS)) {
            assumptionTxts.add("plants");
            Map<Event, BDD> unctrlGuards = CifDataSynthesis.determineGuards(aut, aut.controllables, true);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            for (Event controllable : aut.controllables) {
                BDD assumption2 = (BDD)assumptions.get(controllable);
                BDD extra2 = unctrlGuards.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption2 = assumption2.andWith(extra2);
                assumptions.put(controllable, assumption2);
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_REQ_AUTS)) {
            assumptionTxts.add("requirement automata");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclsReqAuts.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclsReqAuts = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_PLANT_INVS)) {
            assumptionTxts.add("state/event exclusion plant invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclPlants.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclPlants = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_SE_EXCL_REQ_INVS)) {
            assumptionTxts.add("state/event exclusion requirement invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.stateEvtExclsReqInvs.get(controllable);
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.stateEvtExclsReqInvs = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_STATE_REQ_INVS)) {
            assumptionTxts.add("state requirement invariants");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.reqInv.id();
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        aut.reqInv.free();
        aut.reqInv = null;
        if (aut.env.isTerminationRequested()) {
            return;
        }
        if (simplifications.contains((Object)BddSimplify.GUARDS_CTRL_BEH)) {
            assumptionTxts.add("controlled behavior");
            for (Event controllable : aut.controllables) {
                assumption = (BDD)assumptions.get(controllable);
                extra = aut.ctrlBeh.id();
                if (aut.env.isTerminationRequested()) {
                    return;
                }
                assumption = assumption.andWith(extra);
                assumptions.put(controllable, assumption);
            }
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        aut.outputGuards = ctrlGuards;
        if (assumptionTxts.isEmpty()) {
            return;
        }
        if (aut.env.isTerminationRequested()) {
            return;
        }
        String assumptionsTxt = CifDataSynthesis.combineAssumptionTexts(assumptionTxts);
        CifDataSynthesis.simplifyOutputGuards(aut, dbgEnabled, assumptions, assumptionsTxt);
    }

    private static String combineAssumptionTexts(List<String> texts) {
        if (texts.size() == 0) {
            return "";
        }
        if (texts.size() == 1) {
            return texts.get(0);
        }
        StringBuilder txt = new StringBuilder();
        int i = 0;
        while (i < texts.size()) {
            if (i > 0) {
                if (texts.size() > 2) {
                    txt.append(",");
                }
                txt.append(" ");
            }
            if (i == texts.size() - 1) {
                txt.append("and ");
            }
            txt.append(texts.get(i));
            ++i;
        }
        return txt.toString();
    }

    private static void simplifyOutputGuards(SynthesisAutomaton aut, boolean dbgEnabled, Map<Event, BDD> assumptions, String assumptionsTxt) {
        boolean dbgPrinted = false;
        for (Event controllable : aut.controllables) {
            if (aut.env.isTerminationRequested()) {
                return;
            }
            BDD guard = aut.outputGuards.get(controllable);
            BDD assumption = assumptions.get(controllable);
            BDD newGuard = assumption.isZero() && guard.isZero() ? aut.factory.one() : guard.simplify(assumption);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            aut.outputGuards.put(controllable, newGuard);
            if (dbgEnabled && !guard.equals((Object)newGuard)) {
                if (!dbgPrinted) {
                    dbgPrinted = true;
                    OutputProvider.dbg();
                    OutputProvider.dbg((String)"Simplification of controlled system under the assumption of the %s:", (Object[])new Object[]{assumptionsTxt});
                }
                OutputProvider.dbg((String)"  Event %s: guard: %s -> %s [assume %s].", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)controllable), BddUtils.bddToStr(guard, aut), BddUtils.bddToStr(newGuard, aut), BddUtils.bddToStr(assumption, aut)});
            }
            if (aut.env.isTerminationRequested()) {
                return;
            }
            assumption.free();
            guard.free();
        }
    }
}

