/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.conversion;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.LocationPointerManager;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.bdd.CifBddBitVector;
import org.eclipse.escet.cif.datasynth.bdd.CifBddBitVectorAndCarry;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxNodesOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxPathsOption;
import org.eclipse.escet.cif.datasynth.options.BddForceVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.spec.SynthesisInputVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisLocPtrVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisTypedVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.datasynth.varorder.AutoVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.CombiVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.ForceVarOrderer;
import org.eclipse.escet.cif.datasynth.varorder.SlidingWindowVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToSynthesisConverter {
    private final Set<String> problems = Sets.set();
    private Map<Automaton, Monitors> originalMonitors;

    public SynthesisAutomaton convert(Specification spec, BDDFactory factory, boolean dbgEnabled) {
        SynthesisAutomaton aut = this.convertSpec(spec, factory, dbgEnabled);
        if (this.problems.isEmpty()) {
            return aut;
        }
        String msg = "Data-based supervisory controller synthesis failed due to unsatisfied preconditions:\n - " + StringUtils.join((Collection)Sets.sortedstrings(this.problems), (String)"\n - ");
        throw new UnsupportedException(msg);
    }

    /*
     * WARNING - void declaration
     */
    private SynthesisAutomaton convertSpec(Specification spec, BDDFactory factory, boolean dbgEnabled) {
        void var19_25;
        CifEventUtils.Alphabets alphabets;
        SynthesisAutomaton synthAut = new SynthesisAutomaton();
        synthAut.factory = factory;
        synthAut.debugMaxNodes = BddDebugMaxNodesOption.getMaximum();
        synthAut.debugMaxPaths = BddDebugMaxPathsOption.getMaximum();
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        List events = Lists.list();
        CifToSynthesisConverter.collectEvents((ComplexComponent)spec, events);
        for (Event event : events) {
            if (event.getControllable() != null) continue;
            String msg = Strings.fmt((String)"Unsupported event \"%s\": event is not declared as controllable or uncontrollable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        List automata = Lists.list();
        CifToSynthesisConverter.collectAutomata((ComplexComponent)spec, automata);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        List plants = Lists.list();
        List requirements = Lists.list();
        for (Automaton cifAut : automata) {
            switch (cifAut.getKind()) {
                case PLANT: {
                    plants.add(cifAut);
                    break;
                }
                case REQUIREMENT: {
                    requirements.add(cifAut);
                    break;
                }
                default: {
                    String msg = Strings.fmt((String)"Unsupported automaton \"%s\": only plant and requirement automata are supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)cifAut)});
                    this.problems.add(msg);
                }
            }
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        if (plants.isEmpty()) {
            String msg = "Unsupported specification: no plant automata found.";
            this.problems.add(msg);
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        automata = Lists.concat((List)plants, (List)requirements);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        List plantAlphabets = Lists.listc((int)plants.size());
        List reqAlphabets = Lists.listc((int)requirements.size());
        Set plantAlphabet = Sets.set();
        Set reqAlphabet = Sets.set();
        for (Automaton plant : plants) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)plant, null);
            plantAlphabets.add(alphabets);
            plantAlphabet.addAll(alphabets.syncAlphabet);
            plantAlphabet.addAll(alphabets.sendAlphabet);
            plantAlphabet.addAll(alphabets.recvAlphabet);
        }
        for (Automaton req : requirements) {
            alphabets = CifEventUtils.getAllAlphabets((Automaton)req, null);
            reqAlphabets.add(alphabets);
            reqAlphabet.addAll(alphabets.syncAlphabet);
            reqAlphabet.addAll(alphabets.sendAlphabet);
            reqAlphabet.addAll(alphabets.recvAlphabet);
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.alphabet = Sets.union((Set)plantAlphabet, (Set)reqAlphabet);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        int i = 0;
        while (i < requirements.size()) {
            Set commEvents = Sets.union((Set)((CifEventUtils.Alphabets)reqAlphabets.get((int)i)).sendAlphabet, (Set)((CifEventUtils.Alphabets)reqAlphabets.get((int)i)).recvAlphabet);
            if (!commEvents.isEmpty()) {
                List names = Lists.listc((int)commEvents.size());
                Iterator iterator = commEvents.iterator();
                while (iterator.hasNext()) {
                    Event extra = (Event)iterator.next();
                    names.add("\"" + CifTextUtils.getAbsName((PositionObject)extra) + "\"");
                }
                String msg = Strings.fmt((String)"Unsupported %s: requirement uses channel%s: %s.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)((ComplexComponent)requirements.get(i))), commEvents.size() == 1 ? "" : "s", StringUtils.join((Collection)names, (String)", ")});
                this.problems.add(msg);
            }
            ++i;
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.controllables = Sets.set();
        for (Event event : synthAut.alphabet) {
            if (event.getControllable() == null || !event.getControllable().booleanValue()) continue;
            synthAut.controllables.add(event);
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        List cifVarObjs = Lists.list();
        CifToSynthesisConverter.collectVariableObjects((ComplexComponent)spec, cifVarObjs);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        final Map autToLpMap = Maps.mapc((int)automata.size());
        Map lpToAutMap = Maps.mapc((int)automata.size());
        Specification dummySpec = CifConstructors.newSpecification();
        List lpAuts = Lists.filter((List)cifVarObjs, Automaton.class);
        for (Automaton lpAut : lpAuts) {
            DiscVariable var = CifConstructors.newDiscVariable();
            var.setName(CifTextUtils.getAbsName((PositionObject)lpAut));
            autToLpMap.put(lpAut, var);
            lpToAutMap.put(var, lpAut);
            dummySpec.getDeclarations().add((Object)var);
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.variables = new SynthesisVariable[cifVarObjs.size()];
        int i2 = 0;
        while (i2 < synthAut.variables.length) {
            PositionObject positionObject = (PositionObject)cifVarObjs.get(i2);
            if (positionObject instanceof Automaton) {
                Automaton lpAut = (Automaton)positionObject;
                DiscVariable lpVar = (DiscVariable)autToLpMap.get(lpAut);
                synthAut.variables[i2] = this.createLpVar(lpAut, lpVar);
            } else {
                synthAut.variables[i2] = this.convertTypedVar((Declaration)positionObject);
            }
            ++i2;
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.orderVars(synthAut, spec, dbgEnabled);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.createVarDomains(synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.createUpdateAuxiliaries(synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        LocationPointerManager locPtrManager = new LocationPointerManager(){

            public Update createLocUpdate(Location loc) {
                Automaton aut = (Automaton)loc.eContainer();
                int locIdx = aut.getLocations().indexOf((Object)loc);
                DiscVariable lp = (DiscVariable)autToLpMap.get(aut);
                Assert.notNull((Object)lp);
                IntType type = CifConstructors.newIntType();
                type.setLower(Integer.valueOf(0));
                type.setUpper(Integer.valueOf(aut.getLocations().size() - 1));
                DiscVariableExpression lpRef = CifConstructors.newDiscVariableExpression();
                lpRef.setVariable(lp);
                lpRef.setType((CifType)type);
                Assignment asgn = CifConstructors.newAssignment();
                asgn.setAddressable((Expression)lpRef);
                asgn.setValue(CifValueUtils.makeInt((int)locIdx));
                return asgn;
            }

            public Expression createLocRef(Location loc) {
                return CifGuardUtils.LocRefExprCreator.DEFAULT.create(loc);
            }
        };
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.initialsVars = Lists.listc((int)synthAut.variables.length);
        boolean bl = false;
        while (var19_25 < synthAut.variables.length) {
            synthAut.initialsVars.add(null);
            ++var19_25;
        }
        synthAut.initialsComps = Lists.list();
        synthAut.initialsLocs = Lists.list();
        synthAut.initialVars = synthAut.factory.one();
        synthAut.initialComps = synthAut.factory.one();
        synthAut.initialLocs = synthAut.factory.one();
        this.convertInit((ComplexComponent)spec, synthAut, locPtrManager);
        synthAut.initialUnctrl = synthAut.initialVars.and(synthAut.initialComps).and(synthAut.initialLocs);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.markedsComps = Lists.list();
        synthAut.markedsLocs = Lists.list();
        synthAut.markedComps = synthAut.factory.one();
        synthAut.markedLocs = synthAut.factory.one();
        this.convertMarked((ComplexComponent)spec, synthAut, locPtrManager);
        synthAut.marked = synthAut.markedComps.and(synthAut.markedLocs);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.reqInvsComps = Lists.list();
        synthAut.reqInvsLocs = Lists.list();
        synthAut.reqInvComps = synthAut.factory.one();
        synthAut.reqInvLocs = synthAut.factory.one();
        this.convertStateReqInvs((ComplexComponent)spec, synthAut, locPtrManager);
        synthAut.reqInv = synthAut.reqInvComps.and(synthAut.reqInvLocs);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.initialReqInv = synthAut.initialUnctrl.and(synthAut.reqInv);
        synthAut.markedReqInv = synthAut.marked.and(synthAut.reqInv);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        synthAut.stateEvtExclPlants = Maps.mapc((int)synthAut.alphabet.size());
        synthAut.stateEvtExclPlantLists = Maps.mapc((int)synthAut.alphabet.size());
        for (Event event : synthAut.alphabet) {
            synthAut.stateEvtExclPlants.put(event, synthAut.factory.one());
            synthAut.stateEvtExclPlantLists.put(event, Lists.list());
        }
        synthAut.stateEvtExclsReqAuts = Maps.mapc((int)synthAut.controllables.size());
        synthAut.stateEvtExclsReqInvs = Maps.mapc((int)synthAut.controllables.size());
        for (Event event : synthAut.controllables) {
            synthAut.stateEvtExclsReqAuts.put(event, synthAut.factory.one());
            synthAut.stateEvtExclsReqInvs.put(event, synthAut.factory.one());
        }
        synthAut.stateEvtExclReqs = Maps.mapc((int)synthAut.alphabet.size());
        synthAut.stateEvtExclReqLists = Maps.mapc((int)synthAut.alphabet.size());
        for (Event event : synthAut.alphabet) {
            synthAut.stateEvtExclReqs.put(event, synthAut.factory.one());
            synthAut.stateEvtExclReqLists.put(event, Lists.list());
        }
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.convertStateEvtExclInvs((ComplexComponent)spec, synthAut, locPtrManager);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.preconvertReqAuts(requirements, reqAlphabets, synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.convertPlantReqAuts(plants, requirements, plantAlphabets, reqAlphabets, locPtrManager, lpToAutMap, synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        for (Map.Entry entry : this.originalMonitors.entrySet()) {
            ((Automaton)entry.getKey()).setMonitors((Monitors)entry.getValue());
        }
        this.originalMonitors = null;
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.addInputVariableEdges(synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        this.orderEdges(synthAut);
        if (synthAut.env.isTerminationRequested()) {
            return synthAut;
        }
        return synthAut;
    }

    private SynthesisVariable convertTypedVar(Declaration var) {
        int upper;
        int lower;
        int count;
        CifType type;
        if (var instanceof DiscVariable) {
            type = ((DiscVariable)var).getType();
        } else if (var instanceof InputVariable) {
            type = ((InputVariable)var).getType();
        } else {
            throw new RuntimeException("Unexpected variable: " + var);
        }
        type = CifTypeUtils.normalizeType((CifType)type);
        if (type instanceof BoolType) {
            count = 2;
            lower = 0;
            upper = 1;
        } else if (type instanceof IntType) {
            IntType intType = (IntType)type;
            if (CifTypeUtils.isRangeless((IntType)intType)) {
                String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables with rangeless integer types are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
                this.problems.add(msg);
                return null;
            }
            lower = intType.getLower();
            upper = intType.getUpper();
            if (lower < 0) {
                String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables with integer type ranges that include negative values are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
                this.problems.add(msg);
                return null;
            }
            count = upper - lower + 1;
        } else if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            count = enumDecl.getLiterals().size();
            lower = 0;
            upper = count - 1;
        } else {
            String msg = Strings.fmt((String)"Unsupported variable \"%s\": variables of type \"%s\" are not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.typeToStr((CifType)type)});
            this.problems.add(msg);
            return null;
        }
        if (var instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)var;
            return new SynthesisDiscVariable(discVar, type, count, lower, upper);
        }
        if (var instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)var;
            return new SynthesisInputVariable(inputVar, type, count, lower, upper);
        }
        throw new RuntimeException("Unexpected variable: " + var);
    }

    private SynthesisVariable createLpVar(Automaton aut, DiscVariable var) {
        int count = aut.getLocations().size();
        Assert.check((count > 1 ? 1 : 0) != 0);
        return new SynthesisLocPtrVariable(aut, var);
    }

    private void orderVars(SynthesisAutomaton synthAut, Specification spec, boolean dbgEnabled) {
        int varCnt = synthAut.variables.length;
        int i = 0;
        while (i < varCnt) {
            SynthesisVariable var = synthAut.variables[i];
            if (var == null) {
                return;
            }
            ++i;
        }
        String orderTxt = BddVariableOrderOption.getOrder();
        if (orderTxt.toLowerCase(Locale.US).equals("model")) {
            int i2 = 0;
            while (i2 < varCnt) {
                synthAut.variables[i2].group = i2;
                ++i2;
            }
        } else if (orderTxt.toLowerCase(Locale.US).equals("reverse-model")) {
            ArrayUtils.reverse((Object[])synthAut.variables);
            int i3 = 0;
            while (i3 < varCnt) {
                synthAut.variables[i3].group = i3;
                ++i3;
            }
        } else if (orderTxt.toLowerCase(Locale.US).equals("sorted")) {
            Arrays.sort(synthAut.variables, (v, w) -> Strings.SORTER.compare(v.rawName, w.rawName));
            int i4 = 0;
            while (i4 < varCnt) {
                synthAut.variables[i4].group = i4;
                ++i4;
            }
        } else if (orderTxt.toLowerCase(Locale.US).equals("reverse-sorted")) {
            Arrays.sort(synthAut.variables, (v, w) -> Strings.SORTER.compare(v.rawName, w.rawName));
            ArrayUtils.reverse((Object[])synthAut.variables);
            int i5 = 0;
            while (i5 < varCnt) {
                synthAut.variables[i5].group = i5;
                ++i5;
            }
        } else if (orderTxt.toLowerCase(Locale.US).equals("random") || orderTxt.toLowerCase(Locale.US).startsWith("random:")) {
            Long seed = null;
            if (orderTxt.contains(":")) {
                int idx = orderTxt.indexOf(":");
                String seedTxt = orderTxt.substring(idx + 1);
                try {
                    seed = Long.parseUnsignedLong(seedTxt);
                }
                catch (NumberFormatException ex) {
                    String msg = Strings.fmt((String)"Invalid BDD variable random order seed number: \"%s\".", (Object[])new Object[]{orderTxt});
                    throw new InvalidOptionException(msg, (Throwable)ex);
                }
            }
            List<SynthesisVariable> vars = Arrays.asList(synthAut.variables);
            if (seed == null) {
                Collections.shuffle(vars);
            } else {
                Collections.shuffle(vars, new Random(seed));
            }
            synthAut.variables = vars.toArray(synthAut.variables);
            int i6 = 0;
            while (i6 < varCnt) {
                synthAut.variables[i6].group = i6;
                ++i6;
            }
        } else {
            SynthesisVariable[] vars = new SynthesisVariable[varCnt];
            int varIdx = 0;
            int group = 0;
            String[] stringArray = StringUtils.split((String)orderTxt, (String)";");
            int n = stringArray.length;
            int msg = 0;
            while (msg < n) {
                String groupTxt = stringArray[msg];
                if (!(groupTxt = groupTxt.trim()).isEmpty()) {
                    boolean anyVar = false;
                    String[] stringArray2 = StringUtils.split((String)groupTxt, (String)",");
                    int n2 = stringArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String elemTxt = stringArray2[n3];
                        if (!(elemTxt = elemTxt.trim()).isEmpty()) {
                            String regEx = elemTxt.replace(".", "\\.");
                            regEx = regEx.replace("*", ".*");
                            Pattern pattern = Pattern.compile("^" + regEx + "$");
                            List matches = Lists.list();
                            int i7 = 0;
                            while (i7 < varCnt) {
                                String name = synthAut.variables[i7].rawName;
                                if (pattern.matcher(name).matches()) {
                                    matches.add(synthAut.variables[i7]);
                                }
                                ++i7;
                            }
                            if (matches.isEmpty()) {
                                String msg2 = Strings.fmt((String)"Invalid BDD variable order: can't find a match for \"%s\". There is no supported variable or automaton (with two or more locations) in the specification that matches the given name pattern.", (Object[])new Object[]{elemTxt});
                                throw new InvalidOptionException(msg2);
                            }
                            Collections.sort(matches, (v, w) -> Strings.SORTER.compare(v.rawName, w.rawName));
                            for (SynthesisVariable var : matches) {
                                if (var.group != -1) {
                                    String msg3 = Strings.fmt((String)"Invalid BDD variable order: \"%s\" is included more than once.", (Object[])new Object[]{var.name});
                                    throw new InvalidOptionException(msg3);
                                }
                                var.group = group;
                                vars[varIdx] = var;
                                ++varIdx;
                                anyVar = true;
                            }
                        }
                        ++n3;
                    }
                    if (anyVar) {
                        ++group;
                    }
                }
                ++msg;
            }
            if (varIdx < varCnt) {
                List names = Lists.list();
                int i8 = 0;
                while (i8 < varCnt) {
                    if (synthAut.variables[i8].group == -1) {
                        names.add("\"" + synthAut.variables[i8].name + "\"");
                    }
                    ++i8;
                }
                Collections.sort(names, Strings.SORTER);
                String msg4 = Strings.fmt((String)"Invalid BDD variable order: the following are missing from the specified order: %s.", (Object[])new Object[]{StringUtils.join((Collection)names, (String)", ")});
                throw new InvalidOptionException(msg4);
            }
            synthAut.variables = vars;
        }
        CifToSynthesisConverter.applyVariableReorder(synthAut, spec, dbgEnabled);
    }

    private static void applyVariableReorder(SynthesisAutomaton synthAut, Specification spec, boolean dbgEnabled) {
        AutoVarOrderer orderer;
        boolean doAny;
        if (synthAut.variables.length == 0) {
            return;
        }
        if (dbgEnabled) {
            CifToSynthesisConverter.debugCifVars(synthAut);
        }
        boolean doForce = BddForceVarOrderOption.isEnabled();
        boolean doSlidWin = BddSlidingWindowVarOrderOption.isEnabled();
        boolean bl = doAny = doForce || doSlidWin;
        if (!doAny) {
            if (dbgEnabled) {
                OutputProvider.dbg();
            }
            return;
        }
        HyperEdgeCreator creator = new HyperEdgeCreator();
        List<BitSet> hyperEdges = creator.getHyperEdges(spec, synthAut);
        List orderers = Lists.list();
        if (doForce) {
            orderers.add(new ForceVarOrderer());
        }
        if (doSlidWin) {
            int maxLen = BddSlidingWindowSizeOption.getMaxLen();
            orderers.add(new SlidingWindowVarOrderer(maxLen));
        }
        if (orderers.size() == 1) {
            orderer = (AutoVarOrderer)Lists.first((List)orderers);
        } else {
            CombiVarOrderer combi = new CombiVarOrderer();
            combi.children.addAll(orderers);
            orderer = combi;
        }
        boolean reordered = orderer.order(synthAut, hyperEdges, dbgEnabled);
        if (dbgEnabled) {
            if (reordered) {
                CifToSynthesisConverter.debugCifVars(synthAut);
            }
            OutputProvider.dbg();
        }
    }

    private static void debugCifVars(SynthesisAutomaton aut) {
        int cifVarCnt = aut.variables.length;
        GridBox grid = new GridBox(cifVarCnt + 4, 9, 0, 2);
        grid.set(0, 0, "Nr");
        grid.set(0, 1, "Kind");
        grid.set(0, 2, "Type");
        grid.set(0, 3, "Name");
        grid.set(0, 4, "Group");
        grid.set(0, 5, "BDD vars");
        grid.set(0, 6, "CIF values");
        grid.set(0, 7, "BDD values");
        grid.set(0, 8, "Values used");
        Set groups = Sets.set();
        int totalBddVarCnt = 0;
        int totalUsedCnt = 0;
        int totalReprCnt = 0;
        int i = 0;
        while (i < cifVarCnt) {
            SynthesisVariable var = aut.variables[i];
            String typeTxt = var.getTypeText();
            if (typeTxt == null) {
                typeTxt = "n/a";
            }
            int bddCnt = var.getBddVarCount();
            int usedCnt = var.count;
            int reprCnt = 1 << bddCnt;
            grid.set(i + 2, 0, Strings.str((Object)(i + 1)));
            grid.set(i + 2, 1, var.getKindText());
            grid.set(i + 2, 2, typeTxt);
            grid.set(i + 2, 3, var.name);
            grid.set(i + 2, 4, Strings.str((Object)var.group));
            grid.set(i + 2, 5, String.valueOf(Strings.str((Object)bddCnt)) + " * 2");
            grid.set(i + 2, 6, String.valueOf(Strings.str((Object)usedCnt)) + " * 2");
            grid.set(i + 2, 7, String.valueOf(Strings.str((Object)reprCnt)) + " * 2");
            grid.set(i + 2, 8, CifToSynthesisConverter.getPercentageText(usedCnt, reprCnt));
            groups.add(var.group);
            totalBddVarCnt += bddCnt * 2;
            totalUsedCnt += usedCnt * 2;
            totalReprCnt += reprCnt * 2;
            ++i;
        }
        grid.set(cifVarCnt + 3, 0, "Total");
        grid.set(cifVarCnt + 3, 1, "");
        grid.set(cifVarCnt + 3, 2, "");
        grid.set(cifVarCnt + 3, 3, "");
        grid.set(cifVarCnt + 3, 4, Strings.str((Object)groups.size()));
        grid.set(cifVarCnt + 3, 5, Strings.str((Object)totalBddVarCnt));
        grid.set(cifVarCnt + 3, 6, Strings.str((Object)totalUsedCnt));
        grid.set(cifVarCnt + 3, 7, Strings.str((Object)totalReprCnt));
        grid.set(cifVarCnt + 3, 8, CifToSynthesisConverter.getPercentageText(totalUsedCnt, totalReprCnt));
        GridBox.GridBoxLayout layout = grid.computeLayout();
        int i2 = 0;
        while (i2 < layout.numCols) {
            String bar = Strings.duplicate((String)"-", (int)layout.widths[i2]);
            grid.set(1, i2, bar);
            grid.set(cifVarCnt + 2, i2, bar);
            ++i2;
        }
        OutputProvider.dbg();
        OutputProvider.dbg((String)"CIF variables and location pointers:");
        for (String line : grid.getLines()) {
            OutputProvider.dbg((String)("  " + line));
        }
    }

    private static String getPercentageText(int part, int total) {
        double percentage = 100.0 * (double)part / (double)total;
        if (Double.isNaN(percentage)) {
            return "n/a";
        }
        String txt = Strings.fmt((String)"%.0f", (Object[])new Object[]{percentage});
        if ((double)((int)Math.floor(percentage)) != percentage) {
            txt = "~" + txt;
        }
        txt = String.valueOf(txt) + "%";
        return txt;
    }

    private void createVarDomains(SynthesisAutomaton synthAut) {
        SynthesisVariable var;
        int varCnt = synthAut.variables.length;
        if (varCnt == 0) {
            return;
        }
        boolean ordered = true;
        int i = 0;
        while (i < varCnt) {
            var = synthAut.variables[i];
            if (var == null || var.group == -1) {
                ordered = false;
                break;
            }
            ++i;
        }
        if (!ordered) {
            i = 0;
            while (i < varCnt) {
                var = synthAut.variables[i];
                if (var != null) {
                    int size = var.getDomainSize();
                    var.domain = synthAut.factory.extDomain((long)size);
                    var.domainNew = synthAut.factory.extDomain((long)size);
                    var.group = i;
                }
                ++i;
            }
            return;
        }
        int cur = 0;
        int i2 = 0;
        while (i2 < varCnt) {
            int group = synthAut.variables[i2].group;
            if (group != cur) {
                if (group == cur + 1) {
                    cur = group;
                } else {
                    Assert.fail((Object)Strings.fmt((String)"Invalid cur/group: %d/%d.", (Object[])new Object[]{cur, group}));
                }
            }
            ++i2;
        }
        SynthesisVariable lastVar = synthAut.variables[varCnt - 1];
        int[] counts = new int[lastVar.group + 1];
        int i3 = 0;
        while (i3 < varCnt) {
            int n = synthAut.variables[i3].group;
            counts[n] = counts[n] + 1;
            ++i3;
        }
        int offset = 0;
        int grpIdx = 0;
        while (grpIdx < counts.length) {
            int grpVarCnt = counts[grpIdx];
            int[] sizes = new int[grpVarCnt * 2];
            int varIdx = 0;
            while (varIdx < grpVarCnt) {
                int size;
                sizes[2 * varIdx + 0] = size = synthAut.variables[offset + varIdx].getDomainSize();
                sizes[2 * varIdx + 1] = size;
                ++varIdx;
            }
            BDDDomain[] domains = synthAut.factory.extDomain(sizes);
            int varIdx2 = 0;
            while (varIdx2 < grpVarCnt) {
                synthAut.variables[offset + varIdx2].domain = domains[2 * varIdx2 + 0];
                synthAut.variables[offset + varIdx2].domainNew = domains[2 * varIdx2 + 1];
                ++varIdx2;
            }
            offset += grpVarCnt;
            ++grpIdx;
        }
    }

    private void createUpdateAuxiliaries(SynthesisAutomaton synthAut) {
        int cifVarCnt = synthAut.variables.length;
        int domainCnt = synthAut.factory.numberOfDomains();
        if (cifVarCnt * 2 != domainCnt) {
            return;
        }
        BDDDomain[] oldDomains = new BDDDomain[cifVarCnt];
        BDDDomain[] newDomains = new BDDDomain[cifVarCnt];
        int i = 0;
        while (i < cifVarCnt) {
            oldDomains[i] = synthAut.variables[i].domain;
            newDomains[i] = synthAut.variables[i].domainNew;
            ++i;
        }
        synthAut.oldToNewVarsPairing = synthAut.factory.makePair();
        synthAut.newToOldVarsPairing = synthAut.factory.makePair();
        synthAut.oldToNewVarsPairing.set(oldDomains, newDomains);
        synthAut.newToOldVarsPairing.set(newDomains, oldDomains);
        if (synthAut.env.isTerminationRequested()) {
            return;
        }
        int bddVarCnt = synthAut.factory.varNum();
        Assert.check((bddVarCnt % 2 == 0 ? 1 : 0) != 0);
        int[] varIdxsOld = new int[bddVarCnt / 2];
        int[] varIdxsNew = new int[bddVarCnt / 2];
        int varIdx = 0;
        int i2 = 0;
        while (i2 < oldDomains.length) {
            BDDDomain oldDomain = oldDomains[i2];
            BDDDomain newDomain = newDomains[i2];
            int[] domainVarIdxsOld = oldDomain.vars();
            int[] domainVarIdxsNew = newDomain.vars();
            System.arraycopy(domainVarIdxsOld, 0, varIdxsOld, varIdx, domainVarIdxsOld.length);
            System.arraycopy(domainVarIdxsNew, 0, varIdxsNew, varIdx, domainVarIdxsNew.length);
            varIdx += domainVarIdxsOld.length;
            ++i2;
        }
        synthAut.varSetOld = synthAut.factory.makeSet(varIdxsOld);
        synthAut.varSetNew = synthAut.factory.makeSet(varIdxsNew);
        if (synthAut.env.isTerminationRequested()) {
            return;
        }
    }

    private void convertInit(ComplexComponent comp, SynthesisAutomaton synthAut, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getInitials()) {
            BDD initial;
            try {
                initial = CifToSynthesisConverter.convertPred(pred, true, synthAut);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of initialization predicate \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            synthAut.initialsComps.add(initial);
            synthAut.initialComps = synthAut.initialComps.andWith(initial.id());
        }
        if (comp instanceof Automaton) {
            for (Declaration cifDecl : comp.getDeclarations()) {
                BDD pred;
                List values;
                DiscVariable cifVar;
                int varIdx;
                if (!(cifDecl instanceof DiscVariable) || (varIdx = CifToSynthesisConverter.getDiscVarIdx(synthAut.variables, cifVar = (DiscVariable)cifDecl)) == -1) continue;
                SynthesisVariable synthVar = synthAut.variables[varIdx];
                Assert.check((boolean)(synthVar instanceof SynthesisDiscVariable));
                SynthesisDiscVariable var = (SynthesisDiscVariable)synthVar;
                if (cifVar.getValue() == null) {
                    CifType type = cifVar.getType();
                    values = Lists.list((Object)CifValueUtils.getDefaultValue((CifType)type, null));
                } else {
                    values = cifVar.getValue().getValues().isEmpty() ? null : cifVar.getValue().getValues();
                }
                if (values == null) {
                    pred = BddUtils.getVarDomain(var, false, synthAut.factory);
                } else {
                    pred = synthAut.factory.zero();
                    for (Expression value : values) {
                        CifBddBitVectorAndCarry valueRslt;
                        if (var.type instanceof BoolType) {
                            BDD valueBdd;
                            try {
                                valueBdd = CifToSynthesisConverter.convertPred(value, true, synthAut);
                            }
                            catch (UnsupportedPredicateException ex) {
                                if (ex.expr != null) {
                                    String msg = Strings.fmt((String)"Unsupported variable \"%s\": unsupported part \"%s\" of initial value \"%s\": %s", (Object[])new Object[]{var.name, CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)value), ex.getMessage()});
                                    this.problems.add(msg);
                                }
                                pred.free();
                                pred = synthAut.factory.one();
                                continue;
                            }
                            Assert.check((var.domain.varNum() == 1 ? 1 : 0) != 0);
                            int varVar = var.domain.vars()[0];
                            BDD varBdd = synthAut.factory.ithVar(varVar);
                            BDD relation = varBdd.biimpWith(valueBdd);
                            pred = pred.orWith(relation);
                            continue;
                        }
                        Supplier<String> partMsg = () -> Strings.fmt((String)"initial value \"%s\" of variable \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)value), synthesisDiscVariable.name});
                        try {
                            valueRslt = CifToSynthesisConverter.convertExpr(value, true, synthAut, false, partMsg);
                        }
                        catch (UnsupportedPredicateException ex) {
                            if (ex.expr != null) {
                                String msg = Strings.fmt((String)"Unsupported variable \"%s\": unsupported part \"%s\" of initial value \"%s\": %s", (Object[])new Object[]{var.name, CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)value), ex.getMessage()});
                                this.problems.add(msg);
                            }
                            pred.free();
                            pred = synthAut.factory.one();
                            continue;
                        }
                        CifBddBitVector valueVec = valueRslt.vector;
                        Assert.check((boolean)valueRslt.carry.isZero());
                        CifBddBitVector varVec = CifBddBitVector.createDomain(var.domain);
                        int len = Math.max(varVec.length(), varVec.length());
                        varVec.resize(len);
                        valueVec.resize(len);
                        BDD relation = varVec.equalTo(valueVec);
                        varVec.free();
                        valueVec.free();
                        pred = pred.orWith(relation);
                    }
                }
                synthAut.initialsVars.set(varIdx, pred);
                synthAut.initialVars = synthAut.initialVars.andWith(pred.id());
            }
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autInit = synthAut.factory.zero();
            for (Location loc : aut.getLocations()) {
                BDD srcLocPred;
                if (loc.getInitials().isEmpty()) continue;
                BDD locInit = synthAut.factory.one();
                EList locInits = loc.getInitials();
                try {
                    locInit = CifToSynthesisConverter.convertPreds((List<Expression>)locInits, true, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of initialization predicate(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)locInits), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                try {
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    srcLocPred = CifToSynthesisConverter.convertPred(srcLocRef, true, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    throw new RuntimeException(ex);
                }
                locInit = locInit.and(srcLocPred);
                autInit = autInit.or(locInit);
            }
            synthAut.initialsLocs.add(autInit);
            synthAut.initialLocs = synthAut.initialLocs.andWith(autInit.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertInit((ComplexComponent)child, synthAut, locPtrManager);
            }
        }
    }

    private void convertMarked(ComplexComponent comp, SynthesisAutomaton synthAut, LocationPointerManager locPtrManager) {
        for (Expression pred : comp.getMarkeds()) {
            BDD marked;
            try {
                marked = CifToSynthesisConverter.convertPred(pred, false, synthAut);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of marker predicate \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            synthAut.markedsComps.add(marked);
            synthAut.markedComps = synthAut.markedComps.andWith(marked.id());
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            BDD autMarked = synthAut.factory.zero();
            for (Location loc : aut.getLocations()) {
                BDD srcLocPred;
                if (loc.getMarkeds().isEmpty()) continue;
                BDD locMarked = synthAut.factory.one();
                EList locMarkeds = loc.getMarkeds();
                try {
                    locMarked = CifToSynthesisConverter.convertPreds((List<Expression>)locMarkeds, false, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of marker predicate(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)locMarkeds), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                try {
                    Expression srcLocRef = locPtrManager.createLocRef(loc);
                    srcLocPred = CifToSynthesisConverter.convertPred(srcLocRef, false, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    throw new RuntimeException(ex);
                }
                locMarked = locMarked.andWith(srcLocPred);
                autMarked = autMarked.orWith(locMarked);
            }
            synthAut.markedsLocs.add(autMarked);
            synthAut.markedLocs = synthAut.markedLocs.andWith(autMarked.id());
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertMarked((ComplexComponent)child, synthAut, locPtrManager);
            }
        }
    }

    private void convertStateReqInvs(ComplexComponent comp, SynthesisAutomaton synthAut, LocationPointerManager locPtrManager) {
        String msg;
        for (Invariant inv : comp.getInvariants()) {
            BDD reqInvComp;
            if (inv.getInvKind() != InvKind.STATE) continue;
            if (inv.getSupKind() != SupKind.REQUIREMENT) {
                String msg2 = Strings.fmt((String)"Unsupported %s: for state invariants, only requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
                this.problems.add(msg2);
                continue;
            }
            Expression pred = inv.getPredicate();
            try {
                reqInvComp = CifToSynthesisConverter.convertPred(pred, false, synthAut);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of state invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            synthAut.reqInvsComps.add(reqInvComp);
            synthAut.reqInvComps = synthAut.reqInvComps.andWith(reqInvComp.id());
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    BDD srcLocPred;
                    BDD reqInvLoc;
                    if (inv.getInvKind() != InvKind.STATE) continue;
                    if (inv.getSupKind() != SupKind.REQUIREMENT) {
                        msg = Strings.fmt((String)"Unsupported %s: for state invariants, only requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        continue;
                    }
                    Expression pred = inv.getPredicate();
                    try {
                        reqInvLoc = CifToSynthesisConverter.convertPred(pred, false, synthAut);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        String msg3 = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of state invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)pred), ex.getMessage()});
                        this.problems.add(msg3);
                        continue;
                    }
                    try {
                        Expression srcLocRef = locPtrManager.createLocRef(loc);
                        srcLocPred = CifToSynthesisConverter.convertPred(srcLocRef, false, synthAut);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        throw new RuntimeException(ex);
                    }
                    reqInvLoc = srcLocPred.not().orWith(reqInvLoc);
                    srcLocPred.free();
                    synthAut.reqInvsLocs.add(reqInvLoc);
                    synthAut.reqInvLocs = synthAut.reqInvLocs.andWith(reqInvLoc.id());
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateReqInvs((ComplexComponent)child, synthAut, locPtrManager);
            }
        }
    }

    private void convertStateEvtExclInvs(ComplexComponent comp, SynthesisAutomaton synthAut, LocationPointerManager locPtrManager) {
        String msg;
        for (Invariant inv : comp.getInvariants()) {
            BDD compInv;
            if (inv.getInvKind() == InvKind.STATE) continue;
            if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                String msg2 = Strings.fmt((String)"Unsupported %s: for state/event exclusion invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
                this.problems.add(msg2);
                continue;
            }
            Event event = ((EventExpression)inv.getEvent()).getEvent();
            if (!synthAut.alphabet.contains(event)) {
                String msg3 = Strings.fmt((String)"State/event exclusion invariant \"%s\" of %s has no effect, as event \"%s\" is not in the alphabet of any automaton.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false), CifTextUtils.getComponentText2((ComplexComponent)comp), CifTextUtils.getAbsName((PositionObject)event)});
                OutputProvider.warn((String)msg3);
                continue;
            }
            Expression pred = inv.getPredicate();
            try {
                compInv = CifToSynthesisConverter.convertPred(pred, false, synthAut);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr == null) continue;
                msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.invToStr((Invariant)inv, (boolean)false), ex.getMessage()});
                this.problems.add(msg);
                continue;
            }
            if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                BDD compInvNot = compInv.not();
                compInv.free();
                compInv = compInvNot;
            }
            if (inv.getSupKind() == SupKind.PLANT) {
                this.storeStateEvtExclInv(synthAut.stateEvtExclPlantLists, event, compInv.id());
                this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclPlants, event, compInv.id());
            } else if (inv.getSupKind() == SupKind.REQUIREMENT) {
                this.storeStateEvtExclInv(synthAut.stateEvtExclReqLists, event, compInv.id());
                this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclReqs, event, compInv.id());
                if (Boolean.TRUE.equals(event.getControllable())) {
                    this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclsReqInvs, event, compInv.id());
                }
            } else {
                throw new RuntimeException("Unexpected kind: " + inv.getSupKind());
            }
            compInv.free();
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    BDD srcLocPred;
                    BDD locInv;
                    if (inv.getInvKind() == InvKind.STATE) continue;
                    if (inv.getSupKind() != SupKind.PLANT && inv.getSupKind() != SupKind.REQUIREMENT) {
                        String msg4 = Strings.fmt((String)"Unsupported %s: for state/event exclusion invariants, only plant and requirement invariants are supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg4);
                        continue;
                    }
                    Event event = ((EventExpression)inv.getEvent()).getEvent();
                    if (!synthAut.alphabet.contains(event)) {
                        msg = Strings.fmt((String)"State/event exclusion invariant \"%s\" of %s has no effect, as event \"%s\" is not in the alphabet of any automaton.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false), CifTextUtils.getLocationText2((Location)loc), CifTextUtils.getAbsName((PositionObject)event)});
                        OutputProvider.warn((String)msg);
                        continue;
                    }
                    Expression pred = inv.getPredicate();
                    try {
                        locInv = CifToSynthesisConverter.convertPred(pred, false, synthAut);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        String msg5 = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of invariant \"%s\": %s", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.invToStr((Invariant)inv, (boolean)false), ex.getMessage()});
                        this.problems.add(msg5);
                        continue;
                    }
                    try {
                        Expression srcLocRef = locPtrManager.createLocRef(loc);
                        srcLocPred = CifToSynthesisConverter.convertPred(srcLocRef, false, synthAut);
                    }
                    catch (UnsupportedPredicateException ex) {
                        if (ex.expr == null) continue;
                        throw new RuntimeException(ex);
                    }
                    locInv = srcLocPred.not().orWith(locInv);
                    srcLocPred.free();
                    if (inv.getInvKind() == InvKind.EVENT_DISABLES) {
                        BDD locInvNot = locInv.not();
                        locInv.free();
                        locInv = locInvNot;
                    }
                    if (inv.getSupKind() == SupKind.PLANT) {
                        this.storeStateEvtExclInv(synthAut.stateEvtExclPlantLists, event, locInv.id());
                        this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclPlants, event, locInv.id());
                    } else if (inv.getSupKind() == SupKind.REQUIREMENT) {
                        this.storeStateEvtExclInv(synthAut.stateEvtExclReqLists, event, locInv.id());
                        this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclReqs, event, locInv.id());
                        if (Boolean.TRUE.equals(event.getControllable())) {
                            this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclsReqInvs, event, locInv.id());
                        }
                    } else {
                        throw new RuntimeException("Unexpected kind: " + inv.getSupKind());
                    }
                    locInv.free();
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                this.convertStateEvtExclInvs((ComplexComponent)child, synthAut, locPtrManager);
            }
        }
    }

    private void storeStateEvtExclInv(Map<Event, List<BDD>> eventInvs, Event event, BDD inv) {
        List<BDD> invs = eventInvs.get(event);
        invs.add(inv);
    }

    private void conjunctAndStoreStateEvtExclInv(Map<Event, BDD> eventInvs, Event event, BDD inv) {
        BDD invs = eventInvs.get(event);
        invs = invs.andWith(inv);
        eventInvs.put(event, invs);
    }

    private void preconvertReqAuts(List<Automaton> requirements, List<CifEventUtils.Alphabets> alphabets, SynthesisAutomaton synthAut) {
        this.originalMonitors = Maps.mapc((int)requirements.size());
        int i = 0;
        while (i < requirements.size()) {
            Automaton requirement = requirements.get(i);
            CifEventUtils.Alphabets reqAlphabets = alphabets.get(i);
            for (Event event : reqAlphabets.syncAlphabet) {
                BDD synthGuard;
                if (reqAlphabets.moniAlphabet.contains(event)) continue;
                Expression cifGuard = CifGuardUtils.mergeGuards((Automaton)requirement, (Event)event, EdgeEventImpl.class, (CifGuardUtils.LocRefExprCreator)CifGuardUtils.LocRefExprCreator.DEFAULT);
                try {
                    synthGuard = CifToSynthesisConverter.convertPred(cifGuard, false, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr == null) continue;
                    String msg = Strings.fmt((String)"Unsupported %s: unsupported part \"%s\" of combined guard \"%s\": %s", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)requirement), CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)cifGuard), ex.getMessage()});
                    this.problems.add(msg);
                    continue;
                }
                this.storeStateEvtExclInv(synthAut.stateEvtExclReqLists, event, synthGuard.id());
                this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclReqs, event, synthGuard.id());
                if (Boolean.TRUE.equals(event.getControllable())) {
                    this.conjunctAndStoreStateEvtExclInv(synthAut.stateEvtExclsReqAuts, event, synthGuard.id());
                }
                synthGuard.free();
            }
            if (!reqAlphabets.syncAlphabet.isEmpty()) {
                this.originalMonitors.put(requirement, requirement.getMonitors());
                requirement.setMonitors(CifConstructors.newMonitors());
                reqAlphabets.moniAlphabet = Sets.copy((Set)reqAlphabets.syncAlphabet);
            }
            ++i;
        }
    }

    private void convertPlantReqAuts(List<Automaton> plants, List<Automaton> requirements, List<CifEventUtils.Alphabets> plantAlphabets, List<CifEventUtils.Alphabets> reqAlphabets, LocationPointerManager locPtrManager, Map<DiscVariable, Automaton> lpToAutMap, SynthesisAutomaton synthAut) {
        List automata = Lists.concat(plants, requirements);
        List alphabets = Lists.concat(plantAlphabets, reqAlphabets);
        boolean tauOk = this.checkNoTauEdges(automata);
        if (tauOk) {
            List cifEdges = Lists.list();
            LinearizeProduct.linearizeEdges((List)automata, (List)alphabets, (List)Lists.set2list(synthAut.alphabet), (LocationPointerManager)locPtrManager, (boolean)false, (boolean)true, (List)cifEdges);
            synthAut.edges = Lists.listc((int)cifEdges.size());
            synthAut.eventEdges = Maps.mapc((int)synthAut.alphabet.size());
            for (Edge cifEdge : cifEdges) {
                BDD guard;
                Event event;
                if (synthAut.env.isTerminationRequested()) break;
                SynthesisEdge synthEdge = new SynthesisEdge(synthAut);
                synthEdge.edge = cifEdge;
                Assert.check((cifEdge.getEvents().size() == 1 ? 1 : 0) != 0);
                EdgeEvent edgeEvent = (EdgeEvent)Lists.first((List)cifEdge.getEvents());
                synthEdge.event = event = CifEventUtils.getEventFromEdgeEvent((EdgeEvent)edgeEvent);
                synthAut.edges.add(synthEdge);
                List synthEdges = synthAut.eventEdges.get(event);
                if (synthEdges == null) {
                    synthEdges = Lists.list();
                    synthAut.eventEdges.put(event, synthEdges);
                }
                synthEdges.add(synthEdge);
                try {
                    guard = CifToSynthesisConverter.convertPreds((List<Expression>)cifEdge.getGuards(), false, synthAut);
                }
                catch (UnsupportedPredicateException ex) {
                    if (ex.expr != null) {
                        String msg = Strings.fmt((String)"Unsupported linearized guard: unsupported part \"%s\" of guard(s) \"%s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprsToStr((List)cifEdge.getGuards()), ex.getMessage()});
                        this.problems.add(msg);
                    }
                    guard = synthAut.factory.zero();
                }
                synthEdge.guard = guard;
                synthEdge.origGuard = guard.id();
                EList updates = cifEdge.getUpdates();
                this.convertUpdates((List<Update>)updates, synthEdge, lpToAutMap, synthAut);
            }
            if (synthAut.env.isTerminationRequested()) {
                return;
            }
            this.checkNonDeterminism(synthAut.edges);
        }
    }

    private boolean checkNoTauEdges(List<Automaton> automata) {
        boolean tauOk = true;
        for (Automaton aut : automata) {
            for (Location loc : aut.getLocations()) {
                for (Edge edge : loc.getEdges()) {
                    if (edge.getEvents().isEmpty()) {
                        String msg = Strings.fmt((String)"Unsupported %s: edges without events (implicitly event \"tau\") are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        tauOk = false;
                    }
                    for (EdgeEvent edgeEvent : edge.getEvents()) {
                        Expression eventRef = edgeEvent.getEvent();
                        if (!(eventRef instanceof TauExpression)) continue;
                        String msg = Strings.fmt((String)"Unsupported %s: edges with \"tau\" events are not supported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
                        this.problems.add(msg);
                        tauOk = false;
                    }
                }
            }
        }
        return tauOk;
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonDeterminism(List<SynthesisEdge> edges) {
        Map eventGuards = Maps.map();
        Set conflicts = Sets.setc((int)0);
        for (SynthesisEdge edge : edges) {
            Event evt = edge.event;
            Boolean controllable = evt.getControllable();
            if (controllable == null || !controllable.booleanValue() || conflicts.contains(evt)) continue;
            BDD curGuard = (BDD)eventGuards.get(evt);
            BDD bDD = edge.guard;
            if (curGuard == null) {
                eventGuards.put(evt, bDD.id());
                continue;
            }
            BDD overlap = curGuard.and(bDD);
            if (overlap.isZero()) {
                eventGuards.put(evt, curGuard.orWith(bDD.id()));
            } else {
                conflicts.add(evt);
            }
            overlap.free();
        }
        for (BDD guard : eventGuards.values()) {
            guard.free();
        }
        for (Event conflict : conflicts) {
            void var9_15;
            List eventEdges = Lists.list();
            for (SynthesisEdge edge : edges) {
                if (edge.event != conflict) continue;
                eventEdges.add(edge);
            }
            List<List<SynthesisEdge>> groups = CifToSynthesisConverter.groupOnGuardOverlap(eventEdges);
            List guardsTxts = Lists.list();
            for (List list : groups) {
                if (list.size() < 2) continue;
                List guardTxts = Lists.list();
                for (SynthesisEdge edge : list) {
                    EList guards = edge.edge.getGuards();
                    String guardsTxt = guards.isEmpty() ? "true" : CifTextUtils.exprsToStr((List)guards);
                    guardTxts.add("\"" + guardsTxt + "\"");
                }
                Assert.check((!guardTxts.isEmpty() ? 1 : 0) != 0);
                guardsTxts.add(StringUtils.join((Collection)guardTxts, (String)", "));
            }
            Assert.check((!guardsTxts.isEmpty() ? 1 : 0) != 0);
            if (guardsTxts.size() == 1) {
                String string = " " + (String)guardsTxts.get(0) + ".";
            } else {
                int i = 0;
                while (i < guardsTxts.size()) {
                    String txt = (String)guardsTxts.get(i);
                    txt = Strings.fmt((String)"\n    Group %d: %s", (Object[])new Object[]{i + 1, txt});
                    guardsTxts.set(i, txt);
                    ++i;
                }
                String string = StringUtils.join((Collection)guardsTxts, (String)"");
            }
            String msg = Strings.fmt((String)"Unsupported linearized edges: non-determinism detected for edges of controllable event \"%s\" with overlapping guards:%s", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)conflict), var9_15});
            this.problems.add(msg);
        }
    }

    private static List<List<SynthesisEdge>> groupOnGuardOverlap(List<SynthesisEdge> edges) {
        List groups = Lists.listc((int)edges.size());
        int i = 0;
        while (i < edges.size()) {
            groups.add(Lists.list((Object)edges.get(i)));
            ++i;
        }
        i = 0;
        while (i < groups.size()) {
            Assert.check((((List)groups.get(i)).size() == 1 ? 1 : 0) != 0);
            BDD curGuard = ((SynthesisEdge)((List)groups.get((int)i)).get((int)0)).guard.id();
            boolean changed = true;
            while (changed) {
                changed = false;
                int j = i + 1;
                while (j < groups.size()) {
                    Assert.check((((List)groups.get(j)).size() == 1 ? 1 : 0) != 0);
                    BDD newGuard = ((SynthesisEdge)((List)groups.get((int)j)).get((int)0)).guard;
                    BDD overlapPred = curGuard.and(newGuard);
                    boolean disjoint = overlapPred.isZero();
                    overlapPred.free();
                    if (!disjoint) {
                        changed = true;
                        ((List)groups.get(i)).add((SynthesisEdge)((List)groups.get(j)).get(0));
                        groups.remove(j);
                        curGuard = curGuard.andWith(newGuard.id());
                    }
                    ++j;
                }
            }
            curGuard.free();
            ++i;
        }
        return groups;
    }

    private void convertUpdates(List<Update> updates, SynthesisEdge synthEdge, Map<DiscVariable, Automaton> lpToAutMap, SynthesisAutomaton aut) {
        List assignments = Lists.listc((int)updates.size());
        boolean[] assigned = new boolean[aut.variables.length];
        BDD relation = aut.factory.one();
        BDD error = aut.factory.zero();
        for (Update update : updates) {
            Pair<BDD, BDD> rslt = this.convertUpdate(update, assignments, assigned, lpToAutMap, aut);
            if (aut.env.isTerminationRequested()) {
                return;
            }
            if (rslt != null) {
                BDD updateRelation = (BDD)rslt.left;
                relation = relation.andWith(updateRelation);
                BDD updateError = (BDD)rslt.right;
                error = error.orWith(updateError);
            }
            if (!aut.env.isTerminationRequested()) continue;
            return;
        }
        int i = 0;
        while (i < assigned.length) {
            SynthesisVariable var;
            if (!assigned[i] && (var = aut.variables[i]) != null) {
                CifBddBitVector vectorOld = CifBddBitVector.createDomain(var.domain);
                CifBddBitVector vectorNew = CifBddBitVector.createDomain(var.domainNew);
                BDD unchangedRelation = vectorOld.equalTo(vectorNew);
                relation = relation.andWith(unchangedRelation);
                vectorOld.free();
                vectorNew.free();
            }
            ++i;
        }
        int asgnCnt = assignments.size();
        synthEdge.assignments = assignments.toArray(new Assignment[asgnCnt]);
        synthEdge.update = relation;
        synthEdge.error = error;
    }

    private Pair<BDD, BDD> convertUpdate(Update update, List<Assignment> assignments, boolean[] assigned, Map<DiscVariable, Automaton> lpToAutMap, SynthesisAutomaton aut) {
        CifBddBitVectorAndCarry rhsRslt;
        if (update instanceof IfUpdate) {
            String msg = "Unsupported update: conditional updates ('if' updates) are not supported.";
            this.problems.add(msg);
            return null;
        }
        Assignment asgn = (Assignment)update;
        assignments.add(asgn);
        Expression addr = asgn.getAddressable();
        if (addr instanceof TupleExpression) {
            String msg = "Unsupported update: multi-assignments are not supported.";
            this.problems.add(msg);
            return null;
        }
        if (addr instanceof ProjectionExpression) {
            String msg = "Unsupported update: partial variable assignments are not supported.";
            this.problems.add(msg);
            return null;
        }
        if (addr instanceof ContVariableExpression) {
            String msg = "Unsupported update: assignments to continuous variables are not supported.";
            this.problems.add(msg);
            return null;
        }
        DiscVariable cifVar = ((DiscVariableExpression)addr).getVariable();
        Automaton cifAut = lpToAutMap.get(cifVar);
        if (cifAut != null) {
            int varIdx = CifToSynthesisConverter.getLpVarIdx(aut.variables, cifAut);
            if (varIdx == -1) {
                return null;
            }
            SynthesisVariable var = aut.variables[varIdx];
            Assert.check((boolean)(var instanceof SynthesisLocPtrVariable));
            Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
            assigned[varIdx] = true;
            Assert.check((boolean)(asgn.getValue() instanceof IntExpression));
            int locIdx = ((IntExpression)asgn.getValue()).getValue();
            CifBddBitVector varVector = CifBddBitVector.createDomain(var.domainNew);
            CifBddBitVector locVector = CifBddBitVector.createInt(aut.factory, locIdx);
            Assert.check((locVector.length() <= varVector.length() ? 1 : 0) != 0);
            locVector.resize(varVector.length());
            BDD relation = varVector.equalTo(locVector);
            varVector.free();
            locVector.free();
            return Pair.pair((Object)relation, (Object)aut.factory.zero());
        }
        int varIdx = CifToSynthesisConverter.getTypedVarIdx(aut.variables, (Declaration)cifVar);
        if (varIdx == -1) {
            return null;
        }
        SynthesisVariable synthVar = aut.variables[varIdx];
        Assert.check((boolean)(synthVar instanceof SynthesisTypedVariable));
        SynthesisTypedVariable var = (SynthesisTypedVariable)synthVar;
        Assert.check((!assigned[varIdx] ? 1 : 0) != 0);
        assigned[varIdx] = true;
        if (var.type instanceof BoolType) {
            BDD rhsBdd;
            Expression rhsExpr = asgn.getValue();
            try {
                rhsBdd = CifToSynthesisConverter.convertPred(rhsExpr, false, aut);
            }
            catch (UnsupportedPredicateException ex) {
                if (ex.expr != null) {
                    String msg = Strings.fmt((String)"Unsupported assignment: unsupported part \"%s\" of assignment \"%s := %s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr), ex.getMessage()});
                    this.problems.add(msg);
                }
                return Pair.pair((Object)aut.factory.one(), (Object)aut.factory.zero());
            }
            Assert.check((var.domainNew.varNum() == 1 ? 1 : 0) != 0);
            int lhsVar = var.domainNew.vars()[0];
            BDD lhsBdd = aut.factory.ithVar(lhsVar);
            BDD relation = lhsBdd.biimpWith(rhsBdd);
            return Pair.pair((Object)relation, (Object)aut.factory.zero());
        }
        Expression rhsExpr = asgn.getValue();
        Supplier<String> partMsg = () -> Strings.fmt((String)"assignment \"%s := %s\"", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr)});
        try {
            rhsRslt = CifToSynthesisConverter.convertExpr(rhsExpr, false, aut, true, partMsg);
        }
        catch (UnsupportedPredicateException ex) {
            if (ex.expr != null) {
                String msg = Strings.fmt((String)"Unsupported assignment: unsupported part \"%s\" of assignment \"%s := %s\": %s", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)ex.expr), CifTextUtils.exprToStr((Expression)addr), CifTextUtils.exprToStr((Expression)rhsExpr), ex.getMessage()});
                this.problems.add(msg);
            }
            return Pair.pair((Object)aut.factory.one(), (Object)aut.factory.zero());
        }
        CifBddBitVector rhsVec = rhsRslt.vector;
        BDD error = rhsRslt.carry;
        CifBddBitVector lhsVec = CifBddBitVector.createDomain(var.domainNew);
        int lhsLen = lhsVec.length();
        int len = Math.max(lhsVec.length(), rhsVec.length());
        lhsVec.resize(len);
        rhsVec.resize(len);
        BDD relation = lhsVec.equalTo(rhsVec);
        lhsVec.free();
        int i = lhsLen;
        while (i < len) {
            error = error.orWith(rhsVec.getBit(i).id());
            ++i;
        }
        rhsVec.free();
        return Pair.pair((Object)relation, (Object)error);
    }

    private void addInputVariableEdges(SynthesisAutomaton synthAut) {
        synthAut.inputVarEvents = Sets.set();
        SynthesisVariable[] synthesisVariableArray = synthAut.variables;
        int n = synthAut.variables.length;
        int n2 = 0;
        while (n2 < n) {
            SynthesisVariable var = synthesisVariableArray[n2];
            if (var != null && var instanceof SynthesisInputVariable) {
                SynthesisInputVariable synthInputVar = (SynthesisInputVariable)var;
                Event event = CifConstructors.newEvent();
                event.setControllable(Boolean.valueOf(false));
                event.setName(synthInputVar.var.getName());
                synthAut.alphabet.add(event);
                ComplexComponent comp = (ComplexComponent)synthInputVar.var.eContainer();
                comp.getDeclarations().add((Object)event);
                synthAut.inputVarEvents.add(event);
                SynthesisEdge edge = new SynthesisEdge(synthAut);
                edge.edge = null;
                edge.event = event;
                edge.origGuard = synthAut.factory.one();
                edge.guard = synthAut.factory.one();
                edge.error = synthAut.factory.zero();
                synthAut.edges.add(edge);
                InputVariableExpression addr = CifConstructors.newInputVariableExpression();
                addr.setVariable(synthInputVar.var);
                Assignment asgn = CifConstructors.newAssignment();
                asgn.setAddressable((Expression)addr);
                edge.assignments = new Assignment[]{asgn};
                edge.update = synthAut.factory.one();
                SynthesisVariable[] synthesisVariableArray2 = synthAut.variables;
                int n3 = synthAut.variables.length;
                int n4 = 0;
                while (n4 < n3) {
                    SynthesisVariable updVar = synthesisVariableArray2[n4];
                    if (updVar != null) {
                        BDD varUpdate;
                        CifBddBitVector vectorOld = CifBddBitVector.createDomain(updVar.domain);
                        CifBddBitVector vectorNew = CifBddBitVector.createDomain(updVar.domainNew);
                        if (updVar == var) {
                            BDD newInDomain = BddUtils.getVarDomain(updVar, true, synthAut.factory);
                            varUpdate = vectorOld.unequalTo(vectorNew);
                            varUpdate = varUpdate.andWith(newInDomain);
                        } else {
                            varUpdate = vectorOld.equalTo(vectorNew);
                        }
                        edge.update = edge.update.andWith(varUpdate);
                        vectorOld.free();
                        vectorNew.free();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void orderEdges(SynthesisAutomaton synthAut) {
        String orderTxt = EdgeOrderOption.getOrder();
        if (!orderTxt.toLowerCase(Locale.US).equals("model")) {
            if (orderTxt.toLowerCase(Locale.US).equals("reverse-model")) {
                Collections.reverse(synthAut.edges);
            } else if (orderTxt.toLowerCase(Locale.US).equals("sorted")) {
                Collections.sort(synthAut.edges, (v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false)));
            } else if (orderTxt.toLowerCase(Locale.US).equals("reverse-sorted")) {
                Collections.sort(synthAut.edges, (v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false)));
                Collections.reverse(synthAut.edges);
            } else if (orderTxt.toLowerCase(Locale.US).equals("random") || orderTxt.toLowerCase(Locale.US).startsWith("random:")) {
                Long seed = null;
                if (orderTxt.contains(":")) {
                    int idx = orderTxt.indexOf(":");
                    String seedTxt = orderTxt.substring(idx + 1);
                    try {
                        seed = Long.parseUnsignedLong(seedTxt);
                    }
                    catch (NumberFormatException ex) {
                        String msg4 = Strings.fmt((String)"Invalid edge random order seed number: \"%s\".", (Object[])new Object[]{orderTxt});
                        throw new InvalidOptionException(msg4, (Throwable)ex);
                    }
                }
                if (seed == null) {
                    Collections.shuffle(synthAut.edges);
                } else {
                    Collections.shuffle(synthAut.edges, new Random(seed));
                }
            } else {
                List edges = Lists.listc((int)synthAut.edges.size());
                Set processedEdges = Sets.set();
                String[] stringArray = StringUtils.split((String)orderTxt, (String)",");
                int msg4 = stringArray.length;
                int ex = 0;
                while (ex < msg4) {
                    String elemTxt = stringArray[ex];
                    if (!(elemTxt = elemTxt.trim()).isEmpty()) {
                        String regEx = elemTxt.replace(".", "\\.");
                        regEx = regEx.replace("*", ".*");
                        Pattern pattern = Pattern.compile("^" + regEx + "$");
                        List matches = Lists.list();
                        for (SynthesisEdge edge : synthAut.edges) {
                            String name = CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false);
                            if (!pattern.matcher(name).matches()) continue;
                            matches.add(edge);
                        }
                        if (matches.isEmpty()) {
                            String msg2 = Strings.fmt((String)"Invalid edge order: can't find a match for \"%s\". There is no supported event or input variable in the specification that matches the given name pattern.", (Object[])new Object[]{elemTxt});
                            throw new InvalidOptionException(msg2);
                        }
                        Collections.sort(matches, (v, w) -> Strings.SORTER.compare(CifTextUtils.getAbsName((PositionObject)v.event, (boolean)false), CifTextUtils.getAbsName((PositionObject)w.event, (boolean)false)));
                        for (SynthesisEdge edge : matches) {
                            if (processedEdges.contains(edge)) {
                                String msg3 = Strings.fmt((String)"Invalid edge order: \"%s\" is included more than once.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false)});
                                throw new InvalidOptionException(msg3);
                            }
                            processedEdges.add(edge);
                        }
                        edges.addAll(matches);
                    }
                    ++ex;
                }
                if (edges.size() < synthAut.edges.size()) {
                    Set names = Sets.set();
                    for (SynthesisEdge edge : synthAut.edges) {
                        if (processedEdges.contains(edge)) continue;
                        names.add("\"" + CifTextUtils.getAbsName((PositionObject)edge.event, (boolean)false) + "\"");
                    }
                    List sortedNames = Sets.sortedgeneric((Set)names, (Comparator)Strings.SORTER);
                    String msg4 = Strings.fmt((String)"Invalid edge order: the following are missing from the specified order: %s.", (Object[])new Object[]{StringUtils.join((Collection)sortedNames, (String)", ")});
                    throw new InvalidOptionException(msg4);
                }
                synthAut.edges = edges;
            }
        }
    }

    private static BDD convertPreds(List<Expression> preds, boolean initial, SynthesisAutomaton synthAut) throws UnsupportedPredicateException {
        BDD rslt = synthAut.factory.one();
        for (Expression pred : preds) {
            rslt = rslt.andWith(CifToSynthesisConverter.convertPred(pred, initial, synthAut));
        }
        return rslt;
    }

    private static BDD convertPred(Expression pred, boolean initial, SynthesisAutomaton synthAut) throws UnsupportedPredicateException {
        if (pred instanceof BoolExpression) {
            boolean value = ((BoolExpression)pred).isValue();
            return value ? synthAut.factory.one() : synthAut.factory.zero();
        }
        if (pred instanceof DiscVariableExpression) {
            DiscVariable cifVar = ((DiscVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToSynthesisConverter.getDiscVarIdx(synthAut.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            SynthesisVariable var = synthAut.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof InputVariableExpression) {
            InputVariable cifVar = ((InputVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)cifVar.getType()) instanceof BoolType));
            int varIdx = CifToSynthesisConverter.getInputVarIdx(synthAut.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            SynthesisVariable var = synthAut.variables[varIdx];
            return var.domain.ithVar(1L);
        }
        if (pred instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)pred).getVariable();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)var.getType()) instanceof BoolType));
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToSynthesisConverter.convertPred(value, initial, synthAut);
        }
        if (pred instanceof LocationExpression) {
            Location loc = ((LocationExpression)pred).getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            int varIdx = CifToSynthesisConverter.getLpVarIdx(synthAut.variables, aut);
            if (varIdx == -1) {
                if (aut.getLocations().size() == 1) {
                    return synthAut.factory.one();
                }
                throw new UnsupportedPredicateException();
            }
            Assert.check((varIdx >= 0 ? 1 : 0) != 0);
            SynthesisVariable var = synthAut.variables[varIdx];
            int locIdx = aut.getLocations().indexOf((Object)loc);
            Assert.check((locIdx >= 0 ? 1 : 0) != 0);
            return var.domain.ithVar((long)locIdx);
        }
        if (pred instanceof ConstantExpression) {
            Object valueObj;
            Constant constant = ((ConstantExpression)pred).getConstant();
            Assert.check((boolean)(CifTypeUtils.normalizeType((CifType)constant.getType()) instanceof BoolType));
            try {
                valueObj = CifEvalUtils.eval((Expression)constant.getValue(), (boolean)initial);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to statically evaluate the value of constant \"%s\".", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)constant)});
                throw new InvalidInputException(msg, (Throwable)ex);
            }
            return (Boolean)valueObj != false ? synthAut.factory.one() : synthAut.factory.zero();
        }
        if (pred instanceof UnaryExpression) {
            UnaryExpression upred = (UnaryExpression)pred;
            UnaryOperator op = upred.getOperator();
            if (op != UnaryOperator.INVERSE) {
                String msg = Strings.fmt((String)"unary operator \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((UnaryOperator)op)});
                throw new UnsupportedPredicateException(msg, (Expression)upred);
            }
            BDD child = CifToSynthesisConverter.convertPred(upred.getChild(), initial, synthAut);
            BDD rslt = child.not();
            child.free();
            return rslt;
        }
        if (pred instanceof BinaryExpression) {
            BinaryExpression bpred = (BinaryExpression)pred;
            BinaryOperator op = ((BinaryExpression)pred).getOperator();
            Expression lhs = bpred.getLeft();
            Expression rhs = bpred.getRight();
            if (op == BinaryOperator.CONJUNCTION) {
                CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                    String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
                BDD left = CifToSynthesisConverter.convertPred(lhs, initial, synthAut);
                BDD right = CifToSynthesisConverter.convertPred(rhs, initial, synthAut);
                return left.andWith(right);
            }
            if (op == BinaryOperator.DISJUNCTION) {
                CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) {
                    String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
                BDD left = CifToSynthesisConverter.convertPred(lhs, initial, synthAut);
                BDD right = CifToSynthesisConverter.convertPred(rhs, initial, synthAut);
                return left.orWith(right);
            }
            if (op == BinaryOperator.IMPLICATION) {
                BDD left = CifToSynthesisConverter.convertPred(lhs, initial, synthAut);
                BDD right = CifToSynthesisConverter.convertPred(rhs, initial, synthAut);
                return left.impWith(right);
            }
            if (op == BinaryOperator.BI_CONDITIONAL) {
                BDD left = CifToSynthesisConverter.convertPred(lhs, initial, synthAut);
                BDD right = CifToSynthesisConverter.convertPred(rhs, initial, synthAut);
                return left.biimpWith(right);
            }
            switch (op) {
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: {
                    break;
                }
                default: {
                    String msg = Strings.fmt((String)"binary operator \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op)});
                    throw new UnsupportedPredicateException(msg, (Expression)bpred);
                }
            }
            return CifToSynthesisConverter.convertCmpPred(lhs, rhs, op, pred, bpred, initial, synthAut);
        }
        if (pred instanceof IfExpression) {
            IfExpression ifPred = (IfExpression)pred;
            BDD rslt = CifToSynthesisConverter.convertPred(ifPred.getElse(), initial, synthAut);
            int i = ifPred.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifPred = (ElifExpression)ifPred.getElifs().get(i);
                BDD elifGuards = CifToSynthesisConverter.convertPreds((List<Expression>)elifPred.getGuards(), initial, synthAut);
                BDD elifThen = CifToSynthesisConverter.convertPred(elifPred.getThen(), initial, synthAut);
                BDD elifRslt = elifGuards.ite(elifThen, rslt);
                elifGuards.free();
                elifThen.free();
                rslt.free();
                rslt = elifRslt;
                --i;
            }
            BDD ifGuards = CifToSynthesisConverter.convertPreds((List<Expression>)ifPred.getGuards(), initial, synthAut);
            BDD ifThen = CifToSynthesisConverter.convertPred(ifPred.getThen(), initial, synthAut);
            BDD elifRslt = ifGuards.ite(ifThen, rslt);
            ifGuards.free();
            ifThen.free();
            rslt.free();
            rslt = elifRslt;
            return rslt;
        }
        if (pred instanceof SwitchExpression) {
            SwitchExpression switchPred = (SwitchExpression)pred;
            Expression value = switchPred.getValue();
            EList cases = switchPred.getCases();
            BDD rslt = CifToSynthesisConverter.convertPred(((SwitchCase)Lists.last((List)cases)).getValue(), initial, synthAut);
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                BDD caseGuard = CifToSynthesisConverter.convertPred(caseGuardExpr, initial, synthAut);
                BDD caseThen = CifToSynthesisConverter.convertPred(cse.getValue(), initial, synthAut);
                BDD caseRslt = caseGuard.ite(caseThen, rslt);
                caseGuard.free();
                caseThen.free();
                rslt.free();
                rslt = caseRslt;
                --i;
            }
            return rslt;
        }
        String msg = Strings.fmt((String)"predicate is not supported.", (Object[])new Object[0]);
        throw new UnsupportedPredicateException(msg, pred);
    }

    private static BDD convertCmpPred(Expression lhs, Expression rhs, BinaryOperator op, Expression pred, BinaryExpression bpred, boolean initial, SynthesisAutomaton synthAut) throws UnsupportedPredicateException {
        BDD rslt;
        CifType ltype = CifTypeUtils.normalizeType((CifType)lhs.getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)rhs.getType());
        if (!(ltype instanceof BoolType && rtype instanceof BoolType || ltype instanceof EnumType && rtype instanceof EnumType || ltype instanceof IntType && rtype instanceof IntType)) {
            String msg = Strings.fmt((String)"binary operator \"%s\" on values of types \"%s\" and \"%s\" is not supported.", (Object[])new Object[]{CifTextUtils.operatorToStr((BinaryOperator)op), CifTextUtils.typeToStr((CifType)ltype), CifTextUtils.typeToStr((CifType)rtype)});
            throw new UnsupportedPredicateException(msg, (Expression)bpred);
        }
        if (ltype instanceof BoolType && rtype instanceof BoolType) {
            BDD lbdd = CifToSynthesisConverter.convertPred(lhs, initial, synthAut);
            BDD rbdd = CifToSynthesisConverter.convertPred(rhs, initial, synthAut);
            switch (op) {
                case EQUAL: {
                    return lbdd.biimpWith(rbdd);
                }
                case UNEQUAL: {
                    BDD eq = lbdd.biimpWith(rbdd);
                    BDD rslt2 = eq.not();
                    eq.free();
                    return rslt2;
                }
            }
            throw new RuntimeException("Unexpected op: " + op);
        }
        Supplier<String> partMsg = () -> Strings.fmt((String)"predicate \"%s\"", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)pred)});
        CifBddBitVectorAndCarry lrslt = CifToSynthesisConverter.convertExpr(lhs, initial, synthAut, false, partMsg);
        CifBddBitVectorAndCarry rrslt = CifToSynthesisConverter.convertExpr(rhs, initial, synthAut, false, partMsg);
        Assert.check((boolean)lrslt.carry.isZero());
        Assert.check((boolean)rrslt.carry.isZero());
        CifBddBitVector lvec = lrslt.vector;
        CifBddBitVector rvec = rrslt.vector;
        int length = Math.max(lvec.length(), rvec.length());
        lvec.resize(length);
        rvec.resize(length);
        switch (op) {
            case LESS_THAN: {
                rslt = lvec.lessThan(rvec);
                break;
            }
            case LESS_EQUAL: {
                rslt = lvec.lessOrEqual(rvec);
                break;
            }
            case GREATER_THAN: {
                rslt = lvec.greaterThan(rvec);
                break;
            }
            case GREATER_EQUAL: {
                rslt = lvec.greaterOrEqual(rvec);
                break;
            }
            case EQUAL: {
                rslt = lvec.equalTo(rvec);
                break;
            }
            case UNEQUAL: {
                rslt = lvec.unequalTo(rvec);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected op: " + op);
            }
        }
        lvec.free();
        rvec.free();
        return rslt;
    }

    private static CifBddBitVectorAndCarry convertExpr(Expression expr, boolean initial, SynthesisAutomaton synthAut, boolean allowSubtract, Supplier<String> partMsg) throws UnsupportedPredicateException {
        String msg;
        Object valueObj;
        if (expr instanceof DiscVariableExpression) {
            DiscVariable cifVar = ((DiscVariableExpression)expr).getVariable();
            int varIdx = CifToSynthesisConverter.getDiscVarIdx(synthAut.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            SynthesisVariable var = synthAut.variables[varIdx];
            CifBddBitVector vector = CifBddBitVector.createDomain(var.domain);
            return new CifBddBitVectorAndCarry(vector, synthAut.factory.zero());
        }
        if (expr instanceof InputVariableExpression) {
            InputVariable cifVar = ((InputVariableExpression)expr).getVariable();
            int varIdx = CifToSynthesisConverter.getInputVarIdx(synthAut.variables, cifVar);
            if (varIdx == -1) {
                throw new UnsupportedPredicateException();
            }
            SynthesisVariable var = synthAut.variables[varIdx];
            CifBddBitVector vector = CifBddBitVector.createDomain(var.domain);
            return new CifBddBitVectorAndCarry(vector, synthAut.factory.zero());
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            return CifToSynthesisConverter.convertExpr(value, initial, synthAut, allowSubtract, partMsg);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            switch (uexpr.getOperator()) {
                case PLUS: {
                    return CifToSynthesisConverter.convertExpr(uexpr.getChild(), initial, synthAut, false, partMsg);
                }
            }
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            Expression lhs = bexpr.getLeft();
            Expression rhs = bexpr.getRight();
            switch (bexpr.getOperator()) {
                case ADDITION: {
                    CifBddBitVectorAndCarry lrslt = CifToSynthesisConverter.convertExpr(lhs, initial, synthAut, false, partMsg);
                    CifBddBitVectorAndCarry rrslt = CifToSynthesisConverter.convertExpr(rhs, initial, synthAut, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    Assert.check((boolean)rrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    CifBddBitVector rvec = rrslt.vector;
                    int length = Math.max(lvec.length(), rvec.length()) + 1;
                    lvec.resize(length);
                    rvec.resize(length);
                    CifBddBitVectorAndCarry rslt = lvec.add(rvec);
                    Assert.check((boolean)rslt.carry.isZero());
                    lvec.free();
                    rvec.free();
                    return rslt;
                }
                case SUBTRACTION: {
                    if (!allowSubtract) break;
                    CifBddBitVectorAndCarry lrslt = CifToSynthesisConverter.convertExpr(lhs, initial, synthAut, false, partMsg);
                    CifBddBitVectorAndCarry rrslt = CifToSynthesisConverter.convertExpr(rhs, initial, synthAut, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    Assert.check((boolean)rrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    CifBddBitVector rvec = rrslt.vector;
                    int length = Math.max(lvec.length(), rvec.length());
                    lvec.resize(length);
                    rvec.resize(length);
                    CifBddBitVectorAndCarry rslt = lvec.subtract(rvec);
                    lvec.free();
                    rvec.free();
                    return rslt;
                }
                case MODULUS: 
                case INTEGER_DIVISION: {
                    Object rhsValueObj;
                    CifBddBitVectorAndCarry lrslt = CifToSynthesisConverter.convertExpr(lhs, initial, synthAut, false, partMsg);
                    Assert.check((boolean)lrslt.carry.isZero());
                    CifBddBitVector lvec = lrslt.vector;
                    if (!CifValueUtils.hasSingleValue((Expression)rhs, (boolean)initial, (boolean)true)) {
                        String msg2 = "value is too complex to be statically evaluated.";
                        throw new UnsupportedPredicateException(msg2, rhs);
                    }
                    try {
                        rhsValueObj = CifEvalUtils.eval((Expression)rhs, (boolean)initial);
                    }
                    catch (CifEvalException ex) {
                        String msg3 = Strings.fmt((String)"Failed to statically evaluate the \"%s\" part of %s.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)rhs), partMsg.get()});
                        throw new InvalidInputException(msg3, (Throwable)ex);
                    }
                    int divisor = (Integer)rhsValueObj;
                    if (divisor == 0) {
                        String msg4 = Strings.fmt((String)"\"%s\" always results in division by zero.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                        throw new UnsupportedPredicateException(msg4, expr);
                    }
                    if (divisor < 0) {
                        String msg5 = Strings.fmt((String)"\"%s\" performs division/modulus by a negative value, which is not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
                        throw new UnsupportedPredicateException(msg5, expr);
                    }
                    boolean isDiv = bexpr.getOperator() == BinaryOperator.INTEGER_DIVISION;
                    int lhsLen = lvec.length();
                    if (!isDiv) {
                        ++lhsLen;
                    }
                    int rhsLen = BddUtils.getMinimumBits(divisor);
                    int length = Math.max(lhsLen, rhsLen);
                    lvec.resize(length);
                    CifBddBitVector rslt = lvec.divmod(divisor, isDiv);
                    lvec.free();
                    return new CifBddBitVectorAndCarry(rslt, synthAut.factory.zero());
                }
            }
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            CifBddBitVectorAndCarry elseRslt = CifToSynthesisConverter.convertExpr(ifExpr.getElse(), initial, synthAut, false, partMsg);
            Assert.check((boolean)elseRslt.carry.isZero());
            CifBddBitVector rslt = elseRslt.vector;
            int i = ifExpr.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifExpr = (ElifExpression)ifExpr.getElifs().get(i);
                BDD elifGuards = CifToSynthesisConverter.convertPreds((List<Expression>)elifExpr.getGuards(), initial, synthAut);
                CifBddBitVectorAndCarry elifThen = CifToSynthesisConverter.convertExpr(elifExpr.getThen(), initial, synthAut, false, partMsg);
                Assert.check((boolean)elifThen.carry.isZero());
                CifBddBitVector elifVector = elifThen.vector;
                int len = Math.max(rslt.length(), elifVector.length());
                rslt.resize(len);
                elifVector.resize(len);
                CifBddBitVector elifRslt = elifVector.ifThenElse(rslt, elifGuards);
                elifGuards.free();
                elifVector.free();
                rslt.free();
                rslt = elifRslt;
                --i;
            }
            BDD ifGuards = CifToSynthesisConverter.convertPreds((List<Expression>)ifExpr.getGuards(), initial, synthAut);
            CifBddBitVectorAndCarry ifThen = CifToSynthesisConverter.convertExpr(ifExpr.getThen(), initial, synthAut, false, partMsg);
            Assert.check((boolean)ifThen.carry.isZero());
            CifBddBitVector ifVector = ifThen.vector;
            int len = Math.max(rslt.length(), ifVector.length());
            rslt.resize(len);
            ifVector.resize(len);
            CifBddBitVector ifRslt = ifVector.ifThenElse(rslt, ifGuards);
            ifGuards.free();
            ifVector.free();
            rslt.free();
            rslt = ifRslt;
            return new CifBddBitVectorAndCarry(rslt, synthAut.factory.zero());
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            EList cases = switchExpr.getCases();
            CifBddBitVectorAndCarry elseRslt = CifToSynthesisConverter.convertExpr(((SwitchCase)Lists.last((List)cases)).getValue(), initial, synthAut, false, partMsg);
            Assert.check((boolean)elseRslt.carry.isZero());
            CifBddBitVector rslt = elseRslt.vector;
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                Expression caseGuardExpr = CifTypeUtils.isAutRefExpr((Expression)value) ? cse.getKey() : CifConstructors.newBinaryExpression((Expression)((Expression)EMFHelper.deepclone((EObject)value)), (BinaryOperator)BinaryOperator.EQUAL, null, (Expression)((Expression)EMFHelper.deepclone((EObject)cse.getKey())), (CifType)CifConstructors.newBoolType());
                BDD caseGuard = CifToSynthesisConverter.convertPred(caseGuardExpr, initial, synthAut);
                CifBddBitVectorAndCarry caseThen = CifToSynthesisConverter.convertExpr(cse.getValue(), initial, synthAut, false, partMsg);
                Assert.check((boolean)caseThen.carry.isZero());
                CifBddBitVector caseVector = caseThen.vector;
                int len = Math.max(rslt.length(), caseVector.length());
                rslt.resize(len);
                caseVector.resize(len);
                CifBddBitVector caseRslt = caseVector.ifThenElse(rslt, caseGuard);
                caseGuard.free();
                caseVector.free();
                rslt.free();
                rslt = caseRslt;
                --i;
            }
            return new CifBddBitVectorAndCarry(rslt, synthAut.factory.zero());
        }
        if (!CifValueUtils.hasSingleValue((Expression)expr, (boolean)initial, (boolean)true)) {
            String msg6 = "value is too complex to be statically evaluated.";
            throw new UnsupportedPredicateException(msg6, expr);
        }
        try {
            valueObj = CifEvalUtils.eval((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException ex) {
            msg = Strings.fmt((String)"Failed to statically evaluate the \"%s\" part of %s.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), partMsg.get()});
            throw new InvalidInputException(msg, (Throwable)ex);
        }
        if (valueObj instanceof Integer) {
            int value = (Integer)valueObj;
            if (value < 0) {
                msg = Strings.fmt((String)"value \"%d\" is unsupported, as it is negative.", (Object[])new Object[]{value});
                throw new UnsupportedPredicateException(msg, expr);
            }
            CifBddBitVector vector = CifBddBitVector.createInt(synthAut.factory, value);
            return new CifBddBitVectorAndCarry(vector, synthAut.factory.zero());
        }
        Assert.check((boolean)(valueObj instanceof CifEnumLiteral));
        EnumLiteral lit = ((CifEnumLiteral)valueObj).literal;
        EnumDecl enumDecl = (EnumDecl)lit.eContainer();
        int litIdx = enumDecl.getLiterals().indexOf((Object)lit);
        CifBddBitVector vector = CifBddBitVector.createInt(synthAut.factory, litIdx);
        return new CifBddBitVectorAndCarry(vector, synthAut.factory.zero());
    }

    public static void collectEvents(ComplexComponent comp, List<Event> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSynthesisConverter.collectEvents((ComplexComponent)child, events);
            }
        }
    }

    private static void collectAutomata(ComplexComponent comp, List<Automaton> automata) {
        if (comp instanceof Automaton) {
            automata.add((Automaton)comp);
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSynthesisConverter.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }

    private static void collectVariableObjects(ComplexComponent comp, List<PositionObject> objs) {
        Automaton aut;
        if (comp instanceof Automaton && (aut = (Automaton)comp).getLocations().size() > 1) {
            objs.add((PositionObject)aut);
        }
        for (Declaration decl : comp.getDeclarations()) {
            if (decl instanceof DiscVariable) {
                objs.add((PositionObject)decl);
            }
            if (!(decl instanceof InputVariable)) continue;
            objs.add((PositionObject)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifToSynthesisConverter.collectVariableObjects((ComplexComponent)child, objs);
            }
        }
    }

    private static int getDiscVarIdx(SynthesisVariable[] vars, DiscVariable var) {
        Assert.check((var.getType() != null ? 1 : 0) != 0);
        return CifToSynthesisConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    private static int getInputVarIdx(SynthesisVariable[] vars, InputVariable var) {
        return CifToSynthesisConverter.getTypedVarIdx(vars, (Declaration)var);
    }

    private static int getTypedVarIdx(SynthesisVariable[] vars, Declaration var) {
        int i = 0;
        while (i < vars.length) {
            SynthesisVariable synthVar = vars[i];
            if (synthVar != null && synthVar instanceof SynthesisTypedVariable) {
                SynthesisTypedVariable synthTypedVar = (SynthesisTypedVariable)synthVar;
                if (synthTypedVar.obj == var) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int getLpVarIdx(SynthesisVariable[] vars, Automaton aut) {
        int i = 0;
        while (i < vars.length) {
            SynthesisVariable synthVar = vars[i];
            if (synthVar != null && synthVar instanceof SynthesisLocPtrVariable) {
                SynthesisLocPtrVariable synthLpVar = (SynthesisLocPtrVariable)synthVar;
                if (synthLpVar.aut == aut) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static class ComparisonCollector
    extends CifWalker {
        private List<BinaryExpression> comparisons;

        private ComparisonCollector() {
        }

        public List<BinaryExpression> collectComparisons(Expression expr) {
            this.comparisons = Lists.list();
            this.walkExpression(expr);
            List<BinaryExpression> rslt = this.comparisons;
            this.comparisons = null;
            return rslt;
        }

        public void preprocessBinaryExpression(BinaryExpression expr) {
            switch (expr.getOperator()) {
                case LESS_THAN: 
                case LESS_EQUAL: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case EQUAL: 
                case UNEQUAL: {
                    this.comparisons.add(expr);
                }
            }
        }

        protected void preprocessAlgVariableExpression(AlgVariableExpression expr) {
            AlgVariable var = expr.getVariable();
            List values = CifEquationUtils.getValuesForAlgVar((AlgVariable)var, (boolean)false);
            for (Expression value : values) {
                this.walkExpression(value);
            }
        }
    }

    private static class HyperEdgeCreator {
        private SynthesisAutomaton synthAut;
        private List<BitSet> hyperEdges = Lists.list();
        private Map<Event, Set<PositionObject>> eventHyperEdges = Maps.map();

        private HyperEdgeCreator() {
        }

        public List<BitSet> getHyperEdges(Specification spec, SynthesisAutomaton synthAut) {
            this.synthAut = synthAut;
            this.hyperEdges = Lists.list();
            this.eventHyperEdges = Maps.map();
            this.addHyperEdges((ComplexComponent)spec);
            for (Set<PositionObject> vars : this.eventHyperEdges.values()) {
                this.addHyperEdge(vars);
            }
            List<BitSet> rslt = this.hyperEdges;
            this.eventHyperEdges = null;
            this.synthAut = null;
            this.hyperEdges = null;
            return rslt;
        }

        private void addHyperEdges(ComplexComponent comp) {
            for (Invariant inv : comp.getInvariants()) {
                Expression pred = inv.getPredicate();
                VariableCollector varCollector = new VariableCollector();
                Set vars = Sets.set();
                varCollector.collectCifVarObjs(pred, (Set<PositionObject>)vars);
                this.addHyperEdge(vars);
            }
            if (comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                for (Location loc : aut.getLocations()) {
                    for (Invariant inv : comp.getInvariants()) {
                        Expression pred = inv.getPredicate();
                        VariableCollector varCollector = new VariableCollector();
                        Set vars = Sets.set();
                        varCollector.collectCifVarObjs(pred, (Set<PositionObject>)vars);
                        this.addHyperEdge(vars);
                    }
                    for (Edge edge : loc.getEdges()) {
                        this.addHyperEdges(aut, edge);
                    }
                }
            }
            if (comp instanceof Group) {
                Group group = (Group)comp;
                for (Component child : group.getComponents()) {
                    this.addHyperEdges((ComplexComponent)child);
                }
            }
        }

        private void addHyperEdges(Automaton aut, Edge edge) {
            VariableCollector varCollector;
            for (Expression guard : edge.getGuards()) {
                ComparisonCollector cmpCollector = new ComparisonCollector();
                List<BinaryExpression> cmps = cmpCollector.collectComparisons(guard);
                for (BinaryExpression cmp : cmps) {
                    varCollector = new VariableCollector();
                    Set vars = Sets.set();
                    varCollector.collectCifVarObjs(cmp.getLeft(), (Set<PositionObject>)vars);
                    varCollector.collectCifVarObjs(cmp.getRight(), (Set<PositionObject>)vars);
                    this.addHyperEdge(vars);
                }
            }
            this.addHyperEdges((List<Update>)edge.getUpdates());
            Automaton lpAut = aut.getLocations().size() < 2 ? null : aut;
            for (EdgeEvent edgeEvent : edge.getEvents()) {
                Expression eventRef = edgeEvent.getEvent();
                if (eventRef instanceof TauExpression) continue;
                Event event = ((EventExpression)eventRef).getEvent();
                Set vars = this.eventHyperEdges.get(event);
                if (vars == null) {
                    vars = Sets.set();
                    this.eventHyperEdges.put(event, vars);
                }
                varCollector = new VariableCollector();
                for (Expression guard : edge.getGuards()) {
                    varCollector.collectCifVarObjs(guard, (Set<PositionObject>)vars);
                }
                for (Update update : edge.getUpdates()) {
                    varCollector.collectCifVarObjs(update, (Set<PositionObject>)vars);
                }
                if (lpAut == null) continue;
                vars.add(lpAut);
            }
        }

        private void addHyperEdges(List<Update> updates) {
            for (Update update : updates) {
                if (!(update instanceof Assignment)) continue;
                Assignment asgn = (Assignment)update;
                VariableCollector varCollector = new VariableCollector();
                Set vars = Sets.set();
                varCollector.collectCifVarObjs(asgn.getAddressable(), (Set<PositionObject>)vars);
                varCollector.collectCifVarObjs(asgn.getValue(), (Set<PositionObject>)vars);
                this.addHyperEdge(vars);
            }
        }

        private void addHyperEdge(Set<PositionObject> vars) {
            if (vars.isEmpty()) {
                return;
            }
            BitSet hyperEdge = new BitSet(this.synthAut.variables.length);
            for (PositionObject var : vars) {
                int matchIdx = -1;
                int i = 0;
                while (i < this.synthAut.variables.length) {
                    SynthesisVariable synthVar = this.synthAut.variables[i];
                    if (synthVar != null) {
                        boolean match = false;
                        if (synthVar instanceof SynthesisDiscVariable) {
                            SynthesisDiscVariable sdv = (SynthesisDiscVariable)synthVar;
                            if (sdv.var == var) {
                                match = true;
                            }
                        } else if (synthVar instanceof SynthesisInputVariable) {
                            SynthesisInputVariable siv = (SynthesisInputVariable)synthVar;
                            if (siv.var == var) {
                                match = true;
                            }
                        } else if (synthVar instanceof SynthesisLocPtrVariable) {
                            SynthesisLocPtrVariable slpv = (SynthesisLocPtrVariable)synthVar;
                            if (slpv.aut == var) {
                                match = true;
                            }
                        } else {
                            throw new RuntimeException("Unknown synthesis variable: " + synthVar);
                        }
                        if (match) {
                            matchIdx = i;
                            break;
                        }
                    }
                    ++i;
                }
                Assert.check((matchIdx >= 0 ? 1 : 0) != 0);
                hyperEdge.set(matchIdx);
            }
            this.hyperEdges.add(hyperEdge);
        }
    }

    private static class UnsupportedPredicateException
    extends Exception {
        public final Expression expr;

        public UnsupportedPredicateException() {
            this((String)null, (Expression)null);
        }

        public UnsupportedPredicateException(String msg, Expression expr) {
            super(msg);
            this.expr = expr;
        }
    }

    private static class VariableCollector
    extends CifWalker {
        private Set<PositionObject> cifVarObjs;

        private VariableCollector() {
        }

        public void collectCifVarObjs(Update update, Set<PositionObject> cifVarObjs) {
            this.cifVarObjs = cifVarObjs;
            this.walkUpdate(update);
            this.cifVarObjs = null;
        }

        public void collectCifVarObjs(Expression expr, Set<PositionObject> cifVarObjs) {
            this.cifVarObjs = cifVarObjs;
            this.walkExpression(expr);
            this.cifVarObjs = null;
        }

        protected void preprocessDiscVariableExpression(DiscVariableExpression expr) {
            this.cifVarObjs.add((PositionObject)expr.getVariable());
        }

        protected void preprocessInputVariableExpression(InputVariableExpression expr) {
            this.cifVarObjs.add((PositionObject)expr.getVariable());
        }

        protected void preprocessLocationExpression(LocationExpression expr) {
            Location loc = expr.getLocation();
            Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
            if (aut.getLocations().size() > 1) {
                this.cifVarObjs.add((PositionObject)aut);
            }
        }

        protected void preprocessAlgVariableExpression(AlgVariableExpression expr) {
            AlgVariable var = expr.getVariable();
            Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
            this.walkExpression(value);
        }
    }
}

