/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.spec;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDPairing;
import com.github.javabdd.BDDVarSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.spec.SynthesisEdge;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.java.Strings;

public class SynthesisAutomaton {
    public final AppEnvData env = AppEnv.getData();
    public BDDFactory factory;
    public Integer debugMaxNodes;
    public Double debugMaxPaths;
    public Set<Event> alphabet;
    public Set<Event> controllables;
    public Set<Event> inputVarEvents;
    public SynthesisVariable[] variables;
    public List<SynthesisEdge> edges;
    public Map<Event, List<SynthesisEdge>> eventEdges;
    public Set<Event> disabledEvents;
    public List<BDD> initialsVars;
    public List<BDD> initialsComps;
    public List<BDD> initialsLocs;
    public BDD initialVars;
    public BDD initialComps;
    public BDD initialLocs;
    public BDD initialUnctrl;
    public BDD initialReqInv;
    public BDD initialCtrl;
    public BDD initialOutput;
    public List<BDD> markedsComps;
    public List<BDD> markedsLocs;
    public BDD markedComps;
    public BDD markedLocs;
    public BDD marked;
    public BDD markedReqInv;
    public List<BDD> reqInvsComps;
    public List<BDD> reqInvsLocs;
    public BDD reqInvComps;
    public BDD reqInvLocs;
    public BDD reqInv;
    public Map<Event, BDD> stateEvtExclsReqAuts;
    public Map<Event, BDD> stateEvtExclsReqInvs;
    public Map<Event, List<BDD>> stateEvtExclReqLists;
    public Map<Event, BDD> stateEvtExclReqs;
    public Map<Event, List<BDD>> stateEvtExclPlantLists;
    public Map<Event, BDD> stateEvtExclPlants;
    public BDDPairing oldToNewVarsPairing;
    public BDDPairing newToOldVarsPairing;
    public BDDVarSet varSetOld;
    public BDDVarSet varSetNew;
    public Map<Event, BDD> outputGuards;
    public BDD ctrlBeh;

    public String toString() {
        return this.toString(0, "State: ", true);
    }

    public String toString(int indent) {
        return this.toString(indent, "State: ", true);
    }

    public String toString(int indent, boolean inclEdges) {
        return this.toString(indent, "State: ", inclEdges);
    }

    public String toString(int indent, String prefix, boolean inclEdges) {
        StringBuilder txt = new StringBuilder();
        txt.append(Strings.duplicate((String)" ", (int)(2 * indent)));
        txt.append(prefix);
        String cbTxt = this.ctrlBeh == null ? "?" : BddUtils.bddToStr(this.ctrlBeh, this);
        txt.append(Strings.fmt((String)"(controlled-behavior: %s)", (Object[])new Object[]{cbTxt}));
        if (inclEdges) {
            for (SynthesisEdge edge : this.edges) {
                txt.append("\n");
                txt.append(edge.toString(indent + 1, "Edge: "));
            }
        }
        return txt.toString();
    }
}

