/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import org.eclipse.escet.cif.datasynth.varorder.AutoVarOrderer;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.PermuteUtils;

public class SlidingWindowVarOrderer
extends AutoVarOrderer {
    public final int maxLen;

    public SlidingWindowVarOrderer(int maxLen) {
        this.maxLen = maxLen;
    }

    @Override
    protected void initializeAlgo() {
    }

    @Override
    protected void cleanupAlgo() {
    }

    @Override
    protected void computeOrder() {
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"  Applying sliding window algorithm:");
        }
        int length = Math.min(this.maxLen, this.varCnt);
        if (this.dbgEnabled) {
            OutputProvider.dbg((String)"    Window length: %,d", (Object[])new Object[]{length});
        }
        long bestSpan = this.computeTotalSpan(this.bestIndices);
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [before]", (Object[])new Object[]{bestSpan, (double)bestSpan / (double)this.edges.length});
        }
        int[] window = new int[length];
        int permCnt = PermuteUtils.factorial((int)window.length);
        int[][] windowPerms = new int[permCnt][window.length];
        int offset = 0;
        while (offset <= this.varCnt - length) {
            System.arraycopy(this.bestIndices, offset, window, 0, length);
            PermuteUtils.permute((int[])window, (int[][])windowPerms);
            int bestIdx = -1;
            int[] order = (int[])this.bestIndices.clone();
            int i = 0;
            while (i < windowPerms.length) {
                int[] windowPerm = windowPerms[i];
                System.arraycopy(windowPerm, 0, order, offset, length);
                long span = this.computeTotalSpan(order);
                if (span < bestSpan) {
                    bestSpan = span;
                    bestIdx = i;
                }
                ++i;
            }
            if (bestIdx >= 0) {
                System.arraycopy(windowPerms[bestIdx], 0, this.bestIndices, offset, length);
                if (this.dbgEnabled) {
                    OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [window %d..%d]", (Object[])new Object[]{bestSpan, (double)bestSpan / (double)this.edges.length, offset, offset + length - 1});
                }
            }
            ++offset;
        }
        if (this.dbgEnabled) {
            OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [after]", (Object[])new Object[]{bestSpan, (double)bestSpan / (double)this.edges.length});
        }
    }
}

