/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import java.io.DataInputStream;
import org.eclipse.escet.cif.eventbased.analysis.AddedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.DumpfileData;
import org.eclipse.escet.cif.eventbased.analysis.EdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationInfo;
import org.eclipse.escet.cif.eventbased.analysis.StateInfo;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpIO;
import org.eclipse.escet.cif.eventbased.apps.SynthesisAnalysisEditor;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.widgets.Display;

public class DumpfileLoader
implements Runnable {
    private final String filename;
    private final SynthesisAnalysisEditor editor;
    private final DumpfileData data = new DumpfileData();

    public DumpfileLoader(String filename, SynthesisAnalysisEditor editor) {
        this.filename = filename;
        this.editor = editor;
    }

    @Override
    public void run() {
        InputOutputException exception;
        boolean ok;
        block5: {
            DataInputStream inHandle = null;
            ok = false;
            exception = null;
            try {
                try {
                    inHandle = SynthesisDumpIO.openInput(this.filename);
                    this.readDumpFile(inHandle);
                    ok = true;
                }
                catch (InputOutputException ex) {
                    exception = ex;
                    SynthesisDumpIO.close(inHandle);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SynthesisDumpIO.close(inHandle);
                throw throwable;
            }
            SynthesisDumpIO.close(inHandle);
        }
        final DumpfileData result = ok ? this.data : null;
        final InputOutputException ex = exception;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DumpfileLoader.this.editor.loadingFinished(result, (Exception)ex);
            }
        });
    }

    private void readDumpFile(DataInputStream inHandle) {
        boolean finished = false;
        while (!finished) {
            byte blockByte = SynthesisDumpIO.readBlockByte(inHandle);
            switch (blockByte) {
                case 1: {
                    this.data.sourceInfo = SynthesisDumpIO.readDataSourceAutomataInformation(inHandle);
                    break;
                }
                case 2: {
                    this.data.events = SynthesisDumpIO.readDataEvents(inHandle);
                    break;
                }
                case 16: 
                case 17: {
                    int numAuts = this.data.getNumberAutomata();
                    StateInfo state = SynthesisDumpIO.readNewLocation(blockByte, numAuts, inHandle);
                    state.outEdges = Lists.list();
                    Assert.check((state.targetState == this.data.states.size() ? 1 : 0) != 0);
                    this.data.states.add(state);
                    this.data.sortedStates.put(state.srcLocs, state.targetState);
                    break;
                }
                case 18: {
                    AddedEdgeInfo edgeInfo = SynthesisDumpIO.readNewEdge(inHandle);
                    StateInfo src = this.data.states.get(edgeInfo.from);
                    src.outEdges.add(new EdgeInfo(edgeInfo.event, edgeInfo.to));
                    break;
                }
                case 32: 
                case 33: {
                    RemovedLocationInfo locInfo = SynthesisDumpIO.readDataRemovedLocation(blockByte, inHandle);
                    this.data.calculationEvents.add(locInfo);
                    break;
                }
                case 34: 
                case 35: {
                    RemovedEdgeInfo edgeInfo = SynthesisDumpIO.readDataRemovedEdge(blockByte, inHandle);
                    this.data.calculationEvents.add(edgeInfo);
                    break;
                }
                case 112: {
                    finished = true;
                    break;
                }
                default: {
                    Assert.fail((Object)Strings.fmt((String)"Unknown block byte 0x%02x found.", (Object[])new Object[]{blockByte}));
                }
            }
        }
    }
}

