/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.cif.simulator.CifSimulatorApp;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.CifSimulatorHistory;
import org.eclipse.escet.cif.simulator.compiler.CifCompiler;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.SvgInputComponent;
import org.eclipse.escet.cif.simulator.options.AskToTerminateMode;
import org.eclipse.escet.cif.simulator.options.AskToTerminateOption;
import org.eclipse.escet.cif.simulator.options.CifSpecOption;
import org.eclipse.escet.cif.simulator.options.CompileOnlyOption;
import org.eclipse.escet.cif.simulator.options.DebugCodeOption;
import org.eclipse.escet.cif.simulator.options.EndTimeOption;
import org.eclipse.escet.cif.simulator.options.HistoryOption;
import org.eclipse.escet.cif.simulator.options.InputMode;
import org.eclipse.escet.cif.simulator.options.InputModeOption;
import org.eclipse.escet.cif.simulator.options.MaxDelayOption;
import org.eclipse.escet.cif.simulator.options.TestModeOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationFiltersOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerOutputComponent;
import org.eclipse.escet.cif.simulator.output.print.PrintOutputComponent;
import org.eclipse.escet.cif.simulator.output.print.RuntimePrintDecls;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizationFiltersOption;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizationOption;
import org.eclipse.escet.cif.simulator.output.stateviz.StateVisualizerOutputComponent;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgOutputComponent;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgVisualizationOption;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataOption;
import org.eclipse.escet.cif.simulator.output.trajdata.TrajDataOutputComponent;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.ActualTargetTime;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.javacompiler.InMemoryJarClassLoader;
import org.eclipse.escet.common.app.framework.javacompiler.JarClassLoader;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.ui.PlatformUI;

public final class CifSimulator {
    public final CifSimulatorContext ctxt;
    public RuntimeSpec<?> spec;
    public RuntimeState state;

    public CifSimulator(CifSimulatorContext ctxt) {
        this.ctxt = ctxt;
    }

    public SimulationResult simulate(CifSimulatorApp app) {
        SimulationResult rslt;
        try {
            rslt = this.simulateInternal(app);
            if (rslt == null) {
                return null;
            }
        }
        catch (SimulatorExitException ex) {
            rslt = ex.result;
        }
        catch (CifSimulatorException ex) {
            RuntimeState errorState = this.getErrorState(ex);
            String msg = errorState == null ? "Simulation resulted in a runtime error." : Strings.fmt((String)"Simulation resulted in a runtime error, for state: %s.", (Object[])new Object[]{errorState.toSingleLineString(null, false, false)});
            throw new InvalidModelException(msg, (Throwable)ex);
        }
        finally {
            if (this.spec != null && this.spec.resourceClassLoader != null && this.spec.resourceClassLoader instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.spec.resourceClassLoader)).close();
                }
                catch (IOException ex) {
                    String msg = "Failed to close class loader.";
                    throw new InputOutputException(msg, (Throwable)ex);
                }
            }
            this.spec = null;
        }
        this.ctxt.provider.simulationEnded(rslt, this.state);
        this.confirmTermination();
        return rslt;
    }

    private RuntimeState getErrorState(CifSimulatorException rootException) {
        RuntimeState rslt = null;
        Throwable ex = rootException;
        while (ex != null) {
            RuntimeState exState;
            if (ex instanceof CifSimulatorException && (exState = ex.state) != null) {
                if (rslt == null) {
                    rslt = exState;
                } else {
                    Assert.check((rslt == exState ? 1 : 0) != 0);
                }
            }
            ex = ex.getCause();
        }
        if (rslt == null) {
            rslt = this.state;
        }
        return rslt;
    }

    private SimulationResult simulateInternal(CifSimulatorApp app) {
        Object comp;
        String filtersTxt;
        int n;
        int n2;
        Object object;
        String[] filtersTxts;
        RuntimeSpec<?> spec = CifSimulator.loadSpec(app);
        if (spec == null) {
            return null;
        }
        this.ctxt.checkTermination();
        spec.init(this.ctxt);
        this.ctxt.checkTermination();
        if (TrajDataOption.isEnabled()) {
            OutputProvider.register((IOutputComponent)new TrajDataOutputComponent());
        }
        if (StateVisualizationOption.isEnabled()) {
            filtersTxts = StateVisualizationFiltersOption.getFiltersPerViz();
            object = filtersTxts;
            n2 = filtersTxts.length;
            n = 0;
            while (n < n2) {
                filtersTxt = object[n];
                comp = new StateVisualizerOutputComponent(filtersTxt);
                OutputProvider.register((IOutputComponent)comp);
                ++n;
            }
        }
        if (PlotVisualizationOption.isEnabled()) {
            filtersTxts = PlotVisualizationFiltersOption.getFiltersPerViz();
            object = filtersTxts;
            n2 = filtersTxts.length;
            n = 0;
            while (n < n2) {
                filtersTxt = object[n];
                comp = new PlotVisualizerOutputComponent(filtersTxt);
                OutputProvider.register((IOutputComponent)comp);
                ++n;
            }
        }
        boolean svgEnabled = SvgVisualizationOption.isEnabled();
        List<RuntimeCifSvgDecls> cifSvgDecls = spec.getCifSvgDecls();
        InputMode imode = InputModeOption.getInputMode();
        if (svgEnabled && !cifSvgDecls.isEmpty()) {
            for (RuntimeCifSvgDecls cifSvgDecl : cifSvgDecls) {
                comp = new SvgOutputComponent(cifSvgDecl, this.ctxt);
                OutputProvider.register((IOutputComponent)comp);
                if (imode != InputMode.SVG) continue;
                ((SvgInputComponent)spec.input).initialize((SvgOutputComponent)comp);
            }
        } else if (imode == InputMode.SVG) {
            if (!svgEnabled) {
                String msg = "The SVG input mode requires the use of SVG visualization, which is currently disabled.";
                throw new InvalidOptionException(msg);
            }
            Assert.check((boolean)cifSvgDecls.isEmpty());
            String msg = "The SVG input mode requires the use of SVG visualization, but the CIF specification being simulated has no CIF/SVG declarations.";
            throw new InvalidOptionException(msg);
        }
        List<RuntimePrintDecls> printDeclsList = spec.getPrintDecls();
        for (RuntimePrintDecls printDecls : printDeclsList) {
            PrintOutputComponent comp2 = new PrintOutputComponent(printDecls, this.ctxt);
            OutputProvider.register((IOutputComponent)comp2, (boolean)false);
        }
        if (this.ctxt.realTime && !this.ctxt.testMode && !this.ctxt.provider.supportsRealTimeSimulation()) {
            String msg = "Real-time simulation is enabled, but no real-time output components are active.";
            throw new UnsupportedException(msg);
        }
        this.state = spec.createInitialState(spec);
        this.ctxt.checkTermination();
        if (!this.state.checkInitialization()) {
            return SimulationResult.INIT_FAILED;
        }
        this.ctxt.checkTermination();
        this.ctxt.provider.initialState(this.state);
        this.ctxt.checkTermination();
        if (HistoryOption.isEnabled()) {
            spec.input.history = new CifSimulatorHistory(this.state);
        }
        Double optionEndTime = EndTimeOption.getEndTime();
        Double optionMaxDelay = MaxDelayOption.getMaxDelay();
        while (true) {
            Boolean strictTargetTime;
            Double targetStateTime;
            Object targetState;
            SimulationResult simulationResult;
            List transitions;
            this.ctxt.checkTermination();
            if (this.ctxt.realTime && !this.ctxt.testMode && !this.ctxt.provider.supportsRealTimeSimulation()) {
                return SimulationResult.USER_TERMINATED;
            }
            if (optionEndTime != null && this.state.getTime() >= optionEndTime) {
                transitions = Collections.emptyList();
                simulationResult = SimulationResult.ENDTIME_REACHED;
            } else {
                Double inputMaxEndTime = this.state.getNextMaxEndTime();
                Double nextMaxEndTime = optionEndTime;
                if (nextMaxEndTime == null) {
                    nextMaxEndTime = inputMaxEndTime;
                } else if (inputMaxEndTime != null) {
                    nextMaxEndTime = Math.min(nextMaxEndTime, inputMaxEndTime);
                }
                this.state.calcTransitions(nextMaxEndTime, optionMaxDelay);
                transitions = Lists.cast(spec.transitions);
                simulationResult = transitions.isEmpty() ? SimulationResult.DEADLOCK : null;
            }
            this.ctxt.checkTermination();
            this.ctxt.provider.possibleTransitions(transitions, simulationResult);
            Transition<?> transition = this.state.chooseTransition(this.state, transitions, simulationResult);
            this.ctxt.checkTermination();
            ChosenTargetTime chosenTargetTime = null;
            if (transition instanceof TimeTransition) {
                TimeTransition timeTrans = (TimeTransition)transition;
                double maxTargetTime = timeTrans.getLastTime();
                chosenTargetTime = this.state.chooseTargetTime(maxTargetTime);
                this.ctxt.checkTermination();
            }
            this.ctxt.provider.transitionChosen(this.state, transition, chosenTargetTime);
            ActualTargetTime actualTargetTime = null;
            if (transition instanceof TimeTransition) {
                TimeTransition timeTrans = (TimeTransition)transition;
                actualTargetTime = timeTrans.takeTimeTransition(chosenTargetTime);
                this.ctxt.checkTermination();
            }
            if ((targetState = transition.getTargetState(targetStateTime = actualTargetTime == null ? null : Double.valueOf(actualTargetTime.targetTime), strictTargetTime = chosenTargetTime == null ? null : Boolean.valueOf(chosenTargetTime.strictTarget))) == null) {
                Assert.check((strictTargetTime != null && strictTargetTime == false ? 1 : 0) != 0);
                this.state.spec.transitions.clear();
                this.state.calcTimeTransition(targetStateTime);
                this.ctxt.checkTermination();
                Assert.check((this.state.spec.transitions.size() == 1 ? 1 : 0) != 0);
                Transition trans = (Transition)Lists.first(this.state.spec.transitions);
                TimeTransition timeTrans = (TimeTransition)trans;
                targetState = timeTrans.getTargetState(targetStateTime, true);
            }
            RuntimeState sourceState = this.state;
            this.state = targetState;
            Boolean interrupted = actualTargetTime == null ? null : Boolean.valueOf(actualTargetTime.interrupted);
            this.ctxt.provider.transitionTaken(sourceState, transition, (RuntimeState)targetState, interrupted);
            if (spec.input.history == null || transition instanceof HistoryTransition) continue;
            spec.input.history.addState(this.state);
        }
    }

    private static RuntimeSpec<?> loadSpec(CifSimulatorApp app) {
        Object specObj;
        Field specField;
        Class<?> specClass;
        ClassLoader classLoader;
        String classPath = DebugCodeOption.getClasspath();
        if (classPath == null) {
            String inputPath = CifSpecOption.getCifSpecPath();
            if (inputPath.toLowerCase(Locale.US).endsWith(".cifcode")) {
                String path = Paths.resolve((String)inputPath);
                File file = new File(path);
                if (!file.exists()) {
                    String msg = Strings.fmt((String)"Could not find compiled code file \"%s\".", (Object[])new Object[]{inputPath});
                    throw new InvalidOptionException(msg);
                }
                if (!file.isFile()) {
                    String msg = Strings.fmt((String)"Compiled code file path \"%s\" does not refer to a file.", (Object[])new Object[]{inputPath});
                    throw new InvalidOptionException(msg);
                }
                ClassLoader dependencyLoader = CifSimulator.class.getClassLoader();
                classLoader = new InMemoryJarClassLoader(path, dependencyLoader);
            } else {
                CifCompilerContext ctxt = new CifCompilerContext();
                ctxt.app = app;
                CifCompiler.compileSpec(inputPath, ctxt);
                ctxt.app = null;
                classLoader = ctxt.getClassLoader();
                if (CompileOnlyOption.isEnabled()) {
                    return null;
                }
            }
        } else {
            URL url;
            classPath = Paths.resolve((String)classPath);
            try {
                url = Paths.createJavaURI((String)classPath).toURL();
            }
            catch (MalformedURLException e) {
                String msg = Strings.fmt((String)"Invalid classpath specified for the --debug-code option: \"%s\".", (Object[])new Object[]{classPath});
                throw new InvalidOptionException(msg, (Throwable)e);
            }
            URL[] urls = new URL[]{url};
            classLoader = CifSimulator.class.getClassLoader();
            classLoader = new URLClassLoader(urls, classLoader);
        }
        CifSimulator.checkVersion(classLoader, app);
        String specClassName = CifCompilerContext.getClassName("Spec");
        try {
            specClass = classLoader.loadClass(specClassName);
        }
        catch (ClassNotFoundException e) {
            String msg;
            if (classPath != null) {
                msg = Strings.fmt((String)"Failed to load specification from debug code (classpath: \"%s\").", (Object[])new Object[]{classPath});
                throw new InvalidOptionException(msg, (Throwable)e);
            }
            if (classLoader instanceof JarClassLoader) {
                msg = Strings.fmt((String)"Failed to load specification from compiled code file \"%s\". Make sure the file is really a compiled code file.", (Object[])new Object[]{CifSpecOption.getCifSpecPath()});
                throw new InvalidOptionException(msg, (Throwable)e);
            }
            msg = "Unexpected class loader: " + classLoader;
            throw new RuntimeException(msg);
        }
        try {
            specField = specClass.getField("SPEC");
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        try {
            specObj = specField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        RuntimeSpec spec = (RuntimeSpec)specObj;
        spec.resourceClassLoader = classLoader;
        return spec;
    }

    private static void checkVersion(ClassLoader classLoader, CifSimulatorApp app) {
        String loadedVersion;
        String path = "version.dat";
        path = "cifcode/" + path;
        String currentVersion = app.getAppVersion();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream stream = classLoader.getResourceAsStream(path);){
                if (stream == null) {
                    if (classLoader instanceof JarClassLoader) {
                        String msg = Strings.fmt((String)"Failed to obtain version from compiled code file \"%s\". Make sure the file is really a compiled code file.", (Object[])new Object[]{CifSpecOption.getCifSpecPath()});
                        throw new InvalidOptionException(msg);
                    }
                    if (classLoader instanceof URLClassLoader) {
                        String msg = Strings.fmt((String)"Failed to obtain version from debug code (classpath: \"%s\").", (Object[])new Object[]{DebugCodeOption.getClasspath()});
                        throw new InvalidOptionException(msg);
                    }
                    String msg = "Unexpected class loader: " + classLoader;
                    throw new RuntimeException(msg);
                }
                loadedVersion = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read version of compiled code.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
        if (!currentVersion.equals(loadedVersion)) {
            String msg = Strings.fmt((String)"Compiled code version (%s) vs simulator version (%s) mismatch. Please recompile.", (Object[])new Object[]{loadedVersion, currentVersion});
            OutputProvider.warn((String)msg);
        }
    }

    private void confirmTermination() {
        AskToTerminateMode mode = AskToTerminateOption.getMode();
        switch (mode) {
            case ON: {
                break;
            }
            case OFF: {
                return;
            }
            case AUTO: {
                if (Platform.isRunning() && PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                if (TestModeOption.isEnabled()) {
                    return;
                }
                if (this.ctxt.provider.hasVisualInterface()) break;
                return;
            }
        }
        String question = "Press <ENTER> to terminate the simulator...";
        this.ctxt.appEnvData.getStreams().out.print(question);
        this.ctxt.appEnvData.getStreams().out.flush();
        try {
            this.ctxt.appEnvData.getStreams().in.readLine();
        }
        catch (IOException ex) {
            String msg = "Could not read input from stdin.";
            throw new InputOutputException(msg, (Throwable)ex);
        }
    }
}

