/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.CifFormatPatternCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.LiteralCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ExprCodeGenerator {
    private ExprCodeGenerator() {
    }

    public static String gencodePreds(List<Expression> preds, CifCompilerContext ctxt, String state) {
        return ExprCodeGenerator.gencodePreds(preds, ctxt, state, "true");
    }

    public static String gencodePreds(List<Expression> preds, CifCompilerContext ctxt, String state, String noPredsCode) {
        if (preds.isEmpty()) {
            return noPredsCode;
        }
        List txts = Lists.listc((int)preds.size());
        for (Expression pred : preds) {
            String txt = ExprCodeGenerator.gencodeExpr(pred, ctxt, state);
            if (preds.size() > 1) {
                txt = "(" + txt + ")";
            }
            txts.add(txt);
        }
        return StringUtils.join((Iterable)txts, (String)" && ");
    }

    public static String gencodeExprs(List<Expression> exprs, CifCompilerContext ctxt, String state) {
        if (exprs.isEmpty()) {
            return "";
        }
        if (exprs.size() == 1) {
            return ExprCodeGenerator.gencodeExpr((Expression)Lists.first(exprs), ctxt, state);
        }
        List txts = Lists.listc((int)exprs.size());
        for (Expression expr : exprs) {
            txts.add(ExprCodeGenerator.gencodeExpr(expr, ctxt, state));
        }
        return StringUtils.join((Iterable)txts, (String)", ");
    }

    public static String gencodeExpr(Expression expr, CifCompilerContext ctxt, String state) {
        if (expr instanceof BoolExpression) {
            return ((BoolExpression)expr).isValue() ? "true" : "false";
        }
        if (expr instanceof IntExpression) {
            return Integer.toString(((IntExpression)expr).getValue());
        }
        if (expr instanceof RealExpression) {
            String valueTxt = ((RealExpression)expr).getValue();
            double value = Double.parseDouble(valueTxt);
            return CifSimulatorMath.realToStr(value);
        }
        if (expr instanceof StringExpression) {
            return Strings.stringToJava((String)((StringExpression)expr).getValue());
        }
        if (expr instanceof TimeExpression) {
            return Strings.fmt((String)"%s.%s.time", (Object[])new Object[]{state, "s"});
        }
        if (expr instanceof CastExpression) {
            return ExprCodeGenerator.gencodeCastExpr((CastExpression)expr, ctxt, state);
        }
        if (expr instanceof UnaryExpression) {
            return ExprCodeGenerator.gencodeUnaryExpr((UnaryExpression)expr, ctxt, state);
        }
        if (expr instanceof BinaryExpression) {
            return ExprCodeGenerator.gencodeBinaryExpr((BinaryExpression)expr, ctxt, state);
        }
        if (expr instanceof IfExpression) {
            return ExprCodeGenerator.gencodeIfExpr((IfExpression)expr, ctxt, state);
        }
        if (expr instanceof SwitchExpression) {
            return ExprCodeGenerator.gencodeSwitchExpr((SwitchExpression)expr, ctxt, state);
        }
        if (expr instanceof ProjectionExpression) {
            return ExprCodeGenerator.gencodeProjExpr((ProjectionExpression)expr, ctxt, state);
        }
        if (expr instanceof SliceExpression) {
            return ExprCodeGenerator.gencodeSliceExpr((SliceExpression)expr, ctxt, state);
        }
        if (expr instanceof FunctionCallExpression) {
            return ExprCodeGenerator.gencodeFuncCallExpr((FunctionCallExpression)expr, ctxt, state);
        }
        if (expr instanceof ListExpression) {
            return ExprCodeGenerator.gencodeListExpr((ListExpression)expr, ctxt, state);
        }
        if (expr instanceof SetExpression) {
            return ExprCodeGenerator.gencodeSetExpr((SetExpression)expr, ctxt, state);
        }
        if (expr instanceof TupleExpression) {
            return ExprCodeGenerator.gencodeTupleExpr((TupleExpression)expr, ctxt, state);
        }
        if (expr instanceof DictExpression) {
            return ExprCodeGenerator.gencodeDictExpr((DictExpression)expr, ctxt, state);
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression cexpr = (ConstantExpression)expr;
            return ctxt.getConstFieldName(cexpr.getConstant());
        }
        if (expr instanceof DiscVariableExpression) {
            return ExprCodeGenerator.gencodeDiscVarExpr((DiscVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof InputVariableExpression) {
            return ExprCodeGenerator.gencodeInputVarExpr((InputVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            return Strings.fmt((String)"%s(%s)", (Object[])new Object[]{ctxt.getAlgVarMethodName(var), state});
        }
        if (expr instanceof ContVariableExpression) {
            return ExprCodeGenerator.gencodeContVarExpr((ContVariableExpression)expr, ctxt, state);
        }
        if (expr instanceof LocationExpression) {
            return ExprCodeGenerator.gencodeLocExpr((LocationExpression)expr, ctxt, state);
        }
        if (expr instanceof EnumLiteralExpression) {
            EnumLiteral lit = ((EnumLiteralExpression)expr).getLiteral();
            EnumDecl enumDecl = (EnumDecl)lit.eContainer();
            return Strings.fmt((String)"%s.%s", (Object[])new Object[]{ctxt.getEnumClassName(enumDecl), ctxt.getEnumConstName(lit)});
        }
        if (expr instanceof FunctionExpression) {
            Function func = ((FunctionExpression)expr).getFunction();
            return Strings.fmt((String)"%s.%s", (Object[])new Object[]{ctxt.getFuncClassName(func), ctxt.getFuncFieldName(func)});
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event used as value: " + expr);
        }
        if (expr instanceof ReceivedExpression) {
            return "rcvd";
        }
        if (expr instanceof SelfExpression) {
            throw new RuntimeException("Self expr unexpected.");
        }
        if (expr instanceof ComponentExpression) {
            throw new RuntimeException("Component expr unexpected.");
        }
        throw new RuntimeException("Unexpected expr: " + expr);
    }

    private static String gencodeCastExpr(CastExpression expr, CifCompilerContext ctxt, String state) {
        Expression child = expr.getChild();
        if (CifTypeUtils.isAutRefExpr((Expression)child)) {
            CifType ctype = child.getType();
            Assert.check((boolean)(ctype instanceof ComponentType));
            Automaton aut = (Automaton)((ComponentType)ctype).getComponent();
            int idx = ctxt.getAutomata().indexOf(aut);
            return Strings.fmt((String)"%s.getAutCurLocName(%d)", (Object[])new Object[]{state, idx});
        }
        String crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        CifType nctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        CifType ntype = CifTypeUtils.normalizeType((CifType)expr.getType());
        if (nctype instanceof IntType && ntype instanceof RealType) {
            return Strings.fmt((String)"intToReal(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof IntType && ntype instanceof StringType) {
            return Strings.fmt((String)"intToStr(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof RealType && ntype instanceof StringType) {
            return Strings.fmt((String)"realToStr(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof BoolType && ntype instanceof StringType) {
            return Strings.fmt((String)"boolToStr(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof StringType && ntype instanceof IntType) {
            return Strings.fmt((String)"strToInt(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof StringType && ntype instanceof RealType) {
            return Strings.fmt((String)"strToReal(%s)", (Object[])new Object[]{crslt});
        }
        if (nctype instanceof StringType && ntype instanceof BoolType) {
            return Strings.fmt((String)"strToBool(%s)", (Object[])new Object[]{crslt});
        }
        if (CifTypeUtils.checkTypeCompat((CifType)nctype, (CifType)ntype, (RangeCompat)RangeCompat.EQUAL)) {
            return crslt;
        }
        String msg = "Unknown cast: " + nctype + ", " + ntype;
        throw new RuntimeException(msg);
    }

    private static String gencodeUnaryExpr(UnaryExpression expr, CifCompilerContext ctxt, String state) {
        String crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        switch (expr.getOperator()) {
            case INVERSE: {
                return Strings.fmt((String)"!(%s)", (Object[])new Object[]{crslt});
            }
            case NEGATE: {
                return Strings.fmt((String)"negate(%s)", (Object[])new Object[]{crslt});
            }
            case PLUS: {
                return crslt;
            }
            case SAMPLE: {
                ctxt.needSampler = true;
                return Strings.fmt((String)"Sampler.sample(%s)", (Object[])new Object[]{crslt});
            }
        }
        throw new RuntimeException("Unknown unop: " + expr.getOperator());
    }

    private static String gencodeBinaryExpr(BinaryExpression expr, CifCompilerContext ctxt, String state) {
        String lrslt = ExprCodeGenerator.gencodeExpr(expr.getLeft(), ctxt, state);
        String rrslt = ExprCodeGenerator.gencodeExpr(expr.getRight(), ctxt, state);
        switch (expr.getOperator()) {
            case IMPLICATION: {
                return Strings.fmt((String)"!(%s) || (%s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case BI_CONDITIONAL: {
                return Strings.fmt((String)"equal(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case DISJUNCTION: {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (nltype instanceof BoolType) {
                    return Strings.fmt((String)"(%s) || (%s)", (Object[])new Object[]{lrslt, rrslt});
                }
                Assert.check((boolean)(nltype instanceof SetType));
                return Strings.fmt((String)"union(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case CONJUNCTION: {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                if (nltype instanceof BoolType) {
                    return Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{lrslt, rrslt});
                }
                Assert.check((boolean)(nltype instanceof SetType));
                return Strings.fmt((String)"intersection(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case LESS_THAN: {
                return Strings.fmt((String)"(%s) < (%s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case LESS_EQUAL: {
                return Strings.fmt((String)"(%s) <= (%s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case GREATER_THAN: {
                return Strings.fmt((String)"(%s) > (%s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case GREATER_EQUAL: {
                return Strings.fmt((String)"(%s) >= (%s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case EQUAL: {
                return Strings.fmt((String)"equal(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case UNEQUAL: {
                return Strings.fmt((String)"!equal(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case ADDITION: {
                CifType nltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType nrtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (nltype instanceof RealType) {
                    return Strings.fmt((String)"addReal(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
                }
                if (nrtype instanceof RealType) {
                    return Strings.fmt((String)"addReal(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
                }
                if (nltype instanceof ListType) {
                    return Strings.fmt((String)"addList(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
                }
                if (nltype instanceof StringType) {
                    return Strings.fmt((String)"addString(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
                }
                if (nltype instanceof DictType) {
                    return Strings.fmt((String)"addDict(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
                }
                return Strings.fmt((String)"addInt(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case SUBTRACTION: {
                return Strings.fmt((String)"subtract(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case MULTIPLICATION: {
                return Strings.fmt((String)"multiply(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case DIVISION: {
                return Strings.fmt((String)"divide(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case INTEGER_DIVISION: {
                return Strings.fmt((String)"div(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case MODULUS: {
                return Strings.fmt((String)"mod(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case SUBSET: {
                return Strings.fmt((String)"subset(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
            case ELEMENT_OF: {
                return Strings.fmt((String)"in(%s, %s)", (Object[])new Object[]{lrslt, rrslt});
            }
        }
        throw new RuntimeException("Unknown binop: " + expr.getOperator());
    }

    private static String gencodeIfExpr(IfExpression expr, CifCompilerContext ctxt, String state) {
        String rslt = ExprCodeGenerator.gencodeExpr(expr.getElse(), ctxt, state);
        int i = expr.getElifs().size() - 1;
        while (i >= 0) {
            ElifExpression elif = (ElifExpression)expr.getElifs().get(i);
            rslt = Strings.fmt((String)"(%s) ? %s : (%s)", (Object[])new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)elif.getGuards(), ctxt, state), ExprCodeGenerator.gencodeExpr(elif.getThen(), ctxt, state), rslt});
            --i;
        }
        rslt = Strings.fmt((String)"(%s) ? %s : (%s)", (Object[])new Object[]{ExprCodeGenerator.gencodePreds((List<Expression>)expr.getGuards(), ctxt, state), ExprCodeGenerator.gencodeExpr(expr.getThen(), ctxt, state), rslt});
        return rslt;
    }

    private static String gencodeSwitchExpr(SwitchExpression expr, CifCompilerContext ctxt, String state) {
        Expression value = expr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        String valueTxt = isAutRef ? null : ExprCodeGenerator.gencodeExpr(value, ctxt, state);
        EList cases = expr.getCases();
        String rslt = ExprCodeGenerator.gencodeExpr(((SwitchCase)Lists.last((List)cases)).getValue(), ctxt, state);
        int i = cases.size() - 2;
        while (i >= 0) {
            SwitchCase cse = (SwitchCase)cases.get(i);
            Expression key = cse.getKey();
            Assert.notNull((Object)key);
            String keyTxt = ExprCodeGenerator.gencodeExpr(key, ctxt, state);
            if (valueTxt != null) {
                keyTxt = Strings.fmt((String)"equal(%s, %s)", (Object[])new Object[]{valueTxt, keyTxt});
            }
            rslt = Strings.fmt((String)"(%s) ? %s : (%s)", (Object[])new Object[]{keyTxt, ExprCodeGenerator.gencodeExpr(cse.getValue(), ctxt, state), rslt});
            --i;
        }
        return rslt;
    }

    private static String gencodeProjExpr(ProjectionExpression expr, CifCompilerContext ctxt, String state) {
        String crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        CifType nctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
        if (nctype instanceof TupleType && expr.getIndex() instanceof FieldExpression) {
            Field field = ((FieldExpression)expr.getIndex()).getField();
            String fieldName = ctxt.getTupleTypeFieldFieldName(field);
            return Strings.fmt((String)"(%s).%s", (Object[])new Object[]{crslt, fieldName});
        }
        if (nctype instanceof TupleType) {
            int idx;
            try {
                idx = (Integer)CifEvalUtils.eval((Expression)expr.getIndex(), (boolean)false);
            }
            catch (CifEvalException e) {
                throw new RuntimeException(e);
            }
            TupleType tupleType = (TupleType)nctype;
            String fieldName = ctxt.getTupleTypeFieldFieldName(tupleType, idx);
            return Strings.fmt((String)"(%s).%s", (Object[])new Object[]{crslt, fieldName});
        }
        String irslt = ExprCodeGenerator.gencodeExpr(expr.getIndex(), ctxt, state);
        return Strings.fmt((String)"project(%s, %s)", (Object[])new Object[]{crslt, irslt});
    }

    private static String gencodeSliceExpr(SliceExpression expr, CifCompilerContext ctxt, String state) {
        String crslt = ExprCodeGenerator.gencodeExpr(expr.getChild(), ctxt, state);
        String begin = expr.getBegin() == null ? "null" : ExprCodeGenerator.gencodeExpr(expr.getBegin(), ctxt, state);
        String end = expr.getEnd() == null ? "null" : ExprCodeGenerator.gencodeExpr(expr.getEnd(), ctxt, state);
        return Strings.fmt((String)"slice(%s, %s, %s)", (Object[])new Object[]{crslt, begin, end});
    }

    private static String gencodeFuncCallExpr(FunctionCallExpression expr, CifCompilerContext ctxt, String state) {
        if (!(expr.getFunction() instanceof StdLibFunctionExpression)) {
            String argsTxt = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getParams(), ctxt, state);
            return Strings.fmt((String)"(%s).evalFunc(%s)", (Object[])new Object[]{ExprCodeGenerator.gencodeExpr(expr.getFunction(), ctxt, state), argsTxt});
        }
        StdLibFunctionExpression stdlibExpr = (StdLibFunctionExpression)expr.getFunction();
        StdLibFunction stdlib = stdlibExpr.getFunction();
        if (stdlib == StdLibFunction.FORMAT) {
            Expression patternExpr = (Expression)expr.getParams().get(0);
            String pattern = ((StringExpression)patternExpr).getValue();
            List valueTxts = Lists.listc((int)(expr.getParams().size() - 1));
            List valueTypes = Lists.listc((int)(expr.getParams().size() - 1));
            int i = 1;
            while (i < expr.getParams().size()) {
                Expression value = (Expression)expr.getParams().get(i);
                valueTxts.add(ExprCodeGenerator.gencodeExpr(value, ctxt, state));
                valueTypes.add(value.getType());
                ++i;
            }
            return CifFormatPatternCodeGenerator.gencodePattern(pattern, valueTxts, valueTypes);
        }
        String argsTxt = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getParams(), ctxt, state);
        switch (stdlib) {
            case ACOSH: {
                return Strings.fmt((String)"acosh(%s)", (Object[])new Object[]{argsTxt});
            }
            case ACOS: {
                return Strings.fmt((String)"acos(%s)", (Object[])new Object[]{argsTxt});
            }
            case ASINH: {
                return Strings.fmt((String)"asinh(%s)", (Object[])new Object[]{argsTxt});
            }
            case ASIN: {
                return Strings.fmt((String)"asin(%s)", (Object[])new Object[]{argsTxt});
            }
            case ATANH: {
                return Strings.fmt((String)"atanh(%s)", (Object[])new Object[]{argsTxt});
            }
            case ATAN: {
                return Strings.fmt((String)"atan(%s)", (Object[])new Object[]{argsTxt});
            }
            case COSH: {
                return Strings.fmt((String)"cosh(%s)", (Object[])new Object[]{argsTxt});
            }
            case COS: {
                return Strings.fmt((String)"cos(%s)", (Object[])new Object[]{argsTxt});
            }
            case SINH: {
                return Strings.fmt((String)"sinh(%s)", (Object[])new Object[]{argsTxt});
            }
            case SIN: {
                return Strings.fmt((String)"sin(%s)", (Object[])new Object[]{argsTxt});
            }
            case TANH: {
                return Strings.fmt((String)"tanh(%s)", (Object[])new Object[]{argsTxt});
            }
            case TAN: {
                return Strings.fmt((String)"tan(%s)", (Object[])new Object[]{argsTxt});
            }
            case ABS: {
                return Strings.fmt((String)"abs(%s)", (Object[])new Object[]{argsTxt});
            }
            case CBRT: {
                return Strings.fmt((String)"cbrt(%s)", (Object[])new Object[]{argsTxt});
            }
            case CEIL: {
                return Strings.fmt((String)"ceil(%s)", (Object[])new Object[]{argsTxt});
            }
            case DELETE: {
                return Strings.fmt((String)"delete(%s)", (Object[])new Object[]{argsTxt});
            }
            case EMPTY: {
                return Strings.fmt((String)"empty(%s)", (Object[])new Object[]{argsTxt});
            }
            case EXP: {
                return Strings.fmt((String)"exp(%s)", (Object[])new Object[]{argsTxt});
            }
            case FLOOR: {
                return Strings.fmt((String)"floor(%s)", (Object[])new Object[]{argsTxt});
            }
            case FORMAT: {
                throw new RuntimeException("Already handled above: " + stdlib);
            }
            case LN: {
                return Strings.fmt((String)"ln(%s)", (Object[])new Object[]{argsTxt});
            }
            case LOG: {
                return Strings.fmt((String)"log(%s)", (Object[])new Object[]{argsTxt});
            }
            case MAXIMUM: {
                return Strings.fmt((String)"max(%s)", (Object[])new Object[]{argsTxt});
            }
            case MINIMUM: {
                return Strings.fmt((String)"min(%s)", (Object[])new Object[]{argsTxt});
            }
            case POP: {
                TupleType rsltType = (TupleType)CifTypeUtils.normalizeType((CifType)expr.getType());
                String className = ctxt.getTupleTypeClassName(rsltType);
                return Strings.fmt((String)"%s.pop(%s)", (Object[])new Object[]{className, argsTxt});
            }
            case POWER: {
                CifType rsltType = CifTypeUtils.normalizeType((CifType)expr.getType());
                if (rsltType instanceof IntType) {
                    return Strings.fmt((String)"powInt(%s)", (Object[])new Object[]{argsTxt});
                }
                return Strings.fmt((String)"powReal(%s)", (Object[])new Object[]{argsTxt});
            }
            case ROUND: {
                return Strings.fmt((String)"round(%s)", (Object[])new Object[]{argsTxt});
            }
            case SCALE: {
                return Strings.fmt((String)"scale(%s)", (Object[])new Object[]{argsTxt});
            }
            case SIGN: {
                return Strings.fmt((String)"sign(%s)", (Object[])new Object[]{argsTxt});
            }
            case SIZE: {
                return Strings.fmt((String)"size(%s)", (Object[])new Object[]{argsTxt});
            }
            case SQRT: {
                return Strings.fmt((String)"sqrt(%s)", (Object[])new Object[]{argsTxt});
            }
            case BERNOULLI: {
                return Strings.fmt((String)"new BernoulliDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case BETA: {
                return Strings.fmt((String)"new BetaDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case BINOMIAL: {
                return Strings.fmt((String)"new BinomialDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case CONSTANT: {
                String className;
                Expression arg = (Expression)Lists.first((List)expr.getParams());
                CifType argType = CifTypeUtils.normalizeType((CifType)arg.getType());
                if (argType instanceof BoolType) {
                    className = "ConstantBooleanDistribution";
                } else if (argType instanceof IntType) {
                    className = "ConstantIntegerDistribution";
                } else if (argType instanceof RealType) {
                    className = "ConstantRealDistribution";
                } else {
                    String msg = "Unknown constant distribution: " + argType;
                    throw new RuntimeException(msg);
                }
                return Strings.fmt((String)"new %s(%s)", (Object[])new Object[]{className, argsTxt});
            }
            case ERLANG: {
                return Strings.fmt((String)"new ErlangDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case EXPONENTIAL: {
                return Strings.fmt((String)"new ExponentialDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case GAMMA: {
                return Strings.fmt((String)"new GammaDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case GEOMETRIC: {
                return Strings.fmt((String)"new GeometricDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case LOG_NORMAL: {
                return Strings.fmt((String)"new LogNormalDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case NORMAL: {
                return Strings.fmt((String)"new NormalDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case POISSON: {
                return Strings.fmt((String)"new PoissonDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case RANDOM: {
                return Strings.fmt((String)"new RandomDistribution(new CifMersenneTwister(%s.spec.getNextSeed()))", (Object[])new Object[]{state});
            }
            case TRIANGLE: {
                return Strings.fmt((String)"new TriangleDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
            case UNIFORM: {
                String className;
                Expression arg = (Expression)Lists.first((List)expr.getParams());
                CifType argType = CifTypeUtils.normalizeType((CifType)arg.getType());
                if (argType instanceof IntType) {
                    className = "UniformIntegerDistribution";
                } else if (argType instanceof RealType) {
                    className = "UniformRealDistribution";
                } else {
                    String msg = "Unknown uniform distribution: " + argType;
                    throw new RuntimeException(msg);
                }
                return Strings.fmt((String)"new %s(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{className, state, argsTxt});
            }
            case WEIBULL: {
                return Strings.fmt((String)"new WeibullDistribution(new CifMersenneTwister(%s.spec.getNextSeed()), %s)", (Object[])new Object[]{state, argsTxt});
            }
        }
        throw new RuntimeException("Unknown stdlib func: " + stdlib);
    }

    private static String gencodeListExpr(ListExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getElements().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt);
        }
        ListType ltype = (ListType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType etype = ltype.getElementType();
        int size = expr.getElements().size();
        String rslt = Strings.fmt((String)"new ArrayList<%s>(%d)", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true), size});
        if (expr.getElements().isEmpty()) {
            return rslt;
        }
        String elemTxt = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getElements(), ctxt, state);
        return Strings.fmt((String)"makelist(%s, %s)", (Object[])new Object[]{rslt, elemTxt});
    }

    private static String gencodeSetExpr(SetExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getElements().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt);
        }
        SetType stype = (SetType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType etype = stype.getElementType();
        int size = expr.getElements().size();
        String rslt = Strings.fmt((String)"new LinkedHashSet<%s>(%d)", (Object[])new Object[]{TypeCodeGenerator.gencodeType(etype, ctxt, true), size});
        if (expr.getElements().isEmpty()) {
            return rslt;
        }
        String elemTxt = ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getElements(), ctxt, state);
        return Strings.fmt((String)"makeset(%s, %s)", (Object[])new Object[]{rslt, elemTxt});
    }

    private static String gencodeTupleExpr(TupleExpression expr, CifCompilerContext ctxt, String state) {
        TupleType tupleType = (TupleType)CifTypeUtils.normalizeType((CifType)expr.getType());
        String className = ctxt.getTupleTypeClassName(tupleType);
        return Strings.fmt((String)"new %s(%s)", (Object[])new Object[]{className, ExprCodeGenerator.gencodeExprs((List<Expression>)expr.getFields(), ctxt, state)});
    }

    private static String gencodeDictExpr(DictExpression expr, CifCompilerContext ctxt, String state) {
        if (expr.getPairs().size() >= 100 && LiteralCodeGenerator.isSerializableLiteral((Expression)expr)) {
            return LiteralCodeGenerator.gencodeLiteral((Expression)expr, ctxt);
        }
        DictType dtype = (DictType)CifTypeUtils.normalizeType((CifType)expr.getType());
        CifType ktype = dtype.getKeyType();
        CifType vtype = dtype.getValueType();
        EList pairs = expr.getPairs();
        int size = pairs.size();
        String ktypeTxt = TypeCodeGenerator.gencodeType(ktype, ctxt, true);
        String vtypeTxt = TypeCodeGenerator.gencodeType(vtype, ctxt, true);
        String rslt = Strings.fmt((String)"new LinkedHashMap<%s, %s>(%d)", (Object[])new Object[]{ktypeTxt, vtypeTxt, size});
        List keyTxts = Lists.listc((int)pairs.size());
        List valueTxts = Lists.listc((int)pairs.size());
        for (DictPair pair : pairs) {
            keyTxts.add(ExprCodeGenerator.gencodeExpr(pair.getKey(), ctxt, state));
            valueTxts.add(ExprCodeGenerator.gencodeExpr(pair.getValue(), ctxt, state));
        }
        String keysTxt = Strings.fmt((String)"array(%s)", (Object[])new Object[]{StringUtils.join((Iterable)keyTxts, (String)", ")});
        String valuesTxt = Strings.fmt((String)"array(%s)", (Object[])new Object[]{StringUtils.join((Iterable)valueTxts, (String)", ")});
        return Strings.fmt((String)"addpairs(%s, %s, %s)", (Object[])new Object[]{rslt, keysTxt, valuesTxt});
    }

    private static String gencodeDiscVarExpr(DiscVariableExpression expr, CifCompilerContext ctxt, String state) {
        DiscVariable var = expr.getVariable();
        EObject parent = var.eContainer();
        if (parent instanceof ComplexComponent) {
            return Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, ctxt.getAutSubStateFieldName((Automaton)parent), ctxt.getDiscVarFieldName(var)});
        }
        if (parent instanceof FunctionParameter) {
            return ctxt.getFuncParamMethodParamName(var);
        }
        if (parent instanceof InternalFunction) {
            return ctxt.getFuncLocalVarName(var);
        }
        throw new RuntimeException("Unknown disc var parent: " + parent);
    }

    private static String gencodeInputVarExpr(InputVariableExpression expr, CifCompilerContext ctxt, String state) {
        InputVariable var = expr.getVariable();
        return Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, "i", ctxt.getInputVarFieldName(var)});
    }

    private static String gencodeContVarExpr(ContVariableExpression expr, CifCompilerContext ctxt, String state) {
        ContVariable var = expr.getVariable();
        if (expr.isDerivative()) {
            return Strings.fmt((String)"Derivatives.%s(%s)", (Object[])new Object[]{ctxt.getDerivativeMethodName(var), state});
        }
        return Strings.fmt((String)"%s.%s.%s", (Object[])new Object[]{state, ctxt.getContVarSubStateName(var), ctxt.getContVarFieldName(var)});
    }

    private static String gencodeLocExpr(LocationExpression expr, CifCompilerContext ctxt, String state) {
        Location loc = expr.getLocation();
        Automaton aut = (Automaton)loc.eContainer();
        return Strings.fmt((String)"%s.%s.%s == %s", (Object[])new Object[]{state, ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut), ctxt.getLocationValueText(loc)});
    }
}

