/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class CifSpecInitOption
extends Option<List<String>> {
    public CifSpecInitOption() {
        super("CIF specification initialization", "Specify an initial value for a single discrete variable or input variable (\"var:value\", with \"var\" the absolute name of the variable and \"value\" a CIF literal), or an initial location for a single automaton (\"aut:loc\", with \"aut\" the absolute name of the automaton and \"loc\" a name of one of its locations).", null, "init", "INIT", true);
    }

    public static List<String> getInits() {
        return (List)Options.get(CifSpecInitOption.class);
    }

    public List<String> getDefault() {
        return Lists.list();
    }

    public List<String> parseValue(String optName, String value) {
        return Lists.concat(CifSpecInitOption.getInits(), (Object)value);
    }

    public String[] getCmdLine(Object value) {
        List inits = (List)value;
        String[] rslt = new String[inits.size()];
        int i = 0;
        while (i < rslt.length) {
            rslt[i] = "--init=" + (String)inits.get(i);
            ++i;
        }
        return rslt;
    }

    public OptionGroup<List<String>> createOptionGroup(Composite page) {
        return new OptionGroup<List<String>>(page, Options.getInstance(CifSpecInitOption.class)){
            Text initText;

            protected void addComponents(Group group) {
                this.initText = new Text((Composite)group, 2818);
                FormData grpData = new FormData();
                grpData.left = new FormAttachment(0, 0);
                grpData.right = new FormAttachment(100, 0);
                grpData.top = new FormAttachment((Control)this.descrLabel, 0);
                grpData.bottom = new FormAttachment((Control)this.initText, 100);
                this.initText.setLayoutData((Object)grpData);
            }

            public String getDescription() {
                return "The initializations, one per line. Each line specifies an initial value for a single discrete variable or input variable (\"var:value\", with \"var\" the absolute name of the variable and \"value\" a CIF literal), or an initial location for a single automaton (\"aut:loc\", with \"aut\" the absolute name of the automaton and \"loc\" a name of one of its locations).";
            }

            public void setToValue(List<String> value) {
                Object[] inits = value.toArray(new String[0]);
                this.initText.setText(StringUtils.join((Object[])inits, (String)Strings.NL));
            }

            public String[] getCmdLine() {
                String txt = this.initText.getText().replace("\r", "");
                List inits = Lists.list();
                String[] stringArray = txt.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String init = stringArray[n2];
                    if (!init.isEmpty()) {
                        inits.add("--init=" + init);
                    }
                    ++n2;
                }
                return inits.toArray(new String[0]);
            }
        };
    }
}

