/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.parser.ast.ACompInstDecl;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CompInstScope
extends SymbolScope<ComponentInst> {
    private static final ExprContext EVT_REF_CTXT = ExprContext.DEFAULT_CTXT.add(ExprContext.Condition.ALLOW_EVENT);
    private final ACompInstDecl compInstDecl;
    private ParentScope<?> compDefScope;

    public CompInstScope(ComponentInst obj, ACompInstDecl compInstDecl, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        this.compInstDecl = compInstDecl;
    }

    public ParentScope<?> getCompDefScope() {
        Assert.notNull(this.compDefScope);
        return this.compDefScope;
    }

    @Override
    protected boolean isSubScope() {
        return true;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }

    @Override
    public String getName() {
        return ((ComponentInst)this.obj).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.obj);
    }

    @Override
    public String getAbsText() {
        this.tcheckForUse();
        if (this.compDefScope instanceof AutDefScope) {
            return Strings.fmt((String)"automaton \"%s\"", (Object[])new Object[]{this.getAbsName()});
        }
        if (this.compDefScope instanceof GroupDefScope) {
            return Strings.fmt((String)"group \"%s\"", (Object[])new Object[]{this.getAbsName()});
        }
        throw new RuntimeException("Unknown comp def: " + this.compDefScope);
    }

    public Box toBox() {
        return new TextBox(Strings.fmt((String)"[ compinst scope \"%s\" for: %s ]", (Object[])new Object[]{this.getName(), this.obj}));
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            AName compDefRef = this.compInstDecl.defName;
            SymbolTableEntry entry = this.parent.resolve(compDefRef.position, compDefRef.name, this.tchecker, this.parent);
            if (!(entry instanceof AutDefScope) && !(entry instanceof GroupDefScope)) {
                this.tchecker.addProblem(ErrMsg.RESOLVE_NOT_COMP_DEF, compDefRef.position, entry.getAbsName());
                throw new SemanticException();
            }
            this.compDefScope = (ParentScope)entry;
            CifType compdef = this.parent.resolveAsType(compDefRef.name, compDefRef.position, "", this.tchecker);
            ((ComponentInst)this.obj).setDefinition(compdef);
            if (!(compdef instanceof ComponentDefType)) {
                this.tchecker.addProblem(ErrMsg.COMP_INST_DEF_NOT_IN_SCOPE, compDefRef.position, this.compDefScope.getAbsName());
                throw new SemanticException();
            }
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        if (this.compDefScope instanceof AutDefScope) {
            ((AutDefScope)this.compDefScope).tcheckFullParams();
        } else if (this.compDefScope instanceof GroupDefScope) {
            ((GroupDefScope)this.compDefScope).tcheckFullParams();
        } else {
            String msg = "Unknown component def scope: " + this.compDefScope;
            throw new RuntimeException(msg);
        }
        ComponentDef compDef = (ComponentDef)this.compDefScope.obj;
        int paramCountInst = this.compInstDecl.parameters.size();
        int paramCountDef = compDef.getParameters().size();
        if (paramCountInst != paramCountDef) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_COUNT, ((ComponentInst)this.obj).getPosition(), String.valueOf(paramCountInst), this.getAbsName(), String.valueOf(paramCountDef), CifTextUtils.getAbsName((PositionObject)compDef));
            throw new SemanticException();
        }
        EList params = ((ComponentInst)this.obj).getParameters();
        int i = 0;
        while (i < paramCountInst) {
            Expression unwrap;
            CifType actualType;
            CifType formalType;
            CifType paramHint;
            String paramIdxTxt = Numbers.toOrdinal((int)(i + 1));
            Parameter formal = (Parameter)compDef.getParameters().get(i);
            if (formal instanceof AlgParameter) {
                paramHint = ((AlgParameter)formal).getVariable().getType();
            } else if (formal instanceof EventParameter) {
                paramHint = CifExprsTypeChecker.BOOL_TYPE_HINT;
            } else if (formal instanceof LocationParameter) {
                paramHint = CifExprsTypeChecker.BOOL_TYPE_HINT;
            } else if (formal instanceof ComponentParameter) {
                paramHint = ((ComponentParameter)formal).getType();
            } else {
                throw new RuntimeException("Unknown formal param: " + formal);
            }
            ExprContext context = formal instanceof EventParameter ? EVT_REF_CTXT : ExprContext.DEFAULT_CTXT;
            AExpression param = (AExpression)this.compInstDecl.parameters.get(i);
            Expression actual = CifExprsTypeChecker.transExpression(param, paramHint, this.parent, context, this.tchecker);
            params.add(actual);
            if (formal instanceof AlgParameter) {
                formalType = ((AlgParameter)formal).getVariable().getType();
                if (!CifTypeUtils.checkTypeCompat((CifType)formalType, (CifType)(actualType = actual.getType()), (RangeCompat)RangeCompat.CONTAINED)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_ALG_TYPES, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), CifTextUtils.typeToStr((CifType)formalType), CifTextUtils.typeToStr((CifType)actualType));
                }
            } else if (formal instanceof EventParameter) {
                unwrap = CifTypeUtils.unwrapExpression((Expression)actual);
                if (!(unwrap instanceof EventExpression)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_TYPE, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), "event");
                    throw new SemanticException();
                }
                Event formalEvent = ((EventParameter)formal).getEvent();
                Event actualEvent = ((EventExpression)unwrap).getEvent();
                Boolean formalContr = formalEvent.getControllable();
                Boolean actualContr = actualEvent.getControllable();
                if (formalContr != null && !formalContr.equals(actualContr)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_CONTR_MISMATCH, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), CompInstScope.controllableToStr(formalContr), CompInstScope.controllableToStr(actualContr));
                }
                CifType formalType2 = formalEvent.getType();
                CifType actualType2 = actualEvent.getType();
                if (formalType2 != null && actualType2 == null) {
                    String formalTxt = Strings.fmt((String)"is of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)formalType2)});
                    String actualTxt = "has no type";
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_EVENT_TYPES, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), formalTxt, actualTxt);
                }
                if (formalType2 != null && actualType2 != null && !CifTypeUtils.checkTypeCompat((CifType)formalEvent.getType(), (CifType)actualEvent.getType(), (RangeCompat)RangeCompat.EQUAL)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_EVENT_TYPES, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), Strings.fmt((String)"is of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)formalType2)}), Strings.fmt((String)"is of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)actualType2)}));
                }
                EventParameter formalParam = (EventParameter)formal;
                EventParameter actualParam = null;
                if (actualEvent.eContainer() instanceof EventParameter) {
                    actualParam = (EventParameter)actualEvent.eContainer();
                }
                if (actualParam != null) {
                    this.checkEventUsage(formalParam, actualParam, param.position, paramIdxTxt, compDef);
                }
            } else if (formal instanceof LocationParameter) {
                unwrap = CifTypeUtils.unwrapExpression((Expression)actual);
                if (!(unwrap instanceof LocationExpression)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_TYPE, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), "location");
                }
            } else if (formal instanceof ComponentParameter) {
                formalType = ((ComponentParameter)formal).getType();
                if (!CifTypeUtils.checkTypeCompat((CifType)formalType, (CifType)(actualType = actual.getType()), null)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_COMP_TYPES, actual.getPosition(), paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), CifTextUtils.typeToStr((CifType)formalType), CifTextUtils.typeToStr((CifType)actualType));
                }
            } else {
                throw new RuntimeException("Unknown formal param: " + formal);
            }
            ++i;
        }
        this.status = CheckStatus.FULL;
    }

    private void checkEventUsage(EventParameter formal, EventParameter actual, Position position, String paramIdxTxt, ComponentDef compDef) {
        boolean formalSend = CifEventUtils.eventParamSupportsSend((EventParameter)formal);
        boolean formalRecv = CifEventUtils.eventParamSupportsRecv((EventParameter)formal);
        boolean formalSync = CifEventUtils.eventParamSupportsSync((EventParameter)formal);
        boolean actualSend = CifEventUtils.eventParamSupportsSend((EventParameter)actual);
        boolean actualRecv = CifEventUtils.eventParamSupportsRecv((EventParameter)actual);
        boolean actualSync = CifEventUtils.eventParamSupportsSync((EventParameter)actual);
        if (formalSend && !actualSend) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), "send (!)");
        }
        if (formalRecv && !actualRecv) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), "receive (?)");
        }
        if (formalSync && !actualSync) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_PARAM_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.getAbsName((PositionObject)compDef), "synchronization (~)");
        }
    }

    public static String controllableToStr(Boolean controllable) {
        return controllable == null ? "(unspecified)" : (controllable != false ? "controllable" : "uncontrollable");
    }

    @Override
    protected SymbolTableEntry resolve1(Position position, String id, String done, CifTypeChecker tchecker, SymbolScope<?> origScope) {
        this.tcheckForUse();
        if (done.isEmpty()) {
            throw new IllegalArgumentException("done");
        }
        if (origScope != null) {
            throw new IllegalArgumentException("origScope");
        }
        return this.compDefScope.resolve1(position, id, done, tchecker, origScope);
    }

    @Override
    public void detectCompDefInstCycles(List<ParentScope<?>> cycle) {
        this.compDefScope.detectCompDefInstCycles(cycle);
    }
}

