/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.escet.common.app.framework.javacompiler.JavaClassFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.JavaInputFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.OsgiClassFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeClassLoader;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;

public class RuntimeJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final RuntimeClassLoader classLoader;
    private final Map<String, JavaInputFileObject> sources;

    public RuntimeJavaFileManager(JavaFileManager fileManager, ClassLoader classLoader) {
        super(fileManager);
        this.classLoader = new RuntimeClassLoader(classLoader);
        this.sources = Maps.map();
    }

    public void addSourceFile(String absClassName, JavaInputFileObject source) {
        absClassName = RuntimeJavaFileManager.normalizeName(absClassName);
        this.sources.put(absClassName, source);
    }

    public RuntimeClassLoader getClassLoader() {
        return this.getClassLoader(null);
    }

    @Override
    public RuntimeClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        if (location == StandardLocation.SOURCE_PATH) {
            return true;
        }
        if (location == StandardLocation.CLASS_PATH) {
            return true;
        }
        if (location == StandardLocation.CLASS_OUTPUT) {
            return true;
        }
        return super.hasLocation(location);
    }

    @Override
    public boolean isSameFile(FileObject f1, FileObject f2) {
        if (f1 instanceof JavaInputFileObject) {
            return f1.equals(f2);
        }
        if (f1 instanceof JavaClassFileObject) {
            return f1.equals(f2);
        }
        if (f1 instanceof OsgiClassFileObject) {
            return f1.equals(f2);
        }
        return super.isSameFile(f1, f2);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        ClassLoader dependencyLoader;
        String normalizedClassName;
        if (location == StandardLocation.SOURCE_PATH && kind == JavaFileObject.Kind.SOURCE) {
            normalizedClassName = RuntimeJavaFileManager.normalizeName(className);
            for (JavaInputFileObject javaInputFileObject : this.sources.values()) {
                if (javaInputFileObject.getKind() != JavaFileObject.Kind.SOURCE || !javaInputFileObject.absClassName.equals(normalizedClassName)) continue;
                return javaInputFileObject;
            }
        }
        if (location == StandardLocation.CLASS_PATH && kind == JavaFileObject.Kind.CLASS) {
            normalizedClassName = RuntimeJavaFileManager.normalizeName(className);
            for (JavaClassFileObject javaClassFileObject : this.classLoader.generatedClasses.values()) {
                if (javaClassFileObject.getKind() != JavaFileObject.Kind.CLASS || !javaClassFileObject.absClassName.equals(normalizedClassName)) continue;
                return javaClassFileObject;
            }
        }
        if (location == StandardLocation.CLASS_PATH && kind == JavaFileObject.Kind.CLASS && (dependencyLoader = this.classLoader.getParent()) != null && dependencyLoader instanceof BundleReference) {
            String string = RuntimeJavaFileManager.normalizeName(className);
            String pkgName = this.getPackageName(string);
            String resPkgName = pkgName.replace('.', '/');
            String resName = String.valueOf(this.getClassName(string)) + ".class";
            BundleReference ref = (BundleReference)dependencyLoader;
            Bundle bundle = ref.getBundle();
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            Collection resources = wiring.listResources(resPkgName, resName, 0);
            if (!resources.isEmpty()) {
                URI uri;
                Assert.check((resources.size() == 1 ? 1 : 0) != 0);
                String resource = (String)resources.iterator().next();
                try {
                    uri = dependencyLoader.getResource(resource).toURI();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                return new OsgiClassFileObject(string, uri, dependencyLoader);
            }
        }
        if (super.hasLocation(location)) {
            return super.getJavaFileForInput(location, className, kind);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && kind == JavaFileObject.Kind.CLASS) {
            className = RuntimeJavaFileManager.normalizeName(className);
            JavaClassFileObject rslt = new JavaClassFileObject(className);
            this.classLoader.add(className, rslt);
            return rslt;
        }
        if (super.hasLocation(location)) {
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        String rslt;
        if (file instanceof JavaInputFileObject) {
            rslt = ((JavaInputFileObject)file).absClassName;
        } else if (file instanceof JavaClassFileObject) {
            rslt = ((JavaClassFileObject)file).absClassName;
        } else if (file instanceof OsgiClassFileObject) {
            rslt = ((OsgiClassFileObject)file).absClassName;
        } else if (super.hasLocation(location)) {
            rslt = super.inferBinaryName(location, file);
        } else {
            return null;
        }
        return rslt;
    }

    public String getAbsClassname(JavaFileObject file) {
        if (file instanceof JavaInputFileObject) {
            return ((JavaInputFileObject)file).absClassName;
        }
        if (file instanceof JavaClassFileObject) {
            return ((JavaClassFileObject)file).absClassName;
        }
        if (file instanceof OsgiClassFileObject) {
            return ((OsgiClassFileObject)file).absClassName;
        }
        String name = file.getName();
        Assert.check((!name.contains("/") || !name.contains(".") ? 1 : 0) != 0);
        return file.getName().replace('/', '.');
    }

    public String getPackageName(JavaFileObject file) {
        String absClassName = this.getAbsClassname(file);
        return this.getPackageName(absClassName);
    }

    public String getPackageName(String absClassName) {
        int idx = absClassName.lastIndexOf(46);
        String pkgName = idx == -1 ? "" : absClassName.substring(0, idx);
        return pkgName;
    }

    public String getClassName(String absClassName) {
        int idx = absClassName.lastIndexOf(46);
        return idx == -1 ? absClassName : absClassName.substring(idx + 1);
    }

    public boolean inPackage(JavaFileObject file, String packageName, boolean recursive) {
        String filePkgName = this.getPackageName(file);
        if (filePkgName.equals(packageName)) {
            return true;
        }
        if (!recursive) {
            return false;
        }
        return filePkgName.startsWith(String.valueOf(packageName) + ".");
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ClassLoader classLoader;
        String normalizedPkgName = RuntimeJavaFileManager.normalizeName(packageName);
        List rslt = Lists.list();
        if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaInputFileObject javaInputFileObject : this.sources.values()) {
                if (javaInputFileObject.getKind() != JavaFileObject.Kind.SOURCE || !this.inPackage(javaInputFileObject, normalizedPkgName, recurse)) continue;
                rslt.add(javaInputFileObject);
            }
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaClassFileObject javaClassFileObject : this.classLoader.generatedClasses.values()) {
                if (javaClassFileObject.getKind() != JavaFileObject.Kind.CLASS || !this.inPackage(javaClassFileObject, normalizedPkgName, recurse)) continue;
                rslt.add(javaClassFileObject);
            }
        }
        if (super.hasLocation(location)) {
            Iterable<JavaFileObject> iterable = super.list(location, packageName, kinds, recurse);
            for (JavaFileObject file : iterable) {
                rslt.add(file);
            }
        }
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS) && (classLoader = this.classLoader.getParent()) != null && classLoader instanceof BundleReference) {
            String resourcePkgName = normalizedPkgName.replace('.', '/');
            BundleReference ref = (BundleReference)classLoader;
            Bundle bundle = ref.getBundle();
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            Collection resources = wiring.listResources(resourcePkgName, "*.class", recurse ? 1 : 0);
            for (String resource : resources) {
                URI uri;
                Assert.check((boolean)resource.endsWith(".class"));
                int extLength = JavaFileObject.Kind.CLASS.extension.length();
                String absClassName = resource.substring(0, resource.length() - extLength).replace('/', '.');
                try {
                    uri = classLoader.getResource(resource).toURI();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                OsgiClassFileObject file = new OsgiClassFileObject(absClassName, uri, classLoader);
                rslt.add(file);
            }
        }
        return rslt;
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fileObject) throws IOException {
        if (location == StandardLocation.SOURCE_PATH) {
            for (JavaInputFileObject javaInputFileObject : this.sources.values()) {
                if (!this.isSameFile(javaInputFileObject, fileObject)) continue;
                return true;
            }
        }
        if (location == StandardLocation.CLASS_PATH) {
            for (JavaClassFileObject javaClassFileObject : this.classLoader.generatedClasses.values()) {
                if (!this.isSameFile(javaClassFileObject, fileObject)) continue;
                return true;
            }
        }
        return super.contains(location, fileObject);
    }

    public static String normalizeName(String name) {
        Assert.check((!name.contains("\\") ? 1 : 0) != 0);
        Assert.check((!name.contains("/") || !name.contains(".") ? 1 : 0) != 0);
        String rslt = name.replace("/", ".");
        return rslt;
    }
}

