/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.common;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.tooldef.common.Associativity;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.tooldef.JavaTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolParameter;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.BoolExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.CastExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.DoubleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.Expression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ListExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapEntry;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.MapExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NullExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.NumberExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ProjectionExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SetExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.SliceExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.StringExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolArgument;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolInvokeExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolParamExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.ToolRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.TupleExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.expressions.VariableExpression;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeRef;

public class ToolDefTextUtils {
    private ToolDefTextUtils() {
    }

    public static boolean isNamedObj(PositionObject obj, boolean allowImplicit) {
        if (obj instanceof Script) {
            return ((Script)obj).getName() != null;
        }
        if (obj instanceof Tool) {
            return true;
        }
        if (obj instanceof ToolParameter) {
            return true;
        }
        if (obj instanceof TypeDecl) {
            return true;
        }
        if (obj instanceof TypeParam) {
            return true;
        }
        if (obj instanceof Variable) {
            return true;
        }
        if (obj instanceof Script) {
            return allowImplicit;
        }
        if (obj instanceof ForStatement) {
            return allowImplicit;
        }
        if (obj instanceof IfStatement) {
            return allowImplicit;
        }
        if (obj instanceof WhileStatement) {
            return allowImplicit;
        }
        return false;
    }

    public static String getName(PositionObject obj) {
        if (obj instanceof Script) {
            String name = ((Script)obj).getName();
            Assert.notNull((Object)name);
            return name;
        }
        if (obj instanceof Tool) {
            return ((Tool)obj).getName();
        }
        if (obj instanceof ToolParameter) {
            return ((ToolParameter)obj).getName();
        }
        if (obj instanceof TypeDecl) {
            return ((TypeDecl)obj).getName();
        }
        if (obj instanceof TypeParam) {
            return ((TypeParam)obj).getName();
        }
        if (obj instanceof Variable) {
            return ((Variable)obj).getName();
        }
        if (obj instanceof Script) {
            return "(script)";
        }
        if (obj instanceof ForStatement) {
            return "(for)";
        }
        if (obj instanceof IfStatement) {
            return "(if)";
        }
        if (obj instanceof WhileStatement) {
            return "(while)";
        }
        throw new RuntimeException("Unexpected obj: " + obj);
    }

    public static String getAbsName(PositionObject obj) {
        String name = ToolDefTextUtils.getName(obj);
        PositionObject ancestor = (PositionObject)obj.eContainer();
        while (!(ancestor instanceof Script) || ((Script)ancestor).getName() != null) {
            if (ToolDefTextUtils.isNamedObj(ancestor, true)) {
                String ancestorName = ToolDefTextUtils.getName(ancestor);
                name = String.valueOf(ancestorName) + "." + name;
            }
            ancestor = (PositionObject)ancestor.eContainer();
        }
        return name;
    }

    public static String getDescr(PositionObject obj) {
        if (ToolDefTextUtils.isNamedObj(obj, false)) {
            return Strings.fmt((String)"%s \"%s\"", (Object[])new Object[]{ToolDefTextUtils.getKindText(obj), ToolDefTextUtils.getName(obj)});
        }
        if (obj.eContainer() == null) {
            Assert.check((boolean)(obj instanceof Script));
            Assert.check((((Script)obj).getName() == null ? 1 : 0) != 0);
            return "the top level scope of the script";
        }
        return ToolDefTextUtils.getKindText(obj);
    }

    public static String getAbsDescr(PositionObject obj) {
        if (ToolDefTextUtils.isNamedObj(obj, false)) {
            return Strings.fmt((String)"%s \"%s\"", (Object[])new Object[]{ToolDefTextUtils.getKindText(obj), ToolDefTextUtils.getAbsName(obj)});
        }
        if (obj.eContainer() == null) {
            Assert.check((boolean)(obj instanceof Script));
            Assert.check((((Script)obj).getName() == null ? 1 : 0) != 0);
            return "the top level scope of the script";
        }
        return ToolDefTextUtils.getKindText(obj);
    }

    public static String getAbsDescr(ToolRef toolRef) {
        Tool tool = toolRef.getTool();
        if (tool instanceof JavaTool) {
            return Strings.fmt((String)"Java method \"%s\"", (Object[])new Object[]{((JavaTool)tool).getMethodName()});
        }
        return Strings.fmt((String)"%s%s \"%s\"", (Object[])new Object[]{toolRef.isBuiltin() ? "built-in " : "", ToolDefTextUtils.getKindText((PositionObject)tool), ToolDefTextUtils.getAbsName((PositionObject)tool)});
    }

    public static String getKindText(PositionObject obj) {
        if (obj instanceof Script) {
            if (((Script)obj).getName() == null) {
                return "script";
            }
            return "imported script";
        }
        if (obj instanceof Tool) {
            return "tool";
        }
        if (obj instanceof ToolParameter) {
            return "tool parameter";
        }
        if (obj instanceof TypeDecl) {
            return "type declaration";
        }
        if (obj instanceof TypeParam) {
            return "type parameter";
        }
        if (obj instanceof Variable) {
            return "variable";
        }
        if (obj instanceof ForStatement) {
            return "for statement";
        }
        if (obj instanceof IfStatement) {
            return "if statement";
        }
        if (obj instanceof WhileStatement) {
            return "while statement";
        }
        throw new RuntimeException("Unexpected obj: " + obj);
    }

    public static Associativity getAssociativity(String op) {
        switch (op) {
            case "+": {
                return Associativity.LEFT;
            }
            case "and": {
                return Associativity.LEFT;
            }
            case "or": {
                return Associativity.LEFT;
            }
            case "/": {
                return Associativity.LEFT;
            }
            case "==": {
                return Associativity.LEFT;
            }
            case ">=": {
                return Associativity.LEFT;
            }
            case ">": {
                return Associativity.LEFT;
            }
            case "div": {
                return Associativity.LEFT;
            }
            case "<=": {
                return Associativity.LEFT;
            }
            case "<": {
                return Associativity.LEFT;
            }
            case "mod": {
                return Associativity.LEFT;
            }
            case "*": {
                return Associativity.LEFT;
            }
            case "-": {
                return Associativity.LEFT;
            }
            case "!=": {
                return Associativity.LEFT;
            }
        }
        throw new RuntimeException("Unknown binop: " + op);
    }

    public static int getBindingStrength(Expression expr) {
        block57: {
            String name;
            ToolInvokeExpression invoke;
            ToolRef tool;
            if (!(expr instanceof ToolInvokeExpression) || !(tool = (invoke = (ToolInvokeExpression)expr).getTool()).isBuiltin()) break block57;
            switch (name = invoke.getTool().getName()) {
                case "or": {
                    return 0;
                }
                case "and": {
                    return 1;
                }
                case "<": 
                case ">": 
                case "!=": 
                case "<=": 
                case "==": 
                case ">=": {
                    return 2;
                }
                case "*": 
                case "/": 
                case "div": 
                case "mod": {
                    return 4;
                }
                case "not": {
                    return 5;
                }
                case "+": 
                case "-": {
                    int argCnt = invoke.getArguments().size();
                    if (argCnt == 2) {
                        return 3;
                    }
                    if (argCnt == 1) {
                        return 5;
                    }
                    throw new RuntimeException("arg count: " + argCnt);
                }
            }
        }
        if (expr instanceof ProjectionExpression) {
            return 6;
        }
        if (expr instanceof SliceExpression) {
            return 6;
        }
        if (expr instanceof BoolExpression) {
            return 7;
        }
        if (expr instanceof NumberExpression) {
            return 7;
        }
        if (expr instanceof DoubleExpression) {
            return 7;
        }
        if (expr instanceof NullExpression) {
            return 7;
        }
        if (expr instanceof StringExpression) {
            return 7;
        }
        if (expr instanceof CastExpression) {
            return 7;
        }
        if (expr instanceof ListExpression) {
            return 7;
        }
        if (expr instanceof SetExpression) {
            return 7;
        }
        if (expr instanceof MapExpression) {
            return 7;
        }
        if (expr instanceof TupleExpression) {
            return 7;
        }
        if (expr instanceof ToolInvokeExpression) {
            return 7;
        }
        if (expr instanceof ToolParamExpression) {
            return 7;
        }
        if (expr instanceof VariableExpression) {
            return 7;
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static String exprsToStr(List<Expression> exprs) {
        List txts = Lists.listc((int)exprs.size());
        for (Expression expr : exprs) {
            txts.add(ToolDefTextUtils.exprToStr(expr));
        }
        return StringUtils.join((Collection)txts, (String)", ");
    }

    public static String exprToStr(Expression expr) {
        block72: {
            ToolRef tool;
            ToolInvokeExpression invoke;
            block73: {
                if (expr instanceof BoolExpression) {
                    BoolExpression bexpr = (BoolExpression)expr;
                    return bexpr.isValue() ? "true" : "false";
                }
                if (expr instanceof CastExpression) {
                    int childStrength;
                    CastExpression cexpr = (CastExpression)expr;
                    String childTxt = ToolDefTextUtils.exprToStr(cexpr.getChild());
                    int castStrength = ToolDefTextUtils.getBindingStrength(expr);
                    if (castStrength > (childStrength = ToolDefTextUtils.getBindingStrength(cexpr.getChild()))) {
                        childTxt = "(" + childTxt + ")";
                    }
                    return "<" + ToolDefTextUtils.typeToStr(cexpr.getType()) + ">" + childTxt;
                }
                if (expr instanceof DoubleExpression) {
                    DoubleExpression dexpr = (DoubleExpression)expr;
                    return dexpr.getValue();
                }
                if (expr instanceof ListExpression) {
                    ListExpression lexpr = (ListExpression)expr;
                    return "[" + ToolDefTextUtils.exprsToStr((List<Expression>)lexpr.getElements()) + "]";
                }
                if (expr instanceof MapExpression) {
                    MapExpression mexpr = (MapExpression)expr;
                    StringBuilder txt = new StringBuilder();
                    txt.append("{");
                    boolean first = true;
                    for (MapEntry entry : mexpr.getEntries()) {
                        if (first) {
                            first = false;
                        } else {
                            txt.append(", ");
                        }
                        txt.append(ToolDefTextUtils.exprToStr(entry.getKey()));
                        txt.append(": ");
                        txt.append(ToolDefTextUtils.exprToStr(entry.getValue()));
                    }
                    txt.append("}");
                    return txt.toString();
                }
                if (expr instanceof NullExpression) {
                    return "null";
                }
                if (expr instanceof NumberExpression) {
                    NumberExpression dexpr = (NumberExpression)expr;
                    return dexpr.getValue();
                }
                if (expr instanceof ProjectionExpression) {
                    int childStrength;
                    ProjectionExpression pexpr = (ProjectionExpression)expr;
                    String childTxt = ToolDefTextUtils.exprToStr(pexpr.getChild());
                    int projStrength = ToolDefTextUtils.getBindingStrength(expr);
                    if (projStrength > (childStrength = ToolDefTextUtils.getBindingStrength(pexpr.getChild()))) {
                        childTxt = "(" + childTxt + ")";
                    }
                    return String.valueOf(childTxt) + "[" + ToolDefTextUtils.exprToStr(pexpr.getIndex()) + "]";
                }
                if (expr instanceof SetExpression) {
                    SetExpression sexpr = (SetExpression)expr;
                    return "{" + ToolDefTextUtils.exprsToStr((List<Expression>)sexpr.getElements()) + "}";
                }
                if (expr instanceof SliceExpression) {
                    int childStrength;
                    SliceExpression sexpr = (SliceExpression)expr;
                    String childTxt = ToolDefTextUtils.exprToStr(sexpr.getChild());
                    int sliceStrength = ToolDefTextUtils.getBindingStrength(expr);
                    if (sliceStrength > (childStrength = ToolDefTextUtils.getBindingStrength(sexpr.getChild()))) {
                        childTxt = "(" + childTxt + ")";
                    }
                    StringBuilder txt = new StringBuilder();
                    txt.append(childTxt);
                    txt.append("[");
                    if (sexpr.getBegin() != null) {
                        txt.append(ToolDefTextUtils.exprToStr(sexpr.getBegin()));
                    }
                    txt.append(":");
                    if (sexpr.getEnd() != null) {
                        txt.append(ToolDefTextUtils.exprToStr(sexpr.getEnd()));
                    }
                    txt.append("]");
                    return txt.toString();
                }
                if (expr instanceof StringExpression) {
                    StringExpression sexpr = (StringExpression)expr;
                    return "\"" + Strings.escape((String)sexpr.getValue()) + "\"";
                }
                if (!(expr instanceof ToolInvokeExpression)) break block72;
                invoke = (ToolInvokeExpression)expr;
                tool = invoke.getTool();
                if (!tool.isBuiltin()) break block73;
                String name = invoke.getTool().getName();
                boolean binop = false;
                boolean unop = false;
                switch (name) {
                    case "*": 
                    case "/": 
                    case "<": 
                    case ">": 
                    case "!=": 
                    case "<=": 
                    case "==": 
                    case ">=": 
                    case "or": 
                    case "and": 
                    case "div": 
                    case "mod": {
                        binop = true;
                        break;
                    }
                    case "not": {
                        unop = true;
                        break;
                    }
                    case "+": 
                    case "-": {
                        int argCnt = invoke.getArguments().size();
                        if (argCnt == 1) {
                            unop = true;
                        }
                        if (argCnt != 2) break;
                        binop = true;
                    }
                }
                if (unop) {
                    int childStrength;
                    Expression child = ((ToolArgument)invoke.getArguments().get(0)).getValue();
                    String childTxt = ToolDefTextUtils.exprToStr(child);
                    int opStrength = ToolDefTextUtils.getBindingStrength(expr);
                    if (opStrength > (childStrength = ToolDefTextUtils.getBindingStrength(child))) {
                        childTxt = "(" + childTxt + ")";
                    } else if (StringUtils.isAlpha((String)StringUtils.right((String)name, (int)1))) {
                        name = String.valueOf(name) + " ";
                    }
                    return String.valueOf(name) + childTxt;
                }
                if (binop) {
                    Expression left = ((ToolArgument)invoke.getArguments().get(0)).getValue();
                    Expression right = ((ToolArgument)invoke.getArguments().get(1)).getValue();
                    int opStrength = ToolDefTextUtils.getBindingStrength(expr);
                    int leftStrength = ToolDefTextUtils.getBindingStrength(left);
                    int rightStrength = ToolDefTextUtils.getBindingStrength(right);
                    String leftTxt = ToolDefTextUtils.exprToStr(left);
                    if (opStrength > leftStrength || opStrength == leftStrength && ToolDefTextUtils.getAssociativity(name) != Associativity.LEFT) {
                        leftTxt = "(" + leftTxt + ")";
                    }
                    String rightTxt = ToolDefTextUtils.exprToStr(right);
                    if (opStrength > rightStrength || opStrength == rightStrength && ToolDefTextUtils.getAssociativity(name) != Associativity.RIGHT) {
                        rightTxt = "(" + rightTxt + ")";
                    }
                    return String.valueOf(leftTxt) + " " + name + " " + rightTxt;
                }
            }
            StringBuilder txt = new StringBuilder();
            if (tool.isBuiltin()) {
                txt.append(tool.getName());
            } else {
                txt.append(ToolDefTextUtils.getAbsName((PositionObject)tool.getTool()));
            }
            txt.append("(");
            int i = 0;
            while (i < invoke.getArguments().size()) {
                ToolArgument arg;
                if (i > 0) {
                    txt.append(", ");
                }
                if ((arg = (ToolArgument)invoke.getArguments().get(i)).getName() != null) {
                    txt.append(arg.getName());
                    txt.append("=");
                }
                txt.append(ToolDefTextUtils.exprToStr(arg.getValue()));
                ++i;
            }
            txt.append(")");
            return txt.toString();
        }
        if (expr instanceof ToolParamExpression) {
            ToolParamExpression tpexpr = (ToolParamExpression)expr;
            return ToolDefTextUtils.getAbsName((PositionObject)tpexpr.getParam());
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            return "(" + ToolDefTextUtils.exprsToStr((List<Expression>)texpr.getElements()) + ")";
        }
        if (expr instanceof VariableExpression) {
            VariableExpression vexpr = (VariableExpression)expr;
            return ToolDefTextUtils.getAbsName((PositionObject)vexpr.getVariable());
        }
        throw new RuntimeException("Unknown/unsupported expr: " + expr);
    }

    public static String typeToStr(ToolDefType type) {
        return ToolDefTextUtils.typeToStr(type, true);
    }

    public static String typeToStr(ToolDefType type, boolean normalize) {
        if (normalize) {
            type = ToolDefTypeUtils.normalizeType(type);
        }
        if (type instanceof BoolType) {
            return type.isNullable() ? "bool?" : "bool";
        }
        if (type instanceof DoubleType) {
            return type.isNullable() ? "double?" : "double";
        }
        if (type instanceof IntType) {
            return type.isNullable() ? "int?" : "int";
        }
        if (type instanceof LongType) {
            return type.isNullable() ? "long?" : "long";
        }
        if (type instanceof ObjectType) {
            return type.isNullable() ? "object?" : "object";
        }
        if (type instanceof StringType) {
            return type.isNullable() ? "string?" : "string";
        }
        if (type instanceof ListType) {
            String rslt = type.isNullable() ? "list? " : "list ";
            ListType ltype = (ListType)type;
            return String.valueOf(rslt) + ToolDefTextUtils.typeToStr(ltype.getElemType(), normalize);
        }
        if (type instanceof SetType) {
            String rslt = type.isNullable() ? "set? " : "set ";
            SetType stype = (SetType)type;
            return String.valueOf(rslt) + ToolDefTextUtils.typeToStr(stype.getElemType(), normalize);
        }
        if (type instanceof MapType) {
            String rslt = type.isNullable() ? "map?(" : "map(";
            MapType mtype = (MapType)type;
            return String.valueOf(rslt) + ToolDefTextUtils.typeToStr(mtype.getKeyType(), normalize) + ":" + ToolDefTextUtils.typeToStr(mtype.getValueType(), normalize) + ")";
        }
        if (type instanceof TupleType) {
            String rslt = type.isNullable() ? "tuple?(" : "tuple(";
            TupleType ttype = (TupleType)type;
            List frslts = Lists.listc((int)ttype.getFields().size());
            for (ToolDefType t : ttype.getFields()) {
                frslts.add(ToolDefTextUtils.typeToStr(t, normalize));
            }
            return String.valueOf(rslt) + StringUtils.join((Collection)frslts, (String)", ") + ")";
        }
        if (type instanceof TypeParamRef) {
            Assert.check((!type.isNullable() ? 1 : 0) != 0);
            return ToolDefTextUtils.getAbsName((PositionObject)((TypeParamRef)type).getType());
        }
        if (type instanceof TypeRef) {
            Assert.check((!type.isNullable() ? 1 : 0) != 0);
            return ToolDefTextUtils.getAbsName((PositionObject)((TypeRef)type).getType());
        }
        throw new RuntimeException("Unknown/unsupported type: " + type);
    }
}

