/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class AnonymizeNames
extends CifWalker
implements CifToCifTransformation {
    private Map<String, Integer> nextFreeNumbers;
    private Map<EnumDecl, EnumDecl> enumRepresentatives;
    private Map<EnumLiteral, String> enumLitRepresentativesNewNames;

    @Override
    public void transform(Specification spec) {
        this.nextFreeNumbers = Maps.map();
        List enumDecls = Lists.list();
        CifCollectUtils.collectEnumDecls((ComplexComponent)spec, (Collection)enumDecls);
        this.enumRepresentatives = CifEnumUtils.getEnumDeclReprs((List)enumDecls);
        this.enumLitRepresentativesNewNames = Maps.map();
        for (EnumDecl enumDecl : this.enumRepresentatives.values()) {
            for (EnumLiteral lit : enumDecl.getLiterals()) {
                this.enumLitRepresentativesNewNames.put(lit, this.getName("lit"));
            }
        }
        this.walkSpecification(spec);
    }

    protected void preprocessCastExpression(CastExpression castExpr) {
        CifType childType = CifTypeUtils.normalizeType((CifType)castExpr.getChild().getType());
        CifType resultType = CifTypeUtils.normalizeType((CifType)castExpr.getType());
        if (CifTypeUtils.hasComponentLikeType((CifType)childType) && resultType instanceof StringType) {
            throw new CifToCifPreconditionException("Anonymizing names for a CIF specification with automaton to string casts is currently not supported.");
        }
    }

    private String getName(String prefix) {
        Integer nextNr = this.nextFreeNumbers.get(prefix);
        if (nextNr == null) {
            nextNr = 1;
        }
        this.nextFreeNumbers.put(prefix, nextNr + 1);
        return String.valueOf(prefix) + nextNr;
    }

    protected void preprocessAutomaton(Automaton automaton) {
        if (automaton.eContainer() instanceof ComponentDef) {
            automaton.setName(this.getName("autdef"));
        } else {
            automaton.setName(this.getName("aut"));
        }
    }

    protected void preprocessGroup(Group group) {
        if (group instanceof Specification) {
            Assert.check((boolean)"specification".equals(group.getName()));
        } else if (group.eContainer() instanceof ComponentDef) {
            group.setName(this.getName("grpdef"));
        } else {
            group.setName(this.getName("grp"));
        }
    }

    protected void preprocessComponentInst(ComponentInst componentInst) {
        componentInst.setName(this.getName("inst"));
    }

    protected void preprocessAlgVariable(AlgVariable algVar) {
        if (algVar.eContainer() instanceof AlgParameter) {
            algVar.setName(this.getName("aparam"));
        } else {
            algVar.setName(this.getName("alg"));
        }
    }

    protected void preprocessConstant(Constant constant) {
        constant.setName(this.getName("const"));
    }

    protected void preprocessContVariable(ContVariable contVar) {
        contVar.setName(this.getName("cont"));
    }

    protected void preprocessDiscVariable(DiscVariable discVar) {
        if (discVar.eContainer() instanceof FunctionParameter) {
            discVar.setName(this.getName("fparam"));
        } else {
            discVar.setName(this.getName("disc"));
        }
    }

    protected void preprocessEnumDecl(EnumDecl enumDecl) {
        enumDecl.setName(this.getName("enum"));
    }

    protected void preprocessEvent(Event event) {
        if (event.eContainer() instanceof EventParameter) {
            event.setName(this.getName("eparam"));
        } else {
            event.setName(this.getName("evt"));
        }
        if (event.getControllable() != null) {
            String prefix = event.getControllable() != false ? "c_" : "u_";
            event.setName(String.valueOf(prefix) + event.getName());
        }
    }

    protected void preprocessFunction(Function function) {
        function.setName(this.getName("func"));
    }

    protected void preprocessInputVariable(InputVariable inputVar) {
        inputVar.setName(this.getName("input"));
    }

    protected void preprocessTypeDecl(TypeDecl typeDecl) {
        typeDecl.setName(this.getName("type"));
    }

    protected void preprocessLocation(Location location) {
        if (location.eContainer() instanceof LocationParameter) {
            Assert.notNull((Object)location.getName());
            location.setName(this.getName("lparam"));
        } else if (location.getName() != null) {
            location.setName(this.getName("loc"));
        }
    }

    protected void preprocessComponentParameter(ComponentParameter compParam) {
        compParam.setName(this.getName("cparam"));
    }

    protected void preprocessEnumLiteral(EnumLiteral enumLit) {
        EnumDecl enumDecl = (EnumDecl)enumLit.eContainer();
        EnumDecl enumRepresentative = this.enumRepresentatives.get(enumDecl);
        int index = enumDecl.getLiterals().indexOf((Object)enumLit);
        EnumLiteral litRepresentative = (EnumLiteral)enumRepresentative.getLiterals().get(index);
        enumLit.setName(this.enumLitRepresentativesNewNames.get(litRepresentative));
    }

    protected void preprocessField(Field field) {
        if (field.getName() != null) {
            TupleType tupleType = (TupleType)field.eContainer();
            int index = tupleType.getFields().indexOf((Object)field);
            field.setName("field" + Integer.toString(index + 1));
        }
    }
}

