/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.writers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.Strings;

public class Iec611313Writer {
    private Iec611313Writer() {
    }

    public static void write(PlcProject project, String outPath) {
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)outPath);
        Path nioAbsPath = Paths.get(absPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated PLC code.", (Object[])new Object[]{outPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
        for (PlcConfiguration config : project.configurations) {
            Iec611313Writer.write(config, outPath);
        }
        for (PlcPou pou : project.pous) {
            Iec611313Writer.write(pou, outPath);
        }
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            Iec611313Writer.write(typeDecl, outPath);
        }
    }

    private static void write(PlcConfiguration config, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(config.name) + ".plccfg"});
        Box code = config.toBox();
        code.writeToFile(path);
    }

    private static void write(PlcPou pou, String outPath) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(pou.name) + ext});
        Box code = pou.toBox();
        code.writeToFile(path);
    }

    private static void write(PlcTypeDecl typeDecl, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(typeDecl.name) + ".plctype"});
        Box code = typeDecl.toBox();
        code.writeToFile(path);
    }
}

