/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.writers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcArrayType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcDerivedType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcElementaryType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcEnumType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouInstance;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcResource;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcStructType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTask;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcValue;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Strings;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PlcOpenXmlWriter {
    private static final String PLCOPEN_NS = "http://www.plcopen.org/xml/tc6_0201";
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    private PlcOpenXmlWriter() {
    }

    public static void write(PlcProject project, String filePath) {
        Document doc = PlcOpenXmlWriter.transProject(project);
        PlcOpenXmlWriter.writeDocument(doc, filePath);
        PlcOpenXmlWriter.validateDocument(filePath);
    }

    private static Document transProject(PlcProject project) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document doc = domImpl.createDocument(PLCOPEN_NS, "project", null);
        doc.setXmlStandalone(true);
        Element root = doc.getDocumentElement();
        Element fileHeader = doc.createElement("fileHeader");
        root.appendChild(fileHeader);
        fileHeader.setAttribute("companyName", "Eclipse Foundation");
        fileHeader.setAttribute("productName", "CIF to Structured Text");
        fileHeader.setAttribute("productVersion", "0.0");
        Instant instant = Instant.ofEpochMilli(0L);
        String formattedDateTime = DateTimeFormatter.ISO_INSTANT.format(instant);
        fileHeader.setAttribute("creationDateTime", formattedDateTime);
        Element contentHeader = doc.createElement("contentHeader");
        root.appendChild(contentHeader);
        contentHeader.setAttribute("name", project.name);
        Element coordInfo = doc.createElement("coordinateInfo");
        contentHeader.appendChild(coordInfo);
        Element fbd = doc.createElement("fbd");
        coordInfo.appendChild(fbd);
        Element fbdScaling = doc.createElement("scaling");
        fbd.appendChild(fbdScaling);
        fbdScaling.setAttribute("x", "1");
        fbdScaling.setAttribute("y", "1");
        Element ld = doc.createElement("ld");
        coordInfo.appendChild(ld);
        Element ldScaling = doc.createElement("scaling");
        ld.appendChild(ldScaling);
        ldScaling.setAttribute("x", "1");
        ldScaling.setAttribute("y", "1");
        Element sfc = doc.createElement("sfc");
        coordInfo.appendChild(sfc);
        Element sfcScaling = doc.createElement("scaling");
        sfc.appendChild(sfcScaling);
        sfcScaling.setAttribute("x", "1");
        sfcScaling.setAttribute("y", "1");
        Element types = doc.createElement("types");
        root.appendChild(types);
        Element dataTypes = doc.createElement("dataTypes");
        types.appendChild(dataTypes);
        Element pous = doc.createElement("pous");
        types.appendChild(pous);
        Element instances = doc.createElement("instances");
        root.appendChild(instances);
        Element configurations = doc.createElement("configurations");
        instances.appendChild(configurations);
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            PlcOpenXmlWriter.transTypeDecl(typeDecl, dataTypes);
        }
        for (PlcPou pou : project.pous) {
            PlcOpenXmlWriter.transPou(pou, pous);
        }
        for (PlcConfiguration config : project.configurations) {
            PlcOpenXmlWriter.transConfig(config, configurations);
        }
        return doc;
    }

    private static void transTypeDecl(PlcTypeDecl typeDecl, Element parent) {
        Element dataType = parent.getOwnerDocument().createElement("dataType");
        parent.appendChild(dataType);
        dataType.setAttribute("name", typeDecl.name);
        Element baseType = parent.getOwnerDocument().createElement("baseType");
        dataType.appendChild(baseType);
        PlcOpenXmlWriter.transType(typeDecl.type, baseType);
    }

    private static void transType(PlcType type, Element parent) {
        if (type instanceof PlcElementaryType) {
            PlcElementaryType etype = (PlcElementaryType)type;
            Element elem = parent.getOwnerDocument().createElement(etype.name);
            parent.appendChild(elem);
        } else if (type instanceof PlcDerivedType) {
            Element derived = parent.getOwnerDocument().createElement("derived");
            parent.appendChild(derived);
            PlcDerivedType dtype = (PlcDerivedType)type;
            derived.setAttribute("name", dtype.name);
        } else if (type instanceof PlcEnumType) {
            Element enumElem = parent.getOwnerDocument().createElement("enum");
            parent.appendChild(enumElem);
            Element values = parent.getOwnerDocument().createElement("values");
            enumElem.appendChild(values);
            PlcEnumType etype = (PlcEnumType)type;
            for (String lit : etype.literals) {
                Element value = parent.getOwnerDocument().createElement("value");
                values.appendChild(value);
                value.setAttribute("name", lit);
            }
        } else if (type instanceof PlcStructType) {
            Element struct = parent.getOwnerDocument().createElement("struct");
            parent.appendChild(struct);
            PlcStructType stype = (PlcStructType)type;
            for (PlcVariable field : stype.fields) {
                PlcOpenXmlWriter.transVariable(field, struct);
            }
        } else if (type instanceof PlcArrayType) {
            Element array = parent.getOwnerDocument().createElement("array");
            parent.appendChild(array);
            PlcArrayType atype = (PlcArrayType)type;
            Element dim = parent.getOwnerDocument().createElement("dimension");
            array.appendChild(dim);
            dim.setAttribute("lower", Strings.str((Object)atype.lower));
            dim.setAttribute("upper", Strings.str((Object)atype.upper));
            Element bt = parent.getOwnerDocument().createElement("baseType");
            array.appendChild(bt);
            PlcOpenXmlWriter.transType(atype.elemType, bt);
        } else {
            throw new RuntimeException("Unknown plc type: " + type);
        }
    }

    private static void transVariable(PlcVariable var, Element parent) {
        Element varElem = parent.getOwnerDocument().createElement("variable");
        parent.appendChild(varElem);
        varElem.setAttribute("name", var.name);
        if (var.address != null) {
            varElem.setAttribute("address", var.address);
        }
        Element type = parent.getOwnerDocument().createElement("type");
        varElem.appendChild(type);
        PlcOpenXmlWriter.transType(var.type, type);
        if (var.value != null) {
            Element value = parent.getOwnerDocument().createElement("initialValue");
            varElem.appendChild(value);
            PlcOpenXmlWriter.transValue(var.value, value);
        }
    }

    private static void transValue(PlcValue value, Element parent) {
        Element vElem = parent.getOwnerDocument().createElement("simpleValue");
        parent.appendChild(vElem);
        vElem.setAttribute("value", value.value);
    }

    private static void transPou(PlcPou pou, Element parent) {
        Element e;
        Element pouElem = parent.getOwnerDocument().createElement("pou");
        parent.appendChild(pouElem);
        pouElem.setAttribute("name", pou.name);
        String pouTypeText = null;
        switch (pou.pouType) {
            case FUNCTION: {
                pouTypeText = "function";
                break;
            }
            case PROGRAM: {
                pouTypeText = "program";
            }
        }
        pouElem.setAttribute("pouType", pouTypeText);
        Element iface = parent.getOwnerDocument().createElement("interface");
        pouElem.appendChild(iface);
        if (pou.retType != null) {
            Element rtElem = parent.getOwnerDocument().createElement("returnType");
            iface.appendChild(rtElem);
            PlcOpenXmlWriter.transType(pou.retType, rtElem);
        }
        if (!pou.inputVars.isEmpty()) {
            e = parent.getOwnerDocument().createElement("inputVars");
            iface.appendChild(e);
            for (PlcVariable var : pou.inputVars) {
                PlcOpenXmlWriter.transVariable(var, e);
            }
        }
        if (!pou.outputVars.isEmpty()) {
            e = parent.getOwnerDocument().createElement("outputVars");
            iface.appendChild(e);
            for (PlcVariable var : pou.outputVars) {
                PlcOpenXmlWriter.transVariable(var, e);
            }
        }
        if (!pou.localVars.isEmpty()) {
            e = parent.getOwnerDocument().createElement("localVars");
            iface.appendChild(e);
            for (PlcVariable var : pou.localVars) {
                PlcOpenXmlWriter.transVariable(var, e);
            }
        }
        if (!pou.tempVars.isEmpty()) {
            e = parent.getOwnerDocument().createElement("tempVars");
            iface.appendChild(e);
            for (PlcVariable var : pou.tempVars) {
                PlcOpenXmlWriter.transVariable(var, e);
            }
        }
        PlcOpenXmlWriter.transBody(pou.body, pouElem);
    }

    private static void transBody(CodeBox body, Element parent) {
        Element bodyElem = parent.getOwnerDocument().createElement("body");
        parent.appendChild(bodyElem);
        Element st = parent.getOwnerDocument().createElement("ST");
        bodyElem.appendChild(st);
        Element xhtml = parent.getOwnerDocument().createElementNS(XHTML_NS, "xhtml");
        st.appendChild(xhtml);
        xhtml.setTextContent(body.toString());
    }

    private static void transConfig(PlcConfiguration config, Element parent) {
        Element configElem = parent.getOwnerDocument().createElement("configuration");
        parent.appendChild(configElem);
        configElem.setAttribute("name", config.name);
        for (PlcResource resource : config.resources) {
            PlcOpenXmlWriter.transResource(resource, configElem);
        }
        for (PlcGlobalVarList varList : config.globalVarLists) {
            PlcOpenXmlWriter.transGlobalVarList(varList, configElem);
        }
    }

    private static void transGlobalVarList(PlcGlobalVarList varList, Element parent) {
        if (varList.variables.isEmpty()) {
            return;
        }
        Element gv = parent.getOwnerDocument().createElement("globalVars");
        parent.appendChild(gv);
        gv.setAttribute("name", varList.name);
        gv.setAttribute("constant", varList.constants ? "true" : "false");
        for (PlcVariable var : varList.variables) {
            PlcOpenXmlWriter.transVariable(var, gv);
        }
    }

    private static void transResource(PlcResource resource, Element parent) {
        Element resElem = parent.getOwnerDocument().createElement("resource");
        parent.appendChild(resElem);
        resElem.setAttribute("name", resource.name);
        for (PlcTask task : resource.tasks) {
            PlcOpenXmlWriter.transTask(task, resElem);
        }
        for (PlcGlobalVarList varList : resource.globalVarLists) {
            PlcOpenXmlWriter.transGlobalVarList(varList, resElem);
        }
        for (PlcPouInstance inst : resource.pouInstances) {
            PlcOpenXmlWriter.transPouInstance(inst, resElem);
        }
    }

    private static Element transPouInstance(PlcPouInstance inst, Element parent) {
        Element instElem = parent.getOwnerDocument().createElement("pouInstance");
        parent.appendChild(instElem);
        instElem.setAttribute("name", inst.name);
        instElem.setAttribute("typeName", inst.pou.name);
        return instElem;
    }

    private static void transPouInstanceWithDoc(PlcPouInstance inst, Element parent) {
        Element instElem = PlcOpenXmlWriter.transPouInstance(inst, parent);
        Element docElem = instElem.getOwnerDocument().createElement("documentation");
        instElem.appendChild(docElem);
        Element xhtml = docElem.getOwnerDocument().createElementNS(XHTML_NS, "xhtml");
        docElem.appendChild(xhtml);
    }

    private static void transTask(PlcTask task, Element parent) {
        Element taskElem = parent.getOwnerDocument().createElement("task");
        parent.appendChild(taskElem);
        taskElem.setAttribute("name", task.name);
        taskElem.setAttribute("interval", Strings.fmt((String)"PT%.3fS", (Object[])new Object[]{Float.valueOf((float)task.cycleTime / 1000.0f)}));
        taskElem.setAttribute("priority", Strings.str((Object)task.priority));
        for (PlcPouInstance inst : task.pouInstances) {
            PlcOpenXmlWriter.transPouInstanceWithDoc(inst, taskElem);
        }
    }

    private static void validateDocument(String filePath) {
        InputStream schemaStream = null;
        InputStream xmlStream = null;
        try {
            try {
                Schema schema;
                String schemaName = PlcOpenXmlWriter.class.getPackage().getName();
                schemaName = String.valueOf(schemaName.replace('.', '/')) + "/tc6_xml_v201.xsd";
                ClassLoader classLoader = PlcOpenXmlWriter.class.getClassLoader();
                schemaStream = classLoader.getResourceAsStream(schemaName);
                StreamSource schemaSrc = new StreamSource(schemaStream);
                xmlStream = new FileInputStream(filePath);
                xmlStream = new BufferedInputStream(xmlStream);
                StreamSource xmlSrc = new StreamSource(xmlStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    schema = schemaFactory.newSchema(schemaSrc);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                Validator validator = schema.newValidator();
                try {
                    validator.validate(xmlSrc);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Failed to validate \"%s\" due to an I/O error.", (Object[])new Object[]{filePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        finally {
            if (schemaStream != null) {
                try {
                    schemaStream.close();
                }
                catch (IOException iOException) {}
            }
            if (xmlStream != null) {
                try {
                    xmlStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeDocument(Document doc, String filePath) {
        FileOutputStream xmlStream;
        Transformer xmlTrans;
        TransformerFactory xmlTransFactory = TransformerFactory.newInstance();
        try {
            xmlTrans = xmlTransFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        xmlTrans.setOutputProperty("indent", "yes");
        xmlTrans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        try {
            xmlStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to write PLCopen XML file to \"%s\".", (Object[])new Object[]{filePath});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        StreamResult result = new StreamResult(xmlStream);
        try {
            xmlTrans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        try {
            xmlStream.close();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{filePath});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }
}

