/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2supremica;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToSupremicaPreChecker
extends CifWalker {
    private final List<String> problems = Lists.list();
    private Map<DiscVariable, List<Expression>> markeds = Maps.map();
    private int initLocCount;

    public void check(Specification spec) {
        this.walkSpecification(spec);
        Collections.sort(this.problems, Strings.SORTER);
        if (!this.problems.isEmpty()) {
            String msg = "CIF to Supremica transformation failed due to unsatisfied preconditions:\n - " + String.join((CharSequence)"\n - ", this.problems);
            throw new UnsupportedException(msg);
        }
    }

    protected void preprocessEvent(Event event) {
        String msg;
        if (event.getControllable() == null) {
            msg = Strings.fmt((String)"Unsupported event \"%s\": event is not declared as controllable or uncontrollable.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
        if (event.getType() != null) {
            msg = Strings.fmt((String)"Unsupported event \"%s\": event is a channel (has a data type).", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
            this.problems.add(msg);
        }
    }

    protected void preprocessTauExpression(TauExpression obj) {
        this.problems.add("Unsupported event \"tau\": event is not controllable or uncontrollable (explicit use of \"tau\").");
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        String msg;
        if (!comp.getInitials().isEmpty()) {
            String msg2 = Strings.fmt((String)"Unsupported %s: initialization predicates are currently only supported in locations.", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp)});
            this.problems.add(msg2);
        }
        for (Expression marked : comp.getMarkeds()) {
            boolean supported = this.processComponentMarker(marked);
            if (supported) continue;
            msg = Strings.fmt((String)"Unsupported %s: unsupported marker predicate \"%s\".", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.exprToStr((Expression)marked)});
            this.problems.add(msg);
        }
        for (Invariant inv : comp.getInvariants()) {
            SupKind supKind = inv.getSupKind();
            if (inv.getInvKind() == InvKind.STATE) {
                if (supKind == SupKind.REQUIREMENT) continue;
                String kindTxt = supKind == SupKind.NONE ? "kindless" : CifTextUtils.kindToStr((SupKind)supKind);
                String msg3 = Strings.fmt((String)"Unsupported %s: unsupported %s state invariant \"%s\".", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), kindTxt, CifTextUtils.invToStr((Invariant)inv, (boolean)false)});
                this.problems.add(msg3);
                continue;
            }
            if (inv.getInvKind() == InvKind.EVENT_NEEDS || inv.getInvKind() == InvKind.EVENT_DISABLES) {
                if (supKind != SupKind.NONE) continue;
                msg = Strings.fmt((String)"Unsupported %s: unsupported kindless state/event exclusion invariant \"%s\".", (Object[])new Object[]{CifTextUtils.getComponentText1((ComplexComponent)comp), CifTextUtils.invToStr((Invariant)inv, (boolean)false)});
                this.problems.add(msg);
                continue;
            }
            Assert.fail((Object)"Unexpected invariant kind.");
        }
    }

    private boolean processComponentMarker(Expression marker) {
        if (!(marker instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression bexpr = (BinaryExpression)marker;
        if (bexpr.getOperator() != BinaryOperator.EQUAL) {
            return false;
        }
        if (!(bexpr.getLeft() instanceof DiscVariableExpression)) {
            return false;
        }
        DiscVariableExpression vref = (DiscVariableExpression)bexpr.getLeft();
        DiscVariable var = vref.getVariable();
        List values = this.markeds.get(var);
        if (values == null) {
            values = Lists.list();
            this.markeds.put(var, values);
        }
        values.add(bexpr.getRight());
        if (values.size() == 2) {
            String msg = Strings.fmt((String)"Unsupported declaration \"%s\": discrete variables with multiple marker predicates are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            this.problems.add(msg);
        }
        return true;
    }

    protected void preprocessAutomaton(Automaton aut) {
        if (aut.getKind() == SupKind.NONE) {
            String msg = Strings.fmt((String)"Unsupported automaton \"%s\": kindless/regular automata are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
        this.initLocCount = 0;
    }

    protected void postprocessAutomaton(Automaton aut) {
        String msg;
        if (this.initLocCount == 0) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata without an initial location are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut)});
            this.problems.add(msg);
        }
        if (this.initLocCount > 1) {
            msg = Strings.fmt((String)"Unsupported automaton \"%s\": automata with multiple (%d) initial locations are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)aut), this.initLocCount});
            this.problems.add(msg);
        }
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        VariableValue values;
        EObject parent = var.eContainer();
        if (parent instanceof ComplexComponent && (values = var.getValue()) != null && values.getValues().size() != 1) {
            String msg = Strings.fmt((String)"Unsupported declaration \"%s\": discrete variables with multiple potential initial values are currently not supported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
            this.problems.add(msg);
        }
    }

    protected void preprocessContVariable(ContVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": continuous variables are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessInputVariable(InputVariable var) {
        String msg = Strings.fmt((String)"Unsupported declaration \"%s\": input variables are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)var)});
        this.problems.add(msg);
    }

    protected void preprocessLocation(Location loc) {
        String msg;
        EObject parent = loc.eContainer();
        if (parent instanceof LocationParameter) {
            return;
        }
        if (loc.isUrgent()) {
            String msg2 = Strings.fmt((String)"Unsupported %s: urgent locations are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg2);
        }
        boolean initial = false;
        try {
            initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List)loc.getInitials(), (boolean)true, (boolean)true);
        }
        catch (CifEvalException e) {
            msg = Strings.fmt((String)"Failed to evaluate initialization predicate(s): %s.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)loc.getInitials())});
            this.problems.add(msg);
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
        if (!loc.getMarkeds().isEmpty()) {
            try {
                CifEvalUtils.evalPreds((List)loc.getMarkeds(), (boolean)false, (boolean)true);
            }
            catch (CifEvalException e) {
                msg = Strings.fmt((String)"Failed to evaluate marker predicate(s): %s.", (Object[])new Object[]{CifTextUtils.exprsToStr((List)loc.getInitials())});
                this.problems.add(msg);
            }
        }
        for (Invariant inv : loc.getInvariants()) {
            if (inv.getInvKind() != InvKind.STATE) continue;
            String msg3 = Strings.fmt((String)"Unsupported %s: state invariants in locations are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg3);
        }
    }

    protected void preprocessEdge(Edge edge) {
        if (edge.getEvents().isEmpty()) {
            this.problems.add("Unsupported event \"tau\": event is not controllable or uncontrollable (implicit use of \"tau\").");
        }
        if (edge.isUrgent()) {
            Location loc = (Location)edge.eContainer();
            String msg = Strings.fmt((String)"Unsupported %s: urgent edges are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)loc)});
            this.problems.add(msg);
        }
    }

    protected void preprocessAssignment(Assignment asgn) {
        if (asgn.getAddressable() instanceof TupleExpression) {
            Assignment loc = asgn;
            while (!(loc instanceof Location)) {
                loc = loc.eContainer();
            }
            Assert.check((boolean)(loc instanceof Location));
            String msg = Strings.fmt((String)"Unsupported %s: edges with multi-assignments are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)((Location)loc))});
            this.problems.add(msg);
        } else if (asgn.getAddressable() instanceof ProjectionExpression) {
            Assignment loc = asgn;
            while (!(loc instanceof Location)) {
                loc = loc.eContainer();
            }
            Assert.check((boolean)(loc instanceof Location));
            String msg = Strings.fmt((String)"Unsupported %s: edges with partial variable assignments are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)((Location)loc))});
            this.problems.add(msg);
        }
    }

    protected void preprocessIfUpdate(IfUpdate update) {
        IfUpdate loc = update;
        while (!(loc instanceof Location)) {
            loc = loc.eContainer();
        }
        Assert.check((boolean)(loc instanceof Location));
        String msg = Strings.fmt((String)"Unsupported %s: edges with 'if' updates are currently unsupported.", (Object[])new Object[]{CifTextUtils.getLocationText1((Location)((Location)loc))});
        this.problems.add(msg);
    }

    protected void preprocessFunction(Function func) {
        String msg = Strings.fmt((String)"Unsupported function \"%s\": user-defined functions are currently unsupported.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)func)});
        this.problems.add(msg);
    }

    protected void preprocessDictType(DictType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": dictionary types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessDistType(DistType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": distribution types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessFuncType(FuncType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": function types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessIntType(IntType type) {
        if (CifTypeUtils.isRangeless((IntType)type)) {
            String msg = Strings.fmt((String)"Unsupported type \"%s\": rangeless integer types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
            this.problems.add(msg);
        }
    }

    protected void preprocessListType(ListType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": list types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessRealType(RealType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": real types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessSetType(SetType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": set types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessStringType(StringType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": string types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessTupleType(TupleType type) {
        String msg = Strings.fmt((String)"Unsupported type \"%s\": tuple types are currently not supported.", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)type)});
        this.problems.add(msg);
    }

    protected void preprocessBinaryExpression(BinaryExpression expr) {
        BinaryOperator op = expr.getOperator();
        switch (op) {
            case IMPLICATION: 
            case BI_CONDITIONAL: {
                return;
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof BoolType) || !(rtype instanceof BoolType)) break;
                return;
            }
            case MODULUS: 
            case INTEGER_DIVISION: 
            case MULTIPLICATION: 
            case SUBTRACTION: 
            case ADDITION: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || !(rtype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)rtype))) break;
                return;
            }
            case EQUAL: 
            case UNEQUAL: {
                return;
            }
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                CifType ltype = CifTypeUtils.normalizeType((CifType)expr.getLeft().getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)expr.getRight().getType());
                if (!(ltype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || !(rtype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)rtype))) break;
                return;
            }
            case SUBSET: 
            case ELEMENT_OF: 
            case DIVISION: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown bin op: " + op);
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": binary operator \"%s\" is currently not supported, or is not supported for the operands that are used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((BinaryOperator)op)});
        this.problems.add(msg);
    }

    protected void preprocessCastExpression(CastExpression expr) {
        CifType rtype;
        CifType ctype = expr.getChild().getType();
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)(rtype = expr.getType()), (RangeCompat)RangeCompat.EQUAL)) {
            return;
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": cast expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessDictExpression(DictExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": dictionary expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": function calls are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessIfExpression(IfExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": 'if' expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessListExpression(ListExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": list expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessProjectionExpression(ProjectionExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": projection expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessRealExpression(RealExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": real number expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSetExpression(SetExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": set expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSliceExpression(SliceExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": slice expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessStringExpression(StringExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": string literal expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessSwitchExpression(SwitchExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": 'switch' expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTimeExpression(TimeExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": the use of variable \"time\" is currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessTupleExpression(TupleExpression expr) {
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": tuple expressions are currently not supported.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr)});
        this.problems.add(msg);
    }

    protected void preprocessUnaryExpression(UnaryExpression expr) {
        UnaryOperator op = expr.getOperator();
        switch (op) {
            case INVERSE: {
                return;
            }
            case NEGATE: 
            case PLUS: {
                CifType ctype = CifTypeUtils.normalizeType((CifType)expr.getChild().getType());
                if (!(ctype instanceof IntType) || CifTypeUtils.isRangeless((IntType)((IntType)ctype))) break;
                return;
            }
            case SAMPLE: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown un op: " + op);
            }
        }
        String msg = Strings.fmt((String)"Unsupported expression \"%s\": unary operator \"%s\" is currently not supported, or is not supported for the operand that is used.", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.operatorToStr((UnaryOperator)op)});
        this.problems.add(msg);
    }
}

