/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Collection;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;

public class CifCollectUtils {
    private CifCollectUtils() {
    }

    public static void collectEvents(ComplexComponent comp, Collection<Event> events) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event)) continue;
            events.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectEvents((ComplexComponent)child, events);
            }
        }
    }

    public static void collectControllableEvents(ComplexComponent comp, Collection<Event> ctrlEvents) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event) || ((Event)decl).getControllable() == null || !((Event)decl).getControllable().booleanValue()) continue;
            ctrlEvents.add((Event)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectControllableEvents((ComplexComponent)child, ctrlEvents);
            }
        }
    }

    public static void collectAutomata(ComplexComponent comp, Collection<Automaton> automata) {
        if (comp instanceof Automaton) {
            automata.add((Automaton)comp);
        } else {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectAutomata((ComplexComponent)child, automata);
            }
        }
    }

    public static void collectDiscAndInputVariables(ComplexComponent comp, Collection<Declaration> variables) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof DiscVariable) && !(decl instanceof InputVariable)) continue;
            variables.add(decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)child, variables);
            }
        }
    }

    public static void collectDeclarations(ComplexComponent comp, Collection<Declaration> declarations) {
        declarations.addAll((Collection<Declaration>)comp.getDeclarations());
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectDeclarations((ComplexComponent)child, declarations);
            }
        }
    }

    public static void collectIoDeclarations(ComplexComponent comp, Collection<IoDecl> declarations) {
        declarations.addAll((Collection<IoDecl>)comp.getIoDecls());
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifCollectUtils.collectIoDeclarations((ComplexComponent)child, declarations);
            }
        }
    }

    public static void collectEnumDecls(ComplexComponent comp, Collection<EnumDecl> enumDecls) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof EnumDecl)) continue;
            enumDecls.add((EnumDecl)decl);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                if (child instanceof ComponentInst) continue;
                CifCollectUtils.collectEnumDecls((ComplexComponent)child, enumDecls);
            }
            for (ComponentDef cdef : ((Group)comp).getDefinitions()) {
                CifCollectUtils.collectEnumDecls(cdef.getBody(), enumDecls);
            }
        }
    }
}

