/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.ScopeCache;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifScopeUtils {
    private CifScopeUtils() {
    }

    public static boolean isAutomaton(Component component) {
        while (component instanceof ComponentInst) {
            ComponentInst cinst = (ComponentInst)component;
            ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst(cinst);
            component = cdef.getBody();
        }
        if (component instanceof Automaton) {
            return true;
        }
        Assert.check((boolean)(component instanceof Group));
        return false;
    }

    public static Automaton getAutomaton(Component component) {
        while (component instanceof ComponentInst) {
            ComponentInst cinst = (ComponentInst)component;
            ComponentDef cdef = CifTypeUtils.getCompDefFromCompInst(cinst);
            component = cdef.getBody();
        }
        if (component instanceof Automaton) {
            return (Automaton)component;
        }
        Assert.check((boolean)(component instanceof Group));
        throw new RuntimeException("component is not an aut: " + component);
    }

    public static boolean hasCompDefInst(Group group) {
        if (!group.getDefinitions().isEmpty()) {
            return true;
        }
        for (Component child : group.getComponents()) {
            if (child instanceof ComponentInst) {
                return true;
            }
            if (child instanceof Automaton) continue;
            Assert.check((boolean)(child instanceof Group));
            if (!CifScopeUtils.hasCompDefInst((Group)child)) continue;
            return true;
        }
        return false;
    }

    public static List<PositionObject> getScopePath(PositionObject obj) {
        Assert.check((!(obj instanceof Specification) ? 1 : 0) != 0);
        List rslt = Lists.list();
        PositionObject cur = obj;
        do {
            cur = CifScopeUtils.getScope(cur);
            rslt.add(cur);
        } while (!(cur instanceof Specification));
        Assert.check((!rslt.isEmpty() ? 1 : 0) != 0);
        return rslt;
    }

    public static PositionObject getCommonScope(PositionObject scope1, PositionObject scope2) {
        if (scope1 == scope2) {
            return scope1;
        }
        Set path1 = scope1 instanceof Specification ? Sets.set() : Sets.list2set(CifScopeUtils.getScopePath(scope1));
        path1.add(scope1);
        if (path1.contains(scope2)) {
            return scope2;
        }
        List<PositionObject> path2 = CifScopeUtils.getScopePath(scope2);
        for (PositionObject scope : path2) {
            if (!path1.contains(scope)) continue;
            return scope;
        }
        throw new IllegalArgumentException("No common scope found.");
    }

    public static boolean isAncestorScope(PositionObject scope1, PositionObject scope2) {
        PositionObject cur = (PositionObject)scope2.eContainer();
        while (cur != null) {
            if (cur == scope1) {
                return true;
            }
            cur = (PositionObject)cur.eContainer();
        }
        return false;
    }

    public static PositionObject getScope(PositionObject obj) {
        Assert.check((!(obj instanceof Specification) ? 1 : 0) != 0);
        PositionObject cur = (PositionObject)obj.eContainer();
        while (cur != null) {
            if (CifScopeUtils.isScope(cur)) {
                return cur;
            }
            cur = (PositionObject)cur.eContainer();
        }
        throw new IllegalArgumentException("No scope found for: " + obj);
    }

    public static boolean isScope(PositionObject obj) {
        if (obj instanceof ComponentDef) {
            return true;
        }
        if (obj instanceof Function) {
            return true;
        }
        if (obj instanceof ComponentInst) {
            return false;
        }
        if (obj instanceof Component) {
            PositionObject parent = (PositionObject)obj.eContainer();
            return !(parent instanceof ComponentDef);
        }
        if (obj instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)obj;
            CifType t = CifTypeUtils.normalizeType(projExpr.getChild().getType());
            if (!(t instanceof TupleType)) {
                return false;
            }
            return projExpr.getIndex() instanceof ConstantExpression;
        }
        return false;
    }

    public static boolean isRootScope(PositionObject obj) {
        if (obj instanceof Specification) {
            return true;
        }
        return obj instanceof ComponentDef;
    }

    public static PositionObject getScopeRoot(PositionObject scope) {
        Assert.check((boolean)CifScopeUtils.isScope(scope));
        PositionObject curScope = scope;
        while (curScope != null) {
            if (CifScopeUtils.isRootScope(curScope)) {
                return curScope;
            }
            curScope = CifScopeUtils.getScope(curScope);
        }
        throw new RuntimeException("Rootless scope: " + scope);
    }

    public static Specification getSpecRoot(PositionObject scope) {
        Assert.check((boolean)CifScopeUtils.isScope(scope));
        PositionObject curScope = scope;
        while (curScope != null) {
            if (curScope instanceof Specification) {
                return (Specification)curScope;
            }
            curScope = CifScopeUtils.getScope(curScope);
        }
        throw new RuntimeException("Rootless scope: " + scope);
    }

    public static PositionObject getObject(PositionObject scope, String name) {
        String msg;
        Function func;
        if (scope instanceof ComplexComponent) {
            ComplexComponent comp = (ComplexComponent)scope;
            for (Declaration decl : comp.getDeclarations()) {
                if (decl.getName().equals(name)) {
                    return decl;
                }
                if (!(decl instanceof EnumDecl)) continue;
                for (EnumLiteral lit : ((EnumDecl)decl).getLiterals()) {
                    if (!lit.getName().equals(name)) continue;
                    return lit;
                }
            }
        }
        if (scope instanceof Group) {
            Group group = (Group)scope;
            for (Component child : group.getComponents()) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
            for (ComponentDef cdef : group.getDefinitions()) {
                if (!cdef.getBody().getName().equals(name)) continue;
                return cdef;
            }
        }
        if (scope instanceof Automaton) {
            Automaton aut = (Automaton)scope;
            for (Location loc : aut.getLocations()) {
                String locName = loc.getName();
                if (locName == null || !locName.equals(name)) continue;
                return loc;
            }
        }
        if (scope instanceof ComponentDef) {
            ComponentDef compdef = (ComponentDef)scope;
            for (Parameter param : compdef.getParameters()) {
                if (!CifTextUtils.getName((PositionObject)param).equals(name)) continue;
                return param;
            }
            return CifScopeUtils.getObject((PositionObject)compdef.getBody(), name);
        }
        if (scope instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)scope;
            CifType t = CifTypeUtils.normalizeType(projExpr.getChild().getType());
            Assert.check((boolean)(t instanceof TupleType));
            TupleType tt = (TupleType)t;
            for (Field field : tt.getFields()) {
                String fieldName = field.getName();
                if (fieldName == null || !fieldName.equals(name)) continue;
                return field;
            }
        }
        if (scope instanceof Function) {
            func = (Function)scope;
            for (Parameter param : func.getParameters()) {
                if (!param.getParameter().getName().equals(name)) continue;
                return param;
            }
        }
        if (scope instanceof InternalFunction) {
            func = (InternalFunction)scope;
            for (DiscVariable var : func.getVariables()) {
                if (!var.getName().equals(name)) continue;
                return var;
            }
        }
        if (scope instanceof ComponentInst || scope instanceof Parameter) {
            msg = "Inst/param scopes not allowed: " + scope;
            throw new IllegalArgumentException(msg);
        }
        msg = Strings.fmt((String)"Name \"%s\" not found in \"%s\".", (Object[])new Object[]{name, CifTextUtils.getAbsName(scope)});
        throw new IllegalArgumentException(msg);
    }

    public static Set<String> getSymbolNamesForScope(PositionObject scope, ScopeCache scopeCache) {
        if (scopeCache != null) {
            Set<String> rslt = (Set<String>)scopeCache.get(scope);
            if (rslt != null) {
                return rslt;
            }
            rslt = CifScopeUtils.getUncachedSymbolNamesForScope(scope, scopeCache);
            scopeCache.put(scope, rslt);
            return rslt;
        }
        return CifScopeUtils.getUncachedSymbolNamesForScope(scope, scopeCache);
    }

    private static Set<String> getUncachedSymbolNamesForScope(PositionObject scope, ScopeCache scopeCache) {
        Set rslt = Sets.set();
        if (scope instanceof Group) {
            Group group = (Group)scope;
            for (Component comp : group.getComponents()) {
                rslt.add(comp.getName());
            }
            for (Declaration decl : group.getDeclarations()) {
                rslt.add(decl.getName());
                if (!(decl instanceof EnumDecl)) continue;
                for (EnumLiteral lit : ((EnumDecl)decl).getLiterals()) {
                    rslt.add(lit.getName());
                }
            }
            for (ComponentDef cdef : group.getDefinitions()) {
                rslt.add(cdef.getBody().getName());
            }
            return rslt;
        }
        if (scope instanceof Automaton) {
            Automaton aut = (Automaton)scope;
            for (Declaration decl : aut.getDeclarations()) {
                rslt.add(decl.getName());
                if (!(decl instanceof EnumDecl)) continue;
                for (EnumLiteral lit : ((EnumDecl)decl).getLiterals()) {
                    rslt.add(lit.getName());
                }
            }
            for (Location loc : aut.getLocations()) {
                String locName = loc.getName();
                if (locName == null) continue;
                rslt.add(locName);
            }
            return rslt;
        }
        if (scope instanceof ComponentDef) {
            ComponentDef compdef = (ComponentDef)scope;
            for (Parameter param : compdef.getParameters()) {
                rslt.add(CifTextUtils.getName((PositionObject)param));
            }
            Set<String> bodyNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)compdef.getBody(), scopeCache);
            rslt.addAll(bodyNames);
            return rslt;
        }
        if (scope instanceof ProjectionExpression) {
            ProjectionExpression projExpr = (ProjectionExpression)scope;
            CifType t = CifTypeUtils.normalizeType(projExpr.getChild().getType());
            Assert.check((boolean)(t instanceof TupleType));
            TupleType tt = (TupleType)t;
            for (Field field : tt.getFields()) {
                if (field.getName() == null) continue;
                rslt.add(field.getName());
            }
            return rslt;
        }
        if (scope instanceof InternalFunction) {
            InternalFunction func = (InternalFunction)scope;
            for (FunctionParameter param : func.getParameters()) {
                rslt.add(param.getParameter().getName());
            }
            for (DiscVariable var : func.getVariables()) {
                rslt.add(var.getName());
            }
            return rslt;
        }
        if (scope instanceof ExternalFunction) {
            ExternalFunction func = (ExternalFunction)scope;
            for (FunctionParameter param : func.getParameters()) {
                rslt.add(param.getParameter().getName());
            }
            return rslt;
        }
        if (scope instanceof ComponentInst || scope instanceof Parameter) {
            String msg = "Inst/param scopes not allowed: " + scope;
            throw new IllegalArgumentException(msg);
        }
        throw new RuntimeException("Unknown scope: " + scope);
    }

    public static boolean isNameHidden(String name, PositionObject curScope, PositionObject topScope, ScopeCache scopeCache) {
        List<PositionObject> scopePath = CifScopeUtils.getScopePath(curScope);
        Assert.check((boolean)scopePath.contains(topScope));
        Assert.check((topScope != curScope ? 1 : 0) != 0);
        for (PositionObject scope : Lists.concat((Object)curScope, scopePath)) {
            if (scope == topScope) break;
            Set<String> symbolNames = CifScopeUtils.getSymbolNamesForScope(scope, scopeCache);
            if (!symbolNames.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static String getRefTxtFromObj(PositionObject curObj, PositionObject refObj, ScopeCache scopeCache) {
        Assert.check((curObj instanceof Expression || curObj instanceof CifType ? 1 : 0) != 0);
        PositionObject curScope = CifScopeUtils.getScope(curObj);
        return CifScopeUtils.getRefTxtFromScope(curScope, refObj, scopeCache);
    }

    public static String getRefTxtFromScope(PositionObject scope, PositionObject refObj, ScopeCache scopeCache) {
        PositionObject curScope = scope;
        PositionObject refScope = CifScopeUtils.getScope(refObj);
        String refName = CifTextUtils.getName(refObj);
        if (curScope == refScope) {
            return CifTextUtils.escapeIdentifier(refName);
        }
        if (CifScopeUtils.isAncestorScope(refScope, curScope)) {
            if (!CifScopeUtils.isNameHidden(refName, curScope, refScope, scopeCache)) {
                return CifTextUtils.escapeIdentifier(refName);
            }
            PositionObject scopeRoot = CifScopeUtils.getScopeRoot(curScope);
            if (refScope == scopeRoot || CifScopeUtils.isAncestorScope(scopeRoot, refScope)) {
                String refTxt = "." + CifScopeUtils.getRelativeRefTxt(scopeRoot, refScope);
                refTxt = CifScopeUtils.joinRefTxts(refTxt, CifTextUtils.escapeIdentifier(refName));
                return refTxt;
            }
            return "^" + CifTextUtils.getAbsName(refObj);
        }
        PositionObject commonScope = CifScopeUtils.getCommonScope(curScope, refScope);
        List<PositionObject> scopePath = CifScopeUtils.getScopePath(refObj);
        int commonIdx = scopePath.indexOf(commonScope);
        Assert.check((commonIdx != -1 ? 1 : 0) != 0);
        int childIdx = commonIdx - 1;
        Assert.check((childIdx >= 0 ? 1 : 0) != 0);
        PositionObject childScope = scopePath.get(childIdx);
        String childScopeName = CifTextUtils.getName(childScope);
        boolean hidden = curScope == commonScope ? false : CifScopeUtils.isNameHidden(childScopeName, curScope, commonScope, scopeCache);
        String childRefTxt = !hidden ? CifTextUtils.escapeIdentifier(childScopeName) : CifScopeUtils.getRefTxtFromScope(curScope, childScope, scopeCache);
        String relTxt = CifScopeUtils.getRelativeRefTxt(childScope, refObj);
        return CifScopeUtils.joinRefTxts(childRefTxt, relTxt);
    }

    public static String getViaRefTxt(PositionObject viaRef, ScopeCache scopeCache) {
        PositionObject scope = CifScopeUtils.getScope(viaRef);
        return CifScopeUtils.getViaRefTxt(viaRef, scope, scopeCache);
    }

    public static String getViaRefTxt(PositionObject viaRef, PositionObject scope, ScopeCache scopeCache) {
        CifType cdefType;
        ComponentParameter param;
        CompParamWrapExpression paramRef;
        Expression childRef;
        ComponentDef contScope;
        ComponentInst viaScope;
        ComponentInst inst;
        CompInstWrapExpression instRef;
        if (viaRef instanceof CompInstWrapExpression) {
            instRef = (CompInstWrapExpression)viaRef;
            viaScope = inst = instRef.getInstantiation();
            contScope = CifTypeUtils.getCompDefFromCompInst(inst);
            childRef = instRef.getReference();
        } else if (viaRef instanceof CompParamWrapExpression) {
            paramRef = (CompParamWrapExpression)viaRef;
            param = paramRef.getParameter();
            viaScope = param;
            cdefType = CifTypeUtils.normalizeType(param.getType());
            Assert.check((boolean)(cdefType instanceof ComponentDefType));
            contScope = ((ComponentDefType)cdefType).getDefinition();
            childRef = paramRef.getReference();
        } else if (viaRef instanceof CompInstWrapType) {
            instRef = (CompInstWrapType)viaRef;
            viaScope = inst = instRef.getInstantiation();
            contScope = CifTypeUtils.getCompDefFromCompInst(inst);
            childRef = instRef.getReference();
        } else if (viaRef instanceof CompParamWrapType) {
            paramRef = (CompParamWrapType)viaRef;
            param = paramRef.getParameter();
            viaScope = param;
            cdefType = CifTypeUtils.normalizeType(param.getType());
            Assert.check((boolean)(cdefType instanceof ComponentDefType));
            contScope = ((ComponentDefType)cdefType).getDefinition();
            childRef = paramRef.getReference();
        } else {
            throw new RuntimeException("Unknown 'via' reference: " + viaRef);
        }
        String viaTxt = CifScopeUtils.getRefTxtFromScope(scope, (PositionObject)viaScope, scopeCache);
        if (childRef instanceof CompInstWrapExpression || childRef instanceof CompParamWrapExpression || childRef instanceof CompInstWrapType || childRef instanceof CompParamWrapType) {
            String childTxt = CifScopeUtils.getViaRefTxt((PositionObject)childRef, (PositionObject)contScope, scopeCache);
            Assert.check((!childTxt.startsWith("^") ? 1 : 0) != 0);
            Assert.check((!childTxt.startsWith(".") ? 1 : 0) != 0);
            return CifScopeUtils.joinRefTxts(viaTxt, childTxt);
        }
        Object finalRefObj = childRef instanceof TypeRef ? ((TypeRef)childRef).getType() : (childRef instanceof EnumType ? ((EnumType)childRef).getEnum() : (childRef instanceof ComponentType ? ((ComponentType)childRef).getComponent() : (childRef instanceof ComponentDefType ? ((ComponentDefType)childRef).getDefinition() : CifScopeUtils.getRefObjFromRef(childRef))));
        String childTxt = CifScopeUtils.getRelativeRefTxt((PositionObject)contScope, (PositionObject)finalRefObj);
        Assert.check((!childTxt.isEmpty() ? 1 : 0) != 0);
        return CifScopeUtils.joinRefTxts(viaTxt, childTxt);
    }

    public static String getRelativeRefTxt(PositionObject sourceScope, PositionObject targetObj) {
        if (sourceScope == targetObj) {
            return "";
        }
        List<PositionObject> scopePath = CifScopeUtils.getScopePath(targetObj);
        Assert.check((boolean)scopePath.contains(sourceScope));
        StringBuilder rslt = new StringBuilder();
        for (PositionObject scope : scopePath) {
            if (scope == sourceScope) break;
            if (rslt.length() > 0) {
                rslt.insert(0, ".");
            }
            rslt.insert(0, CifTextUtils.escapeIdentifier(CifTextUtils.getName(scope)));
        }
        Assert.check((!(targetObj instanceof Specification) ? 1 : 0) != 0);
        return CifScopeUtils.joinRefTxts(rslt.toString(), CifTextUtils.escapeIdentifier(CifTextUtils.getName(targetObj)));
    }

    public static PositionObject getRefObjFromRef(Expression refExpr) {
        Constant refObj;
        if (refExpr instanceof ConstantExpression) {
            refObj = ((ConstantExpression)refExpr).getConstant();
        } else if (refExpr instanceof DiscVariableExpression) {
            refObj = ((DiscVariableExpression)refExpr).getVariable();
        } else if (refExpr instanceof AlgVariableExpression) {
            refObj = ((AlgVariableExpression)refExpr).getVariable();
        } else if (refExpr instanceof ContVariableExpression) {
            refObj = ((ContVariableExpression)refExpr).getVariable();
        } else if (refExpr instanceof LocationExpression) {
            refObj = ((LocationExpression)refExpr).getLocation();
        } else if (refExpr instanceof EnumLiteralExpression) {
            refObj = ((EnumLiteralExpression)refExpr).getLiteral();
        } else if (refExpr instanceof EventExpression) {
            refObj = ((EventExpression)refExpr).getEvent();
        } else if (refExpr instanceof FunctionExpression) {
            refObj = ((FunctionExpression)refExpr).getFunction();
        } else if (refExpr instanceof InputVariableExpression) {
            refObj = ((InputVariableExpression)refExpr).getVariable();
        } else if (refExpr instanceof ComponentExpression) {
            refObj = ((ComponentExpression)refExpr).getComponent();
        } else if (refExpr instanceof CompParamExpression) {
            refObj = ((CompParamExpression)refExpr).getParameter();
        } else if (refExpr instanceof SelfExpression) {
            CifType ctype = CifTypeUtils.normalizeType(refExpr.getType());
            refObj = ((ComponentType)ctype).getComponent();
        } else {
            throw new RuntimeException("Invalid ref expr: " + refExpr);
        }
        return refObj;
    }

    public static PositionObject getRefObjFromRef(CifType refType) {
        TypeDecl refObj;
        if (refType instanceof TypeRef) {
            refObj = ((TypeRef)refType).getType();
        } else if (refType instanceof EnumType) {
            refObj = ((EnumType)refType).getEnum();
        } else if (refType instanceof ComponentType) {
            refObj = ((ComponentType)refType).getComponent();
        } else if (refType instanceof ComponentDefType) {
            refObj = ((ComponentDefType)refType).getDefinition();
        } else if (refType instanceof CompParamWrapType) {
            refObj = ((CompParamWrapType)refType).getParameter();
        } else if (refType instanceof CompInstWrapType) {
            refObj = ((CompInstWrapType)refType).getInstantiation();
        } else {
            throw new RuntimeException("Invalid ref type: " + refType);
        }
        return refObj;
    }

    public static String joinRefTxts(String ... txts) {
        Assert.check((txts.length >= 2 ? 1 : 0) != 0);
        StringBuilder rslt = new StringBuilder();
        boolean first = true;
        String[] stringArray = txts;
        int n = txts.length;
        int n2 = 0;
        while (n2 < n) {
            String txt = stringArray[n2];
            if (!txt.isEmpty()) {
                if (first) {
                    first = false;
                    rslt.append(txt);
                } else {
                    Assert.check((!txt.startsWith(".") ? 1 : 0) != 0);
                    Assert.check((!txt.startsWith("^") ? 1 : 0) != 0);
                    char lastChar = rslt.charAt(rslt.length() - 1);
                    if (lastChar != '.') {
                        rslt.append('.');
                    }
                    rslt.append(txt);
                }
            }
            ++n2;
        }
        return rslt.toString();
    }

    public static String getUniqueName(String oldName, Set<String> usedNames, Set<String> avoidNames) {
        String newName;
        int nr = 2;
        while (usedNames.contains(newName = String.valueOf(oldName) + String.valueOf(nr)) || avoidNames.contains(newName)) {
            ++nr;
        }
        return newName;
    }

    public static boolean isParamRefExpr(Expression refExpr) {
        if (refExpr instanceof CompParamWrapExpression) {
            return true;
        }
        if (refExpr instanceof CompParamExpression) {
            return true;
        }
        if (refExpr instanceof EventExpression) {
            Event e = ((EventExpression)refExpr).getEvent();
            return e.eContainer() instanceof Parameter;
        }
        if (refExpr instanceof LocationExpression) {
            Location l = ((LocationExpression)refExpr).getLocation();
            return l.eContainer() instanceof Parameter;
        }
        if (refExpr instanceof AlgVariableExpression) {
            AlgVariable a = ((AlgVariableExpression)refExpr).getVariable();
            return a.eContainer() instanceof Parameter;
        }
        return false;
    }

    public static void collectRefExprs(Expression expr, List<Expression> rslt) {
        if (!(expr instanceof BoolExpression || expr instanceof IntExpression || expr instanceof RealExpression || expr instanceof StringExpression || expr instanceof TimeExpression)) {
            if (expr instanceof CastExpression) {
                CifScopeUtils.collectRefExprs(((CastExpression)expr).getChild(), rslt);
            } else if (expr instanceof UnaryExpression) {
                CifScopeUtils.collectRefExprs(((UnaryExpression)expr).getChild(), rslt);
            } else if (expr instanceof BinaryExpression) {
                BinaryExpression bexpr = (BinaryExpression)expr;
                CifScopeUtils.collectRefExprs(bexpr.getLeft(), rslt);
                CifScopeUtils.collectRefExprs(bexpr.getRight(), rslt);
            } else if (expr instanceof IfExpression) {
                IfExpression iexpr = (IfExpression)expr;
                for (Expression guard : iexpr.getGuards()) {
                    CifScopeUtils.collectRefExprs(guard, rslt);
                }
                CifScopeUtils.collectRefExprs(iexpr.getThen(), rslt);
                for (ElifExpression elif : iexpr.getElifs()) {
                    for (Expression guard : elif.getGuards()) {
                        CifScopeUtils.collectRefExprs(guard, rslt);
                    }
                    CifScopeUtils.collectRefExprs(elif.getThen(), rslt);
                }
                CifScopeUtils.collectRefExprs(iexpr.getElse(), rslt);
            } else if (expr instanceof SwitchExpression) {
                SwitchExpression sexpr = (SwitchExpression)expr;
                CifScopeUtils.collectRefExprs(sexpr.getValue(), rslt);
                for (SwitchCase cse : sexpr.getCases()) {
                    if (cse.getKey() != null) {
                        CifScopeUtils.collectRefExprs(cse.getKey(), rslt);
                    }
                    CifScopeUtils.collectRefExprs(cse.getValue(), rslt);
                }
            } else if (expr instanceof ProjectionExpression) {
                ProjectionExpression pexpr = (ProjectionExpression)expr;
                CifScopeUtils.collectRefExprs(pexpr.getChild(), rslt);
                CifScopeUtils.collectRefExprs(pexpr.getIndex(), rslt);
            } else if (expr instanceof SliceExpression) {
                SliceExpression sexpr = (SliceExpression)expr;
                CifScopeUtils.collectRefExprs(sexpr.getChild(), rslt);
                if (sexpr.getBegin() != null) {
                    CifScopeUtils.collectRefExprs(sexpr.getBegin(), rslt);
                }
                if (sexpr.getEnd() != null) {
                    CifScopeUtils.collectRefExprs(sexpr.getEnd(), rslt);
                }
            } else if (expr instanceof FunctionCallExpression) {
                FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
                CifScopeUtils.collectRefExprs(fcexpr.getFunction(), rslt);
                for (Expression param : fcexpr.getParams()) {
                    CifScopeUtils.collectRefExprs(param, rslt);
                }
            } else if (expr instanceof ListExpression) {
                for (Expression elem : ((ListExpression)expr).getElements()) {
                    CifScopeUtils.collectRefExprs(elem, rslt);
                }
            } else if (expr instanceof SetExpression) {
                for (Expression elem : ((SetExpression)expr).getElements()) {
                    CifScopeUtils.collectRefExprs(elem, rslt);
                }
            } else if (expr instanceof TupleExpression) {
                for (Expression elem : ((TupleExpression)expr).getFields()) {
                    CifScopeUtils.collectRefExprs(elem, rslt);
                }
            } else if (expr instanceof DictExpression) {
                for (DictPair pair : ((DictExpression)expr).getPairs()) {
                    CifScopeUtils.collectRefExprs(pair.getKey(), rslt);
                    CifScopeUtils.collectRefExprs(pair.getValue(), rslt);
                }
            } else if (expr instanceof ConstantExpression) {
                rslt.add(expr);
            } else if (expr instanceof DiscVariableExpression) {
                rslt.add(expr);
            } else if (expr instanceof AlgVariableExpression) {
                rslt.add(expr);
            } else if (expr instanceof ContVariableExpression) {
                rslt.add(expr);
            } else if (!(expr instanceof TauExpression)) {
                if (expr instanceof LocationExpression) {
                    rslt.add(expr);
                } else if (expr instanceof EnumLiteralExpression) {
                    rslt.add(expr);
                } else if (expr instanceof EventExpression) {
                    rslt.add(expr);
                } else if (expr instanceof FieldExpression) {
                    rslt.add(expr);
                } else if (!(expr instanceof StdLibFunctionExpression)) {
                    if (expr instanceof FunctionExpression) {
                        rslt.add(expr);
                    } else if (expr instanceof InputVariableExpression) {
                        rslt.add(expr);
                    } else if (expr instanceof ComponentExpression) {
                        rslt.add(expr);
                    } else if (expr instanceof CompParamExpression) {
                        rslt.add(expr);
                    } else if (expr instanceof CompInstWrapExpression) {
                        rslt.add(expr);
                        CompInstWrapExpression wrap = (CompInstWrapExpression)expr;
                        CifScopeUtils.collectRefExprs(wrap.getReference(), rslt);
                    } else if (expr instanceof CompParamWrapExpression) {
                        rslt.add(expr);
                        CompParamWrapExpression wrap = (CompParamWrapExpression)expr;
                        CifScopeUtils.collectRefExprs(wrap.getReference(), rslt);
                    } else if (!(expr instanceof ReceivedExpression)) {
                        if (expr instanceof SelfExpression) {
                            rslt.add(expr);
                        } else {
                            throw new RuntimeException("Unknown expr: " + expr);
                        }
                    }
                }
            }
        }
    }

    public static void changeTypeScope(CifType type, CifType wrapType, PositionObject origScope, PositionObject newScope) {
        PositionObject origRoot;
        boolean addWrapping;
        if (type instanceof BoolType) {
            return;
        }
        if (type instanceof IntType) {
            return;
        }
        if (type instanceof RealType) {
            return;
        }
        if (type instanceof StringType) {
            return;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            CifType etype = ltype.getElementType();
            CifScopeUtils.changeTypeScope(etype, wrapType, origScope, newScope);
            return;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            CifType etype = stype.getElementType();
            CifScopeUtils.changeTypeScope(etype, wrapType, origScope, newScope);
            return;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            CifType rtype = ftype.getReturnType();
            CifScopeUtils.changeTypeScope(rtype, wrapType, origScope, newScope);
            for (CifType ptype : ftype.getParamTypes()) {
                CifScopeUtils.changeTypeScope(ptype, wrapType, origScope, newScope);
            }
            return;
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            CifType ktype = dtype.getKeyType();
            CifType vtype = dtype.getValueType();
            CifScopeUtils.changeTypeScope(ktype, wrapType, origScope, newScope);
            CifScopeUtils.changeTypeScope(vtype, wrapType, origScope, newScope);
            return;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                CifType ftype = field.getType();
                CifScopeUtils.changeTypeScope(ftype, wrapType, origScope, newScope);
            }
            return;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            CifType stype = dtype.getSampleType();
            CifScopeUtils.changeTypeScope(stype, wrapType, origScope, newScope);
            return;
        }
        PositionObject obj = CifScopeUtils.getRefObjFromRef(type);
        PositionObject objScope = CifScopeUtils.getScope(obj);
        PositionObject objRoot = CifScopeUtils.getScopeRoot(objScope);
        boolean bl = addWrapping = objRoot == (origRoot = CifScopeUtils.getScopeRoot(origScope)) && objRoot != obj;
        if (addWrapping) {
            CifType wrapCopy = (CifType)EMFHelper.deepclone((EObject)wrapType);
            EMFHelper.updateParentContainment((EObject)type, (EObject)wrapCopy);
            if (wrapCopy instanceof CompInstWrapType) {
                CompInstWrapType instWrap = (CompInstWrapType)wrapCopy;
                instWrap.setReference(type);
            } else {
                Assert.check((boolean)(wrapCopy instanceof CompParamWrapType));
                CompParamWrapType paramWrap = (CompParamWrapType)wrapCopy;
                paramWrap.setReference(type);
            }
        } else {
            PositionObject newRoot = CifScopeUtils.getScopeRoot(newScope);
            if (newRoot == objRoot) {
                return;
            }
            if (CifScopeUtils.isAncestorScope(objRoot, newRoot)) {
                return;
            }
            throw new RuntimeException("Unexpected reference.");
        }
    }
}

