/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.controllercheck.ControllerCheckDeterminismChecker;
import org.eclipse.escet.cif.controllercheck.ControllerCheckPreChecker;
import org.eclipse.escet.cif.controllercheck.finiteresponse.FiniteResponseChecker;
import org.eclipse.escet.cif.controllercheck.options.PrintControlLoopsOutputOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;

public class ControllerCheckApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ControllerCheckApp app = new ControllerCheckApp();
        app.run(args);
    }

    public ControllerCheckApp() {
    }

    public ControllerCheckApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF controller properties check tool";
    }

    public String getAppDescription() {
        return "Verifies whether a set of CIF automata meet the requirements for a controller.";
    }

    protected int runInternal() {
        OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs().transform(spec);
        new ElimMonitors().transform(spec);
        new ElimSelf().transform(spec);
        new ElimTypeDecls().transform(spec);
        Function<Automaton, String> varNamingFunction = a -> "LP_" + a.getName();
        Function<Automaton, String> enumNamingFunction = a -> "LOCS_" + a.getName();
        Function<Location, String> litNamingFunction = l -> "LOC_" + l.getName();
        boolean considerLocsForRename = true;
        boolean addInitPreds = true;
        boolean optimized = false;
        Map lpVarToAbsAutNameMap = null;
        boolean optInits = true;
        boolean addEdgeGuards = true;
        new ElimLocRefExprs(varNamingFunction, enumNamingFunction, litNamingFunction, true, true, false, lpVarToAbsAutNameMap, true, true).transform(spec);
        new EnumsToInts().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ElimAlgVariables().transform(spec);
        new ElimConsts().transform(spec);
        new SimplifyValues().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ControllerCheckPreChecker().check(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ElimIfUpdates().transform(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        new ControllerCheckDeterminismChecker().check(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        OutputProvider.out((String)"Checking for finite response...");
        boolean finiteResponse = new FiniteResponseChecker().checkSystem(spec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        return finiteResponse ? 0 : 1;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = ControllerCheckApp.getGeneralOptionCategory();
        List checkOpts = Lists.list();
        checkOpts.add(Options.getInstance(InputFileOption.class));
        checkOpts.add(Options.getInstance(PrintControlLoopsOutputOption.class));
        OptionCategory checksCat = new OptionCategory("Checks", "Controller properties check options.", Lists.list(), checkOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, checksCat});
        OptionCategory options = new OptionCategory("CIF Controller properties check Options", "All options for the CIF controller properties check tool.", cats, Lists.list());
        return options;
    }
}

