/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import com.github.javabdd.BDDFactory;
import com.github.javabdd.JFactory;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.datasynth.CifDataSynthesis;
import org.eclipse.escet.cif.datasynth.CifDataSynthesisTiming;
import org.eclipse.escet.cif.datasynth.bdd.BddUtils;
import org.eclipse.escet.cif.datasynth.conversion.CifToSynthesisConverter;
import org.eclipse.escet.cif.datasynth.conversion.SynthesisToCifConverter;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxNodesOption;
import org.eclipse.escet.cif.datasynth.options.BddDebugMaxPathsOption;
import org.eclipse.escet.cif.datasynth.options.BddForceVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddInitNodeTableSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheRatioOption;
import org.eclipse.escet.cif.datasynth.options.BddOpCacheSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputNamePrefixOption;
import org.eclipse.escet.cif.datasynth.options.BddOutputOption;
import org.eclipse.escet.cif.datasynth.options.BddSimplifyOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowSizeOption;
import org.eclipse.escet.cif.datasynth.options.BddSlidingWindowVarOrderOption;
import org.eclipse.escet.cif.datasynth.options.BddVariableOrderOption;
import org.eclipse.escet.cif.datasynth.options.ContinuousPerformanceStatisticsFileOption;
import org.eclipse.escet.cif.datasynth.options.EdgeOrderOption;
import org.eclipse.escet.cif.datasynth.options.EventWarnOption;
import org.eclipse.escet.cif.datasynth.options.ForwardReachOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNameOption;
import org.eclipse.escet.cif.datasynth.options.SupervisorNamespaceOption;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatistics;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatisticsOption;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputMode;
import org.eclipse.escet.common.app.framework.output.OutputModeOption;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifDataSynthesisApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifDataSynthesisApp app = new CifDataSynthesisApp();
        app.run(args);
    }

    public CifDataSynthesisApp() {
    }

    public CifDataSynthesisApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF data-based supervisory controller synthesis tool";
    }

    public String getAppDescription() {
        return "Synthesizes a supervisory controller for a CIF specification with data.";
    }

    protected int runInternal() {
        EnumSet<SynthesisStatistics> stats = SynthesisStatisticsOption.getStatistics();
        boolean doTiming = stats.contains((Object)SynthesisStatistics.TIMING);
        CifDataSynthesisTiming timing = new CifDataSynthesisTiming();
        if (doTiming) {
            timing.total.start();
        }
        try {
            this.doSynthesis(doTiming, timing);
        }
        finally {
            if (doTiming) {
                timing.total.stop();
                timing.print(AppEnv.getData());
            }
        }
        return 0;
    }

    private void doSynthesis(boolean doTiming, CifDataSynthesisTiming timing) {
        Specification rslt;
        Specification spec;
        String supName = SupervisorNameOption.getSupervisorName("sup");
        String supNamespace = SupervisorNamespaceOption.getNamespace();
        boolean dbgEnabled = OutputModeOption.getOutputMode() == OutputMode.DEBUG;
        String inputPath = InputFileOption.getPath();
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Reading CIF file \"%s\".", (Object[])new Object[]{inputPath});
        }
        CifReader cifReader = (CifReader)new CifReader().init();
        if (doTiming) {
            timing.inputRead.start();
        }
        try {
            spec = (Specification)cifReader.read();
        }
        finally {
            if (doTiming) {
                timing.inputRead.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Preprocessing CIF specification.");
        }
        if (doTiming) {
            timing.inputPreProcess.start();
        }
        try {
            RemoveIoDecls removeIoDecls = new RemoveIoDecls();
            removeIoDecls.transform(spec);
            if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
                OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
            }
            new ElimComponentDefInst().transform(spec);
        }
        finally {
            if (doTiming) {
                timing.inputPreProcess.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
        int bddTableSize = BddInitNodeTableSizeOption.getInitialSize();
        Integer bddCacheSize = BddOpCacheSizeOption.getCacheSize();
        double bddCacheRatio = BddOpCacheRatioOption.getCacheRatio();
        if (bddCacheSize == null) {
            bddCacheSize = (int)((double)bddTableSize * bddCacheRatio);
            if (bddCacheSize < 2) {
                bddCacheSize = 2;
            }
        } else {
            bddCacheRatio = -1.0;
        }
        BDDFactory factory = JFactory.init((int)bddTableSize, (int)bddCacheSize);
        if (bddCacheRatio != -1.0) {
            factory.setCacheRatio(bddCacheRatio);
        }
        EnumSet<SynthesisStatistics> stats = SynthesisStatisticsOption.getStatistics();
        boolean doGcStats = stats.contains((Object)SynthesisStatistics.BDD_GC_COLLECT);
        boolean doResizeStats = stats.contains((Object)SynthesisStatistics.BDD_GC_RESIZE);
        BddUtils.setBddCallbacks(factory, doGcStats, doResizeStats);
        boolean doCacheStats = stats.contains((Object)SynthesisStatistics.BDD_PERF_CACHE);
        boolean doContinuousPerformanceStats = stats.contains((Object)SynthesisStatistics.BDD_PERF_CONT);
        boolean doMaxBddNodesStats = stats.contains((Object)SynthesisStatistics.BDD_PERF_MAX_NODES);
        if (doCacheStats || doContinuousPerformanceStats) {
            factory.getCacheStats().enableMeasurements();
        }
        if (doContinuousPerformanceStats) {
            factory.getContinuousStats().enableMeasurements();
        }
        if (doMaxBddNodesStats) {
            factory.getMaxUsedBddNodesStats().enableMeasurements();
        }
        try {
            SynthesisAutomaton aut;
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Converting CIF specification to internal format.");
            }
            CifToSynthesisConverter converter1 = new CifToSynthesisConverter();
            if (doTiming) {
                timing.inputConvert.start();
            }
            try {
                aut = converter1.convert(spec, factory, dbgEnabled);
            }
            finally {
                if (doTiming) {
                    timing.inputConvert.stop();
                }
            }
            if (this.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Starting data-based synthesis.");
            }
            CifDataSynthesis.synthesize(aut, dbgEnabled, doTiming, timing);
            if (this.isTerminationRequested()) {
                return;
            }
            if (dbgEnabled) {
                OutputProvider.dbg((String)"Constructing output CIF specification.");
            }
            SynthesisToCifConverter converter2 = new SynthesisToCifConverter();
            if (doTiming) {
                timing.outputConvert.start();
            }
            try {
                rslt = converter2.convert(aut, spec, supName, supNamespace);
            }
            finally {
                if (doTiming) {
                    timing.outputConvert.stop();
                }
            }
            if (this.isTerminationRequested()) {
                return;
            }
            if (doCacheStats) {
                this.printBddCacheStats(factory.getCacheStats());
            }
            if (doContinuousPerformanceStats) {
                this.printBddContinuousPerformanceStats(factory.getContinuousStats());
            }
            if (doMaxBddNodesStats) {
                OutputProvider.out((String)Strings.fmt((String)"Maximum used BDD nodes: %d.", (Object[])new Object[]{factory.getMaxUsedBddNodesStats().getMaxUsedBddNodes()}));
            }
            if (this.isTerminationRequested()) {
                return;
            }
        }
        finally {
            factory.done();
        }
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".ctrlsys.cif");
        if (dbgEnabled) {
            OutputProvider.dbg((String)"Writing output CIF file \"%s\".", (Object[])new Object[]{outPath});
        }
        outPath = Paths.resolve((String)outPath);
        if (doTiming) {
            timing.outputWrite.start();
        }
        try {
            CifWriter.writeCifSpec((Specification)rslt, (String)outPath, (String)cifReader.getAbsDirPath());
        }
        finally {
            if (doTiming) {
                timing.outputWrite.stop();
            }
        }
        if (this.isTerminationRequested()) {
            return;
        }
    }

    private void printBddCacheStats(BDDFactory.CacheStats stats) {
        GridBox grid = new GridBox(7, 2, 0, 1);
        grid.set(0, 0, "Node creation requests:");
        grid.set(1, 0, "Node creation chain accesses:");
        grid.set(2, 0, "Node creation cache hits:");
        grid.set(3, 0, "Node creation cache misses:");
        grid.set(4, 0, "Operation count:");
        grid.set(5, 0, "Operation cache hits:");
        grid.set(6, 0, "Operation cache misses:");
        grid.set(0, 1, Strings.str((Object)stats.uniqueAccess));
        grid.set(1, 1, Strings.str((Object)stats.uniqueChain));
        grid.set(2, 1, Strings.str((Object)stats.uniqueHit));
        grid.set(3, 1, Strings.str((Object)stats.uniqueMiss));
        grid.set(4, 1, Strings.str((Object)stats.opAccess));
        grid.set(5, 1, Strings.str((Object)stats.opHit));
        grid.set(6, 1, Strings.str((Object)stats.opMiss));
        OutputProvider.out((String)"BDD cache statistics:");
        for (String line : grid.getLines()) {
            OutputProvider.out((String)("  " + line));
        }
    }

    private void printBddContinuousPerformanceStats(BDDFactory.ContinuousStats stats) {
        List operations = stats.getOperationsStats();
        List nodes = stats.getNodesStats();
        int numberOfDataPoints = nodes.size();
        String outPath = ContinuousPerformanceStatisticsFileOption.getPath();
        OutputProvider.dbg((String)"Writing continuous BDD performance statistics file \"%s\".", (Object[])new Object[]{outPath});
        String absOutPath = Paths.resolve((String)outPath);
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileAppStream stream = new FileAppStream(outPath, absOutPath);){
            stream.println("Operations,Used BBD nodes");
            long lastOperations = -1L;
            int lastNodes = -1;
            int i = 0;
            while (i < numberOfDataPoints) {
                long nextOperations = (Long)operations.get(i);
                int nextNodes = (Integer)nodes.get(i);
                if (nextOperations != lastOperations || nextNodes != lastNodes) {
                    lastOperations = nextOperations;
                    lastNodes = nextNodes;
                    stream.printfln("%d,%d", new Object[]{lastOperations, lastNodes});
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifDataSynthesisApp.getGeneralOptionCategory();
        List bddOpts = Lists.list();
        bddOpts.add(Options.getInstance(BddOutputOption.class));
        bddOpts.add(Options.getInstance(BddOutputNamePrefixOption.class));
        bddOpts.add(Options.getInstance(BddVariableOrderOption.class));
        bddOpts.add(Options.getInstance(BddForceVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowVarOrderOption.class));
        bddOpts.add(Options.getInstance(BddSlidingWindowSizeOption.class));
        bddOpts.add(Options.getInstance(BddSimplifyOption.class));
        bddOpts.add(Options.getInstance(BddInitNodeTableSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheSizeOption.class));
        bddOpts.add(Options.getInstance(BddOpCacheRatioOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxNodesOption.class));
        bddOpts.add(Options.getInstance(BddDebugMaxPathsOption.class));
        OptionCategory bddCat = new OptionCategory("BDD", "BDD options.", Lists.list(), bddOpts);
        List synthOpts = Lists.list();
        synthOpts.add(Options.getInstance(InputFileOption.class));
        synthOpts.add(Options.getInstance(OutputFileOption.class));
        synthOpts.add(Options.getInstance(SupervisorNameOption.class));
        synthOpts.add(Options.getInstance(SupervisorNamespaceOption.class));
        synthOpts.add(Options.getInstance(ForwardReachOption.class));
        synthOpts.add(Options.getInstance(EdgeOrderOption.class));
        synthOpts.add(Options.getInstance(SynthesisStatisticsOption.class));
        synthOpts.add(Options.getInstance(ContinuousPerformanceStatisticsFileOption.class));
        synthOpts.add(Options.getInstance(EventWarnOption.class));
        OptionCategory synthCat = new OptionCategory("Synthesis", "Synthesis options.", Lists.list((Object)bddCat), synthOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, synthCat});
        OptionCategory options = new OptionCategory("CIF Data-based Synthesis Options", "All options for the CIF data-based supervisory controller synthesis tool.", cats, Lists.list());
        return options;
    }
}

