/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.eventbased.analysis.AnalysisListHandler;
import org.eclipse.escet.cif.eventbased.analysis.AnalysisReportHandler;
import org.eclipse.escet.cif.eventbased.analysis.AnalysisSearchHandler;
import org.eclipse.escet.cif.eventbased.analysis.DumpfileData;
import org.eclipse.escet.cif.eventbased.analysis.DumpfileLoader;
import org.eclipse.escet.cif.eventbased.analysis.EdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.EventInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedEdgeInfo;
import org.eclipse.escet.cif.eventbased.analysis.RemovedLocationInfo;
import org.eclipse.escet.cif.eventbased.analysis.StateInfo;
import org.eclipse.escet.cif.eventbased.analysis.StateOverview;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.ColoredText;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.SimpleText;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Exceptions;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SynthesisAnalysisEditor
extends ControlEditor {
    private Composite root;
    private ScrolledComposite scrolledLists = null;
    private Composite automataArea = null;
    public DumpfileData data = null;
    private List<AnalysisListHandler> listSelections = Lists.list();
    private AnalysisSearchHandler buttons = null;
    private AnalysisReportHandler reportArea = null;
    private List<Integer> searchHistory = Lists.list();
    public Color greenColor = null;
    public Color redColor = null;
    public Color linkColor = null;

    public static String makeCountText(int count, String text, String singular, String multilar) {
        if (count == 1) {
            return Strings.fmt((String)text, (Object[])new Object[]{count, singular});
        }
        return Strings.fmt((String)text, (Object[])new Object[]{count, multilar});
    }

    private Composite buildWidgets(Composite parent) {
        this.root = new Composite(parent, 0);
        GridLayout automataGrid = new GridLayout(2, false);
        this.root.setLayout((Layout)automataGrid);
        this.scrolledLists = new ScrolledComposite(this.root, 512);
        this.automataArea = new Composite((Composite)this.scrolledLists, 0);
        this.scrolledLists.setContent((Control)this.automataArea);
        this.scrolledLists.setVisible(false);
        GridLayout listLayout = new GridLayout(1, false);
        this.automataArea.setLayout((Layout)listLayout);
        this.automataArea.setSize(this.automataArea.computeSize(-1, -1));
        GridData gridData = new GridData(4, 4, false, true);
        gridData.verticalSpan = 2;
        this.scrolledLists.setLayoutData((Object)gridData);
        this.scrolledLists.pack();
        this.buttons = new AnalysisSearchHandler(this.root);
        this.reportArea = new AnalysisReportHandler(this.root);
        this.root.pack();
        return this.root;
    }

    private void buildAutomataColumn() {
        int numAuts = this.data.getNumberAutomata();
        int numPlants = this.data.getNumberPlants();
        int autIndex = 0;
        while (autIndex < numAuts) {
            int preIndent = (autIndex != 0 ? 10 : 0) + (autIndex == numPlants ? 40 : 0);
            AnalysisListHandler locList = new AnalysisListHandler(this.automataArea, preIndent, this.data.sourceInfo.sourceInfo.get(autIndex));
            this.listSelections.add(locList);
            ++autIndex;
        }
        this.automataArea.pack();
        this.scrolledLists.setVisible(true);
        this.root.layout(true, true);
    }

    public void clickedResetState() {
        if (this.data == null) {
            return;
        }
        for (AnalysisListHandler alh : this.listSelections) {
            alh.setValue(0);
        }
        this.clickedSearch(false);
    }

    public void clickedSearch(boolean goBack) {
        int state;
        if (this.data == null) {
            return;
        }
        if (goBack && this.searchHistory.size() > 1) {
            this.searchHistory.remove(this.searchHistory.size() - 1);
            state = (Integer)Lists.last(this.searchHistory);
        } else {
            for (AnalysisListHandler handler : this.listSelections) {
                Assert.check((handler.value >= 0 ? 1 : 0) != 0);
            }
            StateInfo found = this.findSelectedState();
            if (found == null) {
                this.reportArea.setResult(new SimpleText("No information about the queried state found, it was never created."));
                return;
            }
            state = found.targetState;
            if (this.searchHistory.isEmpty() || (Integer)Lists.last(this.searchHistory) != state) {
                this.searchHistory.add(state);
            }
        }
        this.buttons.setEnableBack(this.searchHistory.size() > 1);
        int count = this.buttons.getNumberIntermediateStates();
        boolean displayFullState = this.buttons.getFullStateDisplayed();
        boolean displayControllables = this.buttons.getDisabledControllablesDisplayed();
        boolean displayPlant = this.buttons.getPlantRemovedDisplayed();
        StateOverview overview = this.getOverview(state, displayPlant, true);
        List header = Lists.list();
        header.add(new SimpleText("Analysis of "));
        header.addAll(overview.getStateText(overview.locInfo.targetState, true));
        header.add(new SimpleText(":\r\n\r\n"));
        this.reportArea.setResult(header);
        this.reportArea.addResult(overview.makeDescription(displayFullState, displayControllables));
        int skipCount = 0;
        while ((state = overview.getSuccessorState()) >= 0) {
            overview = this.getOverview(state, displayPlant, false);
            if (count > 0) {
                this.reportArea.addResult(new SimpleText("\r\n"));
                this.reportArea.addResult(overview.makeDescription(displayFullState, displayControllables));
                --count;
                continue;
            }
            ++skipCount;
        }
        if (skipCount > 0) {
            if (skipCount > 1) {
                this.reportArea.addResult(new SimpleText(Strings.fmt((String)"\r\n(Skipped reporting of %d states.)\r\n\r\n", (Object[])new Object[]{skipCount - 1})));
            }
            this.reportArea.addResult(overview.makeDescription(displayFullState, displayControllables));
        }
        this.reportArea.addResult(new SimpleText("\r\nDone.\r\n"));
    }

    private StateOverview getOverview(int state, boolean displayPlant, boolean expandEdges) {
        if (state < 0 || state >= this.data.states.size() || this.data.states.get(state) == null) {
            return null;
        }
        StateOverview overview = new StateOverview(this, this.data.states.get(state));
        for (Object calcEvent : this.data.calculationEvents) {
            if (calcEvent instanceof RemovedEdgeInfo) {
                boolean notPlantInduced;
                RemovedEdgeInfo removedEdge = (RemovedEdgeInfo)calcEvent;
                if (removedEdge.from != state) continue;
                EventInfo evtInfo = this.data.events.get(removedEdge.event);
                boolean bl = notPlantInduced = !removedEdge.toIsAutomaton || removedEdge.to >= this.data.getNumberPlants();
                if (evtInfo.contr) {
                    if (!displayPlant && !notPlantInduced) continue;
                    overview.removedControllables.add(removedEdge);
                    continue;
                }
                if (displayPlant || notPlantInduced) {
                    overview.removedUncontrollables.add(removedEdge);
                }
                if (!notPlantInduced || overview.killerRemovedEdge != null) continue;
                overview.killerRemovedEdge = removedEdge;
                continue;
            }
            if (calcEvent instanceof RemovedLocationInfo) {
                RemovedLocationInfo removedState = (RemovedLocationInfo)calcEvent;
                if (removedState.loc != state) continue;
                overview.removedState = removedState;
                break;
            }
            Assert.fail((Object)"Unexpected kind of calculation event found.");
            break;
        }
        if (expandEdges && overview.locInfo.outEdges != null && overview.removedState == null) {
            int[] edges = new int[this.data.events.size()];
            Arrays.fill(edges, -1);
            for (EdgeInfo edgeInfo : overview.locInfo.outEdges) {
                edges[edgeInfo.event] = edgeInfo.destLoc;
            }
            for (RemovedEdgeInfo removed : overview.removedControllables) {
                edges[removed.event] = -1;
            }
            for (RemovedEdgeInfo removed : overview.removedUncontrollables) {
                edges[removed.event] = -1;
            }
            overview.outEdges = edges;
        }
        return overview;
    }

    private StateInfo findSelectedState() {
        int[] locs = new int[this.listSelections.size()];
        int autIndex = 0;
        while (autIndex < this.listSelections.size()) {
            locs[autIndex] = this.listSelections.get((int)autIndex).value;
            ++autIndex;
        }
        Integer stateNum = this.data.sortedStates.get(locs);
        if (stateNum == null) {
            return null;
        }
        return this.data.states.get(stateNum);
    }

    public void setSelectedState(int stateNumber) {
        if (stateNumber < 0 || stateNumber >= this.data.states.size()) {
            return;
        }
        StateInfo stateInfo = this.data.states.get(stateNumber);
        int autIndex = 0;
        while (autIndex < this.listSelections.size()) {
            this.listSelections.get(autIndex).setValue(stateInfo.srcLocs[autIndex]);
            ++autIndex;
        }
        this.clickedSearch(false);
    }

    protected Control createContents(Composite parent) {
        String absFilename = this.input.getAbsoluteFilePath();
        String filename = Paths.getFileName((String)absFilename);
        int dirPrefix = absFilename.length() - filename.length();
        while (dirPrefix > 0 && (absFilename.charAt(dirPrefix - 1) == '/' || absFilename.charAt(dirPrefix - 1) == '\\')) {
            --dirPrefix;
        }
        if (dirPrefix == 0) {
            dirPrefix = absFilename.length();
        }
        this.setContentDescription(absFilename.substring(0, dirPrefix));
        this.setPartName(filename);
        this.greenColor = new Color(154, 205, 50);
        this.redColor = parent.getDisplay().getSystemColor(3);
        this.linkColor = new Color(135, 206, 250);
        Composite root = this.buildWidgets(parent);
        DumpfileLoader loader = new DumpfileLoader(absFilename, this);
        Thread loaderThread = new Thread((Runnable)loader, loader.getClass().getName());
        loaderThread.start();
        return root;
    }

    public void loadingFinished(DumpfileData data, Exception ex) {
        if (!this.isAvailable()) {
            return;
        }
        if (data == null) {
            List report = Lists.list();
            report.add(new ColoredText(Strings.fmt((String)"Loading of file \"%s\" failed!\r\n", (Object[])new Object[]{this.input.getAbsoluteFilePath()}), this.redColor));
            if (ex != null) {
                report.add(new SimpleText("\r\nReason:\r\n" + Exceptions.exToStr((Throwable)ex) + "\r\n"));
            }
            this.reportArea.setResult(report);
            return;
        }
        this.data = data;
        this.buttons.setApplication(this);
        this.reportArea.setApplication(this);
        this.buildAutomataColumn();
        this.buttons.setEnableBack(this.searchHistory.size() > 1);
    }
}

