/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.cif.simulator.output.plotviz.MaterialUiColors600;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerCanvas;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerDataSeries;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerRange;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerUpdateData;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerUpdateDataEntry;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerUpdateThread;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.eclipse.ui.MsgBox;
import org.eclipse.escet.common.eclipse.ui.SelectionListenerBase;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Exceptions;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.style.MatlabTheme;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class PlotVisualizer
extends ControlEditor {
    private XYChart chart;
    private PlotVisualizerCanvas canvas;
    public List<PlotVisualizerDataSeries> varDatas;
    public PlotVisualizerRange rangeX;
    private PlotVisualizerUpdateThread thread;

    protected Control createContents(Composite parent) {
        this.chart = new XYChartBuilder().build();
        this.chart.setXAxisTitle("time");
        XYStyler styler = (XYStyler)this.chart.getStyler();
        styler.setTheme((Theme)new MatlabTheme());
        styler.setAntiAlias(true);
        styler.setChartPadding(15);
        styler.setLegendBorderColor(ChartColor.getAWTColor((ChartColor)ChartColor.DARK_GREY));
        styler.setLegendFont(((XYStyler)this.chart.getStyler()).getAxisTitleFont());
        styler.setLegendLayout(Styler.LegendLayout.Horizontal);
        styler.setLegendPadding(7);
        styler.setLegendPosition(Styler.LegendPosition.OutsideS);
        styler.setPlotContentSize(1.0);
        styler.setPlotGridLinesColor(new Color(245, 245, 245));
        styler.setPlotGridLinesStroke((Stroke)new BasicStroke());
        styler.setPlotBackgroundColor(new Color(252, 252, 252));
        styler.setSeriesMarkers(new Marker[]{SeriesMarkers.NONE});
        styler.setSeriesLines(new BasicStroke[]{SeriesLines.SOLID});
        styler.setSeriesColors(MaterialUiColors600.COLORS);
        styler.setXAxisMin(Double.valueOf(0.0));
        styler.setYAxisLabelAlignment(Styler.TextAlignment.Centre);
        this.canvas = new PlotVisualizerCanvas(parent, this.chart);
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 0);
        tableData.right = new FormAttachment(100, 0);
        tableData.top = new FormAttachment(0, 0);
        tableData.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData(tableData);
        Menu popupMenu = new Menu((Control)parent);
        final MenuItem saveItem = new MenuItem(popupMenu, 0);
        saveItem.setEnabled(this.isSaveAsAllowed());
        saveItem.setText("Save as...");
        this.canvas.setMenu(popupMenu);
        popupMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                saveItem.setEnabled(PlotVisualizer.this.isSaveAsAllowed());
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        saveItem.addSelectionListener((SelectionListener)new SelectionListenerBase(){

            public void widgetSelected(SelectionEvent e) {
                PlotVisualizer.this.doSaveAs();
            }
        });
        if (this.thread == null) {
            this.thread = new PlotVisualizerUpdateThread(this.chart, this.canvas);
            this.thread.start();
        }
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUpdate() {
        List updateEntries = Lists.listc((int)this.varDatas.size());
        for (PlotVisualizerDataSeries varData : this.varDatas) {
            double[] xValues = varData.getXValuesArray();
            double[] yValues = varData.getYValuesArray();
            updateEntries.add(new PlotVisualizerUpdateDataEntry(varData.meta.name, xValues, yValues));
        }
        PlotVisualizerUpdateData updateData = new PlotVisualizerUpdateData(updateEntries);
        AtomicBoolean atomicBoolean = this.thread.updateRequested;
        synchronized (atomicBoolean) {
            this.thread.updateData.set(updateData);
            this.thread.updateRangeX.set(this.rangeX);
            this.thread.updateRequested.set(true);
            this.thread.updateRequested.notify();
        }
    }

    public void initVarDatas(List<RuntimeStateObjectMeta> metas) {
        this.varDatas = Lists.listc((int)metas.size());
        for (RuntimeStateObjectMeta meta : metas) {
            this.varDatas.add(new PlotVisualizerDataSeries(meta));
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        if (this.varDatas == null || this.varDatas.isEmpty()) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save plot as", (String)"No data available.");
            return;
        }
        if (((PlotVisualizerDataSeries)Lists.first(this.varDatas)).points.size() < 2) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save plot as", (String)"Not enough data available.");
            return;
        }
        String path = this.input.getAbsoluteFilePath();
        int idx = Math.max(path.lastIndexOf(92), path.lastIndexOf(47));
        Assert.check((idx > 0 ? 1 : 0) != 0);
        path = path.substring(0, idx);
        String fileName = Paths.getFileName((String)this.input.getAbsoluteFilePath());
        fileName = Paths.pathChangeExtension((String)fileName, (String)"cif", (String)"plot.png");
        FileDialog fd = new FileDialog(this.contents.getShell(), 8192);
        fd.setText("Save plot as");
        fd.setFilterPath(path);
        fd.setFilterExtensions(new String[]{"*.png;*.jpg;*.gif"});
        fd.setFileName(fileName);
        fd.setOverwrite(true);
        String savePath = fd.open();
        if (savePath == null || savePath.trim().length() == 0) {
            return;
        }
        File saveFile = new File(savePath);
        Assert.check((boolean)saveFile.isAbsolute());
        if (!(savePath.endsWith(".png") || savePath.endsWith(".jpg") || savePath.endsWith(".gif"))) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save plot as", (String)"Invalid file extension: use .png, .jpg, or .gif.");
            return;
        }
        String imgFormat = Strings.slice((String)savePath, (Integer)-3, null);
        IInputValidator sizeValidator = new IInputValidator(){

            public String isValid(String newText) {
                int idx = newText.indexOf("x");
                if (idx == -1) {
                    return "Missing \"x\" between width and height.";
                }
                String widthTxt = newText.substring(0, idx);
                try {
                    int i = Integer.parseInt(widthTxt);
                    if (i <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException ex) {
                    return Strings.fmt((String)"Invalid width \"%s\".", (Object[])new Object[]{widthTxt});
                }
                String heightTxt = newText.substring(idx + 1);
                try {
                    int i = Integer.parseInt(heightTxt);
                    if (i <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException ex) {
                    return Strings.fmt((String)"Invalid height \"%s\".", (Object[])new Object[]{heightTxt});
                }
                return null;
            }
        };
        Point lastSize = this.canvas.getLastSize();
        int width = lastSize == null ? 1000 : lastSize.x;
        int height = lastSize == null ? 800 : lastSize.y;
        String sizeTxt = String.valueOf(Strings.str((Object)width)) + "x" + Strings.str((Object)height);
        InputDialog id = new InputDialog(this.contents.getShell(), "Save plot as", "Specify size of image, e.g. 640x480:", sizeTxt, sizeValidator);
        int idRslt = id.open();
        if (idRslt == 1) {
            return;
        }
        sizeTxt = id.getValue();
        idx = sizeTxt.indexOf("x");
        width = Integer.parseInt(sizeTxt.substring(0, idx));
        height = Integer.parseInt(sizeTxt.substring(idx + 1));
        try {
            BufferedImage image = new BufferedImage(width, height, 5);
            Graphics2D graphics = image.createGraphics();
            this.canvas.paint(graphics, width, height);
            graphics.dispose();
            boolean rslt = ImageIO.write((RenderedImage)image, imgFormat, saveFile);
            if (!rslt) {
                String msg = Strings.fmt((String)"Failed to save image to \"%s\": unknown or unsupported file extension.", (Object[])new Object[]{savePath});
                throw new IOException(msg);
            }
        }
        catch (NullPointerException e) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save plot as", (String)"Failed to save image.");
            return;
        }
        catch (IOException e) {
            MsgBox.show((Shell)this.contents.getShell(), (int)33, (String)"Save plot as", (String)("Failed to save image." + Strings.NL + Strings.NL + Exceptions.exToStr((Throwable)e)));
            return;
        }
        if (Platform.isRunning() && PlatformUI.isWorkbenchRunning()) {
            IContainer[] dirs;
            URI saveDirUri = saveFile.getParentFile().toURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IContainer[] iContainerArray = dirs = root.findContainersForLocationURI(saveDirUri);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer dir = iContainerArray[n2];
                try {
                    dir.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }
}

