/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.multivaluetrees;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.VarInfo;
import org.eclipse.escet.common.multivaluetrees.VariableReplacement;

public class Tree {
    public static final Node ZERO;
    public static final Node ONE;
    private final WeakHashMap<Node, WeakReference<Node>> nodeTable = new WeakHashMap();

    static {
        Node[] noChilds = new Node[]{};
        ZERO = new Node(new VarInfo(-1, null, 0, 0, 0), noChilds);
        ONE = new Node(new VarInfo(-2, null, 0, 0, 0), noChilds);
    }

    private Node addNode(VarInfo varInfo, Node[] childs) {
        Node child = childs[0];
        int i = 1;
        while (i < childs.length) {
            if (child != childs[i]) {
                Node node = new Node(varInfo, childs);
                WeakReference<Node> value = this.nodeTable.get(node);
                if (value == null) {
                    this.nodeTable.put(node, new WeakReference<Node>(node));
                    return node;
                }
                node = (Node)value.get();
                Assert.notNull((Object)node);
                return node;
            }
            ++i;
        }
        return child;
    }

    public String dumpGraph(Node n) {
        StringBuilder sb = new StringBuilder();
        int freeNum = 1;
        Map foundNodes = Maps.map();
        ArrayDeque<Node> notPrinted = new ArrayDeque<Node>();
        foundNodes.put(n, String.valueOf(freeNum++));
        foundNodes.put(ONE, "*TRUE*");
        foundNodes.put(ZERO, "*FALSE*");
        notPrinted.add(n);
        while (!notPrinted.isEmpty()) {
            Node a = (Node)notPrinted.poll();
            String name = (String)foundNodes.get(a);
            if (a == ONE || a == ZERO) {
                sb.append(Strings.fmt((String)"%s\n", (Object[])new Object[]{name}));
                continue;
            }
            sb.append(Strings.fmt((String)"%s (%s):", (Object[])new Object[]{name, a.varInfo.toString()}));
            Node[] nodeArray = a.childs;
            int n2 = a.childs.length;
            int n3 = 0;
            while (n3 < n2) {
                Node c = nodeArray[n3];
                name = (String)foundNodes.get(c);
                if (name == null) {
                    name = String.valueOf(freeNum++);
                    foundNodes.put(c, name);
                    notPrinted.add(c);
                }
                sb.append(' ');
                sb.append(name);
                ++n3;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public Node buildEqualityValue(VarInfo varInfo, int value) {
        return this.buildEqualityIndex(varInfo, value - varInfo.lower);
    }

    public Node buildEqualityIndex(VarInfo varInfo, int index) {
        return this.buildEqualityIndex(varInfo, index, ONE);
    }

    public Node buildEqualityIndex(VarInfo varInfo, int index, Node sub) {
        Assert.check((sub == ZERO || sub == ONE || sub.varInfo.level > varInfo.level ? 1 : 0) != 0);
        Object[] childs = new Node[varInfo.length];
        Arrays.fill(childs, ZERO);
        childs[index] = sub;
        return this.addNode(varInfo, (Node[])childs);
    }

    public Node conjunct(Node a, Node b) {
        if (a == b) {
            return a;
        }
        if (a == ZERO || b == ZERO) {
            return ZERO;
        }
        if (a == ONE) {
            return b;
        }
        if (b == ONE) {
            return a;
        }
        int aLevel = a.varInfo.level;
        int bLevel = b.varInfo.level;
        if (aLevel == bLevel) {
            return this.addNode(a.varInfo, this.conjunctChilds(a.childs, b.childs));
        }
        if (aLevel < bLevel) {
            return this.addNode(a.varInfo, this.conjunctChilds(a.childs, b));
        }
        return this.addNode(b.varInfo, this.conjunctChilds(b.childs, a));
    }

    private Node[] conjunctChilds(Node[] aChilds, Node[] bChilds) {
        Node[] childs = new Node[aChilds.length];
        int i = 0;
        while (i < aChilds.length) {
            if (childs[i] == null) {
                Node n;
                childs[i] = n = this.conjunct(aChilds[i], bChilds[i]);
                int j = i + 1;
                while (j < aChilds.length) {
                    if (aChilds[j] == aChilds[i] && bChilds[j] == bChilds[i]) {
                        childs[j] = n;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return childs;
    }

    private Node[] conjunctChilds(Node[] aChilds, Node bNode) {
        Node[] childs = new Node[aChilds.length];
        int i = 0;
        while (i < aChilds.length) {
            if (childs[i] == null) {
                Node n;
                childs[i] = n = this.conjunct(aChilds[i], bNode);
                int j = i + 1;
                while (j < aChilds.length) {
                    if (aChilds[j] == aChilds[i]) {
                        childs[j] = n;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return childs;
    }

    public Node multiConjunct(Node ... nodes) {
        Assert.check((nodes.length > 0 ? 1 : 0) != 0);
        BitSet skipNodes = new BitSet(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == ZERO) {
                return nodes[i];
            }
            if (nodes[i] == ONE) {
                skipNodes.set(i);
            } else {
                int j = 0;
                while (j < i) {
                    if (nodes[j] == nodes[i]) {
                        skipNodes.set(i);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Node result = nodes[0];
        int i2 = 1;
        while (i2 < nodes.length) {
            if (!skipNodes.get(i2)) {
                result = this.conjunct(result, nodes[i2]);
            }
            ++i2;
        }
        return result;
    }

    public Node disjunct(Node a, Node b) {
        if (a == b) {
            return a;
        }
        if (a == ZERO) {
            return b;
        }
        if (b == ZERO) {
            return a;
        }
        if (a == ONE) {
            return a;
        }
        if (b == ONE) {
            return b;
        }
        int aLevel = a.varInfo.level;
        int bLevel = b.varInfo.level;
        if (aLevel == bLevel) {
            return this.addNode(a.varInfo, this.disjunctChilds(a.childs, b.childs));
        }
        if (aLevel < bLevel) {
            return this.addNode(a.varInfo, this.disjunctChilds(a.childs, b));
        }
        return this.addNode(b.varInfo, this.disjunctChilds(b.childs, a));
    }

    private Node[] disjunctChilds(Node[] aChilds, Node[] bChilds) {
        Node[] childs = new Node[aChilds.length];
        int i = 0;
        while (i < aChilds.length) {
            if (childs[i] == null) {
                Node n;
                childs[i] = n = this.disjunct(aChilds[i], bChilds[i]);
                int j = i + 1;
                while (j < aChilds.length) {
                    if (aChilds[j] == aChilds[i] && bChilds[j] == bChilds[i]) {
                        childs[j] = n;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return childs;
    }

    private Node[] disjunctChilds(Node[] aChilds, Node bNode) {
        Node[] childs = new Node[aChilds.length];
        int i = 0;
        while (i < aChilds.length) {
            if (childs[i] == null) {
                Node n;
                childs[i] = n = this.disjunct(aChilds[i], bNode);
                int j = i + 1;
                while (j < aChilds.length) {
                    if (aChilds[j] == aChilds[i]) {
                        childs[j] = n;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return childs;
    }

    public Node multiDisjunct(Node ... nodes) {
        Assert.check((nodes.length > 0 ? 1 : 0) != 0);
        BitSet skipNodes = new BitSet(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] == ONE) {
                return nodes[i];
            }
            if (nodes[i] == ZERO) {
                skipNodes.set(i);
            } else {
                int j = 0;
                while (j < i) {
                    if (nodes[j] == nodes[i]) {
                        skipNodes.set(i);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Node result = nodes[0];
        int i2 = 1;
        while (i2 < nodes.length) {
            if (!skipNodes.get(i2)) {
                result = this.disjunct(result, nodes[i2]);
            }
            ++i2;
        }
        return result;
    }

    public Node invert(Node n) {
        if (n == ONE) {
            return ZERO;
        }
        if (n == ZERO) {
            return ONE;
        }
        Node[] childs = new Node[n.childs.length];
        int i = 0;
        while (i < childs.length) {
            childs[i] = this.invert(n.childs[i]);
            ++i;
        }
        return this.addNode(n.varInfo, childs);
    }

    public Node variableAbstractions(Node n, VarInfo[] abstractions) {
        if (abstractions.length == 0) {
            return n;
        }
        int prev = -1;
        VarInfo[] varInfoArray = abstractions;
        int n2 = abstractions.length;
        int n3 = 0;
        while (n3 < n2) {
            VarInfo abstraction = varInfoArray[n3];
            Assert.check((abstraction.level > prev ? 1 : 0) != 0);
            prev = abstraction.level;
            ++n3;
        }
        return this.abstractVariables(n, 0, abstractions);
    }

    private Node abstractVariables(Node n, int abstractionIndex, VarInfo[] abstractions) {
        if (abstractionIndex >= abstractions.length) {
            return n;
        }
        if (n == ZERO || n == ONE) {
            return n;
        }
        int level = n.varInfo.level;
        while (level > abstractions[abstractionIndex].level) {
            if (++abstractionIndex != abstractions.length) continue;
            return n;
        }
        Node[] childs = new Node[n.childs.length];
        int i = 0;
        while (i < n.childs.length) {
            childs[i] = this.abstractVariables(n.childs[i], abstractionIndex, abstractions);
            ++i;
        }
        if (level < abstractions[abstractionIndex].level) {
            return this.addNode(n.varInfo, childs);
        }
        return this.multiDisjunct(childs);
    }

    public Node assign(Node n, VarInfo varInfo, int index) {
        Assert.check((index >= 0 && index < varInfo.length ? 1 : 0) != 0);
        if (n == ZERO || n == ONE) {
            return n;
        }
        if (n.varInfo.level > varInfo.level) {
            return n;
        }
        if (n.varInfo.level == varInfo.level) {
            return n.childs[index];
        }
        Node[] childs = new Node[n.childs.length];
        int i = 0;
        while (i < childs.length) {
            childs[i] = this.assign(n.childs[i], varInfo, index);
            ++i;
        }
        return this.addNode(n.varInfo, childs);
    }

    public Node adjacentReplacements(Node n, VariableReplacement[] replacements) {
        if (replacements.length == 0) {
            return n;
        }
        int prev = -2;
        VariableReplacement[] variableReplacementArray = replacements;
        int n2 = replacements.length;
        int n3 = 0;
        while (n3 < n2) {
            VariableReplacement replacement = variableReplacementArray[n3];
            Assert.check((replacement.topLevel >= prev + 2 ? 1 : 0) != 0);
            prev = replacement.topLevel;
            ++n3;
        }
        return this.replaceAdjacents(n, 0, replacements);
    }

    private Node replaceAdjacents(Node n, int replaceIndex, VariableReplacement[] replacements) {
        if (replaceIndex >= replacements.length) {
            return n;
        }
        if (n == ZERO || n == ONE) {
            return n;
        }
        int level = n.varInfo.level;
        while (level > replacements[replaceIndex].topLevel + 1) {
            if (++replaceIndex != replacements.length) continue;
            return n;
        }
        if (level < replacements[replaceIndex].topLevel) {
            Node[] childs = new Node[n.childs.length];
            int i = 0;
            while (i < n.childs.length) {
                childs[i] = this.replaceAdjacents(n.childs[i], replaceIndex, replacements);
                ++i;
            }
            return this.addNode(n.varInfo, childs);
        }
        VariableReplacement vr = replacements[replaceIndex];
        if (level == vr.topLevel) {
            if (vr.isOldAtTop()) {
                Node[] childs = new Node[vr.oldVar.length];
                int i = 0;
                while (i < vr.oldVar.length) {
                    Node sub = ZERO;
                    Node[] nodeArray = n.childs;
                    int n2 = n.childs.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Node c = nodeArray[n3];
                        c = c == ONE || c == ZERO || c.varInfo.level > level + 1 ? this.replaceAdjacents(c, replaceIndex + 1, replacements) : this.replaceAdjacents(c.childs[i], replaceIndex + 1, replacements);
                        sub = this.disjunct(sub, c);
                        ++n3;
                    }
                    childs[i] = sub;
                    ++i;
                }
                return this.addNode(vr.oldVar, childs);
            }
            Node[] childs = new Node[vr.oldVar.length];
            int i = 0;
            while (i < vr.oldVar.length) {
                Node sub;
                Node c = n.childs[i];
                if (c == ONE || c == ZERO || c.varInfo.level > level + 1) {
                    sub = this.replaceAdjacents(c, replaceIndex + 1, replacements);
                } else {
                    sub = ZERO;
                    Node[] nodeArray = c.childs;
                    int n4 = c.childs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Node subC = nodeArray[n5];
                        subC = this.replaceAdjacents(subC, replaceIndex + 1, replacements);
                        sub = this.disjunct(sub, subC);
                        ++n5;
                    }
                }
                childs[i] = sub;
                ++i;
            }
            return this.addNode(vr.oldVar, childs);
        }
        Assert.check((level == vr.topLevel + 1 ? 1 : 0) != 0);
        if (vr.isOldAtTop()) {
            Node[] childs = new Node[vr.oldVar.length];
            int i = 0;
            while (i < vr.oldVar.length) {
                childs[i] = this.replaceAdjacents(n.childs[i], replaceIndex + 1, replacements);
                ++i;
            }
            return this.addNode(vr.oldVar, childs);
        }
        Node result = ZERO;
        Node[] nodeArray = n.childs;
        int n6 = n.childs.length;
        int n7 = 0;
        while (n7 < n6) {
            Node c = nodeArray[n7];
            Node sub = this.replaceAdjacents(c, replaceIndex + 1, replacements);
            result = this.disjunct(result, sub);
            ++n7;
        }
        return result;
    }

    public Node replace(Node n, VarInfo oldVar, VarInfo newVar) {
        int upperLevel = Math.min(oldVar.level, newVar.level);
        int bottomLevel = Math.max(oldVar.level, newVar.level);
        if (upperLevel == oldVar.level) {
            return this.replaceOldNew(n, upperLevel, bottomLevel, oldVar);
        }
        return this.replaceNewOld(n, upperLevel, bottomLevel, oldVar);
    }

    private Node replaceOldNew(Node n, int oldLevel, int newLevel, VarInfo oldVar) {
        if (n == ONE || n == ZERO) {
            return n;
        }
        int level = n.varInfo.level;
        if (level > newLevel) {
            return n;
        }
        if (level < oldLevel) {
            Node[] childs = new Node[n.childs.length];
            int i = 0;
            while (i < n.childs.length) {
                childs[i] = this.replaceOldNew(n.childs[i], oldLevel, newLevel, oldVar);
                ++i;
            }
            return this.addNode(n.varInfo, childs);
        }
        if (level == newLevel) {
            Node[] childs = new Node[n.childs.length];
            System.arraycopy(n.childs, 0, childs, 0, n.childs.length);
            return this.addNode(oldVar, childs);
        }
        Node[] childs = new Node[oldVar.length];
        if (level > oldLevel) {
            int i = 0;
            while (i < oldVar.length) {
                childs[i] = this.replaceOldNewValue(n, newLevel, i);
                ++i;
            }
            return this.addNode(oldVar, childs);
        }
        int i = 0;
        while (i < oldVar.length) {
            Node subExpr = ZERO;
            Node[] nodeArray = n.childs;
            int n2 = n.childs.length;
            int n3 = 0;
            while (n3 < n2) {
                Node c = nodeArray[n3];
                subExpr = this.disjunct(subExpr, this.replaceOldNewValue(c, newLevel, i));
                ++n3;
            }
            childs[i] = subExpr;
            ++i;
        }
        return this.addNode(oldVar, childs);
    }

    private Node replaceOldNewValue(Node n, int newLevel, int newValue) {
        if (n == ONE || n == ZERO) {
            return n;
        }
        int level = n.varInfo.level;
        if (level > newLevel) {
            return n;
        }
        if (level < newLevel) {
            Node[] childs = new Node[n.childs.length];
            int i = 0;
            while (i < n.childs.length) {
                childs[i] = this.replaceOldNewValue(n.childs[i], newLevel, newValue);
                ++i;
            }
            return this.addNode(n.varInfo, childs);
        }
        return n.childs[newValue];
    }

    private Node replaceNewOld(Node n, int newLevel, int oldLevel, VarInfo oldVar) {
        if (n == ONE || n == ZERO) {
            return n;
        }
        int level = n.varInfo.level;
        if (level > oldLevel) {
            return n;
        }
        if (level < newLevel) {
            Node[] childs = new Node[n.childs.length];
            int i = 0;
            while (i < n.childs.length) {
                childs[i] = this.replaceNewOld(n.childs[i], newLevel, oldLevel, oldVar);
                ++i;
            }
            return this.addNode(n.varInfo, childs);
        }
        if (level == oldLevel) {
            Node result = ZERO;
            Node[] nodeArray = n.childs;
            int n2 = n.childs.length;
            int n3 = 0;
            while (n3 < n2) {
                Node c = nodeArray[n3];
                result = this.disjunct(result, c);
                ++n3;
            }
            return result;
        }
        if (level == newLevel) {
            Node result = ZERO;
            int i = 0;
            while (i < n.childs.length) {
                Node sub = this.replaceNewOldValue(n.childs[i], oldLevel, oldVar, i);
                result = this.disjunct(result, sub);
                ++i;
            }
            return result;
        }
        return this.replaceNewOldValue(n, oldLevel, null, -1);
    }

    private Node replaceNewOldValue(Node n, int oldLevel, VarInfo oldVar, int newValue) {
        if (n == ONE) {
            if (newValue < 0) {
                return n;
            }
            return this.buildEqualityIndex(oldVar, newValue, n);
        }
        if (n == ZERO) {
            return n;
        }
        int level = n.varInfo.level;
        if (level > oldLevel) {
            if (newValue < 0) {
                return n;
            }
            return this.buildEqualityIndex(oldVar, newValue, n);
        }
        if (level < oldLevel) {
            Node[] childs = new Node[n.childs.length];
            int i = 0;
            while (i < n.childs.length) {
                childs[i] = this.replaceNewOldValue(n.childs[i], oldLevel, oldVar, newValue);
                ++i;
            }
            return this.addNode(n.varInfo, childs);
        }
        Node result = ZERO;
        Node[] nodeArray = n.childs;
        int n2 = n.childs.length;
        int n3 = 0;
        while (n3 < n2) {
            Node c = nodeArray[n3];
            result = this.disjunct(result, c);
            ++n3;
        }
        if (newValue < 0) {
            return result;
        }
        return this.buildEqualityIndex(oldVar, newValue, result);
    }
}

