/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;

public class SyntaxWarning
implements Comparable<SyntaxWarning> {
    public final String message;
    public final Position position;

    public SyntaxWarning(String message, Position position) {
        Assert.notNull((Object)message);
        Assert.notNull((Object)position);
        this.message = message;
        this.position = position;
    }

    public boolean equals(Object obj) {
        SyntaxWarning other = (SyntaxWarning)obj;
        return PositionUtils.equalPositions((Position)this.position, (Position)other.position) && this.message.equals(other.message);
    }

    public int hashCode() {
        return PositionUtils.hashPosition((Position)this.position) ^ this.message.hashCode();
    }

    @Override
    public int compareTo(SyntaxWarning other) {
        int rslt = 0;
        String src1 = this.position.getSource();
        String src2 = other.position.getSource();
        if (src1 == null && src2 != null) {
            return -1;
        }
        if (src1 != null && src2 == null) {
            return 1;
        }
        if (src1 != null && src2 != null && (rslt = Strings.SORTER.compare(src1, src2)) != 0) {
            return rslt;
        }
        rslt = Strings.SORTER.compare(this.position.getLocation(), other.position.getLocation());
        if (rslt != 0) {
            return rslt;
        }
        rslt = Integer.valueOf(this.position.getStartOffset()).compareTo(other.position.getStartOffset());
        if (rslt != 0) {
            return rslt;
        }
        rslt = Integer.valueOf(this.position.getEndOffset()).compareTo(other.position.getEndOffset());
        if (rslt != 0) {
            return rslt;
        }
        return Strings.SORTER.compare(this.message, other.message);
    }

    public String toString() {
        String src = this.position.getSource();
        if (src == null) {
            src = "";
        }
        return Strings.fmt((String)"%sSyntax warning at line %d, column %d: %s", (Object[])new Object[]{src, this.position.getStartLine(), this.position.getStartColumn(), this.message});
    }
}

