/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.tooldef.common.ToolDefTextUtils;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefMap;
import org.eclipse.escet.tooldef.runtime.ToolDefSet;
import org.eclipse.escet.tooldef.runtime.ToolDefTuple;
import org.eclipse.escet.tooldef.runtime.ToolDefTupleNary;
import org.eclipse.escet.tooldef.runtime.ToolDefTuplePair;
import org.eclipse.escet.tooldef.runtime.builtins.BuiltInDataTools;

public class ToolDefRuntimeUtils {
    private ToolDefRuntimeUtils() {
    }

    public static boolean equalValues(Object v1, Object v2) {
        if (v1 == null != (v2 == null)) {
            return false;
        }
        if (v1 == null || v2 == null) {
            return true;
        }
        if (v1 instanceof Boolean && v2 instanceof Boolean) {
            boolean b2;
            boolean b1 = (Boolean)v1;
            return b1 == (b2 = ((Boolean)v2).booleanValue());
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            int i2;
            int i1 = (Integer)v1;
            return i1 == (i2 = ((Integer)v2).intValue());
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            long l2;
            int i1 = (Integer)v1;
            long l1 = i1;
            return l1 == (l2 = ((Long)v2).longValue());
        }
        if (v1 instanceof Integer && v2 instanceof Double) {
            double d2;
            int i1 = (Integer)v1;
            double d1 = i1;
            return d1 == (d2 = ((Double)v2).doubleValue());
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            int i2;
            long l2;
            long l1 = (Long)v1;
            return l1 == (l2 = (long)(i2 = ((Integer)v2).intValue()));
        }
        if (v1 instanceof Long && v2 instanceof Long) {
            long l2;
            long l1 = (Long)v1;
            return l1 == (l2 = ((Long)v2).longValue());
        }
        if (v1 instanceof Long && v2 instanceof Double) {
            double d2;
            long l1 = (Long)v1;
            double d1 = l1;
            return d1 == (d2 = ((Double)v2).doubleValue());
        }
        if (v1 instanceof Double && v2 instanceof Integer) {
            int i2;
            double d2;
            double d1 = (Double)v1;
            return d1 == (d2 = (double)(i2 = ((Integer)v2).intValue()));
        }
        if (v1 instanceof Double && v2 instanceof Long) {
            long l2;
            double d2;
            double d1 = (Double)v1;
            return d1 == (d2 = (double)(l2 = ((Long)v2).longValue()));
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            double d2;
            double d1 = (Double)v1;
            return d1 == (d2 = ((Double)v2).doubleValue());
        }
        if (v1 instanceof String && v2 instanceof String) {
            return v1.equals(v2);
        }
        if (v1 instanceof ToolDefList && v2 instanceof ToolDefList) {
            return v1.equals(v2);
        }
        if (v1 instanceof ToolDefSet && v2 instanceof ToolDefSet) {
            return v1.equals(v2);
        }
        if (v1 instanceof ToolDefMap && v2 instanceof ToolDefMap) {
            return v1.equals(v2);
        }
        if (v1 instanceof ToolDefTuple && v2 instanceof ToolDefTuple) {
            return v1.equals(v2);
        }
        return false;
    }

    public static int hashValue(Object v) {
        if (v == null) {
            return 0;
        }
        if (v instanceof Boolean) {
            return ((Boolean)v).hashCode();
        }
        if (v instanceof Integer) {
            double d = ((Integer)v).intValue();
            return Double.valueOf(d).hashCode();
        }
        if (v instanceof Long) {
            double d = ((Long)v).longValue();
            return Double.valueOf(d).hashCode();
        }
        if (v instanceof Double) {
            return ((Double)v).hashCode();
        }
        if (v instanceof String) {
            return ((String)v).hashCode();
        }
        if (v instanceof ToolDefList) {
            return ((ToolDefList)v).hashCode();
        }
        if (v instanceof ToolDefSet) {
            return ((ToolDefSet)v).hashCode();
        }
        if (v instanceof ToolDefMap) {
            return ((ToolDefMap)v).hashCode();
        }
        if (v instanceof ToolDefTuple) {
            return ((ToolDefTuple)v).hashCode();
        }
        throw new RuntimeException("Unknown value: " + v);
    }

    public static int compareValues(Object v1, Object v2) {
        int o2;
        int o1 = ToolDefRuntimeUtils.getBasicSortOrder(v1);
        if (o1 < (o2 = ToolDefRuntimeUtils.getBasicSortOrder(v2))) {
            return -1;
        }
        if (o1 > o2) {
            return 1;
        }
        if (v1 instanceof Boolean) {
            boolean b1 = (Boolean)v1;
            boolean b2 = (Boolean)v2;
            return Boolean.compare(b1, b2);
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            int i1 = (Integer)v1;
            int i2 = (Integer)v2;
            return Integer.compare(i1, i2);
        }
        if (v1 instanceof Integer && v2 instanceof Long) {
            long l1 = ((Integer)v1).intValue();
            long l2 = (Long)v2;
            return Long.compare(l1, l2);
        }
        if (v1 instanceof Integer && v2 instanceof Double) {
            double d1 = ((Integer)v1).intValue();
            double d2 = (Double)v2;
            return Double.compare(d1, d2);
        }
        if (v1 instanceof Long && v2 instanceof Integer) {
            long l1 = (Long)v1;
            long l2 = ((Integer)v2).intValue();
            return Long.compare(l1, l2);
        }
        if (v1 instanceof Long && v2 instanceof Long) {
            long l1 = (Long)v1;
            long l2 = (Long)v2;
            return Long.compare(l1, l2);
        }
        if (v1 instanceof Long && v2 instanceof Double) {
            double d1 = ((Long)v1).longValue();
            double d2 = (Double)v2;
            return Double.compare(d1, d2);
        }
        if (v1 instanceof Double && v2 instanceof Integer) {
            double d1 = (Double)v1;
            double d2 = ((Integer)v2).intValue();
            return Double.compare(d1, d2);
        }
        if (v1 instanceof Double && v2 instanceof Long) {
            double d1 = (Double)v1;
            double d2 = ((Long)v2).longValue();
            return Double.compare(d1, d2);
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            double d1 = (Double)v1;
            double d2 = (Double)v2;
            return Double.compare(d1, d2);
        }
        if (v1 instanceof String) {
            String s1 = (String)v1;
            String s2 = (String)v2;
            return Strings.SORTER.compare(s1, s2);
        }
        if (v1 instanceof ToolDefTuple) {
            int size2;
            ToolDefTuple t1 = (ToolDefTuple)v1;
            ToolDefTuple t2 = (ToolDefTuple)v2;
            int size1 = t1.size();
            if (size1 < (size2 = t2.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            int i = 0;
            while (i < size1) {
                int erslt = ToolDefRuntimeUtils.compareValues(t1.getValue(i), t2.getValue(i));
                if (erslt != 0) {
                    return erslt;
                }
                ++i;
            }
            return 0;
        }
        if (v1 instanceof ToolDefList) {
            ToolDefList l1 = (ToolDefList)v1;
            ToolDefList l2 = (ToolDefList)v2;
            if (l1.size() < l2.size()) {
                return -1;
            }
            if (l1.size() > l2.size()) {
                return 1;
            }
            int i = 0;
            while (i < l1.size()) {
                int erslt = ToolDefRuntimeUtils.compareValues(l1.get(i), l2.get(i));
                if (erslt != 0) {
                    return erslt;
                }
                ++i;
            }
            return 0;
        }
        if (v1 instanceof ToolDefSet) {
            ToolDefSet s1 = (ToolDefSet)v1;
            ToolDefSet s2 = (ToolDefSet)v2;
            if (s1.size() < s2.size()) {
                return -1;
            }
            if (s1.size() > s2.size()) {
                return 1;
            }
            ToolDefList l1 = new ToolDefList(s1);
            ToolDefList l2 = new ToolDefList(s2);
            Collections.sort(l1, ToolDefRuntimeUtils::compareValues);
            Collections.sort(l2, ToolDefRuntimeUtils::compareValues);
            return ToolDefRuntimeUtils.compareValues(l1, l2);
        }
        if (v1 instanceof ToolDefMap) {
            ToolDefMap m1 = (ToolDefMap)v1;
            ToolDefMap m2 = (ToolDefMap)v2;
            if (m1.size() < m2.size()) {
                return -1;
            }
            if (m1.size() > m2.size()) {
                return 1;
            }
            List l1 = BuiltInDataTools.entries(m1);
            List l2 = BuiltInDataTools.entries(m2);
            Collections.sort(l1, (a, b) -> ToolDefRuntimeUtils.compareValues(a.left, b.left));
            Collections.sort(l2, (a, b) -> ToolDefRuntimeUtils.compareValues(a.left, b.left));
            return ToolDefRuntimeUtils.compareValues(l1, l2);
        }
        if (v1 == null) {
            Assert.check((v2 == null ? 1 : 0) != 0);
            return 0;
        }
        String msg = Strings.fmt((String)"Unknown runtime values: \"%s\" and \"%s\".", (Object[])new Object[]{v1, v2});
        throw new RuntimeException(msg);
    }

    private static int getBasicSortOrder(Object value) {
        if (value instanceof Boolean) {
            return 1;
        }
        if (value instanceof Integer) {
            return 2;
        }
        if (value instanceof Long) {
            return 2;
        }
        if (value instanceof Double) {
            return 2;
        }
        if (value instanceof String) {
            return 3;
        }
        if (value instanceof ToolDefTuple) {
            return 4;
        }
        if (value instanceof ToolDefList) {
            return 5;
        }
        if (value instanceof ToolDefSet) {
            return 6;
        }
        if (value instanceof ToolDefMap) {
            return 7;
        }
        if (value == null) {
            return 8;
        }
        throw new RuntimeException("Unsupported value: " + value);
    }

    public static Object getDefaultValue(ToolDefType type) {
        if ((type = ToolDefTypeUtils.normalizeType((ToolDefType)type)) instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            return 0;
        }
        if (type instanceof LongType) {
            return 0L;
        }
        if (type instanceof DoubleType) {
            return 0.0;
        }
        if (type instanceof StringType) {
            return "";
        }
        if (type instanceof ObjectType) {
            Assert.check((boolean)type.isNullable());
            return null;
        }
        if (type instanceof ListType) {
            return new ToolDefList();
        }
        if (type instanceof SetType) {
            return new ToolDefSet();
        }
        if (type instanceof MapType) {
            return new ToolDefMap();
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            ToolDefList<Object> elems = new ToolDefList<Object>(ttype.getFields().size());
            for (ToolDefType fieldType : ttype.getFields()) {
                elems.add(ToolDefRuntimeUtils.getDefaultValue(fieldType));
            }
            return ToolDefRuntimeUtils.makeTuple(elems);
        }
        throw new RuntimeException("Unknown/unsupported type: " + type);
    }

    public static String valueToStr(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean) {
            boolean bvalue = (Boolean)value;
            return bvalue ? "true" : "false";
        }
        if (value instanceof Integer) {
            int ivalue = (Integer)value;
            return Integer.toString(ivalue);
        }
        if (value instanceof Long) {
            long lvalue = (Long)value;
            return Long.toString(lvalue);
        }
        if (value instanceof Double) {
            double dvalue = (Double)value;
            Assert.check((!Double.isNaN(dvalue) ? 1 : 0) != 0);
            Assert.check((!Double.isInfinite(dvalue) ? 1 : 0) != 0);
            return Double.toString(dvalue).replace('E', 'e');
        }
        if (value instanceof String) {
            String svalue = (String)value;
            return "\"" + Strings.escape((String)svalue) + "\"";
        }
        if (value instanceof ToolDefTuple) {
            ToolDefTuple tvalue = (ToolDefTuple)value;
            return tvalue.toString();
        }
        if (value instanceof ToolDefList) {
            ToolDefList lvalue = (ToolDefList)value;
            List elems = Lists.listc((int)lvalue.size());
            for (Object elem : lvalue) {
                elems.add(ToolDefRuntimeUtils.valueToStr(elem));
            }
            return "[" + String.join((CharSequence)", ", elems) + "]";
        }
        if (value instanceof ToolDefSet) {
            ToolDefSet svalue = (ToolDefSet)value;
            List elems = Lists.listc((int)svalue.size());
            for (Object elem : svalue) {
                elems.add(ToolDefRuntimeUtils.valueToStr(elem));
            }
            return "{" + String.join((CharSequence)", ", elems) + "}";
        }
        if (value instanceof ToolDefMap) {
            ToolDefMap mvalue = (ToolDefMap)value;
            List entries = Lists.listc((int)mvalue.size());
            for (Map.Entry entry : mvalue.entrySet()) {
                entries.add(String.valueOf(ToolDefRuntimeUtils.valueToStr(entry.getKey())) + ": " + ToolDefRuntimeUtils.valueToStr(entry.getValue()));
            }
            return "{" + String.join((CharSequence)", ", entries) + "}";
        }
        throw new RuntimeException("Unknown runtime value: " + value);
    }

    public static String valueToTypeStr(Object value) {
        return ToolDefTextUtils.typeToStr((ToolDefType)ToolDefRuntimeUtils.valueToType(value));
    }

    public static ToolDefType valueToType(Object value) {
        if (value == null) {
            return ToolDefConstructors.newObjectType((Boolean)true, null);
        }
        if (value instanceof Boolean) {
            return ToolDefConstructors.newBoolType((Boolean)false, null);
        }
        if (value instanceof Integer) {
            return ToolDefConstructors.newIntType((Boolean)false, null);
        }
        if (value instanceof Long) {
            return ToolDefConstructors.newLongType((Boolean)false, null);
        }
        if (value instanceof Double) {
            return ToolDefConstructors.newDoubleType((Boolean)false, null);
        }
        if (value instanceof String) {
            return ToolDefConstructors.newStringType((Boolean)false, null);
        }
        if (value instanceof ToolDefTupleNary) {
            ToolDefTupleNary naryValue = (ToolDefTupleNary)value;
            List fieldTypes = Lists.list();
            fieldTypes.add(ToolDefRuntimeUtils.valueToType(naryValue.prefix));
            Object cur = naryValue.remainder;
            while (cur instanceof ToolDefTupleNary) {
                ToolDefTupleNary nary = (ToolDefTupleNary)cur;
                fieldTypes.add(ToolDefRuntimeUtils.valueToType(nary.prefix));
                cur = nary.remainder;
            }
            Assert.check((boolean)(cur instanceof ToolDefTuplePair));
            ToolDefTuplePair pair = (ToolDefTuplePair)cur;
            fieldTypes.add(ToolDefRuntimeUtils.valueToType(pair.left));
            fieldTypes.add(ToolDefRuntimeUtils.valueToType(pair.right));
            return ToolDefConstructors.newTupleType((List)fieldTypes, (Boolean)false, null);
        }
        if (value instanceof ToolDefTuplePair) {
            ToolDefTuplePair pair = (ToolDefTuplePair)value;
            List fieldTypes = Lists.list();
            fieldTypes.add(ToolDefRuntimeUtils.valueToType(pair.left));
            fieldTypes.add(ToolDefRuntimeUtils.valueToType(pair.right));
            return ToolDefConstructors.newTupleType((List)fieldTypes, (Boolean)false, null);
        }
        if (value instanceof ToolDefList) {
            ToolDefList lvalue = (ToolDefList)value;
            ObjectType mergedType = null;
            for (Object elem : lvalue) {
                ToolDefType elemType = ToolDefRuntimeUtils.valueToType(elem);
                ToolDefType toolDefType = mergedType = mergedType == null ? elemType : ToolDefTypeUtils.mergeTypes((ToolDefType)mergedType, (ToolDefType)elemType);
            }
            if (mergedType == null) {
                mergedType = ToolDefConstructors.newObjectType((Boolean)true, null);
            }
            return ToolDefConstructors.newListType((ToolDefType)mergedType, (Boolean)false, null);
        }
        if (value instanceof ToolDefSet) {
            ToolDefSet svalue = (ToolDefSet)value;
            ObjectType mergedType = null;
            for (Object elem : svalue) {
                ToolDefType elemType = ToolDefRuntimeUtils.valueToType(elem);
                ToolDefType toolDefType = mergedType = mergedType == null ? elemType : ToolDefTypeUtils.mergeTypes((ToolDefType)mergedType, (ToolDefType)elemType);
            }
            if (mergedType == null) {
                mergedType = ToolDefConstructors.newObjectType((Boolean)true, null);
            }
            return ToolDefConstructors.newSetType((ToolDefType)mergedType, (Boolean)false, null);
        }
        if (value instanceof ToolDefMap) {
            ToolDefMap mvalue = (ToolDefMap)value;
            ObjectType mergedKeyType = null;
            ObjectType mergedValueType = null;
            for (Map.Entry entry : mvalue.entrySet()) {
                ToolDefType keyType = ToolDefRuntimeUtils.valueToType(entry.getKey());
                ToolDefType valueType = ToolDefRuntimeUtils.valueToType(entry.getValue());
                mergedKeyType = mergedKeyType == null ? keyType : ToolDefTypeUtils.mergeTypes((ToolDefType)mergedKeyType, (ToolDefType)keyType);
                ToolDefType toolDefType = mergedValueType = mergedValueType == null ? valueType : ToolDefTypeUtils.mergeTypes((ToolDefType)mergedValueType, (ToolDefType)valueType);
            }
            if (mergedKeyType == null) {
                mergedKeyType = ToolDefConstructors.newObjectType((Boolean)true, null);
            }
            if (mergedValueType == null) {
                mergedValueType = ToolDefConstructors.newObjectType((Boolean)true, null);
            }
            return ToolDefConstructors.newMapType((ToolDefType)mergedKeyType, (Boolean)false, null, (ToolDefType)mergedValueType);
        }
        throw new RuntimeException("Unknown runtime value: " + value);
    }

    public static ToolDefTuple makeTuple(List<Object> values) {
        Assert.check((values.size() >= 2 ? 1 : 0) != 0);
        Object v1 = values.get(values.size() - 2);
        Object v2 = values.get(values.size() - 1);
        ToolDefTuple tuple = new ToolDefTuplePair<Object, Object>(v1, v2);
        int i = values.size() - 3;
        while (i >= 0) {
            tuple = new ToolDefTupleNary<Object, ToolDefTuplePair<Object, Object>>(values.get(i), (ToolDefTuplePair<Object, Object>)tuple);
            --i;
        }
        return tuple;
    }

    public static List<Object> unpackTuple(ToolDefTuple tuple) {
        ToolDefList<Object> rslt = new ToolDefList<Object>();
        ToolDefTuple cur = tuple;
        while (cur instanceof ToolDefTupleNary) {
            ToolDefTupleNary nary = (ToolDefTupleNary)cur;
            rslt.add(nary.prefix);
            cur = nary.remainder;
        }
        Assert.check((boolean)(cur instanceof ToolDefTuplePair));
        ToolDefTuplePair pair = (ToolDefTuplePair)cur;
        rslt.add(pair.left);
        rslt.add(pair.right);
        return rslt;
    }
}

