/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime.builtins;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefMap;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefSet;
import org.eclipse.escet.tooldef.runtime.ToolDefTuplePair;

public class BuiltInDataTools {
    private BuiltInDataTools() {
    }

    public static int abs(int x) {
        if (x == Integer.MIN_VALUE) {
            String msg = Strings.fmt((String)"Integer number overflow: abs(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return Math.abs(x);
    }

    public static long abs(long x) {
        if (x == Long.MIN_VALUE) {
            String msg = Strings.fmt((String)"Long number overflow: abs(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static long ceil(double x) {
        double rslt = Math.ceil(x);
        if (rslt < -9.223372036854776E18 || rslt > 9.223372036854776E18) {
            String msg = Strings.fmt((String)"Long number overflow: ceil(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return (long)rslt;
    }

    public static boolean contains(String whole, String part) {
        return whole.contains(part);
    }

    public static <T> boolean contains(List<T> list, T elem) {
        return list.contains(elem);
    }

    public static <T> boolean contains(Set<T> set, T elem) {
        return set.contains(elem);
    }

    public static <K, V> boolean contains(Map<K, V> map, K key) {
        return map.containsKey(key);
    }

    public static <T> List<T> del(List<T> list, T elem) {
        ToolDefList<T> rslt = new ToolDefList<T>(list.size());
        for (T x : list) {
            if (ToolDefRuntimeUtils.equalValues(x, elem)) continue;
            rslt.add(x);
        }
        return rslt;
    }

    public static <T> Set<T> del(Set<T> set, T elem) {
        ToolDefSet<T> rslt = new ToolDefSet<T>(set);
        rslt.remove(elem);
        return rslt;
    }

    public static <K, V> Map<K, V> del(Map<K, V> map, K key) {
        ToolDefMap<K, V> rslt = new ToolDefMap<K, V>(map);
        rslt.remove(key);
        return rslt;
    }

    public static <T> List<T> delidx(List<T> list, int index) {
        int normalizedIdx = index;
        if (normalizedIdx < 0) {
            normalizedIdx = list.size() + normalizedIdx;
        }
        if (normalizedIdx < 0 || normalizedIdx >= list.size()) {
            String msg = Strings.fmt((String)"Index out of bounds: delidx(%s, %s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(list), index});
            throw new ToolDefException(msg);
        }
        ToolDefList<T> rslt = new ToolDefList<T>(list);
        rslt.remove(normalizedIdx);
        return rslt;
    }

    public static boolean empty(String x) {
        return x.isEmpty();
    }

    public static <T> boolean empty(List<T> x) {
        return x.isEmpty();
    }

    public static <T> boolean empty(Set<T> x) {
        return x.isEmpty();
    }

    public static <K, V> boolean empty(Map<K, V> x) {
        return x.isEmpty();
    }

    public static boolean endswith(String whole, String suffix) {
        return whole.endsWith(suffix);
    }

    public static <K, V> List<ToolDefTuplePair<K, V>> entries(Map<K, V> map) {
        ToolDefList<ToolDefTuplePair<K, V>> rslt = new ToolDefList<ToolDefTuplePair<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            rslt.add(new ToolDefTuplePair<K, V>(key, value));
        }
        return rslt;
    }

    public static <T> List<ToolDefTuplePair<Integer, T>> enumerate(List<T> list) {
        ToolDefList<ToolDefTuplePair<Integer, T>> rslt = new ToolDefList<ToolDefTuplePair<Integer, T>>(list.size());
        int i = 0;
        while (i < list.size()) {
            T elem = list.get(i);
            rslt.add(new ToolDefTuplePair<Integer, T>(i, elem));
            ++i;
        }
        return rslt;
    }

    public static long floor(double x) {
        double rslt = Math.floor(x);
        if (rslt < -9.223372036854776E18 || rslt > 9.223372036854776E18) {
            String msg = Strings.fmt((String)"Long number overflow: floor(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return (long)rslt;
    }

    public static String fmtToolDef(String pattern, Object ... args) {
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        for (FormatDescription part : parts) {
            if (part.conversion != FormatDescription.Conversion.ERROR) continue;
            String msg = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
            throw new ToolDefException(msg, (Throwable)((Object)new ToolDefException(part.text)));
        }
        StringBuilder rslt = new StringBuilder();
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            String msg;
            int idx;
            if (part.conversion == FormatDescription.Conversion.LITERAL) {
                rslt.append(part.text);
                continue;
            }
            if (!part.index.isEmpty()) {
                idx = part.getExplicitIndex();
                if (idx == -1) {
                    msg = "Invalid format specifier: the explicit index causes integer overflow.";
                    ToolDefException cause = new ToolDefException(msg);
                    msg = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
                    throw new ToolDefException(msg, (Throwable)((Object)cause));
                }
                --idx;
            } else {
                idx = implicitIndex++;
            }
            if (idx < 0 || idx >= args.length) {
                msg = Strings.fmt((String)"Invalid format specifier: the %s value is used, which does not exist.", (Object[])new Object[]{Numbers.toOrdinal((int)(idx + 1))});
                ToolDefException cause = new ToolDefException(msg);
                msg = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
                throw new ToolDefException(msg, (Throwable)((Object)cause));
            }
            Object value = args[idx];
            switch (part.conversion) {
                case BOOLEAN: {
                    if (value != null && !(value instanceof Boolean)) {
                        String msg2 = Strings.fmt((String)"Invalid \"%%%s\" format specifier: a value of type \"bool\" or \"bool?\" is required, but the %s value of type \"%s\" is used.", (Object[])new Object[]{part.text, Numbers.toOrdinal((int)(idx + 1)), ToolDefRuntimeUtils.valueToTypeStr(value)});
                        ToolDefException cause = new ToolDefException(msg2);
                        msg2 = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
                        throw new ToolDefException(msg2, (Throwable)((Object)cause));
                    }
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{value});
                    rslt.append(txt);
                    break;
                }
                case INTEGER: {
                    if (!(value instanceof Integer) && !(value instanceof Long)) {
                        String msg3 = Strings.fmt((String)"Invalid \"%%%s\" format specifier: a value of type \"int\" or \"long\" is required, but the %s value of type \"%s\" is used.", (Object[])new Object[]{part.text, Numbers.toOrdinal((int)(idx + 1)), ToolDefRuntimeUtils.valueToTypeStr(value)});
                        ToolDefException cause = new ToolDefException(msg3);
                        msg3 = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
                        throw new ToolDefException(msg3, (Throwable)((Object)cause));
                    }
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{value});
                    rslt.append(txt);
                    break;
                }
                case REAL: {
                    double v;
                    if (!(value instanceof Integer || value instanceof Long || value instanceof Double)) {
                        String msg4 = Strings.fmt((String)"Invalid \"%%%s\" format specifier: a value of type \"int\", \"long\", or \"double\" is required, but the %s value of type \"%s\" is used.", (Object[])new Object[]{part.text, Numbers.toOrdinal((int)(idx + 1)), ToolDefRuntimeUtils.valueToTypeStr(value)});
                        ToolDefException cause = new ToolDefException(msg4);
                        msg4 = Strings.fmt((String)"Invalid format pattern: %s (problem at position %d..%d).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(pattern), part.offset + 1, part.offset + part.length});
                        throw new ToolDefException(msg4, (Throwable)((Object)cause));
                    }
                    if (value instanceof Integer) {
                        v = ((Integer)value).intValue();
                    } else if (value instanceof Long) {
                        v = ((Long)value).longValue();
                    } else if (value instanceof Double) {
                        v = (Double)value;
                    } else {
                        throw new RuntimeException("Unexpected value: " + value);
                    }
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{v});
                    rslt.append(txt);
                    break;
                }
                case STRING: {
                    if (!(value instanceof String)) {
                        value = ToolDefRuntimeUtils.valueToStr(value);
                    }
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{value});
                    rslt.append(txt);
                    break;
                }
                default: {
                    String msg5 = "Unexpected: " + part.conversion;
                    throw new RuntimeException(msg5);
                }
            }
        }
        return rslt.toString();
    }

    public static int indexof(String whole, String part) {
        return whole.indexOf(part);
    }

    public static int indexof(String whole, String part, int offset) {
        return whole.indexOf(part, offset);
    }

    public static <T> int indexof(List<T> list, T elem) {
        return list.indexOf(elem);
    }

    public static <T> int indexof(List<T> list, T elem, int offset) {
        int rslt;
        int size = list.size();
        if (offset < 0) {
            offset = 0;
        }
        if (offset > size) {
            offset = size;
        }
        if ((rslt = list.subList(offset, size).indexOf(elem)) >= 0) {
            rslt += offset;
        }
        return rslt;
    }

    public static String join(List<String> texts) {
        return String.join((CharSequence)"", texts);
    }

    public static String join(List<String> texts, String separator) {
        return String.join((CharSequence)separator, texts);
    }

    public static <K, V> Set<K> keys(Map<K, V> map) {
        ToolDefSet<K> keys = new ToolDefSet<K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static int lastindexof(String whole, String part) {
        return whole.lastIndexOf(part);
    }

    public static int lastindexof(String whole, String part, int offset) {
        return whole.lastIndexOf(part, offset);
    }

    public static <T> int lastindexof(List<T> list, T elem) {
        return list.lastIndexOf(elem);
    }

    public static <T> int lastindexof(List<T> list, T elem, int offset) {
        int size = list.size();
        if (++offset < 0) {
            offset = 0;
        }
        if (offset > size) {
            offset = size;
        }
        return list.subList(0, offset).lastIndexOf(elem);
    }

    public static double ln(double x) {
        if (x <= 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: ln(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return Math.log(x);
    }

    public static double log(double x) {
        if (x <= 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: log(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return Math.log10(x);
    }

    public static String lower(String text) {
        return text.toLowerCase(Locale.US);
    }

    public static String ltrim(String text) {
        return StringUtils.stripStart((String)text, null);
    }

    public static int max(int ... x) {
        int rslt = Integer.MIN_VALUE;
        int[] nArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            int y = nArray[n2];
            if (y > rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static long max(long ... x) {
        long rslt = Long.MIN_VALUE;
        long[] lArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            long y = lArray[n2];
            if (y > rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static double max(double ... x) {
        double rslt = -1.7976931348623157E308;
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double y = dArray[n2];
            if (y > rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static int min(int ... x) {
        int rslt = Integer.MAX_VALUE;
        int[] nArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            int y = nArray[n2];
            if (y < rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static long min(long ... x) {
        long rslt = Long.MAX_VALUE;
        long[] lArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            long y = lArray[n2];
            if (y < rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static double min(double ... x) {
        double rslt = Double.MAX_VALUE;
        double[] dArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            double y = dArray[n2];
            if (y < rslt) {
                rslt = y;
            }
            ++n2;
        }
        return rslt;
    }

    public static double pow(double base, double exponent) {
        double rslt = Math.pow(base, exponent);
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Double number overflow: pow(%s, %s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(base), ToolDefRuntimeUtils.valueToStr(exponent)});
            throw new ToolDefException(msg);
        }
        if (Double.isNaN(rslt)) {
            String msg = Strings.fmt((String)"Invalid operation: pow(%s, %s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(base), ToolDefRuntimeUtils.valueToStr(exponent)});
            throw new ToolDefException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static List<Integer> range(int count) {
        ToolDefList<Integer> rslt = new ToolDefList<Integer>(count >= 0 ? count : 0);
        int i = 0;
        while (i < count) {
            rslt.add(i);
            ++i;
        }
        return rslt;
    }

    public static List<Integer> range(int begin, int end) {
        int cnt = end - begin + 1;
        if (cnt < 0) {
            cnt = 0;
        }
        ToolDefList<Integer> rslt = new ToolDefList<Integer>(cnt);
        int i = begin;
        while (i <= end) {
            rslt.add(i);
            ++i;
        }
        return rslt;
    }

    public static <T> List<Integer> range(List<T> list) {
        return BuiltInDataTools.range(list.size());
    }

    public static String replace(String text, String oldtext, String newtext) {
        return text.replace(oldtext, newtext);
    }

    public static <T> List<T> replace(List<T> list, T oldelem, T newelem) {
        ToolDefList<T> rslt = new ToolDefList<T>(list);
        int i = 0;
        while (i < rslt.size()) {
            if (ToolDefRuntimeUtils.equalValues(rslt.get(i), oldelem)) {
                rslt.set(i, newelem);
            }
            ++i;
        }
        return rslt;
    }

    public static String reverse(String text) {
        return StringUtils.reverse((String)text);
    }

    public static <T> List<T> reverse(List<T> list) {
        ToolDefList<T> rslt = new ToolDefList<T>(list);
        Collections.reverse(rslt);
        return rslt;
    }

    public static long round(double x) {
        if (x < -9.223372036854776E18 || x >= 9.223372036854776E18) {
            String msg = Strings.fmt((String)"Long number overflow: round(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        long rslt = Math.round(x);
        return (int)rslt;
    }

    public static String rtrim(String text) {
        return StringUtils.stripEnd((String)text, null);
    }

    public static int size(String x) {
        return x.length();
    }

    public static <T> int size(List<T> x) {
        return x.size();
    }

    public static <T> int size(Set<T> x) {
        return x.size();
    }

    public static <K, V> int size(Map<K, V> x) {
        return x.size();
    }

    public static <T> List<T> sorted(List<T> list) {
        ToolDefList<T> rslt = new ToolDefList<T>(list);
        Collections.sort(rslt, ToolDefRuntimeUtils::compareValues);
        return rslt;
    }

    public static <T> List<T> sorted(Set<T> set) {
        ToolDefList<T> rslt = new ToolDefList<T>(set);
        Collections.sort(rslt, ToolDefRuntimeUtils::compareValues);
        return rslt;
    }

    public static List<String> split(String text, String separator, boolean removeEmpty) {
        String[] parts = removeEmpty ? StringUtils.splitByWholeSeparator((String)text, (String)separator) : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)text, (String)separator);
        ToolDefList<String> rslt = new ToolDefList<String>(parts.length);
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            rslt.add(part);
            ++n2;
        }
        return rslt;
    }

    public static double sqrt(double x) {
        if (x < 0.0) {
            String msg = Strings.fmt((String)"Invalid operation: sqrt(%s).", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(x)});
            throw new ToolDefException(msg);
        }
        return Math.sqrt(x);
    }

    public static boolean startswith(String whole, String prefix) {
        return whole.startsWith(prefix);
    }

    public static String str(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return ToolDefRuntimeUtils.valueToStr(value);
    }

    public static String strdup(String text, int count) {
        if (count < 0) {
            String msg = Strings.fmt((String)"Invalid negative count for strdup: %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(count)});
            throw new ToolDefException(msg);
        }
        return Strings.duplicate((String)text, (int)count);
    }

    public static <T> boolean subset(Set<T> part, Set<T> whole) {
        return whole.containsAll(part);
    }

    public static String trim(String text) {
        return StringUtils.strip((String)text, null);
    }

    public static String upper(String text) {
        return text.toUpperCase(Locale.US);
    }

    public static <K, V> Set<V> values(Map<K, V> map) {
        ToolDefSet<V> values = new ToolDefSet<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }
}

