//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2022 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

// Disable Eclipse Java formatter for generated code file:
// @formatter:off

package org.eclipse.escet.chi.parser;

import static org.eclipse.escet.common.java.Strings.fmt;

import java.io.IOException;
import java.util.List;

import org.eclipse.escet.chi.metamodel.chi.CreateCase;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.DictionaryPair;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.IfCase;
import org.eclipse.escet.chi.metamodel.chi.MatrixRow;
import org.eclipse.escet.chi.metamodel.chi.SelectCase;
import org.eclipse.escet.chi.metamodel.chi.Statement;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.Unwind;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.ParserHooksBase;
import org.eclipse.escet.setext.runtime.Token;

/**
 * ChiParser.
 *
 * <p>This parser is generated by SeText for main symbol
 * "Program".</p>
 */
@SuppressWarnings("unchecked")
public final class ChiParser extends Parser<List<Declaration>> {
    /** The names of the non-terminals, ordered by their unique ids. */
    private static final String[] NON_TERMINAL_NAMES = {
        "Program",
        "EndSimpleProgram",
        "EndCompoundProgram",
        "CompoundProgram",
        "SimpleProgram",
        "TypeDefList",
        "ConstantDefList",
        "EnumDefList",
        "Body",
        "StatementList",
        "EndSimple",
        "EndCompound",
        "CompoundStatement",
        "SimpleStatement",
        "CommStatement",
        "ElifsOpt",
        "ElseOpt",
        "Instances",
        "Unwinds",
        "IteratedInstance",
        "ProcessInstance",
        "EndInstance",
        "EndIterated",
        "Selections",
        "SelectionAlt",
        "SelectCondition",
        "FormalParameters",
        "VarDefinitionList",
        "VarNames",
        "ElementaryType",
        "Type",
        "TupleTypeList",
        "TupleType",
        "TypeList",
        "IdentifierList",
        "OptExpression",
        "ExprList",
        "MatExprList",
        "Expression",
        "AndExpression",
        "NotExpression",
        "CompareExpression",
        "AddExpression",
        "MulExpression",
        "PowerExpression",
        "UnaryExpression",
        "SampleExpression",
        "FuncExpression",
        "ExpressionFactor",
        "DictPairs",
    };

    /**
     * The entry symbol names for each of the parser states, and {@code null}
     * for the initial state.
     */
    private static final String[] ENTRY_SYMBOL_NAMES = new String[] {
        null,
        "CONSTKW",
        "ENUMKW",
        "XPERKW",
        "FUNCKW",
        "MODELKW",
        "PROCKW",
        "TYPEKW",
        "CompoundProgram",
        "EndCompoundProgram",
        "EndSimpleProgram",
        "Program",
        "SimpleProgram",
        "SEMICOLTK",
        "CompoundProgram",
        "SimpleProgram",
        "SEMICOLTK",
        "CompoundProgram",
        "SimpleProgram",
        "CompoundProgram",
        "SimpleProgram",
        "IDENTIFIERTK",
        "TypeDefList",
        "COMMATK",
        "IDENTIFIERTK",
        "BECOMESTK",
        "FUNCKW",
        "PROCKW",
        "BOOLKW",
        "CHANKW",
        "DICTKW",
        "DISTKW",
        "FILEKW",
        "INSTKW",
        "INTKW",
        "LISTKW",
        "MATRIXKW",
        "REALKW",
        "SETKW",
        "STRINGKW",
        "TIMERKW",
        "TUPLEKW",
        "VOIDKW",
        "IDENTIFIERTK",
        "ElementaryType",
        "Type",
        "PAROPENTK",
        "TupleType",
        "TupleTypeList",
        "Type",
        "IDENTIFIERTK",
        "IdentifierList",
        "COMMATK",
        "IDENTIFIERTK",
        "SEMICOLTK",
        "PARCLOSETK",
        "TupleType",
        "Type",
        "PAROPENTK",
        "ABSKW",
        "SIGNKW",
        "MAXKW",
        "MINKW",
        "CEILKW",
        "FLOORKW",
        "ROUNDKW",
        "CBRTKW",
        "SQRTKW",
        "EXPKW",
        "LNKW",
        "LOGKW",
        "ACOSHKW",
        "ACOSKW",
        "ASINHKW",
        "ASINKW",
        "ATANHKW",
        "ATANKW",
        "COSHKW",
        "COSKW",
        "SINHKW",
        "SINKW",
        "TANHKW",
        "TANKW",
        "BERNOULLIKW",
        "BETAKW",
        "BINOMIALKW",
        "CONSTANTKW",
        "LOGNORMALKW",
        "EXPONENTIALKW",
        "ERLANGKW",
        "GAMMAKW",
        "GEOMETRICKW",
        "NORMALKW",
        "POISSONKW",
        "RANDOMKW",
        "TRIANGLEKW",
        "UNIFORMKW",
        "WEIBULLKW",
        "DICTKEYSKW",
        "DICTVALUESKW",
        "EMPTYKW",
        "SIZEKW",
        "POPKW",
        "ENUMERATEKW",
        "RANGEKW",
        "DELKW",
        "INSERTKW",
        "SORTKW",
        "FINISHEDKW",
        "READYKW",
        "OPENKW",
        "CHANNELKW",
        "READKW",
        "EOLKW",
        "EOFKW",
        "NEWLINESKW",
        "TIMEKW",
        "MATRIXKW",
        "SETKW",
        "NOTKW",
        "SAMPLEKW",
        "FALSEKW",
        "TRUEKW",
        "LTTK",
        "PLUSTK",
        "MINUSTK",
        "CUROPENTK",
        "PAROPENTK",
        "SQOPENTK",
        "IDENTIFIERTK",
        "STRINGTK",
        "NUMBERTK",
        "REALTK",
        "AddExpression",
        "AndExpression",
        "CompareExpression",
        "ElementaryType",
        "Expression",
        "ExpressionFactor",
        "FuncExpression",
        "MulExpression",
        "NotExpression",
        "PowerExpression",
        "SampleExpression",
        "UnaryExpression",
        "CARETTK",
        "UnaryExpression",
        "DIVKW",
        "MODKW",
        "ASTERISKTK",
        "SLASHTK",
        "PowerExpression",
        "PowerExpression",
        "PowerExpression",
        "PowerExpression",
        "DOTTK",
        "CUROPENTK",
        "PAROPENTK",
        "SQOPENTK",
        "Expression",
        "OptExpression",
        "COLONTK",
        "Expression",
        "OptExpression",
        "COLONTK",
        "SQCLOSETK",
        "OptExpression",
        "SQCLOSETK",
        "ORKW",
        "AndExpression",
        "ANDKW",
        "NotExpression",
        "SQCLOSETK",
        "PARCLOSETK",
        "Expression",
        "ExprList",
        "COMMATK",
        "PARCLOSETK",
        "Expression",
        "Expression",
        "CURCLOSETK",
        "PAROPENTK",
        "PARCLOSETK",
        "ExprList",
        "PARCLOSETK",
        "IDENTIFIERTK",
        "COMMATK",
        "Expression",
        "PARCLOSETK",
        "PAROPENTK",
        "Expression",
        "PARCLOSETK",
        "INKW",
        "SUBKW",
        "LTTK",
        "LETK",
        "EQTK",
        "NETK",
        "GETK",
        "GTTK",
        "AddExpression",
        "PLUSTK",
        "MINUSTK",
        "MulExpression",
        "MulExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "AddExpression",
        "ExprList",
        "MatExprList",
        "SEMICOLTK",
        "SQCLOSETK",
        "ExprList",
        "ExprList",
        "PARCLOSETK",
        "DictPairs",
        "Expression",
        "ExprList",
        "CURCLOSETK",
        "COLONTK",
        "Expression",
        "COMMATK",
        "CURCLOSETK",
        "Expression",
        "COLONTK",
        "Expression",
        "UnaryExpression",
        "UnaryExpression",
        "Type",
        "GTTK",
        "COLONTK",
        "Type",
        "GTTK",
        "CUROPENTK",
        "CURCLOSETK",
        "CUROPENTK",
        "SQOPENTK",
        "SQCLOSETK",
        "CURCLOSETK",
        "FuncExpression",
        "NotExpression",
        "PAROPENTK",
        "Expression",
        "PARCLOSETK",
        "PAROPENTK",
        "Expression",
        "COMMATK",
        "Expression",
        "COMMATK",
        "Expression",
        "PARCLOSETK",
        "PAROPENTK",
        "MATRIXKW",
        "SETKW",
        "IDENTIFIERTK",
        "ElementaryType",
        "Expression",
        "Type",
        "PARCLOSETK",
        "COMMATK",
        "Type",
        "PARCLOSETK",
        "PAROPENTK",
        "Expression",
        "COMMATK",
        "Expression",
        "PAROPENTK",
        "Type",
        "PARCLOSETK",
        "PAROPENTK",
        "Type",
        "Expression",
        "PARCLOSETK",
        "Type",
        "Type",
        "PAROPENTK",
        "Type",
        "COLONTK",
        "Type",
        "PARCLOSETK",
        "SENDTK",
        "RECEIVETK",
        "SENDRECEIVETK",
        "Type",
        "Type",
        "Type",
        "Type",
        "PAROPENTK",
        "Type",
        "PAROPENTK",
        "PARCLOSETK",
        "Type",
        "TypeList",
        "COMMATK",
        "PARCLOSETK",
        "Type",
        "PARCLOSETK",
        "TypeList",
        "PARCLOSETK",
        "Type",
        "PAROPENTK",
        "PARCLOSETK",
        "TypeList",
        "PARCLOSETK",
        "BECOMESTK",
        "Type",
        "IDENTIFIERTK",
        "Type",
        "IDENTIFIERTK",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "Type",
        "IdentifierList",
        "SEMICOLTK",
        "PARCLOSETK",
        "COLONTK",
        "FORKW",
        "WHILEKW",
        "BREAKKW",
        "CONTINUEKW",
        "RETURNKW",
        "RUNKW",
        "STARTKW",
        "SELECTKW",
        "CLOSEKW",
        "IFKW",
        "DELAYKW",
        "FINISHKW",
        "PASSKW",
        "EXITKW",
        "WRITEKW",
        "WRITELNKW",
        "Body",
        "CommStatement",
        "CompoundStatement",
        "EndCompound",
        "EndSimple",
        "Expression",
        "ExprList",
        "SimpleStatement",
        "StatementList",
        "Type",
        "VarDefinitionList",
        "StatementList",
        "Type",
        "IDENTIFIERTK",
        "VarNames",
        "COMMATK",
        "SEMICOLTK",
        "IDENTIFIERTK",
        "BECOMESTK",
        "Expression",
        "BECOMESTK",
        "Expression",
        "VarNames",
        "SEMICOLTK",
        "BECOMESTK",
        "ExprList",
        "SENDTK",
        "RECEIVETK",
        "ExprList",
        "ExprList",
        "SEMICOLTK",
        "CompoundStatement",
        "SimpleStatement",
        "SEMICOLTK",
        "CompoundStatement",
        "SimpleStatement",
        "CompoundStatement",
        "SimpleStatement",
        "ENDKW",
        "PAROPENTK",
        "ExprList",
        "PARCLOSETK",
        "PAROPENTK",
        "ExprList",
        "PARCLOSETK",
        "ExprList",
        "ExprList",
        "Expression",
        "Expression",
        "COLONTK",
        "StatementList",
        "ElifsOpt",
        "ELIFKW",
        "ELSEKW",
        "ElseOpt",
        "ENDKW",
        "COLONTK",
        "StatementList",
        "Expression",
        "COLONTK",
        "StatementList",
        "PAROPENTK",
        "Expression",
        "PARCLOSETK",
        "UNWINDKW",
        "CommStatement",
        "Expression",
        "SelectCondition",
        "SelectionAlt",
        "Selections",
        "Unwinds",
        "COLONTK",
        "COMMATK",
        "IdentifierList",
        "INKW",
        "Expression",
        "SelectionAlt",
        "ENDKW",
        "ALTKW",
        "ENDKW",
        "SelectionAlt",
        "COLONTK",
        "StatementList",
        "COMMATK",
        "CommStatement",
        "Expression",
        "IdentifierList",
        "INKW",
        "Expression",
        "EndInstance",
        "EndIterated",
        "Expression",
        "Instances",
        "IteratedInstance",
        "ProcessInstance",
        "Unwinds",
        "COLONTK",
        "Instances",
        "ENDKW",
        "BECOMESTK",
        "Expression",
        "COMMATK",
        "IteratedInstance",
        "ProcessInstance",
        "IteratedInstance",
        "ProcessInstance",
        "COMMATK",
        "IteratedInstance",
        "ProcessInstance",
        "Instances",
        "ExprList",
        "Expression",
        "COLONTK",
        "StatementList",
        "ENDKW",
        "IdentifierList",
        "INKW",
        "Expression",
        "COLONTK",
        "StatementList",
        "ENDKW",
        "Type",
        "IdentifierList",
        "COLONTK",
        "Body",
        "ENDKW",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "PARCLOSETK",
        "COLONTK",
        "Body",
        "ENDKW",
        "COLONTK",
        "Body",
        "ENDKW",
        "IDENTIFIERTK",
        "Type",
        "IDENTIFIERTK",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "PARCLOSETK",
        "COLONTK",
        "Body",
        "ENDKW",
        "COLONTK",
        "Body",
        "ENDKW",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "PARCLOSETK",
        "COLONTK",
        "Body",
        "ENDKW",
        "COLONTK",
        "Body",
        "ENDKW",
        "Type",
        "IDENTIFIERTK",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "PARCLOSETK",
        "COLONTK",
        "Body",
        "ENDKW",
        "COLONTK",
        "Body",
        "ENDKW",
        "IDENTIFIERTK",
        "PAROPENTK",
        "PARCLOSETK",
        "FormalParameters",
        "PARCLOSETK",
        "COLONTK",
        "Body",
        "ENDKW",
        "COLONTK",
        "Body",
        "ENDKW",
        "IDENTIFIERTK",
        "EnumDefList",
        "COMMATK",
        "IDENTIFIERTK",
        "BECOMESTK",
        "CUROPENTK",
        "IdentifierList",
        "CURCLOSETK",
        "BECOMESTK",
        "CUROPENTK",
        "IdentifierList",
        "CURCLOSETK",
        "ConstantDefList",
        "Type",
        "IDENTIFIERTK",
        "BECOMESTK",
        "Expression",
        "COMMATK",
        "Type",
        "IDENTIFIERTK",
        "BECOMESTK",
        "Expression",
    };

    /** Parser call back hook methods. */
    private final ChiHooks hooks;

    /** Whether parsing has completed (final result has been accepted). */
    private boolean accept;

    /** The parse result, but only if {@code #accept} is {@code true}. */
    private List<Declaration> acceptObject;

    /** The current scanner token to process, if any. */
    private Token token;

    /** Whether parsing has resulted in a reduce action. */
    private boolean reduce;

    /** The state from which to reduce, if {@code #reduce} is {@code true}. */
    private int reduceState;

    /** The non-terminal to reduce, if {@code #reduce} is {@code true}. */
    private int reduceNonTerminal;

    /** Constructor for the {@link ChiParser} class. */
    public ChiParser() {
        super(new ChiScanner());
        entrySymbolNames = ENTRY_SYMBOL_NAMES;
        firstTerminals = FirstTerminals.FIRST_TERMINALS;
        firstTerminalsReduced = FirstTerminalsReduced.FIRST_TERMINALS_REDUCED;
        reducibleNonTerminals = ReducibleNonTerminals.REDUCIBLE_NON_TERMINALS;
        reducibleNonTerminalsReduced = ReducibleNonTerminalsReduced.REDUCIBLE_NON_TERMINALS_REDUCED;
        hooks = ((ChiScanner)scanner).hooks;
    }

    @Override
    public ParserHooksBase getHooks() {
        return hooks;
    }

    @Override
    protected final List<Declaration> parse() throws IOException {
        token = nextToken();
        int state;

        accept = false;

        while (true) {
            // Perform action.
            state = getCurrentState();
            reduce = false;

            switch (state) {
                case 0:
                    action0();
                    break;
                case 1:
                    action1();
                    break;
                case 2:
                    action2();
                    break;
                case 3:
                    action3();
                    break;
                case 4:
                    action4();
                    break;
                case 5:
                    action5();
                    break;
                case 6:
                    action6();
                    break;
                case 7:
                    action7();
                    break;
                case 8:
                    action8();
                    break;
                case 9:
                    action9();
                    break;
                case 10:
                    action10();
                    break;
                case 11:
                    action11();
                    break;
                case 12:
                    action12();
                    break;
                case 13:
                    action13();
                    break;
                case 14:
                    action14();
                    break;
                case 15:
                    action15();
                    break;
                case 16:
                    action16();
                    break;
                case 17:
                    action17();
                    break;
                case 18:
                    action18();
                    break;
                case 19:
                    action19();
                    break;
                case 20:
                    action20();
                    break;
                case 21:
                    action21();
                    break;
                case 22:
                    action22();
                    break;
                case 23:
                    action23();
                    break;
                case 24:
                    action24();
                    break;
                case 25:
                    action25();
                    break;
                case 26:
                    action26();
                    break;
                case 27:
                    action27();
                    break;
                case 28:
                    action28();
                    break;
                case 29:
                    action29();
                    break;
                case 30:
                    action30();
                    break;
                case 31:
                    action31();
                    break;
                case 32:
                    action32();
                    break;
                case 33:
                    action33();
                    break;
                case 34:
                    action34();
                    break;
                case 35:
                    action35();
                    break;
                case 36:
                    action36();
                    break;
                case 37:
                    action37();
                    break;
                case 38:
                    action38();
                    break;
                case 39:
                    action39();
                    break;
                case 40:
                    action40();
                    break;
                case 41:
                    action41();
                    break;
                case 42:
                    action42();
                    break;
                case 43:
                    action43();
                    break;
                case 44:
                    action44();
                    break;
                case 45:
                    action45();
                    break;
                case 46:
                    action46();
                    break;
                case 47:
                    action47();
                    break;
                case 48:
                    action48();
                    break;
                case 49:
                    action49();
                    break;
                case 50:
                    action50();
                    break;
                case 51:
                    action51();
                    break;
                case 52:
                    action52();
                    break;
                case 53:
                    action53();
                    break;
                case 54:
                    action54();
                    break;
                case 55:
                    action55();
                    break;
                case 56:
                    action56();
                    break;
                case 57:
                    action57();
                    break;
                case 58:
                    action58();
                    break;
                case 59:
                    action59();
                    break;
                case 60:
                    action60();
                    break;
                case 61:
                    action61();
                    break;
                case 62:
                    action62();
                    break;
                case 63:
                    action63();
                    break;
                case 64:
                    action64();
                    break;
                case 65:
                    action65();
                    break;
                case 66:
                    action66();
                    break;
                case 67:
                    action67();
                    break;
                case 68:
                    action68();
                    break;
                case 69:
                    action69();
                    break;
                case 70:
                    action70();
                    break;
                case 71:
                    action71();
                    break;
                case 72:
                    action72();
                    break;
                case 73:
                    action73();
                    break;
                case 74:
                    action74();
                    break;
                case 75:
                    action75();
                    break;
                case 76:
                    action76();
                    break;
                case 77:
                    action77();
                    break;
                case 78:
                    action78();
                    break;
                case 79:
                    action79();
                    break;
                case 80:
                    action80();
                    break;
                case 81:
                    action81();
                    break;
                case 82:
                    action82();
                    break;
                case 83:
                    action83();
                    break;
                case 84:
                    action84();
                    break;
                case 85:
                    action85();
                    break;
                case 86:
                    action86();
                    break;
                case 87:
                    action87();
                    break;
                case 88:
                    action88();
                    break;
                case 89:
                    action89();
                    break;
                case 90:
                    action90();
                    break;
                case 91:
                    action91();
                    break;
                case 92:
                    action92();
                    break;
                case 93:
                    action93();
                    break;
                case 94:
                    action94();
                    break;
                case 95:
                    action95();
                    break;
                case 96:
                    action96();
                    break;
                case 97:
                    action97();
                    break;
                case 98:
                    action98();
                    break;
                case 99:
                    action99();
                    break;
                case 100:
                    action100();
                    break;
                case 101:
                    action101();
                    break;
                case 102:
                    action102();
                    break;
                case 103:
                    action103();
                    break;
                case 104:
                    action104();
                    break;
                case 105:
                    action105();
                    break;
                case 106:
                    action106();
                    break;
                case 107:
                    action107();
                    break;
                case 108:
                    action108();
                    break;
                case 109:
                    action109();
                    break;
                case 110:
                    action110();
                    break;
                case 111:
                    action111();
                    break;
                case 112:
                    action112();
                    break;
                case 113:
                    action113();
                    break;
                case 114:
                    action114();
                    break;
                case 115:
                    action115();
                    break;
                case 116:
                    action116();
                    break;
                case 117:
                    action117();
                    break;
                case 118:
                    action118();
                    break;
                case 119:
                    action119();
                    break;
                case 120:
                    action120();
                    break;
                case 121:
                    action121();
                    break;
                case 122:
                    action122();
                    break;
                case 123:
                    action123();
                    break;
                case 124:
                    action124();
                    break;
                case 125:
                    action125();
                    break;
                case 126:
                    action126();
                    break;
                case 127:
                    action127();
                    break;
                case 128:
                    action128();
                    break;
                case 129:
                    action129();
                    break;
                case 130:
                    action130();
                    break;
                case 131:
                    action131();
                    break;
                case 132:
                    action132();
                    break;
                case 133:
                    action133();
                    break;
                case 134:
                    action134();
                    break;
                case 135:
                    action135();
                    break;
                case 136:
                    action136();
                    break;
                case 137:
                    action137();
                    break;
                case 138:
                    action138();
                    break;
                case 139:
                    action139();
                    break;
                case 140:
                    action140();
                    break;
                case 141:
                    action141();
                    break;
                case 142:
                    action142();
                    break;
                case 143:
                    action143();
                    break;
                case 144:
                    action144();
                    break;
                case 145:
                    action145();
                    break;
                case 146:
                    action146();
                    break;
                case 147:
                    action147();
                    break;
                case 148:
                    action148();
                    break;
                case 149:
                    action149();
                    break;
                case 150:
                    action150();
                    break;
                case 151:
                    action151();
                    break;
                case 152:
                    action152();
                    break;
                case 153:
                    action153();
                    break;
                case 154:
                    action154();
                    break;
                case 155:
                    action155();
                    break;
                case 156:
                    action156();
                    break;
                case 157:
                    action157();
                    break;
                case 158:
                    action158();
                    break;
                case 159:
                    action159();
                    break;
                case 160:
                    action160();
                    break;
                case 161:
                    action161();
                    break;
                case 162:
                    action162();
                    break;
                case 163:
                    action163();
                    break;
                case 164:
                    action164();
                    break;
                case 165:
                    action165();
                    break;
                case 166:
                    action166();
                    break;
                case 167:
                    action167();
                    break;
                case 168:
                    action168();
                    break;
                case 169:
                    action169();
                    break;
                case 170:
                    action170();
                    break;
                case 171:
                    action171();
                    break;
                case 172:
                    action172();
                    break;
                case 173:
                    action173();
                    break;
                case 174:
                    action174();
                    break;
                case 175:
                    action175();
                    break;
                case 176:
                    action176();
                    break;
                case 177:
                    action177();
                    break;
                case 178:
                    action178();
                    break;
                case 179:
                    action179();
                    break;
                case 180:
                    action180();
                    break;
                case 181:
                    action181();
                    break;
                case 182:
                    action182();
                    break;
                case 183:
                    action183();
                    break;
                case 184:
                    action184();
                    break;
                case 185:
                    action185();
                    break;
                case 186:
                    action186();
                    break;
                case 187:
                    action187();
                    break;
                case 188:
                    action188();
                    break;
                case 189:
                    action189();
                    break;
                case 190:
                    action190();
                    break;
                case 191:
                    action191();
                    break;
                case 192:
                    action192();
                    break;
                case 193:
                    action193();
                    break;
                case 194:
                    action194();
                    break;
                case 195:
                    action195();
                    break;
                case 196:
                    action196();
                    break;
                case 197:
                    action197();
                    break;
                case 198:
                    action198();
                    break;
                case 199:
                    action199();
                    break;
                case 200:
                    action200();
                    break;
                case 201:
                    action201();
                    break;
                case 202:
                    action202();
                    break;
                case 203:
                    action203();
                    break;
                case 204:
                    action204();
                    break;
                case 205:
                    action205();
                    break;
                case 206:
                    action206();
                    break;
                case 207:
                    action207();
                    break;
                case 208:
                    action208();
                    break;
                case 209:
                    action209();
                    break;
                case 210:
                    action210();
                    break;
                case 211:
                    action211();
                    break;
                case 212:
                    action212();
                    break;
                case 213:
                    action213();
                    break;
                case 214:
                    action214();
                    break;
                case 215:
                    action215();
                    break;
                case 216:
                    action216();
                    break;
                case 217:
                    action217();
                    break;
                case 218:
                    action218();
                    break;
                case 219:
                    action219();
                    break;
                case 220:
                    action220();
                    break;
                case 221:
                    action221();
                    break;
                case 222:
                    action222();
                    break;
                case 223:
                    action223();
                    break;
                case 224:
                    action224();
                    break;
                case 225:
                    action225();
                    break;
                case 226:
                    action226();
                    break;
                case 227:
                    action227();
                    break;
                case 228:
                    action228();
                    break;
                case 229:
                    action229();
                    break;
                case 230:
                    action230();
                    break;
                case 231:
                    action231();
                    break;
                case 232:
                    action232();
                    break;
                case 233:
                    action233();
                    break;
                case 234:
                    action234();
                    break;
                case 235:
                    action235();
                    break;
                case 236:
                    action236();
                    break;
                case 237:
                    action237();
                    break;
                case 238:
                    action238();
                    break;
                case 239:
                    action239();
                    break;
                case 240:
                    action240();
                    break;
                case 241:
                    action241();
                    break;
                case 242:
                    action242();
                    break;
                case 243:
                    action243();
                    break;
                case 244:
                    action244();
                    break;
                case 245:
                    action245();
                    break;
                case 246:
                    action246();
                    break;
                case 247:
                    action247();
                    break;
                case 248:
                    action248();
                    break;
                case 249:
                    action249();
                    break;
                case 250:
                    action250();
                    break;
                case 251:
                    action251();
                    break;
                case 252:
                    action252();
                    break;
                case 253:
                    action253();
                    break;
                case 254:
                    action254();
                    break;
                case 255:
                    action255();
                    break;
                case 256:
                    action256();
                    break;
                case 257:
                    action257();
                    break;
                case 258:
                    action258();
                    break;
                case 259:
                    action259();
                    break;
                case 260:
                    action260();
                    break;
                case 261:
                    action261();
                    break;
                case 262:
                    action262();
                    break;
                case 263:
                    action263();
                    break;
                case 264:
                    action264();
                    break;
                case 265:
                    action265();
                    break;
                case 266:
                    action266();
                    break;
                case 267:
                    action267();
                    break;
                case 268:
                    action268();
                    break;
                case 269:
                    action269();
                    break;
                case 270:
                    action270();
                    break;
                case 271:
                    action271();
                    break;
                case 272:
                    action272();
                    break;
                case 273:
                    action273();
                    break;
                case 274:
                    action274();
                    break;
                case 275:
                    action275();
                    break;
                case 276:
                    action276();
                    break;
                case 277:
                    action277();
                    break;
                case 278:
                    action278();
                    break;
                case 279:
                    action279();
                    break;
                case 280:
                    action280();
                    break;
                case 281:
                    action281();
                    break;
                case 282:
                    action282();
                    break;
                case 283:
                    action283();
                    break;
                case 284:
                    action284();
                    break;
                case 285:
                    action285();
                    break;
                case 286:
                    action286();
                    break;
                case 287:
                    action287();
                    break;
                case 288:
                    action288();
                    break;
                case 289:
                    action289();
                    break;
                case 290:
                    action290();
                    break;
                case 291:
                    action291();
                    break;
                case 292:
                    action292();
                    break;
                case 293:
                    action293();
                    break;
                case 294:
                    action294();
                    break;
                case 295:
                    action295();
                    break;
                case 296:
                    action296();
                    break;
                case 297:
                    action297();
                    break;
                case 298:
                    action298();
                    break;
                case 299:
                    action299();
                    break;
                case 300:
                    action300();
                    break;
                case 301:
                    action301();
                    break;
                case 302:
                    action302();
                    break;
                case 303:
                    action303();
                    break;
                case 304:
                    action304();
                    break;
                case 305:
                    action305();
                    break;
                case 306:
                    action306();
                    break;
                case 307:
                    action307();
                    break;
                case 308:
                    action308();
                    break;
                case 309:
                    action309();
                    break;
                case 310:
                    action310();
                    break;
                case 311:
                    action311();
                    break;
                case 312:
                    action312();
                    break;
                case 313:
                    action313();
                    break;
                case 314:
                    action314();
                    break;
                case 315:
                    action315();
                    break;
                case 316:
                    action316();
                    break;
                case 317:
                    action317();
                    break;
                case 318:
                    action318();
                    break;
                case 319:
                    action319();
                    break;
                case 320:
                    action320();
                    break;
                case 321:
                    action321();
                    break;
                case 322:
                    action322();
                    break;
                case 323:
                    action323();
                    break;
                case 324:
                    action324();
                    break;
                case 325:
                    action325();
                    break;
                case 326:
                    action326();
                    break;
                case 327:
                    action327();
                    break;
                case 328:
                    action328();
                    break;
                case 329:
                    action329();
                    break;
                case 330:
                    action330();
                    break;
                case 331:
                    action331();
                    break;
                case 332:
                    action332();
                    break;
                case 333:
                    action333();
                    break;
                case 334:
                    action334();
                    break;
                case 335:
                    action335();
                    break;
                case 336:
                    action336();
                    break;
                case 337:
                    action337();
                    break;
                case 338:
                    action338();
                    break;
                case 339:
                    action339();
                    break;
                case 340:
                    action340();
                    break;
                case 341:
                    action341();
                    break;
                case 342:
                    action342();
                    break;
                case 343:
                    action343();
                    break;
                case 344:
                    action344();
                    break;
                case 345:
                    action345();
                    break;
                case 346:
                    action346();
                    break;
                case 347:
                    action347();
                    break;
                case 348:
                    action348();
                    break;
                case 349:
                    action349();
                    break;
                case 350:
                    action350();
                    break;
                case 351:
                    action351();
                    break;
                case 352:
                    action352();
                    break;
                case 353:
                    action353();
                    break;
                case 354:
                    action354();
                    break;
                case 355:
                    action355();
                    break;
                case 356:
                    action356();
                    break;
                case 357:
                    action357();
                    break;
                case 358:
                    action358();
                    break;
                case 359:
                    action359();
                    break;
                case 360:
                    action360();
                    break;
                case 361:
                    action361();
                    break;
                case 362:
                    action362();
                    break;
                case 363:
                    action363();
                    break;
                case 364:
                    action364();
                    break;
                case 365:
                    action365();
                    break;
                case 366:
                    action366();
                    break;
                case 367:
                    action367();
                    break;
                case 368:
                    action368();
                    break;
                case 369:
                    action369();
                    break;
                case 370:
                    action370();
                    break;
                case 371:
                    action371();
                    break;
                case 372:
                    action372();
                    break;
                case 373:
                    action373();
                    break;
                case 374:
                    action374();
                    break;
                case 375:
                    action375();
                    break;
                case 376:
                    action376();
                    break;
                case 377:
                    action377();
                    break;
                case 378:
                    action378();
                    break;
                case 379:
                    action379();
                    break;
                case 380:
                    action380();
                    break;
                case 381:
                    action381();
                    break;
                case 382:
                    action382();
                    break;
                case 383:
                    action383();
                    break;
                case 384:
                    action384();
                    break;
                case 385:
                    action385();
                    break;
                case 386:
                    action386();
                    break;
                case 387:
                    action387();
                    break;
                case 388:
                    action388();
                    break;
                case 389:
                    action389();
                    break;
                case 390:
                    action390();
                    break;
                case 391:
                    action391();
                    break;
                case 392:
                    action392();
                    break;
                case 393:
                    action393();
                    break;
                case 394:
                    action394();
                    break;
                case 395:
                    action395();
                    break;
                case 396:
                    action396();
                    break;
                case 397:
                    action397();
                    break;
                case 398:
                    action398();
                    break;
                case 399:
                    action399();
                    break;
                case 400:
                    action400();
                    break;
                case 401:
                    action401();
                    break;
                case 402:
                    action402();
                    break;
                case 403:
                    action403();
                    break;
                case 404:
                    action404();
                    break;
                case 405:
                    action405();
                    break;
                case 406:
                    action406();
                    break;
                case 407:
                    action407();
                    break;
                case 408:
                    action408();
                    break;
                case 409:
                    action409();
                    break;
                case 410:
                    action410();
                    break;
                case 411:
                    action411();
                    break;
                case 412:
                    action412();
                    break;
                case 413:
                    action413();
                    break;
                case 414:
                    action414();
                    break;
                case 415:
                    action415();
                    break;
                case 416:
                    action416();
                    break;
                case 417:
                    action417();
                    break;
                case 418:
                    action418();
                    break;
                case 419:
                    action419();
                    break;
                case 420:
                    action420();
                    break;
                case 421:
                    action421();
                    break;
                case 422:
                    action422();
                    break;
                case 423:
                    action423();
                    break;
                case 424:
                    action424();
                    break;
                case 425:
                    action425();
                    break;
                case 426:
                    action426();
                    break;
                case 427:
                    action427();
                    break;
                case 428:
                    action428();
                    break;
                case 429:
                    action429();
                    break;
                case 430:
                    action430();
                    break;
                case 431:
                    action431();
                    break;
                case 432:
                    action432();
                    break;
                case 433:
                    action433();
                    break;
                case 434:
                    action434();
                    break;
                case 435:
                    action435();
                    break;
                case 436:
                    action436();
                    break;
                case 437:
                    action437();
                    break;
                case 438:
                    action438();
                    break;
                case 439:
                    action439();
                    break;
                case 440:
                    action440();
                    break;
                case 441:
                    action441();
                    break;
                case 442:
                    action442();
                    break;
                case 443:
                    action443();
                    break;
                case 444:
                    action444();
                    break;
                case 445:
                    action445();
                    break;
                case 446:
                    action446();
                    break;
                case 447:
                    action447();
                    break;
                case 448:
                    action448();
                    break;
                case 449:
                    action449();
                    break;
                case 450:
                    action450();
                    break;
                case 451:
                    action451();
                    break;
                case 452:
                    action452();
                    break;
                case 453:
                    action453();
                    break;
                case 454:
                    action454();
                    break;
                case 455:
                    action455();
                    break;
                case 456:
                    action456();
                    break;
                case 457:
                    action457();
                    break;
                case 458:
                    action458();
                    break;
                case 459:
                    action459();
                    break;
                case 460:
                    action460();
                    break;
                case 461:
                    action461();
                    break;
                case 462:
                    action462();
                    break;
                case 463:
                    action463();
                    break;
                case 464:
                    action464();
                    break;
                case 465:
                    action465();
                    break;
                case 466:
                    action466();
                    break;
                case 467:
                    action467();
                    break;
                case 468:
                    action468();
                    break;
                case 469:
                    action469();
                    break;
                case 470:
                    action470();
                    break;
                case 471:
                    action471();
                    break;
                case 472:
                    action472();
                    break;
                case 473:
                    action473();
                    break;
                case 474:
                    action474();
                    break;
                case 475:
                    action475();
                    break;
                case 476:
                    action476();
                    break;
                case 477:
                    action477();
                    break;
                case 478:
                    action478();
                    break;
                case 479:
                    action479();
                    break;
                case 480:
                    action480();
                    break;
                case 481:
                    action481();
                    break;
                case 482:
                    action482();
                    break;
                case 483:
                    action483();
                    break;
                case 484:
                    action484();
                    break;
                case 485:
                    action485();
                    break;
                case 486:
                    action486();
                    break;
                case 487:
                    action487();
                    break;
                case 488:
                    action488();
                    break;
                case 489:
                    action489();
                    break;
                case 490:
                    action490();
                    break;
                case 491:
                    action491();
                    break;
                case 492:
                    action492();
                    break;
                case 493:
                    action493();
                    break;
                case 494:
                    action494();
                    break;
                case 495:
                    action495();
                    break;
                case 496:
                    action496();
                    break;
                case 497:
                    action497();
                    break;
                case 498:
                    action498();
                    break;
                case 499:
                    action499();
                    break;
                case 500:
                    action500();
                    break;
                case 501:
                    action501();
                    break;
                case 502:
                    action502();
                    break;
                case 503:
                    action503();
                    break;
                case 504:
                    action504();
                    break;
                case 505:
                    action505();
                    break;
                case 506:
                    action506();
                    break;
                case 507:
                    action507();
                    break;
                case 508:
                    action508();
                    break;
                case 509:
                    action509();
                    break;
                case 510:
                    action510();
                    break;
                case 511:
                    action511();
                    break;
                case 512:
                    action512();
                    break;
                case 513:
                    action513();
                    break;
                case 514:
                    action514();
                    break;
                case 515:
                    action515();
                    break;
                case 516:
                    action516();
                    break;
                case 517:
                    action517();
                    break;
                case 518:
                    action518();
                    break;
                case 519:
                    action519();
                    break;
                case 520:
                    action520();
                    break;
                case 521:
                    action521();
                    break;
                case 522:
                    action522();
                    break;
                case 523:
                    action523();
                    break;
                case 524:
                    action524();
                    break;
                case 525:
                    action525();
                    break;
                case 526:
                    action526();
                    break;
                case 527:
                    action527();
                    break;
                case 528:
                    action528();
                    break;
                case 529:
                    action529();
                    break;
                case 530:
                    action530();
                    break;
                case 531:
                    action531();
                    break;
                case 532:
                    action532();
                    break;
                case 533:
                    action533();
                    break;
                case 534:
                    action534();
                    break;
                case 535:
                    action535();
                    break;
                case 536:
                    action536();
                    break;
                case 537:
                    action537();
                    break;
                case 538:
                    action538();
                    break;
                case 539:
                    action539();
                    break;
                case 540:
                    action540();
                    break;
                default:
                    String msg = "Unknown parser state: " + state;
                    throw new RuntimeException(msg);
            }

            // Accept action.
            if (accept) {
                return acceptObject;
            }

            // Shift action.
            if (!reduce) {
                continue;
            }

            // Perform goto (as part of a reduce action).
            switch (reduceState) {
                case 0:
                    goto0();
                    break;
                case 1:
                    goto1();
                    break;
                case 2:
                    goto2();
                    break;
                case 3:
                    goto3();
                    break;
                case 4:
                    goto4();
                    break;
                case 5:
                    goto5();
                    break;
                case 6:
                    goto6();
                    break;
                case 7:
                    goto7();
                    break;
                case 8:
                    goto8();
                    break;
                case 9:
                    goto9();
                    break;
                case 10:
                    goto10();
                    break;
                case 11:
                    goto11();
                    break;
                case 12:
                    goto12();
                    break;
                case 13:
                    goto13();
                    break;
                case 14:
                    goto14();
                    break;
                case 15:
                    goto15();
                    break;
                case 16:
                    goto16();
                    break;
                case 17:
                    goto17();
                    break;
                case 18:
                    goto18();
                    break;
                case 19:
                    goto19();
                    break;
                case 20:
                    goto20();
                    break;
                case 21:
                    goto21();
                    break;
                case 22:
                    goto22();
                    break;
                case 23:
                    goto23();
                    break;
                case 24:
                    goto24();
                    break;
                case 25:
                    goto25();
                    break;
                case 26:
                    goto26();
                    break;
                case 27:
                    goto27();
                    break;
                case 28:
                    goto28();
                    break;
                case 29:
                    goto29();
                    break;
                case 30:
                    goto30();
                    break;
                case 31:
                    goto31();
                    break;
                case 32:
                    goto32();
                    break;
                case 33:
                    goto33();
                    break;
                case 34:
                    goto34();
                    break;
                case 35:
                    goto35();
                    break;
                case 36:
                    goto36();
                    break;
                case 37:
                    goto37();
                    break;
                case 38:
                    goto38();
                    break;
                case 39:
                    goto39();
                    break;
                case 40:
                    goto40();
                    break;
                case 41:
                    goto41();
                    break;
                case 42:
                    goto42();
                    break;
                case 43:
                    goto43();
                    break;
                case 44:
                    goto44();
                    break;
                case 45:
                    goto45();
                    break;
                case 46:
                    goto46();
                    break;
                case 47:
                    goto47();
                    break;
                case 48:
                    goto48();
                    break;
                case 49:
                    goto49();
                    break;
                case 50:
                    goto50();
                    break;
                case 51:
                    goto51();
                    break;
                case 52:
                    goto52();
                    break;
                case 53:
                    goto53();
                    break;
                case 54:
                    goto54();
                    break;
                case 55:
                    goto55();
                    break;
                case 56:
                    goto56();
                    break;
                case 57:
                    goto57();
                    break;
                case 58:
                    goto58();
                    break;
                case 59:
                    goto59();
                    break;
                case 60:
                    goto60();
                    break;
                case 61:
                    goto61();
                    break;
                case 62:
                    goto62();
                    break;
                case 63:
                    goto63();
                    break;
                case 64:
                    goto64();
                    break;
                case 65:
                    goto65();
                    break;
                case 66:
                    goto66();
                    break;
                case 67:
                    goto67();
                    break;
                case 68:
                    goto68();
                    break;
                case 69:
                    goto69();
                    break;
                case 70:
                    goto70();
                    break;
                case 71:
                    goto71();
                    break;
                case 72:
                    goto72();
                    break;
                case 73:
                    goto73();
                    break;
                case 74:
                    goto74();
                    break;
                case 75:
                    goto75();
                    break;
                case 76:
                    goto76();
                    break;
                case 77:
                    goto77();
                    break;
                case 78:
                    goto78();
                    break;
                case 79:
                    goto79();
                    break;
                case 80:
                    goto80();
                    break;
                case 81:
                    goto81();
                    break;
                case 82:
                    goto82();
                    break;
                case 83:
                    goto83();
                    break;
                case 84:
                    goto84();
                    break;
                case 85:
                    goto85();
                    break;
                case 86:
                    goto86();
                    break;
                case 87:
                    goto87();
                    break;
                case 88:
                    goto88();
                    break;
                case 89:
                    goto89();
                    break;
                case 90:
                    goto90();
                    break;
                case 91:
                    goto91();
                    break;
                case 92:
                    goto92();
                    break;
                case 93:
                    goto93();
                    break;
                case 94:
                    goto94();
                    break;
                case 95:
                    goto95();
                    break;
                case 96:
                    goto96();
                    break;
                case 97:
                    goto97();
                    break;
                case 98:
                    goto98();
                    break;
                case 99:
                    goto99();
                    break;
                case 100:
                    goto100();
                    break;
                case 101:
                    goto101();
                    break;
                case 102:
                    goto102();
                    break;
                case 103:
                    goto103();
                    break;
                case 104:
                    goto104();
                    break;
                case 105:
                    goto105();
                    break;
                case 106:
                    goto106();
                    break;
                case 107:
                    goto107();
                    break;
                case 108:
                    goto108();
                    break;
                case 109:
                    goto109();
                    break;
                case 110:
                    goto110();
                    break;
                case 111:
                    goto111();
                    break;
                case 112:
                    goto112();
                    break;
                case 113:
                    goto113();
                    break;
                case 114:
                    goto114();
                    break;
                case 115:
                    goto115();
                    break;
                case 116:
                    goto116();
                    break;
                case 117:
                    goto117();
                    break;
                case 118:
                    goto118();
                    break;
                case 119:
                    goto119();
                    break;
                case 120:
                    goto120();
                    break;
                case 121:
                    goto121();
                    break;
                case 122:
                    goto122();
                    break;
                case 123:
                    goto123();
                    break;
                case 124:
                    goto124();
                    break;
                case 125:
                    goto125();
                    break;
                case 126:
                    goto126();
                    break;
                case 127:
                    goto127();
                    break;
                case 128:
                    goto128();
                    break;
                case 129:
                    goto129();
                    break;
                case 130:
                    goto130();
                    break;
                case 131:
                    goto131();
                    break;
                case 132:
                    goto132();
                    break;
                case 133:
                    goto133();
                    break;
                case 134:
                    goto134();
                    break;
                case 135:
                    goto135();
                    break;
                case 136:
                    goto136();
                    break;
                case 137:
                    goto137();
                    break;
                case 138:
                    goto138();
                    break;
                case 139:
                    goto139();
                    break;
                case 140:
                    goto140();
                    break;
                case 141:
                    goto141();
                    break;
                case 142:
                    goto142();
                    break;
                case 143:
                    goto143();
                    break;
                case 144:
                    goto144();
                    break;
                case 145:
                    goto145();
                    break;
                case 146:
                    goto146();
                    break;
                case 147:
                    goto147();
                    break;
                case 148:
                    goto148();
                    break;
                case 149:
                    goto149();
                    break;
                case 150:
                    goto150();
                    break;
                case 151:
                    goto151();
                    break;
                case 152:
                    goto152();
                    break;
                case 153:
                    goto153();
                    break;
                case 154:
                    goto154();
                    break;
                case 155:
                    goto155();
                    break;
                case 156:
                    goto156();
                    break;
                case 157:
                    goto157();
                    break;
                case 158:
                    goto158();
                    break;
                case 159:
                    goto159();
                    break;
                case 160:
                    goto160();
                    break;
                case 161:
                    goto161();
                    break;
                case 162:
                    goto162();
                    break;
                case 163:
                    goto163();
                    break;
                case 164:
                    goto164();
                    break;
                case 165:
                    goto165();
                    break;
                case 166:
                    goto166();
                    break;
                case 167:
                    goto167();
                    break;
                case 168:
                    goto168();
                    break;
                case 169:
                    goto169();
                    break;
                case 170:
                    goto170();
                    break;
                case 171:
                    goto171();
                    break;
                case 172:
                    goto172();
                    break;
                case 173:
                    goto173();
                    break;
                case 174:
                    goto174();
                    break;
                case 175:
                    goto175();
                    break;
                case 176:
                    goto176();
                    break;
                case 177:
                    goto177();
                    break;
                case 178:
                    goto178();
                    break;
                case 179:
                    goto179();
                    break;
                case 180:
                    goto180();
                    break;
                case 181:
                    goto181();
                    break;
                case 182:
                    goto182();
                    break;
                case 183:
                    goto183();
                    break;
                case 184:
                    goto184();
                    break;
                case 185:
                    goto185();
                    break;
                case 186:
                    goto186();
                    break;
                case 187:
                    goto187();
                    break;
                case 188:
                    goto188();
                    break;
                case 189:
                    goto189();
                    break;
                case 190:
                    goto190();
                    break;
                case 191:
                    goto191();
                    break;
                case 192:
                    goto192();
                    break;
                case 193:
                    goto193();
                    break;
                case 194:
                    goto194();
                    break;
                case 195:
                    goto195();
                    break;
                case 196:
                    goto196();
                    break;
                case 197:
                    goto197();
                    break;
                case 198:
                    goto198();
                    break;
                case 199:
                    goto199();
                    break;
                case 200:
                    goto200();
                    break;
                case 201:
                    goto201();
                    break;
                case 202:
                    goto202();
                    break;
                case 203:
                    goto203();
                    break;
                case 204:
                    goto204();
                    break;
                case 205:
                    goto205();
                    break;
                case 206:
                    goto206();
                    break;
                case 207:
                    goto207();
                    break;
                case 208:
                    goto208();
                    break;
                case 209:
                    goto209();
                    break;
                case 210:
                    goto210();
                    break;
                case 211:
                    goto211();
                    break;
                case 212:
                    goto212();
                    break;
                case 213:
                    goto213();
                    break;
                case 214:
                    goto214();
                    break;
                case 215:
                    goto215();
                    break;
                case 216:
                    goto216();
                    break;
                case 217:
                    goto217();
                    break;
                case 218:
                    goto218();
                    break;
                case 219:
                    goto219();
                    break;
                case 220:
                    goto220();
                    break;
                case 221:
                    goto221();
                    break;
                case 222:
                    goto222();
                    break;
                case 223:
                    goto223();
                    break;
                case 224:
                    goto224();
                    break;
                case 225:
                    goto225();
                    break;
                case 226:
                    goto226();
                    break;
                case 227:
                    goto227();
                    break;
                case 228:
                    goto228();
                    break;
                case 229:
                    goto229();
                    break;
                case 230:
                    goto230();
                    break;
                case 231:
                    goto231();
                    break;
                case 232:
                    goto232();
                    break;
                case 233:
                    goto233();
                    break;
                case 234:
                    goto234();
                    break;
                case 235:
                    goto235();
                    break;
                case 236:
                    goto236();
                    break;
                case 237:
                    goto237();
                    break;
                case 238:
                    goto238();
                    break;
                case 239:
                    goto239();
                    break;
                case 240:
                    goto240();
                    break;
                case 241:
                    goto241();
                    break;
                case 242:
                    goto242();
                    break;
                case 243:
                    goto243();
                    break;
                case 244:
                    goto244();
                    break;
                case 245:
                    goto245();
                    break;
                case 246:
                    goto246();
                    break;
                case 247:
                    goto247();
                    break;
                case 248:
                    goto248();
                    break;
                case 249:
                    goto249();
                    break;
                case 250:
                    goto250();
                    break;
                case 251:
                    goto251();
                    break;
                case 252:
                    goto252();
                    break;
                case 253:
                    goto253();
                    break;
                case 254:
                    goto254();
                    break;
                case 255:
                    goto255();
                    break;
                case 256:
                    goto256();
                    break;
                case 257:
                    goto257();
                    break;
                case 258:
                    goto258();
                    break;
                case 259:
                    goto259();
                    break;
                case 260:
                    goto260();
                    break;
                case 261:
                    goto261();
                    break;
                case 262:
                    goto262();
                    break;
                case 263:
                    goto263();
                    break;
                case 264:
                    goto264();
                    break;
                case 265:
                    goto265();
                    break;
                case 266:
                    goto266();
                    break;
                case 267:
                    goto267();
                    break;
                case 268:
                    goto268();
                    break;
                case 269:
                    goto269();
                    break;
                case 270:
                    goto270();
                    break;
                case 271:
                    goto271();
                    break;
                case 272:
                    goto272();
                    break;
                case 273:
                    goto273();
                    break;
                case 274:
                    goto274();
                    break;
                case 275:
                    goto275();
                    break;
                case 276:
                    goto276();
                    break;
                case 277:
                    goto277();
                    break;
                case 278:
                    goto278();
                    break;
                case 279:
                    goto279();
                    break;
                case 280:
                    goto280();
                    break;
                case 281:
                    goto281();
                    break;
                case 282:
                    goto282();
                    break;
                case 283:
                    goto283();
                    break;
                case 284:
                    goto284();
                    break;
                case 285:
                    goto285();
                    break;
                case 286:
                    goto286();
                    break;
                case 287:
                    goto287();
                    break;
                case 288:
                    goto288();
                    break;
                case 289:
                    goto289();
                    break;
                case 290:
                    goto290();
                    break;
                case 291:
                    goto291();
                    break;
                case 292:
                    goto292();
                    break;
                case 293:
                    goto293();
                    break;
                case 294:
                    goto294();
                    break;
                case 295:
                    goto295();
                    break;
                case 296:
                    goto296();
                    break;
                case 297:
                    goto297();
                    break;
                case 298:
                    goto298();
                    break;
                case 299:
                    goto299();
                    break;
                case 300:
                    goto300();
                    break;
                case 301:
                    goto301();
                    break;
                case 302:
                    goto302();
                    break;
                case 303:
                    goto303();
                    break;
                case 304:
                    goto304();
                    break;
                case 305:
                    goto305();
                    break;
                case 306:
                    goto306();
                    break;
                case 307:
                    goto307();
                    break;
                case 308:
                    goto308();
                    break;
                case 309:
                    goto309();
                    break;
                case 310:
                    goto310();
                    break;
                case 311:
                    goto311();
                    break;
                case 312:
                    goto312();
                    break;
                case 313:
                    goto313();
                    break;
                case 314:
                    goto314();
                    break;
                case 315:
                    goto315();
                    break;
                case 316:
                    goto316();
                    break;
                case 317:
                    goto317();
                    break;
                case 318:
                    goto318();
                    break;
                case 319:
                    goto319();
                    break;
                case 320:
                    goto320();
                    break;
                case 321:
                    goto321();
                    break;
                case 322:
                    goto322();
                    break;
                case 323:
                    goto323();
                    break;
                case 324:
                    goto324();
                    break;
                case 325:
                    goto325();
                    break;
                case 326:
                    goto326();
                    break;
                case 327:
                    goto327();
                    break;
                case 328:
                    goto328();
                    break;
                case 329:
                    goto329();
                    break;
                case 330:
                    goto330();
                    break;
                case 331:
                    goto331();
                    break;
                case 332:
                    goto332();
                    break;
                case 333:
                    goto333();
                    break;
                case 334:
                    goto334();
                    break;
                case 335:
                    goto335();
                    break;
                case 336:
                    goto336();
                    break;
                case 337:
                    goto337();
                    break;
                case 338:
                    goto338();
                    break;
                case 339:
                    goto339();
                    break;
                case 340:
                    goto340();
                    break;
                case 341:
                    goto341();
                    break;
                case 342:
                    goto342();
                    break;
                case 343:
                    goto343();
                    break;
                case 344:
                    goto344();
                    break;
                case 345:
                    goto345();
                    break;
                case 346:
                    goto346();
                    break;
                case 347:
                    goto347();
                    break;
                case 348:
                    goto348();
                    break;
                case 349:
                    goto349();
                    break;
                case 350:
                    goto350();
                    break;
                case 351:
                    goto351();
                    break;
                case 352:
                    goto352();
                    break;
                case 353:
                    goto353();
                    break;
                case 354:
                    goto354();
                    break;
                case 355:
                    goto355();
                    break;
                case 356:
                    goto356();
                    break;
                case 357:
                    goto357();
                    break;
                case 358:
                    goto358();
                    break;
                case 359:
                    goto359();
                    break;
                case 360:
                    goto360();
                    break;
                case 361:
                    goto361();
                    break;
                case 362:
                    goto362();
                    break;
                case 363:
                    goto363();
                    break;
                case 364:
                    goto364();
                    break;
                case 365:
                    goto365();
                    break;
                case 366:
                    goto366();
                    break;
                case 367:
                    goto367();
                    break;
                case 368:
                    goto368();
                    break;
                case 369:
                    goto369();
                    break;
                case 370:
                    goto370();
                    break;
                case 371:
                    goto371();
                    break;
                case 372:
                    goto372();
                    break;
                case 373:
                    goto373();
                    break;
                case 374:
                    goto374();
                    break;
                case 375:
                    goto375();
                    break;
                case 376:
                    goto376();
                    break;
                case 377:
                    goto377();
                    break;
                case 378:
                    goto378();
                    break;
                case 379:
                    goto379();
                    break;
                case 380:
                    goto380();
                    break;
                case 381:
                    goto381();
                    break;
                case 382:
                    goto382();
                    break;
                case 383:
                    goto383();
                    break;
                case 384:
                    goto384();
                    break;
                case 385:
                    goto385();
                    break;
                case 386:
                    goto386();
                    break;
                case 387:
                    goto387();
                    break;
                case 388:
                    goto388();
                    break;
                case 389:
                    goto389();
                    break;
                case 390:
                    goto390();
                    break;
                case 391:
                    goto391();
                    break;
                case 392:
                    goto392();
                    break;
                case 393:
                    goto393();
                    break;
                case 394:
                    goto394();
                    break;
                case 395:
                    goto395();
                    break;
                case 396:
                    goto396();
                    break;
                case 397:
                    goto397();
                    break;
                case 398:
                    goto398();
                    break;
                case 399:
                    goto399();
                    break;
                case 400:
                    goto400();
                    break;
                case 401:
                    goto401();
                    break;
                case 402:
                    goto402();
                    break;
                case 403:
                    goto403();
                    break;
                case 404:
                    goto404();
                    break;
                case 405:
                    goto405();
                    break;
                case 406:
                    goto406();
                    break;
                case 407:
                    goto407();
                    break;
                case 408:
                    goto408();
                    break;
                case 409:
                    goto409();
                    break;
                case 410:
                    goto410();
                    break;
                case 411:
                    goto411();
                    break;
                case 412:
                    goto412();
                    break;
                case 413:
                    goto413();
                    break;
                case 414:
                    goto414();
                    break;
                case 415:
                    goto415();
                    break;
                case 416:
                    goto416();
                    break;
                case 417:
                    goto417();
                    break;
                case 418:
                    goto418();
                    break;
                case 419:
                    goto419();
                    break;
                case 420:
                    goto420();
                    break;
                case 421:
                    goto421();
                    break;
                case 422:
                    goto422();
                    break;
                case 423:
                    goto423();
                    break;
                case 424:
                    goto424();
                    break;
                case 425:
                    goto425();
                    break;
                case 426:
                    goto426();
                    break;
                case 427:
                    goto427();
                    break;
                case 428:
                    goto428();
                    break;
                case 429:
                    goto429();
                    break;
                case 430:
                    goto430();
                    break;
                case 431:
                    goto431();
                    break;
                case 432:
                    goto432();
                    break;
                case 433:
                    goto433();
                    break;
                case 434:
                    goto434();
                    break;
                case 435:
                    goto435();
                    break;
                case 436:
                    goto436();
                    break;
                case 437:
                    goto437();
                    break;
                case 438:
                    goto438();
                    break;
                case 439:
                    goto439();
                    break;
                case 440:
                    goto440();
                    break;
                case 441:
                    goto441();
                    break;
                case 442:
                    goto442();
                    break;
                case 443:
                    goto443();
                    break;
                case 444:
                    goto444();
                    break;
                case 445:
                    goto445();
                    break;
                case 446:
                    goto446();
                    break;
                case 447:
                    goto447();
                    break;
                case 448:
                    goto448();
                    break;
                case 449:
                    goto449();
                    break;
                case 450:
                    goto450();
                    break;
                case 451:
                    goto451();
                    break;
                case 452:
                    goto452();
                    break;
                case 453:
                    goto453();
                    break;
                case 454:
                    goto454();
                    break;
                case 455:
                    goto455();
                    break;
                case 456:
                    goto456();
                    break;
                case 457:
                    goto457();
                    break;
                case 458:
                    goto458();
                    break;
                case 459:
                    goto459();
                    break;
                case 460:
                    goto460();
                    break;
                case 461:
                    goto461();
                    break;
                case 462:
                    goto462();
                    break;
                case 463:
                    goto463();
                    break;
                case 464:
                    goto464();
                    break;
                case 465:
                    goto465();
                    break;
                case 466:
                    goto466();
                    break;
                case 467:
                    goto467();
                    break;
                case 468:
                    goto468();
                    break;
                case 469:
                    goto469();
                    break;
                case 470:
                    goto470();
                    break;
                case 471:
                    goto471();
                    break;
                case 472:
                    goto472();
                    break;
                case 473:
                    goto473();
                    break;
                case 474:
                    goto474();
                    break;
                case 475:
                    goto475();
                    break;
                case 476:
                    goto476();
                    break;
                case 477:
                    goto477();
                    break;
                case 478:
                    goto478();
                    break;
                case 479:
                    goto479();
                    break;
                case 480:
                    goto480();
                    break;
                case 481:
                    goto481();
                    break;
                case 482:
                    goto482();
                    break;
                case 483:
                    goto483();
                    break;
                case 484:
                    goto484();
                    break;
                case 485:
                    goto485();
                    break;
                case 486:
                    goto486();
                    break;
                case 487:
                    goto487();
                    break;
                case 488:
                    goto488();
                    break;
                case 489:
                    goto489();
                    break;
                case 490:
                    goto490();
                    break;
                case 491:
                    goto491();
                    break;
                case 492:
                    goto492();
                    break;
                case 493:
                    goto493();
                    break;
                case 494:
                    goto494();
                    break;
                case 495:
                    goto495();
                    break;
                case 496:
                    goto496();
                    break;
                case 497:
                    goto497();
                    break;
                case 498:
                    goto498();
                    break;
                case 499:
                    goto499();
                    break;
                case 500:
                    goto500();
                    break;
                case 501:
                    goto501();
                    break;
                case 502:
                    goto502();
                    break;
                case 503:
                    goto503();
                    break;
                case 504:
                    goto504();
                    break;
                case 505:
                    goto505();
                    break;
                case 506:
                    goto506();
                    break;
                case 507:
                    goto507();
                    break;
                case 508:
                    goto508();
                    break;
                case 509:
                    goto509();
                    break;
                case 510:
                    goto510();
                    break;
                case 511:
                    goto511();
                    break;
                case 512:
                    goto512();
                    break;
                case 513:
                    goto513();
                    break;
                case 514:
                    goto514();
                    break;
                case 515:
                    goto515();
                    break;
                case 516:
                    goto516();
                    break;
                case 517:
                    goto517();
                    break;
                case 518:
                    goto518();
                    break;
                case 519:
                    goto519();
                    break;
                case 520:
                    goto520();
                    break;
                case 521:
                    goto521();
                    break;
                case 522:
                    goto522();
                    break;
                case 523:
                    goto523();
                    break;
                case 524:
                    goto524();
                    break;
                case 525:
                    goto525();
                    break;
                case 526:
                    goto526();
                    break;
                case 527:
                    goto527();
                    break;
                case 528:
                    goto528();
                    break;
                case 529:
                    goto529();
                    break;
                case 530:
                    goto530();
                    break;
                case 531:
                    goto531();
                    break;
                case 532:
                    goto532();
                    break;
                case 533:
                    goto533();
                    break;
                case 534:
                    goto534();
                    break;
                case 535:
                    goto535();
                    break;
                case 536:
                    goto536();
                    break;
                case 537:
                    goto537();
                    break;
                case 538:
                    goto538();
                    break;
                case 539:
                    goto539();
                    break;
                case 540:
                    goto540();
                    break;
                default:
                    String msg = fmt("Unknown reduce state %d.", reduceState);
                    throw new RuntimeException(msg);
            }
        }
    }

    /**
     * Parser action code for parser state 0.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action0() throws IOException {
        switch (token.id) {
            case 57: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 58: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 59: {
                // Shift 3.
                token = doShift(token, 3);
                return;
            }

            case 60: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 61: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 62: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 63: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 142: {
                // Reduce Program : ;
                doReduce1(token, 0);
                List<Declaration> o = hooks.parseProgram1();

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 1.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action1() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 2.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action2() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 519.
                token = doShift(token, 519);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 3.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action3() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 508.
                token = doShift(token, 508);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 4.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action4() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 5.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action5() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 473.
                token = doShift(token, 473);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 6.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action6() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 310.
                token = doShift(token, 310);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 7.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action7() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 21.
                token = doShift(token, 21);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 8.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action8() throws IOException {
        switch (token.id) {
            case 57:
            case 58:
            case 59:
            case 60:
            case 61:
            case 62:
            case 63:
            case 126:
            case 142: {
                // Reduce EndCompoundProgram : CompoundProgram;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndCompoundProgram1((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 9.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action9() throws IOException {
        switch (token.id) {
            case 57: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 58: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 59: {
                // Shift 3.
                token = doShift(token, 3);
                return;
            }

            case 60: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 61: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 62: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 63: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 126: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            case 142: {
                // Reduce Program : EndCompoundProgram;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseProgram4((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 10.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action10() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 13.
                token = doShift(token, 13);
                return;
            }

            case 142: {
                // Reduce Program : EndSimpleProgram;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseProgram2((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 11.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action11() throws IOException {
        switch (token.id) {
            case 142: {
                // Accept.
                Object rslt = doAccept(token);
                accept = true;
                acceptObject = (List<Declaration>)rslt;
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 12.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action12() throws IOException {
        switch (token.id) {
            case 126:
            case 142: {
                // Reduce EndSimpleProgram : SimpleProgram;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndSimpleProgram1((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 13.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action13() throws IOException {
        switch (token.id) {
            case 57: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 58: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 59: {
                // Shift 3.
                token = doShift(token, 3);
                return;
            }

            case 60: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 61: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 62: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 63: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 142: {
                // Reduce Program : EndSimpleProgram SEMICOLTK;
                doReduce1(token, 0);
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseProgram3((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 14.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action14() throws IOException {
        switch (token.id) {
            case 57:
            case 58:
            case 59:
            case 60:
            case 61:
            case 62:
            case 63:
            case 126:
            case 142: {
                // Reduce EndCompoundProgram : EndSimpleProgram SEMICOLTK CompoundProgram;
                doReduce1(token, 2);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndCompoundProgram4((List<Declaration>)o1, (List<Declaration>)o3);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 15.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action15() throws IOException {
        switch (token.id) {
            case 126:
            case 142: {
                // Reduce EndSimpleProgram : EndSimpleProgram SEMICOLTK SimpleProgram;
                doReduce1(token, 1);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndSimpleProgram2((List<Declaration>)o1, (List<Declaration>)o3);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 16.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action16() throws IOException {
        switch (token.id) {
            case 57: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 58: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 59: {
                // Shift 3.
                token = doShift(token, 3);
                return;
            }

            case 60: {
                // Shift 4.
                token = doShift(token, 4);
                return;
            }

            case 61: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 62: {
                // Shift 6.
                token = doShift(token, 6);
                return;
            }

            case 63: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 142: {
                // Reduce Program : EndCompoundProgram SEMICOLTK;
                doReduce1(token, 0);
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseProgram5((List<Declaration>)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 17.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action17() throws IOException {
        switch (token.id) {
            case 57:
            case 58:
            case 59:
            case 60:
            case 61:
            case 62:
            case 63:
            case 126:
            case 142: {
                // Reduce EndCompoundProgram : EndCompoundProgram CompoundProgram;
                doReduce1(token, 2);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndCompoundProgram2((List<Declaration>)o1, (List<Declaration>)o2);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 18.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action18() throws IOException {
        switch (token.id) {
            case 126:
            case 142: {
                // Reduce EndSimpleProgram : EndCompoundProgram SimpleProgram;
                doReduce1(token, 1);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndSimpleProgram4((List<Declaration>)o1, (List<Declaration>)o2);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 19.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action19() throws IOException {
        switch (token.id) {
            case 57:
            case 58:
            case 59:
            case 60:
            case 61:
            case 62:
            case 63:
            case 126:
            case 142: {
                // Reduce EndCompoundProgram : EndCompoundProgram SEMICOLTK CompoundProgram;
                doReduce1(token, 2);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndCompoundProgram3((List<Declaration>)o1, (List<Declaration>)o3);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 20.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action20() throws IOException {
        switch (token.id) {
            case 126:
            case 142: {
                // Reduce EndSimpleProgram : EndCompoundProgram SEMICOLTK SimpleProgram;
                doReduce1(token, 1);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseEndSimpleProgram3((List<Declaration>)o1, (List<Declaration>)o3);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 21.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action21() throws IOException {
        switch (token.id) {
            case 123: {
                // Shift 308.
                token = doShift(token, 308);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 22.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action22() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 126:
            case 142: {
                // Reduce SimpleProgram : TYPEKW TypeDefList;
                doReduce1(token, 4);
                Object o2 = doReduce2();
                doReduce2();

                List<Declaration> o = hooks.parseSimpleProgram1((List<Declaration>)o2);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 23.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action23() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 24.
                token = doShift(token, 24);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 24.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action24() throws IOException {
        switch (token.id) {
            case 123: {
                // Shift 25.
                token = doShift(token, 25);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 25.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action25() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 26.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action26() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 27.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action27() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 129: {
                // Shift 291.
                token = doShift(token, 291);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 28.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action28() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : BOOLKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType2((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 29.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action29() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 133: {
                // Shift 284.
                token = doShift(token, 284);
                return;
            }

            case 134: {
                // Shift 285.
                token = doShift(token, 285);
                return;
            }

            case 135: {
                // Shift 286.
                token = doShift(token, 286);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 30.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action30() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 279.
                token = doShift(token, 279);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 31.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action31() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 32.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action32() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : FILEKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType6((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 33.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action33() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : INSTKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType7((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 34.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action34() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : INTKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType3((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 35.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action35() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 129: {
                // Shift 273.
                token = doShift(token, 273);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 36.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action36() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 58.
                token = doShift(token, 58);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 37.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action37() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : REALKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType4((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 38.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action38() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 39.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action39() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : STRINGKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType5((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 40.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action40() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : TIMERKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType8((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 41.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action41() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 46.
                token = doShift(token, 46);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 42.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action42() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce ElementaryType : VOIDKW;
                doReduce1(token, 29);
                Object o1 = doReduce2();

                Type o = hooks.parseElementaryType1((Token)o1);

                reduce = true;
                reduceNonTerminal = 29;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 43.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action43() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : IDENTIFIERTK;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                Type o = hooks.parseType19((Token)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 44.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action44() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : ElementaryType;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                Type o = hooks.parseType01((Type)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 45.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action45() throws IOException {
        switch (token.id) {
            case 125:
            case 126:
            case 142: {
                // Reduce TypeDefList : TypeDefList COMMATK IDENTIFIERTK BECOMESTK Type;
                doReduce1(token, 5);
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseTypeDefList2((List<Declaration>)o1, (Token)o3, (Type)o5);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 46.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action46() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 47.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action47() throws IOException {
        switch (token.id) {
            case 126:
            case 130: {
                // Reduce TupleTypeList : TupleType;
                doReduce1(token, 31);
                Object o1 = doReduce2();

                List<TupleField> o = hooks.parseTupleTypeList1((List<TupleField>)o1);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 48.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action48() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 54.
                token = doShift(token, 54);
                return;
            }

            case 130: {
                // Shift 55.
                token = doShift(token, 55);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 49.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action49() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 50.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action50() throws IOException {
        switch (token.id) {
            case 103:
            case 125:
            case 126:
            case 128:
            case 130: {
                // Reduce IdentifierList : IDENTIFIERTK;
                doReduce1(token, 34);
                Object o1 = doReduce2();

                List<ParserIdentifier> o = hooks.parseIdentifierList1((Token)o1);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 51.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action51() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 126:
            case 130: {
                // Reduce TupleType : Type IdentifierList;
                doReduce1(token, 32);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<TupleField> o = hooks.parseTupleType1((Type)o1, (List<ParserIdentifier>)o2);

                reduce = true;
                reduceNonTerminal = 32;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 52.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action52() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 53.
                token = doShift(token, 53);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 53.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action53() throws IOException {
        switch (token.id) {
            case 103:
            case 125:
            case 126:
            case 128:
            case 130: {
                // Reduce IdentifierList : IdentifierList COMMATK IDENTIFIERTK;
                doReduce1(token, 34);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<ParserIdentifier> o = hooks.parseIdentifierList2((List<ParserIdentifier>)o1, (Token)o3);

                reduce = true;
                reduceNonTerminal = 34;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 54.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action54() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 55.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action55() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : TUPLEKW PAROPENTK TupleTypeList PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType11((Token)o1, (List<TupleField>)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 56.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action56() throws IOException {
        switch (token.id) {
            case 126:
            case 130: {
                // Reduce TupleTypeList : TupleTypeList SEMICOLTK TupleType;
                doReduce1(token, 31);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<TupleField> o = hooks.parseTupleTypeList2((List<TupleField>)o1, (List<TupleField>)o3);

                reduce = true;
                reduceNonTerminal = 31;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 57.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action57() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : SETKW Type;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType03((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 58.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action58() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 59.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action59() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ABSKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor18((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 60.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action60() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SIGNKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor19((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 61.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action61() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : MAXKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor20((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 62.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action62() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : MINKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor21((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 63.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action63() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : CEILKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor22((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 64.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action64() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : FLOORKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor23((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 65.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action65() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ROUNDKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor24((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 66.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action66() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : CBRTKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor25((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 67.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action67() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SQRTKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor26((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 68.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action68() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : EXPKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor27((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 69.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action69() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LNKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor28((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 70.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action70() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LOGKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor29((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 71.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action71() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ACOSHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor30((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 72.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action72() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ACOSKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor31((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 73.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action73() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ASINHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor32((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 74.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action74() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ASINKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor33((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 75.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action75() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ATANHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor34((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 76.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action76() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ATANKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor35((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 77.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action77() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : COSHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor36((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 78.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action78() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : COSKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor37((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 79.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action79() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SINHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor38((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 80.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action80() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SINKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor39((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 81.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action81() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : TANHKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor40((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 82.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action82() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : TANKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor41((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 83.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action83() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : BERNOULLIKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor42((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 84.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action84() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : BETAKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor43((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 85.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action85() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : BINOMIALKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor44((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 86.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action86() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : CONSTANTKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor45((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 87.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action87() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LOGNORMALKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor46((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 88.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action88() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : EXPONENTIALKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor47((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 89.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action89() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ERLANGKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor48((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 90.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action90() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : GAMMAKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor49((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 91.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action91() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : GEOMETRICKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor50((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 92.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action92() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : NORMALKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor51((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 93.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action93() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : POISSONKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor52((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 94.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action94() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : RANDOMKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor53((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 95.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action95() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : TRIANGLEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor54((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 96.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action96() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : UNIFORMKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor55((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 97.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action97() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : WEIBULLKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor56((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 98.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action98() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : DICTKEYSKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor57((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 99.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action99() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : DICTVALUESKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor58((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 100.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action100() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : EMPTYKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor59((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 101.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action101() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SIZEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor60((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 102.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action102() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : POPKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor61((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 103.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action103() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ENUMERATEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor62((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 104.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action104() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : RANGEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor63((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 105.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action105() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : DELKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor64((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 106.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action106() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : INSERTKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor65((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 107.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action107() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SORTKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor66((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 108.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action108() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : FINISHEDKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor67((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 109.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action109() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : READYKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor68((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 110.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action110() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : OPENKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor69((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 111.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action111() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 270.
                token = doShift(token, 270);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 112.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action112() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 255.
                token = doShift(token, 255);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 113.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action113() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : EOLKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor70((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 114.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action114() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : EOFKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor71((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 115.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action115() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : NEWLINESKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor72((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 116.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action116() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : TIMEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor01((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 117.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action117() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 248.
                token = doShift(token, 248);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 118.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action118() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 245.
                token = doShift(token, 245);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 119.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action119() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 120.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action120() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 121.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action121() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : FALSEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor03((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 122.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action122() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : TRUEKW;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor02((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 123.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action123() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 124.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action124() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 125.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action125() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 126.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action126() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 127.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action127() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 128.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action128() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 129.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action129() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : IDENTIFIERTK;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor14((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 130.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action130() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : STRINGTK;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor06((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 131.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action131() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : NUMBERTK;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor04((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 132.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action132() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : REALTK;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor05((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 133.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action133() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : AddExpression;
                doReduce1(token, 41);
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 134.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action134() throws IOException {
        switch (token.id) {
            case 101: {
                // Shift 170.
                token = doShift(token, 170);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce Expression : AndExpression;
                doReduce1(token, 38);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 38;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 135.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action135() throws IOException {
        switch (token.id) {
            case 103: {
                // Shift 192.
                token = doShift(token, 192);
                return;
            }

            case 107: {
                // Shift 193.
                token = doShift(token, 193);
                return;
            }

            case 115: {
                // Shift 194.
                token = doShift(token, 194);
                return;
            }

            case 116: {
                // Shift 195.
                token = doShift(token, 195);
                return;
            }

            case 117: {
                // Shift 196.
                token = doShift(token, 196);
                return;
            }

            case 118: {
                // Shift 197.
                token = doShift(token, 197);
                return;
            }

            case 119: {
                // Shift 198.
                token = doShift(token, 198);
                return;
            }

            case 120: {
                // Shift 199.
                token = doShift(token, 199);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce NotExpression : CompareExpression;
                doReduce1(token, 40);
                Object o1 = doReduce2();

                Expression o = hooks.parseNotExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 40;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 136.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action136() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 189.
                token = doShift(token, 189);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 137.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action137() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125: {
                // Shift 186.
                token = doShift(token, 186);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 138.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action138() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : ExpressionFactor;
                doReduce1(token, 47);
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression01((Expression)o1);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 139.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action139() throws IOException {
        switch (token.id) {
            case 114: {
                // Shift 155.
                token = doShift(token, 155);
                return;
            }

            case 127: {
                // Shift 156.
                token = doShift(token, 156);
                return;
            }

            case 129: {
                // Shift 157.
                token = doShift(token, 157);
                return;
            }

            case 131: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce SampleExpression : FuncExpression;
                doReduce1(token, 46);
                Object o1 = doReduce2();

                Expression o = hooks.parseSampleExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 46;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 140.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action140() throws IOException {
        switch (token.id) {
            case 102: {
                // Shift 147.
                token = doShift(token, 147);
                return;
            }

            case 104: {
                // Shift 148.
                token = doShift(token, 148);
                return;
            }

            case 111: {
                // Shift 149.
                token = doShift(token, 149);
                return;
            }

            case 112: {
                // Shift 150.
                token = doShift(token, 150);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce AddExpression : MulExpression;
                doReduce1(token, 42);
                Object o1 = doReduce2();

                Expression o = hooks.parseAddExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 42;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 141.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action141() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce AndExpression : NotExpression;
                doReduce1(token, 39);
                Object o1 = doReduce2();

                Expression o = hooks.parseAndExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 39;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 142.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action142() throws IOException {
        switch (token.id) {
            case 113: {
                // Shift 145.
                token = doShift(token, 145);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce MulExpression : PowerExpression;
                doReduce1(token, 43);
                Object o1 = doReduce2();

                Expression o = hooks.parseMulExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 43;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 143.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action143() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce UnaryExpression : SampleExpression;
                doReduce1(token, 45);
                Object o1 = doReduce2();

                Expression o = hooks.parseUnaryExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 144.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action144() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce PowerExpression : UnaryExpression;
                doReduce1(token, 44);
                Object o1 = doReduce2();

                Expression o = hooks.parsePowerExpression1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 44;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 145.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action145() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 146.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action146() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce PowerExpression : PowerExpression CARETTK UnaryExpression;
                doReduce1(token, 44);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parsePowerExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 44;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 147.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action147() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 148.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action148() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 149.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action149() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 150.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action150() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 151.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action151() throws IOException {
        switch (token.id) {
            case 113: {
                // Shift 145.
                token = doShift(token, 145);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce MulExpression : MulExpression SLASHTK PowerExpression;
                doReduce1(token, 43);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseMulExpression3((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 43;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 152.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action152() throws IOException {
        switch (token.id) {
            case 113: {
                // Shift 145.
                token = doShift(token, 145);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce MulExpression : MulExpression ASTERISKTK PowerExpression;
                doReduce1(token, 43);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseMulExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 43;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 153.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action153() throws IOException {
        switch (token.id) {
            case 113: {
                // Shift 145.
                token = doShift(token, 145);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce MulExpression : MulExpression MODKW PowerExpression;
                doReduce1(token, 43);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseMulExpression5((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 43;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 154.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action154() throws IOException {
        switch (token.id) {
            case 113: {
                // Shift 145.
                token = doShift(token, 145);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce MulExpression : MulExpression DIVKW PowerExpression;
                doReduce1(token, 43);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseMulExpression4((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 43;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 155.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action155() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 185.
                token = doShift(token, 185);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 156.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action156() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 157.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action157() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 130: {
                // Shift 173.
                token = doShift(token, 173);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 158.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action158() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 124: {
                // Reduce OptExpression : ;
                doReduce1(token, 35);
                Expression o = hooks.parseOptExpression1();

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 159.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action159() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 132: {
                // Shift 172.
                token = doShift(token, 172);
                return;
            }

            case 124: {
                // Reduce OptExpression : Expression;
                doReduce1(token, 35);
                Object o1 = doReduce2();

                Expression o = hooks.parseOptExpression2((Expression)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 160.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action160() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 161.
                token = doShift(token, 161);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 161.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action161() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 124:
            case 132: {
                // Reduce OptExpression : ;
                doReduce1(token, 35);
                Expression o = hooks.parseOptExpression1();

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 162.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action162() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 124:
            case 132: {
                // Reduce OptExpression : Expression;
                doReduce1(token, 35);
                Object o1 = doReduce2();

                Expression o = hooks.parseOptExpression2((Expression)o1);

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 163.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action163() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 164.
                token = doShift(token, 164);
                return;
            }

            case 132: {
                // Shift 165.
                token = doShift(token, 165);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 164.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action164() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 132: {
                // Reduce OptExpression : ;
                doReduce1(token, 35);
                Expression o = hooks.parseOptExpression1();

                reduce = true;
                reduceNonTerminal = 35;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 165.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action165() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression SQOPENTK OptExpression COLONTK OptExpression SQCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression07((Expression)o1, (Token)o2, (Expression)o3, (Expression)o5);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 166.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action166() throws IOException {
        switch (token.id) {
            case 132: {
                // Shift 167.
                token = doShift(token, 167);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 167.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action167() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression SQOPENTK OptExpression COLONTK OptExpression COLONTK OptExpression SQCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o7 = doReduce2();
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression08((Expression)o1, (Token)o2, (Expression)o3, (Expression)o5, (Expression)o7);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 168.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action168() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 169.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action169() throws IOException {
        switch (token.id) {
            case 101: {
                // Shift 170.
                token = doShift(token, 170);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce Expression : Expression ORKW AndExpression;
                doReduce1(token, 38);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 38;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 170.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action170() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 171.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action171() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce AndExpression : AndExpression ANDKW NotExpression;
                doReduce1(token, 39);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseAndExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 39;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 172.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action172() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression SQOPENTK Expression SQCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression06((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 173.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action173() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression PAROPENTK PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression12((Expression)o1, (Token)o2);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 174.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action174() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 124:
            case 125:
            case 126:
            case 130:
            case 132: {
                // Reduce ExprList : Expression;
                doReduce1(token, 36);
                Object o1 = doReduce2();

                List<Expression> o = hooks.parseExprList1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 36;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 175.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action175() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 130: {
                // Shift 177.
                token = doShift(token, 177);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 176.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action176() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 177.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action177() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression PAROPENTK ExprList PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression11((Expression)o1, (Token)o2, (List<Expression>)o3);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 178.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action178() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132: {
                // Reduce ExprList : ExprList COMMATK Expression;
                doReduce1(token, 36);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Expression> o = hooks.parseExprList2((List<Expression>)o1, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 36;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 179.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action179() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 128: {
                // Shift 180.
                token = doShift(token, 180);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 180.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action180() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 181.
                token = doShift(token, 181);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 181.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action181() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 130: {
                // Shift 182.
                token = doShift(token, 182);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 182.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action182() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression CUROPENTK Expression CURCLOSETK PAROPENTK PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression10((Expression)o1, (Expression)o3, (Token)o5);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 183.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action183() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 130: {
                // Shift 184.
                token = doShift(token, 184);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 184.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action184() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression CUROPENTK Expression CURCLOSETK PAROPENTK ExprList PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o6 = doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression09((Expression)o1, (Expression)o3, (Token)o5, (List<Expression>)o6);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 185.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action185() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : FuncExpression DOTTK IDENTIFIERTK;
                doReduce1(token, 47);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression05((Expression)o1, (Token)o2, (Token)o3);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 186.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action186() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 187.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action187() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 188.
                token = doShift(token, 188);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 188.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action188() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : MATRIXKW PAROPENTK Expression COMMATK Expression PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType02((Token)o1, (Expression)o3, (Expression)o5);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 189.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action189() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 190.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action190() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 191.
                token = doShift(token, 191);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 191.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action191() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : ElementaryType PAROPENTK Expression PARCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor15((Type)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 192.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action192() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 193.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action193() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 194.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action194() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 195.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action195() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 196.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action196() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 197.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action197() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 198.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action198() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 199.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action199() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 200.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action200() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression GTTK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression7((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 201.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action201() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 202.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action202() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 203.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action203() throws IOException {
        switch (token.id) {
            case 102: {
                // Shift 147.
                token = doShift(token, 147);
                return;
            }

            case 104: {
                // Shift 148.
                token = doShift(token, 148);
                return;
            }

            case 111: {
                // Shift 149.
                token = doShift(token, 149);
                return;
            }

            case 112: {
                // Shift 150.
                token = doShift(token, 150);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce AddExpression : AddExpression MINUSTK MulExpression;
                doReduce1(token, 42);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseAddExpression3((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 42;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 204.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action204() throws IOException {
        switch (token.id) {
            case 102: {
                // Shift 147.
                token = doShift(token, 147);
                return;
            }

            case 104: {
                // Shift 148.
                token = doShift(token, 148);
                return;
            }

            case 111: {
                // Shift 149.
                token = doShift(token, 149);
                return;
            }

            case 112: {
                // Shift 150.
                token = doShift(token, 150);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce AddExpression : AddExpression PLUSTK MulExpression;
                doReduce1(token, 42);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseAddExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 42;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 205.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action205() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression GETK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression6((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 206.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action206() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression NETK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression5((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 207.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action207() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression EQTK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression4((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 208.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action208() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression LETK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression3((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 209.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action209() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression LTTK AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression2((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 210.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action210() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression SUBKW AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression9((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 211.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action211() throws IOException {
        switch (token.id) {
            case 121: {
                // Shift 201.
                token = doShift(token, 201);
                return;
            }

            case 122: {
                // Shift 202.
                token = doShift(token, 202);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 103:
            case 106:
            case 107:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce CompareExpression : CompareExpression INKW AddExpression;
                doReduce1(token, 41);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseCompareExpression8((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 41;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 212.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action212() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 126:
            case 132: {
                // Reduce MatExprList : ExprList;
                doReduce1(token, 37);
                Object o1 = doReduce2();

                List<MatrixRow> o = hooks.parseMatExprList1((List<Expression>)o1);

                reduce = true;
                reduceNonTerminal = 37;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 213.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action213() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 214.
                token = doShift(token, 214);
                return;
            }

            case 132: {
                // Shift 215.
                token = doShift(token, 215);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 214.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action214() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 215.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action215() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SQOPENTK MatExprList SQCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor08((Token)o1, (List<MatrixRow>)o2);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 216.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action216() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 126:
            case 132: {
                // Reduce MatExprList : MatExprList SEMICOLTK ExprList;
                doReduce1(token, 37);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<MatrixRow> o = hooks.parseMatExprList2((List<MatrixRow>)o1, (List<Expression>)o3);

                reduce = true;
                reduceNonTerminal = 37;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 217.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action217() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 130: {
                // Shift 218.
                token = doShift(token, 218);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 218.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action218() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : PAROPENTK ExprList PARCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Expression o = hooks.parseExpressionFactor13((List<Expression>)o2);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 219.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action219() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 225.
                token = doShift(token, 225);
                return;
            }

            case 128: {
                // Shift 226.
                token = doShift(token, 226);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 220.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action220() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 124: {
                // Shift 223.
                token = doShift(token, 223);
                return;
            }

            case 125:
            case 128: {
                // Reduce ExprList : Expression;
                doReduce1(token, 36);
                Object o1 = doReduce2();

                List<Expression> o = hooks.parseExprList1((Expression)o1);

                reduce = true;
                reduceNonTerminal = 36;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 221.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action221() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 176.
                token = doShift(token, 176);
                return;
            }

            case 128: {
                // Shift 222.
                token = doShift(token, 222);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 222.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action222() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : CUROPENTK ExprList CURCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor11((Token)o1, (List<Expression>)o2);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 223.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action223() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 224.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action224() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125:
            case 128: {
                // Reduce DictPairs : Expression COLONTK Expression;
                doReduce1(token, 49);
                Object o3 = doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<DictionaryPair> o = hooks.parseDictPairs1((Expression)o1, (Token)o2, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 49;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 225.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action225() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 226.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action226() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : CUROPENTK DictPairs CURCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor12((Token)o1, (List<DictionaryPair>)o2);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 227.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action227() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 124: {
                // Shift 228.
                token = doShift(token, 228);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 228.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action228() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 229.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action229() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125:
            case 128: {
                // Reduce DictPairs : DictPairs COMMATK Expression COLONTK Expression;
                doReduce1(token, 49);
                Object o5 = doReduce2();
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<DictionaryPair> o = hooks.parseDictPairs2((List<DictionaryPair>)o1, (Expression)o3, (Token)o4, (Expression)o5);

                reduce = true;
                reduceNonTerminal = 49;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 230.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action230() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce UnaryExpression : MINUSTK UnaryExpression;
                doReduce1(token, 45);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseUnaryExpression2((Token)o1, (Expression)o2);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 231.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action231() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce UnaryExpression : PLUSTK UnaryExpression;
                doReduce1(token, 45);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseUnaryExpression3((Token)o1, (Expression)o2);

                reduce = true;
                reduceNonTerminal = 45;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 232.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action232() throws IOException {
        switch (token.id) {
            case 120: {
                // Shift 233.
                token = doShift(token, 233);
                return;
            }

            case 124: {
                // Shift 234.
                token = doShift(token, 234);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 233.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action233() throws IOException {
        switch (token.id) {
            case 127: {
                // Shift 239.
                token = doShift(token, 239);
                return;
            }

            case 131: {
                // Shift 240.
                token = doShift(token, 240);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 234.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action234() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 235.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action235() throws IOException {
        switch (token.id) {
            case 120: {
                // Shift 236.
                token = doShift(token, 236);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 236.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action236() throws IOException {
        switch (token.id) {
            case 127: {
                // Shift 237.
                token = doShift(token, 237);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 237.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action237() throws IOException {
        switch (token.id) {
            case 128: {
                // Shift 238.
                token = doShift(token, 238);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 238.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action238() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LTTK Type COLONTK Type GTTK CUROPENTK CURCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o6 = doReduce2();
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Expression o = hooks.parseExpressionFactor10((Type)o2, (Type)o4, (Token)o6);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 239.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action239() throws IOException {
        switch (token.id) {
            case 128: {
                // Shift 242.
                token = doShift(token, 242);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 240.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action240() throws IOException {
        switch (token.id) {
            case 132: {
                // Shift 241.
                token = doShift(token, 241);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 241.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action241() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LTTK Type GTTK SQOPENTK SQCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Expression o = hooks.parseExpressionFactor07((Type)o2, (Token)o4);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 242.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action242() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : LTTK Type GTTK CUROPENTK CURCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                doReduce2();

                Expression o = hooks.parseExpressionFactor09((Type)o2, (Token)o4);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 243.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action243() throws IOException {
        switch (token.id) {
            case 114: {
                // Shift 155.
                token = doShift(token, 155);
                return;
            }

            case 127: {
                // Shift 156.
                token = doShift(token, 156);
                return;
            }

            case 129: {
                // Shift 157.
                token = doShift(token, 157);
                return;
            }

            case 131: {
                // Shift 158.
                token = doShift(token, 158);
                return;
            }

            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce SampleExpression : SAMPLEKW FuncExpression;
                doReduce1(token, 46);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseSampleExpression2((Token)o1, (Expression)o2);

                reduce = true;
                reduceNonTerminal = 46;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 244.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action244() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 106:
            case 123:
            case 124:
            case 125:
            case 126:
            case 128:
            case 130:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce NotExpression : NOTKW NotExpression;
                doReduce1(token, 40);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseNotExpression2((Token)o1, (Expression)o2);

                reduce = true;
                reduceNonTerminal = 40;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 245.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action245() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 246.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action246() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 247.
                token = doShift(token, 247);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 247.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action247() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : SETKW PAROPENTK Expression PARCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor17((Token)o1, (Expression)o3);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 248.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action248() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 249.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action249() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125: {
                // Shift 250.
                token = doShift(token, 250);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 250.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action250() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 251.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action251() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125: {
                // Shift 252.
                token = doShift(token, 252);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 252.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action252() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 253.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action253() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 254.
                token = doShift(token, 254);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 254.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action254() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce ExpressionFactor : MATRIXKW PAROPENTK Expression COMMATK Expression COMMATK Expression PARCLOSETK;
                doReduce1(token, 48);
                doReduce2();
                Object o7 = doReduce2();
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor16((Token)o1, (Expression)o3, (Expression)o5, (Expression)o7);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 255.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action255() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 94: {
                // Shift 256.
                token = doShift(token, 256);
                return;
            }

            case 96: {
                // Shift 257.
                token = doShift(token, 257);
                return;
            }

            case 136: {
                // Shift 258.
                token = doShift(token, 258);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 256.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action256() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 266.
                token = doShift(token, 266);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 257.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action257() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 129: {
                // Shift 245.
                token = doShift(token, 245);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 258.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action258() throws IOException {
        switch (token.id) {
            case 130:
            case 136: {
                // Reduce Type : IDENTIFIERTK;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                Type o = hooks.parseType19((Token)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 125:
            case 127:
            case 129:
            case 131:
            case 133:
            case 134: {
                // Reduce ExpressionFactor : IDENTIFIERTK;
                doReduce1(token, 48);
                Object o1 = doReduce2();

                Expression o = hooks.parseExpressionFactor14((Token)o1);

                reduce = true;
                reduceNonTerminal = 48;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 259.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action259() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 189.
                token = doShift(token, 189);
                return;
            }

            case 130:
            case 136: {
                // Reduce Type : ElementaryType;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                Type o = hooks.parseType01((Type)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 260.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action260() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125: {
                // Shift 263.
                token = doShift(token, 263);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 261.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action261() throws IOException {
        switch (token.id) {
            case 130: {
                // Shift 262.
                token = doShift(token, 262);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 262.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action262() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : READKW PAROPENTK Type PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression02((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 263.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action263() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 264.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action264() throws IOException {
        switch (token.id) {
            case 130: {
                // Shift 265.
                token = doShift(token, 265);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 265.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action265() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : READKW PAROPENTK Expression COMMATK Type PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression03((Token)o1, (Expression)o3, (Type)o5);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 266.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action266() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 267.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action267() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 125: {
                // Shift 268.
                token = doShift(token, 268);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 268.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action268() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 269.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action269() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 188.
                token = doShift(token, 188);
                return;
            }

            case 125: {
                // Shift 252.
                token = doShift(token, 252);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 270.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action270() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 271.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action271() throws IOException {
        switch (token.id) {
            case 130: {
                // Shift 272.
                token = doShift(token, 272);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 272.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action272() throws IOException {
        switch (token.id) {
            case 72:
            case 76:
            case 77:
            case 80:
            case 101:
            case 102:
            case 103:
            case 104:
            case 106:
            case 107:
            case 111:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 124:
            case 125:
            case 126:
            case 127:
            case 128:
            case 129:
            case 130:
            case 131:
            case 132:
            case 133:
            case 134:
            case 142: {
                // Reduce FuncExpression : CHANNELKW PAROPENTK Type PARCLOSETK;
                doReduce1(token, 47);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Expression o = hooks.parseFuncExpression04((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 47;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 273.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action273() throws IOException {
        switch (token.id) {
            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 94: {
                // Shift 117.
                token = doShift(token, 117);
                return;
            }

            case 96: {
                // Shift 118.
                token = doShift(token, 118);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 136: {
                // Shift 129.
                token = doShift(token, 129);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 274.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action274() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : LISTKW Type;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType04((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 275.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action275() throws IOException {
        switch (token.id) {
            case 106: {
                // Shift 168.
                token = doShift(token, 168);
                return;
            }

            case 130: {
                // Shift 276.
                token = doShift(token, 276);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 276.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action276() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 277.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action277() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : LISTKW PAROPENTK Expression PARCLOSETK Type;
                doReduce1(token, 30);
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType05((Token)o1, (Expression)o3, (Type)o5);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 278.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action278() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : DISTKW Type;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType18((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 279.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action279() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 280.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action280() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 281.
                token = doShift(token, 281);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 281.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action281() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 282.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action282() throws IOException {
        switch (token.id) {
            case 130: {
                // Shift 283.
                token = doShift(token, 283);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 283.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action283() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : DICTKW PAROPENTK Type COLONTK Type PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o5 = doReduce2();
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType10((Token)o1, (Type)o3, (Type)o5);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 284.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action284() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 285.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action285() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 286.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action286() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 287.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action287() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : CHANKW Type;
                doReduce1(token, 30);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType06((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 288.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action288() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : CHANKW SENDRECEIVETK Type;
                doReduce1(token, 30);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType09((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 289.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action289() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : CHANKW RECEIVETK Type;
                doReduce1(token, 30);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType07((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 290.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action290() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : CHANKW SENDTK Type;
                doReduce1(token, 30);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType08((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 291.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action291() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 130: {
                // Shift 300.
                token = doShift(token, 300);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 292.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action292() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 293.
                token = doShift(token, 293);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 293.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action293() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 130: {
                // Shift 294.
                token = doShift(token, 294);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 294.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action294() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : PROCKW Type PAROPENTK PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType17((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 295.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action295() throws IOException {
        switch (token.id) {
            case 125:
            case 130: {
                // Reduce TypeList : Type;
                doReduce1(token, 33);
                Object o1 = doReduce2();

                List<Type> o = hooks.parseTypeList1((Type)o1);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 296.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action296() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 297.
                token = doShift(token, 297);
                return;
            }

            case 130: {
                // Shift 298.
                token = doShift(token, 298);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 297.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action297() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 298.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action298() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : PROCKW Type PAROPENTK TypeList PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType16((Token)o1, (Type)o2, (List<Type>)o4);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 299.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action299() throws IOException {
        switch (token.id) {
            case 125:
            case 130: {
                // Reduce TypeList : TypeList COMMATK Type;
                doReduce1(token, 33);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Type> o = hooks.parseTypeList2((List<Type>)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 33;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 300.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action300() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : PROCKW PAROPENTK PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType15((Token)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 301.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action301() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 297.
                token = doShift(token, 297);
                return;
            }

            case 130: {
                // Shift 302.
                token = doShift(token, 302);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 302.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action302() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : PROCKW PAROPENTK TypeList PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType14((Token)o1, (List<Type>)o3);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 303.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action303() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 304.
                token = doShift(token, 304);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 304.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action304() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 130: {
                // Shift 305.
                token = doShift(token, 305);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 305.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action305() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : FUNCKW Type PAROPENTK PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType12((Token)o1, (Type)o2);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 306.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action306() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 297.
                token = doShift(token, 297);
                return;
            }

            case 130: {
                // Shift 307.
                token = doShift(token, 307);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 307.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action307() throws IOException {
        switch (token.id) {
            case 120:
            case 124:
            case 125:
            case 126:
            case 129:
            case 130:
            case 136:
            case 142: {
                // Reduce Type : FUNCKW Type PAROPENTK TypeList PARCLOSETK;
                doReduce1(token, 30);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                Type o = hooks.parseType13((Token)o1, (Type)o2, (List<Type>)o4);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 308.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action308() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 309.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action309() throws IOException {
        switch (token.id) {
            case 125:
            case 126:
            case 142: {
                // Reduce TypeDefList : IDENTIFIERTK BECOMESTK Type;
                doReduce1(token, 5);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<Declaration> o = hooks.parseTypeDefList1((Token)o1, (Type)o3);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 310.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action310() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 463.
                token = doShift(token, 463);
                return;
            }

            case 136: {
                // Reduce Type : IDENTIFIERTK;
                doReduce1(token, 30);
                Object o1 = doReduce2();

                Type o = hooks.parseType19((Token)o1);

                reduce = true;
                reduceNonTerminal = 30;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 311.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action311() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 312.
                token = doShift(token, 312);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 312.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action312() throws IOException {
        switch (token.id) {
            case 129: {
                // Shift 313.
                token = doShift(token, 313);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 313.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action313() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            case 130: {
                // Shift 314.
                token = doShift(token, 314);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 314.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action314() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 460.
                token = doShift(token, 460);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 315.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action315() throws IOException {
        switch (token.id) {
            case 126: {
                // Shift 318.
                token = doShift(token, 318);
                return;
            }

            case 130: {
                // Shift 319.
                token = doShift(token, 319);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 316.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action316() throws IOException {
        switch (token.id) {
            case 136: {
                // Shift 50.
                token = doShift(token, 50);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 317.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action317() throws IOException {
        switch (token.id) {
            case 125: {
                // Shift 52.
                token = doShift(token, 52);
                return;
            }

            case 126:
            case 130: {
                // Reduce FormalParameters : Type IdentifierList;
                doReduce1(token, 26);
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                List<VariableDeclaration> o = hooks.parseFormalParameters1((Type)o1, (List<ParserIdentifier>)o2);

                reduce = true;
                reduceNonTerminal = 26;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 318.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action318() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 94: {
                // Shift 36.
                token = doShift(token, 36);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 96: {
                // Shift 38.
                token = doShift(token, 38);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 136: {
                // Shift 43.
                token = doShift(token, 43);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 319.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action319() throws IOException {
        switch (token.id) {
            case 124: {
                // Shift 320.
                token = doShift(token, 320);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 320.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action320() throws IOException {
        switch (token.id) {
            case 60: {
                // Shift 26.
                token = doShift(token, 26);
                return;
            }

            case 62: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            case 86: {
                // Shift 28.
                token = doShift(token, 28);
                return;
            }

            case 87: {
                // Shift 29.
                token = doShift(token, 29);
                return;
            }

            case 88: {
                // Shift 30.
                token = doShift(token, 30);
                return;
            }

            case 89: {
                // Shift 31.
                token = doShift(token, 31);
                return;
            }

            case 90: {
                // Shift 32.
                token = doShift(token, 32);
                return;
            }

            case 91: {
                // Shift 33.
                token = doShift(token, 33);
                return;
            }

            case 92: {
                // Shift 34.
                token = doShift(token, 34);
                return;
            }

            case 93: {
                // Shift 35.
                token = doShift(token, 35);
                return;
            }

            case 95: {
                // Shift 37.
                token = doShift(token, 37);
                return;
            }

            case 97: {
                // Shift 39.
                token = doShift(token, 39);
                return;
            }

            case 98: {
                // Shift 40.
                token = doShift(token, 40);
                return;
            }

            case 99: {
                // Shift 41.
                token = doShift(token, 41);
                return;
            }

            case 100: {
                // Shift 42.
                token = doShift(token, 42);
                return;
            }

            case 0: {
                // Shift 59.
                token = doShift(token, 59);
                return;
            }

            case 1: {
                // Shift 60.
                token = doShift(token, 60);
                return;
            }

            case 2: {
                // Shift 61.
                token = doShift(token, 61);
                return;
            }

            case 3: {
                // Shift 62.
                token = doShift(token, 62);
                return;
            }

            case 4: {
                // Shift 63.
                token = doShift(token, 63);
                return;
            }

            case 5: {
                // Shift 64.
                token = doShift(token, 64);
                return;
            }

            case 6: {
                // Shift 65.
                token = doShift(token, 65);
                return;
            }

            case 7: {
                // Shift 66.
                token = doShift(token, 66);
                return;
            }

            case 8: {
                // Shift 67.
                token = doShift(token, 67);
                return;
            }

            case 9: {
                // Shift 68.
                token = doShift(token, 68);
                return;
            }

            case 10: {
                // Shift 69.
                token = doShift(token, 69);
                return;
            }

            case 11: {
                // Shift 70.
                token = doShift(token, 70);
                return;
            }

            case 12: {
                // Shift 71.
                token = doShift(token, 71);
                return;
            }

            case 13: {
                // Shift 72.
                token = doShift(token, 72);
                return;
            }

            case 14: {
                // Shift 73.
                token = doShift(token, 73);
                return;
            }

            case 15: {
                // Shift 74.
                token = doShift(token, 74);
                return;
            }

            case 16: {
                // Shift 75.
                token = doShift(token, 75);
                return;
            }

            case 17: {
                // Shift 76.
                token = doShift(token, 76);
                return;
            }

            case 18: {
                // Shift 77.
                token = doShift(token, 77);
                return;
            }

            case 19: {
                // Shift 78.
                token = doShift(token, 78);
                return;
            }

            case 20: {
                // Shift 79.
                token = doShift(token, 79);
                return;
            }

            case 21: {
                // Shift 80.
                token = doShift(token, 80);
                return;
            }

            case 22: {
                // Shift 81.
                token = doShift(token, 81);
                return;
            }

            case 23: {
                // Shift 82.
                token = doShift(token, 82);
                return;
            }

            case 24: {
                // Shift 83.
                token = doShift(token, 83);
                return;
            }

            case 25: {
                // Shift 84.
                token = doShift(token, 84);
                return;
            }

            case 26: {
                // Shift 85.
                token = doShift(token, 85);
                return;
            }

            case 27: {
                // Shift 86.
                token = doShift(token, 86);
                return;
            }

            case 28: {
                // Shift 87.
                token = doShift(token, 87);
                return;
            }

            case 29: {
                // Shift 88.
                token = doShift(token, 88);
                return;
            }

            case 30: {
                // Shift 89.
                token = doShift(token, 89);
                return;
            }

            case 31: {
                // Shift 90.
                token = doShift(token, 90);
                return;
            }

            case 32: {
                // Shift 91.
                token = doShift(token, 91);
                return;
            }

            case 33: {
                // Shift 92.
                token = doShift(token, 92);
                return;
            }

            case 34: {
                // Shift 93.
                token = doShift(token, 93);
                return;
            }

            case 35: {
                // Shift 94.
                token = doShift(token, 94);
                return;
            }

            case 36: {
                // Shift 95.
                token = doShift(token, 95);
                return;
            }

            case 37: {
                // Shift 96.
                token = doShift(token, 96);
                return;
            }

            case 38: {
                // Shift 97.
                token = doShift(token, 97);
                return;
            }

            case 39: {
                // Shift 98.
                token = doShift(token, 98);
                return;
            }

            case 40: {
                // Shift 99.
                token = doShift(token, 99);
                return;
            }

            case 41: {
                // Shift 100.
                token = doShift(token, 100);
                return;
            }

            case 42: {
                // Shift 101.
                token = doShift(token, 101);
                return;
            }

            case 43: {
                // Shift 102.
                token = doShift(token, 102);
                return;
            }

            case 44: {
                // Shift 103.
                token = doShift(token, 103);
                return;
            }

            case 45: {
                // Shift 104.
                token = doShift(token, 104);
                return;
            }

            case 46: {
                // Shift 105.
                token = doShift(token, 105);
                return;
            }

            case 47: {
                // Shift 106.
                token = doShift(token, 106);
                return;
            }

            case 48: {
                // Shift 107.
                token = doShift(token, 107);
                return;
            }

            case 49: {
                // Shift 108.
                token = doShift(token, 108);
                return;
            }

            case 50: {
                // Shift 109.
                token = doShift(token, 109);
                return;
            }

            case 51: {
                // Shift 110.
                token = doShift(token, 110);
                return;
            }

            case 52: {
                // Shift 111.
                token = doShift(token, 111);
                return;
            }

            case 53: {
                // Shift 112.
                token = doShift(token, 112);
                return;
            }

            case 54: {
                // Shift 113.
                token = doShift(token, 113);
                return;
            }

            case 55: {
                // Shift 114.
                token = doShift(token, 114);
                return;
            }

            case 56: {
                // Shift 115.
                token = doShift(token, 115);
                return;
            }

            case 79: {
                // Shift 116.
                token = doShift(token, 116);
                return;
            }

            case 105: {
                // Shift 119.
                token = doShift(token, 119);
                return;
            }

            case 108: {
                // Shift 120.
                token = doShift(token, 120);
                return;
            }

            case 109: {
                // Shift 121.
                token = doShift(token, 121);
                return;
            }

            case 110: {
                // Shift 122.
                token = doShift(token, 122);
                return;
            }

            case 115: {
                // Shift 123.
                token = doShift(token, 123);
                return;
            }

            case 121: {
                // Shift 124.
                token = doShift(token, 124);
                return;
            }

            case 122: {
                // Shift 125.
                token = doShift(token, 125);
                return;
            }

            case 127: {
                // Shift 126.
                token = doShift(token, 126);
                return;
            }

            case 129: {
                // Shift 127.
                token = doShift(token, 127);
                return;
            }

            case 131: {
                // Shift 128.
                token = doShift(token, 128);
                return;
            }

            case 137: {
                // Shift 130.
                token = doShift(token, 130);
                return;
            }

            case 138: {
                // Shift 131.
                token = doShift(token, 131);
                return;
            }

            case 139: {
                // Shift 132.
                token = doShift(token, 132);
                return;
            }

            case 94: {
                // Shift 256.
                token = doShift(token, 256);
                return;
            }

            case 96: {
                // Shift 257.
                token = doShift(token, 257);
                return;
            }

            case 136: {
                // Shift 258.
                token = doShift(token, 258);
                return;
            }

            case 64: {
                // Shift 321.
                token = doShift(token, 321);
                return;
            }

            case 65: {
                // Shift 322.
                token = doShift(token, 322);
                return;
            }

            case 66: {
                // Shift 323.
                token = doShift(token, 323);
                return;
            }

            case 67: {
                // Shift 324.
                token = doShift(token, 324);
                return;
            }

            case 68: {
                // Shift 325.
                token = doShift(token, 325);
                return;
            }

            case 69: {
                // Shift 326.
                token = doShift(token, 326);
                return;
            }

            case 70: {
                // Shift 327.
                token = doShift(token, 327);
                return;
            }

            case 71: {
                // Shift 328.
                token = doShift(token, 328);
                return;
            }

            case 74: {
                // Shift 329.
                token = doShift(token, 329);
                return;
            }

            case 75: {
                // Shift 330.
                token = doShift(token, 330);
                return;
            }

            case 78: {
                // Shift 331.
                token = doShift(token, 331);
                return;
            }

            case 81: {
                // Shift 332.
                token = doShift(token, 332);
                return;
            }

            case 82: {
                // Shift 333.
                token = doShift(token, 333);
                return;
            }

            case 83: {
                // Shift 334.
                token = doShift(token, 334);
                return;
            }

            case 84: {
                // Shift 335.
                token = doShift(token, 335);
                ret