/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.texteditor;

import org.eclipse.escet.chi.parser.ChiScanner;
import org.eclipse.escet.chi.texteditor.ChiStyles;
import org.eclipse.escet.setext.texteditorbase.ColorManager;
import org.eclipse.escet.setext.texteditorbase.detectors.GenericWhitespaceDetector;
import org.eclipse.escet.setext.texteditorbase.rules.IdentifiersRule;
import org.eclipse.escet.setext.texteditorbase.rules.IntNumberRule;
import org.eclipse.escet.setext.texteditorbase.rules.KeywordsRule;
import org.eclipse.escet.setext.texteditorbase.rules.RealNumberRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class ChiTextScanner
extends RuleBasedScanner {
    public ChiTextScanner(ColorManager manager) {
        String[] keywords = ChiScanner.getKeywords((String)"Keywords");
        String[] types = ChiScanner.getKeywords((String)"Types");
        String[] constants = ChiScanner.getKeywords((String)"Constants");
        String[] allKeywords = new String[keywords.length + types.length + constants.length];
        int destPos = 0;
        System.arraycopy(keywords, 0, allKeywords, destPos, keywords.length);
        System.arraycopy(types, 0, allKeywords, destPos += keywords.length, types.length);
        System.arraycopy(constants, 0, allKeywords, destPos += types.length, constants.length);
        String[] stdlibfuncs = ChiScanner.getKeywords((String)"Functions");
        String[] operators = ChiScanner.getKeywords((String)"Operators");
        IRule[] rules = new IRule[]{new KeywordsRule(allKeywords, ChiStyles.KEYWORD.createToken(manager)), new KeywordsRule(stdlibfuncs, ChiStyles.STDLIBFUNC.createToken(manager)), new KeywordsRule(operators, ChiStyles.OPERATOR.createToken(manager)), new IdentifiersRule(ChiStyles.IDENTIFIER.createToken(manager)), new RealNumberRule(ChiStyles.NUMBER.createToken(manager)), new IntNumberRule(ChiStyles.NUMBER.createToken(manager)), new WhitespaceRule((IWhitespaceDetector)new GenericWhitespaceDetector())};
        this.setRules(rules);
        this.setDefaultReturnToken(ChiStyles.DEFAULT.createToken(manager));
    }
}

