/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.EnumsToBase;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class EnumsToConsts
extends EnumsToBase {
    private Map<EnumLiteral, Constant> enumConst = Maps.map();

    @Override
    protected void preprocessComplexComponent(ComplexComponent comp) {
        EList decls = comp.getDeclarations();
        Iterator declIter = decls.iterator();
        List newConstants = Lists.list();
        while (declIter.hasNext()) {
            Declaration decl = (Declaration)declIter.next();
            if (!(decl instanceof EnumDecl)) continue;
            EnumDecl enumDecl = (EnumDecl)decl;
            EList lits = enumDecl.getLiterals();
            for (EnumLiteral lit : lits) {
                newConstants.add(this.getConstant(lit));
            }
            declIter.remove();
        }
        decls.addAll(newConstants);
    }

    @Override
    protected void walkEnumLiteralExpression(EnumLiteralExpression litRef) {
        EnumLiteral lit = litRef.getLiteral();
        ConstantExpression constExpr = CifConstructors.newConstantExpression();
        constExpr.setConstant(this.getConstant(lit));
        constExpr.setType((CifType)this.getIntType(EnumsToConsts.literalToInt(lit)));
        EMFHelper.updateParentContainment((EObject)litRef, (EObject)constExpr);
    }

    @Override
    protected void walkEnumType(EnumType enumType) {
        EnumsToConsts.replaceEnumTypeByIntType(enumType);
    }

    private Constant getConstant(EnumLiteral lit) {
        Constant constant = this.enumConst.get(lit);
        if (constant == null) {
            int value = EnumsToConsts.literalToInt(lit);
            constant = CifConstructors.newConstant((String)lit.getName(), null, (CifType)this.getIntType(value), (Expression)CifValueUtils.makeInt((int)value));
            this.enumConst.put(lit, constant);
        }
        return constant;
    }

    private IntType getIntType(int value) {
        return CifConstructors.newIntType((Integer)value, null, (Integer)value);
    }
}

