/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcGlobalVarList
extends PlcObject {
    public final String name;
    public final boolean constants;
    public List<PlcVariable> variables = Lists.list();

    public PlcGlobalVarList(String name, boolean constants) {
        this.name = name;
        this.constants = constants;
    }

    public Box toBox() {
        Assert.check((!this.variables.isEmpty() ? 1 : 0) != 0);
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("VAR_GLOBAL%s // %s", new Object[]{this.constants ? " CONSTANT" : "", this.name});
        c.indent();
        for (PlcVariable variable : this.variables) {
            c.add((Boxable)variable);
        }
        c.dedent();
        c.add("END_VAR");
        return c;
    }

    @Override
    public Box toBoxS7() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("<?xml version='1.0' encoding='utf-8'?>");
        c.add("<Tagtable name='%s'>", new Object[]{this.name});
        c.indent();
        if (this.constants) {
            for (PlcVariable constant : this.variables) {
                c.add("<Constant type='%s' remark='' value='%s'>%s</Constant>", new Object[]{constant.type, constant.value, constant.name});
            }
        } else {
            for (PlcVariable var : this.variables) {
                c.add("<Tag type='%s' hmiVisible='True' hmiWriteable='False' hmiAccessible='True' retain='False' remark='' addr='%s'>%s</Tag>", new Object[]{var.type, var.address, var.name});
            }
        }
        c.dedent();
        c.add("</Tagtable>");
        return c;
    }
}

