/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputType;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputTypeOption;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class PlcPou
extends PlcObject {
    public final String name;
    public final PlcPouType pouType;
    public final PlcType retType;
    public List<PlcVariable> inputVars = Lists.list();
    public List<PlcVariable> outputVars = Lists.list();
    public List<PlcVariable> localVars = Lists.list();
    public List<PlcVariable> tempVars = Lists.list();
    public CodeBox body = new MemoryCodeBox(4);
    private int nextTmpVarNr = 0;

    public PlcPou(String name, PlcPouType pouType, PlcType retType) {
        this.name = name;
        this.pouType = pouType;
        this.retType = retType;
    }

    public String addTempVar(PlcType type, String valueTxt) {
        String varName = "tmp" + this.nextTmpVarNr;
        ++this.nextTmpVarNr;
        PlcVariable var = new PlcVariable(varName, type);
        if (this.retType == null) {
            this.tempVars.add(var);
        } else {
            this.localVars.add(var);
        }
        if (valueTxt != null) {
            this.body.add("%s := %s;", new Object[]{varName, valueTxt});
        }
        return varName;
    }

    public Box toBox() {
        CodeBox c = this.headerToBox();
        c.add();
        c.add((Box)this.body);
        c.add("END_%s", new Object[]{this.pouType});
        return c;
    }

    public CodeBox headerToBox() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String retTypeTxt = this.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.retType});
        c.add("%s %s%s", new Object[]{this.pouType, this.name, retTypeTxt});
        if (!this.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcVariable var : this.inputVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.outputVars.isEmpty()) {
            c.add("VAR_OUTPUT");
            c.indent();
            for (PlcVariable var : this.outputVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.localVars.isEmpty()) {
            c.add("VAR");
            c.indent();
            for (PlcVariable var : this.localVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.tempVars.isEmpty()) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcVariable var : this.tempVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        return c;
    }

    @Override
    public Box toBoxS7() {
        String pouTypeText;
        MemoryCodeBox c = new MemoryCodeBox(4);
        boolean optimizedBlockAccess = PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1500 || PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1200;
        switch (this.pouType) {
            case FUNCTION: {
                pouTypeText = "FUNCTION";
                break;
            }
            case PROGRAM: {
                pouTypeText = "ORGANIZATION_BLOCK";
                break;
            }
            default: {
                throw new RuntimeException("Unknown pou type: " + (Object)((Object)this.pouType));
            }
        }
        String retTypeTxt = this.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.retType});
        c.add("%s %s%s", new Object[]{pouTypeText, this.name, retTypeTxt});
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{optimizedBlockAccess});
        c.indent();
        if (!this.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcVariable var : this.inputVars) {
                c.add("%s: %s;", new Object[]{var.name, var.type});
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.localVars.isEmpty() && this.pouType == PlcPouType.FUNCTION) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcVariable var : this.localVars) {
                c.add("%s: %s;", new Object[]{var.name, var.type});
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.tempVars.isEmpty() || !this.outputVars.isEmpty()) {
            Assert.areEqual((Object)((Object)this.pouType), (Object)((Object)PlcPouType.PROGRAM));
            c.add("VAR_TEMP");
            c.indent();
            for (PlcVariable var : this.tempVars) {
                c.add("%s: %s;", new Object[]{var.name, var.type});
            }
            for (PlcVariable var : this.outputVars) {
                Assert.areEqual((Object)this.outputVars.size(), (Object)2);
                c.add("%s: %s;", new Object[]{var.name, var.type});
            }
            c.dedent();
            c.add("END_VAR");
        }
        c.dedent();
        c.add();
        c.add("BEGIN");
        c.indent();
        c.add((Box)this.body);
        c.dedent();
        c.add("END_%s", new Object[]{pouTypeText});
        return c;
    }
}

