/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.writers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputType;
import org.eclipse.escet.cif.cif2plc.options.PlcOutputTypeOption;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcResource;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class S7Writer {
    private S7Writer() {
    }

    public static void write(PlcProject project, String outPath) {
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)outPath);
        Path nioAbsPath = Paths.get(absPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated PLC code.", (Object[])new Object[]{outPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
        Assert.areEqual((Object)project.configurations.size(), (Object)1);
        PlcConfiguration config = project.configurations.get(0);
        Assert.areEqual((Object)config.resources.size(), (Object)1);
        PlcResource resource = config.resources.get(0);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.name.equals("INPUTS")) {
                S7Writer.write(globalVarList, outPath);
                continue;
            }
            if (globalVarList.name.equals("CONSTS")) {
                S7Writer.write(globalVarList, outPath);
                continue;
            }
            Assert.areEqual((Object)globalVarList.name, (Object)"TIMERS");
            S7Writer.writeTimers(outPath);
        }
        for (PlcPou pou : project.pous) {
            S7Writer.write(pou, outPath);
        }
        int programCount = 0;
        for (PlcPou pou : project.pous) {
            if (pou.pouType != PlcPouType.PROGRAM) continue;
            ++programCount;
            if (pou.localVars.isEmpty()) continue;
            S7Writer.write(pou.localVars, outPath);
        }
        Assert.areEqual((Object)programCount, (Object)1);
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            S7Writer.write(typeDecl, outPath);
        }
    }

    private static void write(PlcPou pou, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(pou.name) + ".scl"});
        Box code = pou.toBoxS7();
        code.writeToFile(path);
    }

    private static void writeTimers(String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, Strings.fmt((String)"timers.db", (Object[])new Object[0])});
        MemoryCodeBox c = new MemoryCodeBox(4);
        boolean s71500OrS71200 = PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1500 || PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1200;
        int timerIdx = 0;
        while (timerIdx < 2) {
            c.add("DATA_BLOCK \"timer%d\"", new Object[]{timerIdx});
            c.add("{InstructionName := '%s';", new Object[]{s71500OrS71200 ? "IEC_TIMER" : "TON"});
            c.add("LibVersion := '1.0';");
            c.add("S7_Optimized_Access := '%b' }", new Object[]{s71500OrS71200});
            c.add("AUTHOR : Simatic");
            c.add("FAMILY : %s", new Object[]{s71500OrS71200 ? "IEC" : "IEC_TC"});
            c.add("NAME : %s", new Object[]{s71500OrS71200 ? "IEC_TMR" : "TON"});
            c.add("VERSION : 1.0");
            c.add("NON_RETAIN");
            c.add("%s", new Object[]{s71500OrS71200 ? "IEC_TIMER" : "TON"});
            c.add();
            c.add("BEGIN");
            c.add();
            c.add("END_DATA_BLOCK");
            c.add();
            ++timerIdx;
        }
        c.writeToFile(path);
    }

    private static void write(PlcTypeDecl typeDecl, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(typeDecl.name) + ".udt"});
        Box code = typeDecl.toBoxS7();
        code.writeToFile(path);
    }

    private static void write(PlcGlobalVarList gvl, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, String.valueOf(gvl.name) + ".xml"});
        Box code = gvl.toBoxS7();
        code.writeToFile(path);
    }

    private static void write(List<PlcVariable> variables, String outPath) {
        String path = org.eclipse.escet.common.app.framework.Paths.join((String[])new String[]{outPath, "DB.db"});
        MemoryCodeBox c = new MemoryCodeBox(4);
        boolean optimizedBlockAccess = PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1500 || PlcOutputTypeOption.getPlcOutputType() == PlcOutputType.S7_1200;
        c.add("DATA_BLOCK \"DB\"");
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{optimizedBlockAccess});
        c.indent();
        c.add("VAR");
        c.indent();
        for (PlcVariable var : variables) {
            c.add("%s: %s;", new Object[]{var.name, var.type});
        }
        c.add("curTimer: INT;");
        c.dedent();
        c.add("END_VAR");
        c.dedent();
        c.add("BEGIN");
        c.indent();
        for (PlcVariable var : variables) {
            if (var.value == null) continue;
            c.add("%s := %s;", new Object[]{var.name, var.value});
        }
        c.dedent();
        c.add("END_DATA_BLOCK");
        c.writeToFile(path);
    }
}

