/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.java.Assert;

public class CifExtFuncUtils {
    private CifExtFuncUtils() {
    }

    public static String getLangName(String extRef) {
        int idx = extRef.indexOf(58);
        String langName = idx == -1 ? "" : extRef.substring(0, idx);
        return langName;
    }

    public static String[] splitExtJavaRef(String extRef) {
        Assert.check((boolean)extRef.startsWith("java:"));
        extRef = extRef.substring("java:".length());
        int idx = extRef.indexOf(124);
        String methodName = idx == -1 ? extRef : extRef.substring(0, idx);
        String classPath = idx == -1 ? null : extRef.substring(idx + 1);
        idx = methodName.lastIndexOf(46);
        String className = idx == -1 ? "" : methodName.substring(0, idx);
        methodName = idx == -1 ? methodName : methodName.substring(idx + 1);
        return new String[]{"java", className, methodName, classPath};
    }

    public static String mergeExtJavaRef(String[] parts) {
        Assert.check((parts.length == 4 ? 1 : 0) != 0);
        String rslt = String.valueOf(parts[0]) + ":" + parts[1] + "." + parts[2];
        if (parts[3] != null) {
            rslt = String.valueOf(rslt) + "|" + parts[3];
        }
        return rslt;
    }

    public static String[] splitJavaClassPathEntries(String classPath) {
        return StringUtils.split((String)classPath, (String)";");
    }

    public static String updateExtRefRelPaths(String extRef, String funcSpecDir, String relDir) {
        String langName = CifExtFuncUtils.getLangName(extRef);
        if (langName.equals("java")) {
            String[] parts = CifExtFuncUtils.splitExtJavaRef(extRef);
            String classPath = parts[3];
            if (classPath == null) {
                return extRef;
            }
            CharSequence[] entries = CifExtFuncUtils.splitJavaClassPathEntries(classPath);
            int i = 0;
            while (i < entries.length) {
                String entry = entries[i];
                entry = PlatformUriUtils.resolve((String)entry, (String)funcSpecDir);
                entry = PlatformUriUtils.getRelativePath((String)entry, (String)relDir);
                entries[i] = entry;
                ++i;
            }
            parts[3] = String.join((CharSequence)";", entries);
            return CifExtFuncUtils.mergeExtJavaRef(parts);
        }
        throw new IllegalArgumentException("Uknown language: " + langName);
    }
}

