/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Maps;

public class EventRefSet
implements Iterable<Expression> {
    protected final Map<EventRefWrapper, EventRefWrapper> eventRefs;

    public EventRefSet() {
        this(Maps.map());
    }

    public EventRefSet(EventRefSet set) {
        this(Maps.copy(set.eventRefs));
    }

    private EventRefSet(Map<EventRefWrapper, EventRefWrapper> eventRefs) {
        this.eventRefs = eventRefs;
    }

    public boolean isEmpty() {
        return this.eventRefs.isEmpty();
    }

    public boolean contains(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        return this.eventRefs.containsKey(wrapper);
    }

    public Expression get(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper entry = this.eventRefs.get(wrapper);
        return entry == null ? null : entry.eventRef;
    }

    public Expression add(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper prev = this.eventRefs.put(wrapper, wrapper);
        return prev == null ? null : prev.eventRef;
    }

    public Expression remove(Expression eventRef) {
        EventRefWrapper wrapper = new EventRefWrapper(eventRef);
        EventRefWrapper removed = this.eventRefs.remove(wrapper);
        return removed == null ? null : removed.eventRef;
    }

    public void removeAll(EventRefSet eventRefSet) {
        for (Expression eventRef : eventRefSet) {
            this.remove(eventRef);
        }
    }

    @Override
    public Iterator<Expression> iterator() {
        return new Iterator<Expression>(){
            private final Iterator<EventRefWrapper> iter;
            {
                this.iter = EventRefSet.this.eventRefs.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Expression next() {
                return this.iter.next().eventRef;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    private class EventRefWrapper {
        public final Expression eventRef;

        public EventRefWrapper(Expression eventRef) {
            this.eventRef = eventRef;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EventRefWrapper)) {
                return false;
            }
            EventRefWrapper other = (EventRefWrapper)obj;
            return CifEventUtils.areSameEventRefs(this.eventRef, other.eventRef);
        }

        public int hashCode() {
            if (this.eventRef instanceof TauExpression) {
                return 0;
            }
            if (this.eventRef instanceof EventExpression) {
                return ((EventExpression)this.eventRef).getEvent().hashCode();
            }
            String msg = "Unknown event ref expr: " + this.eventRef;
            throw new RuntimeException(msg);
        }
    }
}

