/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Objects;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifCheckViolation {
    private final PositionObject cifObject;
    private final String message;

    public CifCheckViolation(PositionObject cifObject, String message) {
        this.cifObject = cifObject;
        this.message = message;
        if (cifObject != null) {
            Assert.check((boolean)CifTextUtils.hasName(cifObject), (Object)cifObject);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CifCheckViolation)) {
            return false;
        }
        CifCheckViolation that = (CifCheckViolation)obj;
        return this.cifObject == that.cifObject && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.cifObject, this.message);
    }

    public String toString() {
        String name = this.cifObject == null ? "specification" : "\"" + CifTextUtils.getAbsName(this.cifObject) + "\"";
        return Strings.fmt((String)"%s: %s.", (Object[])new Object[]{name, this.message});
    }
}

