/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.checkers.CifChecker;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Strings;

public class CifPreconditionChecker
extends CifChecker {
    public CifPreconditionChecker(List<CifCheck> preconditions) {
        super(preconditions);
    }

    public CifPreconditionChecker(CifCheck[] preconditions) {
        super(preconditions);
    }

    public void reportPreconditionViolations(Specification spec, String toolName) {
        CifCheckViolations violations = this.check(spec);
        if (violations.hasViolations()) {
            List messages = violations.getViolations().map(v -> "Unsupported " + v.toString()).collect(Collectors.toList());
            Collections.sort(messages, Strings.SORTER);
            String msg = String.valueOf(toolName) + " failed due to unsatisfied preconditions:\n - " + String.join((CharSequence)"\n - ", messages);
            throw new UnsupportedException(msg);
        }
    }
}

