/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class NoKindlessStateEvtExclInvsCheck
extends CifCheck {
    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        for (Invariant inv : comp.getInvariants()) {
            SupKind supKind;
            if (inv.getInvKind() != InvKind.EVENT_NEEDS && inv.getInvKind() != InvKind.EVENT_DISABLES || (supKind = inv.getSupKind()) != SupKind.NONE) continue;
            violations.add((PositionObject)comp, "component has a kindless state/event exclusion invariant, lacking a supervisory kind");
        }
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        for (Invariant inv : loc.getInvariants()) {
            SupKind supKind;
            if (inv.getInvKind() != InvKind.EVENT_NEEDS && inv.getInvKind() != InvKind.EVENT_DISABLES || (supKind = inv.getSupKind()) != SupKind.NONE) continue;
            if (loc.getName() != null) {
                violations.add((PositionObject)loc, "location has a kindless state/event exclusion invariant, lacking a supervisory kind");
                continue;
            }
            violations.add((PositionObject)((Automaton)loc.eContainer()), "automaton has a location with a kindless state/event exclusion invariant, lacking a supervisory kind");
        }
    }
}

