/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class NoSpecificExprsCheck
extends CifCheck {
    private final EnumSet<NoSpecificExpr> disalloweds;

    public NoSpecificExprsCheck(NoSpecificExpr ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public NoSpecificExprsCheck(EnumSet<NoSpecificExpr> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessAlgVariableExpression(AlgVariableExpression algRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.ALG_VAR_REFS)) {
            this.addExprViolation((Expression)algRef, "algebraic variable reference", violations);
        }
    }

    protected void preprocessFunctionExpression(FunctionExpression userDefFuncRef, CifCheckViolations violations) {
        if ((this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS) || this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF) || this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_INT)) && userDefFuncRef.getFunction() instanceof InternalFunction) {
            this.addExprViolation((Expression)userDefFuncRef, "internal user-defined function reference", violations);
        }
        if ((this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS) || this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF) || this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_USER_DEF_EXT)) && userDefFuncRef.getFunction() instanceof ExternalFunction) {
            this.addExprViolation((Expression)userDefFuncRef, "external user-defined function reference", violations);
        }
    }

    protected void preprocessStdLibFunctionExpression(StdLibFunctionExpression stdLibRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS) || this.disalloweds.contains((Object)NoSpecificExpr.FUNC_REFS_STD_LIB)) {
            this.addExprViolation((Expression)stdLibRef, "standard library function reference", violations);
        }
    }

    protected void preprocessBinaryExpression(BinaryExpression binExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.BINARY_EXPRS)) {
            this.addExprViolation((Expression)binExpr, "binary expression", violations);
        }
    }

    protected void preprocessBoolExpression(BoolExpression boolLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.BOOL_LITS)) {
            this.addExprViolation((Expression)boolLit, "boolean literal", violations);
        }
    }

    protected void preprocessCastExpression(CastExpression castExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS)) {
            this.addExprViolation((Expression)castExpr, "cast expression", violations);
        } else if (this.disalloweds.contains((Object)NoSpecificExpr.CAST_EXPRS_NON_EQUAL_TYPE)) {
            CifType rtype;
            CifType ctype = castExpr.getChild().getType();
            if (CifTypeUtils.checkTypeCompat(ctype, rtype = castExpr.getType(), RangeCompat.EQUAL)) {
                return;
            }
            this.addExprViolation((Expression)castExpr, "type-changing cast expression", violations);
        }
    }

    protected void preprocessComponentExpression(ComponentExpression compRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS) || this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS_EXPLICIT)) {
            this.addExprViolation((Expression)compRef, "component reference", violations);
        }
    }

    protected void preprocessCompParamExpression(CompParamExpression compParamRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_PARAM_REFS)) {
            this.addExprViolation((Expression)compParamRef, "component parameter reference", violations);
        }
    }

    protected void preprocessConstantExpression(ConstantExpression constRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.CONST_REFS)) {
            this.addExprViolation((Expression)constRef, "constant reference", violations);
        }
    }

    protected void preprocessContVariableExpression(ContVariableExpression contRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.CONT_VAR_REFS)) {
            this.addExprViolation((Expression)contRef, "continuous variable reference", violations);
        }
    }

    protected void preprocessDictExpression(DictExpression dictLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.DICT_LITS)) {
            this.addExprViolation((Expression)dictLit, "dictionary literal", violations);
        }
    }

    protected void preprocessDiscVariableExpression(DiscVariableExpression discRef, CifCheckViolations violations) {
        EObject parent = discRef.getVariable().eContainer();
        if (parent instanceof ComplexComponent) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.DISC_VAR_REFS)) {
                this.addExprViolation((Expression)discRef, "discrete variable reference", violations);
            }
        } else if (parent instanceof FunctionParameter) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.USER_DEF_FUNC_PARAM_REFS)) {
                this.addExprViolation((Expression)discRef, "user-defined function parameter reference", violations);
            }
        } else if (parent instanceof InternalFunction) {
            if (this.disalloweds.contains((Object)NoSpecificExpr.INT_USER_DEF_FUNC_LOCAL_VAR_REFS)) {
                this.addExprViolation((Expression)discRef, "internal user-defined function local variable reference", violations);
            }
        } else {
            throw new RuntimeException("Unexpected disc var parent: " + parent);
        }
    }

    protected void preprocessEnumLiteralExpression(EnumLiteralExpression enumLitRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.ENUM_LIT_REFS)) {
            this.addExprViolation((Expression)enumLitRef, "enumeration literal reference", violations);
        }
    }

    protected void preprocessFieldExpression(FieldExpression fieldRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.TUPLE_FIELD_REFS)) {
            this.addExprViolation((Expression)fieldRef, "tuple field reference", violations);
        }
    }

    protected void preprocessFunctionCallExpression(FunctionCallExpression funcCall, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.FUNC_CALLS)) {
            this.addExprViolation((Expression)funcCall, "function call", violations);
        }
    }

    protected void preprocessIfExpression(IfExpression ifExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.IF_EXPRS)) {
            this.addExprViolation((Expression)ifExpr, "conditional expression", violations);
        }
    }

    protected void preprocessInputVariableExpression(InputVariableExpression inputRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.INPUT_VAR_REFS)) {
            this.addExprViolation((Expression)inputRef, "input variable reference", violations);
        }
    }

    protected void preprocessIntExpression(IntExpression intLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.INT_LITS)) {
            this.addExprViolation((Expression)intLit, "integer number literal", violations);
        }
    }

    protected void preprocessListExpression(ListExpression listLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.LIST_LITS)) {
            this.addExprViolation((Expression)listLit, "list literal", violations);
        }
    }

    protected void preprocessLocationExpression(LocationExpression locRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.LOC_REFS)) {
            this.addExprViolation((Expression)locRef, "location reference", violations);
        }
    }

    protected void preprocessProjectionExpression(ProjectionExpression projExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS)) {
            this.addExprViolation((Expression)projExpr, "projection expression", violations);
        } else {
            CifType ctype;
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_LISTS) && (ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType())) instanceof ListType) {
                this.addExprViolation((Expression)projExpr, "list projection expression", violations);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_DICTS) && (ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType())) instanceof DictType) {
                this.addExprViolation((Expression)projExpr, "dictionary projection expression", violations);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_STRINGS) && (ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType())) instanceof StringType) {
                this.addExprViolation((Expression)projExpr, "string projection expression", violations);
            }
            if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES)) {
                ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType());
                if (ctype instanceof TupleType) {
                    this.addExprViolation((Expression)projExpr, "tuple projection expression", violations);
                }
            } else {
                if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES_INDEX)) {
                    ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType());
                    CifType itype = CifTypeUtils.normalizeType(projExpr.getIndex().getType());
                    if (ctype instanceof TupleType && itype instanceof IntType) {
                        this.addExprViolation((Expression)projExpr, "tuple index-projection expression", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificExpr.PROJECTION_EXPRS_TUPLES_FIELD) && (ctype = CifTypeUtils.normalizeType(projExpr.getChild().getType())) instanceof TupleType && projExpr.getIndex() instanceof FieldExpression) {
                    this.addExprViolation((Expression)projExpr, "tuple field-projection expression", violations);
                }
            }
        }
    }

    protected void preprocessRealExpression(RealExpression realLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.REAL_LITS)) {
            this.addExprViolation((Expression)realLit, "real number literal", violations);
        }
    }

    protected void preprocessReceivedExpression(ReceivedExpression receivedExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.RECEIVE_EXPRS)) {
            this.addExprViolation((Expression)receivedExpr, "received value expression", violations);
        }
    }

    protected void preprocessSelfExpression(SelfExpression selfRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS) || this.disalloweds.contains((Object)NoSpecificExpr.COMP_REFS_SELF)) {
            this.addExprViolation((Expression)selfRef, "component reference", violations);
        }
    }

    protected void preprocessSetExpression(SetExpression setLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.SET_LITS)) {
            this.addExprViolation((Expression)setLit, "set literal", violations);
        }
    }

    protected void preprocessSliceExpression(SliceExpression sliceExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.SLICE_EXPRS)) {
            this.addExprViolation((Expression)sliceExpr, "slice expression", violations);
        }
    }

    protected void preprocessStringExpression(StringExpression stringLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.STRING_LITS)) {
            this.addExprViolation((Expression)stringLit, "string literal", violations);
        }
    }

    protected void preprocessSwitchExpression(SwitchExpression switchExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.SWITCH_EXPRS)) {
            this.addExprViolation((Expression)switchExpr, "switch expression", violations);
        }
    }

    protected void preprocessTimeExpression(TimeExpression timeRef, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.TIME_VAR_REFS)) {
            this.addExprViolation((Expression)timeRef, "time variable reference", violations);
        }
    }

    protected void preprocessTupleExpression(TupleExpression tupleLit, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.TUPLE_LITS)) {
            this.addExprViolation((Expression)tupleLit, "tuple literal", violations);
        }
    }

    protected void preprocessUnaryExpression(UnaryExpression unExpr, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificExpr.UNARY_EXPRS)) {
            this.addExprViolation((Expression)unExpr, "unary expression", violations);
        }
    }

    private void addExprViolation(Expression expr, String description, CifCheckViolations violations) {
        violations.add(CifTextUtils.getNamedSelfOrAncestor((PositionObject)expr), Strings.fmt((String)"uses %s \"%s\"", (Object[])new Object[]{description, CifTextUtils.exprToStr(expr)}));
    }

    public static enum NoSpecificExpr {
        ALG_VAR_REFS,
        FUNC_REFS,
        FUNC_REFS_USER_DEF,
        FUNC_REFS_USER_DEF_INT,
        FUNC_REFS_USER_DEF_EXT,
        FUNC_REFS_STD_LIB,
        BINARY_EXPRS,
        BOOL_LITS,
        CAST_EXPRS,
        CAST_EXPRS_NON_EQUAL_TYPE,
        COMP_REFS,
        COMP_REFS_EXPLICIT,
        COMP_REFS_SELF,
        COMP_PARAM_REFS,
        CONST_REFS,
        CONT_VAR_REFS,
        DICT_LITS,
        DISC_VAR_REFS,
        USER_DEF_FUNC_PARAM_REFS,
        INT_USER_DEF_FUNC_LOCAL_VAR_REFS,
        ENUM_LIT_REFS,
        TUPLE_FIELD_REFS,
        FUNC_CALLS,
        IF_EXPRS,
        INPUT_VAR_REFS,
        INT_LITS,
        LIST_LITS,
        LOC_REFS,
        PROJECTION_EXPRS,
        PROJECTION_EXPRS_LISTS,
        PROJECTION_EXPRS_DICTS,
        PROJECTION_EXPRS_STRINGS,
        PROJECTION_EXPRS_TUPLES,
        PROJECTION_EXPRS_TUPLES_INDEX,
        PROJECTION_EXPRS_TUPLES_FIELD,
        REAL_LITS,
        RECEIVE_EXPRS,
        SET_LITS,
        SLICE_EXPRS,
        STRING_LITS,
        SWITCH_EXPRS,
        TIME_VAR_REFS,
        TUPLE_LITS,
        UNARY_EXPRS;

    }
}

