/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class NoSpecificTypesCheck
extends CifCheck {
    private final EnumSet<NoSpecificType> disalloweds;

    public NoSpecificTypesCheck(NoSpecificType ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public NoSpecificTypesCheck(EnumSet<NoSpecificType> disalloweds) {
        this.disalloweds = disalloweds;
    }

    protected void preprocessComponentDefType(ComponentDefType compDefType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.COMP_DEF_TYPES)) {
            this.addTypeViolation((CifType)compDefType, "component definition type", violations);
        }
    }

    protected void preprocessComponentType(ComponentType compType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.COMP_TYPES)) {
            this.addTypeViolation((CifType)compType, "component type", violations);
        }
    }

    protected void preprocessDictType(DictType dictType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.DICT_TYPES)) {
            this.addTypeViolation((CifType)dictType, "dictionary type", violations);
        }
    }

    protected void preprocessDistType(DistType distType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.DIST_TYPES)) {
            this.addTypeViolation((CifType)distType, "distribution type", violations);
        }
    }

    protected void preprocessEnumType(EnumType enumType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.ENUM_TYPES)) {
            this.addTypeViolation((CifType)enumType, "enumeration type", violations);
        }
    }

    protected void preprocessFuncType(FuncType funcType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.FUNC_TYPES)) {
            this.addTypeViolation((CifType)funcType, "function type", violations);
        }
    }

    protected void preprocessIntType(IntType intType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.INT_TYPES)) {
            this.addTypeViolation((CifType)intType, "integer type", violations);
        } else if (this.disalloweds.contains((Object)NoSpecificType.INT_TYPES_RANGELESS) && CifTypeUtils.isRangeless(intType)) {
            this.addTypeViolation((CifType)intType, "rangeless integer type", violations);
        }
    }

    protected void preprocessListType(ListType listType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.LIST_TYPES)) {
            this.addTypeViolation((CifType)listType, "list type", violations);
        } else if (this.disalloweds.contains((Object)NoSpecificType.LIST_TYPES_NON_ARRAY) && !CifTypeUtils.isArrayType(listType)) {
            this.addTypeViolation((CifType)listType, "non-array list type", violations);
        }
    }

    protected void preprocessRealType(RealType realType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.REAL_TYPES)) {
            this.addTypeViolation((CifType)realType, "real type", violations);
        }
    }

    protected void preprocessSetType(SetType setType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.SET_TYPES)) {
            this.addTypeViolation((CifType)setType, "set type", violations);
        }
    }

    protected void preprocessStringType(StringType stringType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.STRING_TYPES)) {
            this.addTypeViolation((CifType)stringType, "string type", violations);
        }
    }

    protected void preprocessTupleType(TupleType tupleType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.TUPLE_TYPES)) {
            this.addTypeViolation((CifType)tupleType, "tuple type", violations);
        }
    }

    protected void preprocessVoidType(VoidType voidType, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)NoSpecificType.VOID_TYPES)) {
            this.addTypeViolation((CifType)voidType, "void type", violations);
        }
    }

    private void addTypeViolation(CifType type, String description, CifCheckViolations violations) {
        violations.add(CifTextUtils.getNamedSelfOrAncestor((PositionObject)type), Strings.fmt((String)"uses %s \"%s\"", (Object[])new Object[]{description, CifTextUtils.typeToStr(type)}));
    }

    public static enum NoSpecificType {
        COMP_DEF_TYPES,
        COMP_TYPES,
        DICT_TYPES,
        DIST_TYPES,
        ENUM_TYPES,
        FUNC_TYPES,
        INT_TYPES,
        INT_TYPES_RANGELESS,
        LIST_TYPES,
        LIST_TYPES_NON_ARRAY,
        REAL_TYPES,
        SET_TYPES,
        STRING_TYPES,
        TUPLE_TYPES,
        VOID_TYPES;

    }
}

