/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class OnlyAutsWithOneInitLocCheck
extends CifCheck {
    private int initLocCount;

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        this.initLocCount = 0;
    }

    protected void postprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (this.initLocCount == 0) {
            violations.add((PositionObject)aut, "automaton has no initial location");
        } else if (this.initLocCount > 1) {
            violations.add((PositionObject)aut, Strings.fmt((String)"automata has multiple (%d) initial locations", (Object[])new Object[]{this.initLocCount}));
        }
    }

    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        EObject parent = loc.eContainer();
        if (parent instanceof LocationParameter) {
            return;
        }
        boolean initial = false;
        String errMsg = null;
        try {
            initial = loc.getInitials().isEmpty() ? false : CifEvalUtils.evalPreds((List<Expression>)loc.getInitials(), true, true);
        }
        catch (UnsupportedException e) {
            errMsg = "as one of its initialization predicates can not be statically evaluated";
        }
        catch (CifEvalException e) {
            errMsg = "as evaluating one of its initialization predicates resulted in an evaluation error";
        }
        if (errMsg != null) {
            if (loc.getName() != null) {
                violations.add((PositionObject)loc, "failed to determine whether this is an initial location, " + errMsg);
            } else {
                violations.add((PositionObject)((Automaton)loc.eContainer()), "failed to determine whether the automaton's location is an initial location, " + errMsg);
            }
            this.initLocCount = -1;
        }
        if (initial && this.initLocCount != -1) {
            ++this.initLocCount;
        }
    }
}

