/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class OnlyEventsWithControllabilityCheck
extends CifCheck {
    protected void preprocessEvent(Event event, CifCheckViolations violations) {
        if (event.getControllable() == null) {
            violations.add((PositionObject)event, "event is not declared as controllable or uncontrollable");
        }
    }

    protected void preprocessTauExpression(TauExpression tauExpr, CifCheckViolations violations) {
        EdgeEvent edgeEvent = (EdgeEvent)tauExpr.eContainer();
        Edge edge = (Edge)edgeEvent.eContainer();
        Location loc = CifEdgeUtils.getSource(edge);
        if (loc.getName() != null) {
            violations.add((PositionObject)loc, "location has an edge with explicitly event \"tau\" on it, which is not controllable or uncontrollable");
        } else {
            violations.add((PositionObject)((Automaton)loc.eContainer()), "automaton has an edge with explicitly event \"tau\" on it, which is not controllable or uncontrollable");
        }
    }

    protected void preprocessEdge(Edge edge, CifCheckViolations violations) {
        if (edge.getEvents().isEmpty()) {
            Location loc = CifEdgeUtils.getSource(edge);
            if (loc.getName() != null) {
                violations.add((PositionObject)loc, "location has an edge with implicitly event \"tau\" on it, which is not controllable or uncontrollable");
            } else {
                violations.add((PositionObject)((Automaton)loc.eContainer()), "automaton has an edge with implicitly event \"tau\" on it, which is not controllable or uncontrollable");
            }
        }
    }
}

