/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class OnlyStaticEvalMarkerPredsInLocsCheck
extends CifCheck {
    protected void preprocessLocation(Location loc, CifCheckViolations violations) {
        EObject parent = loc.eContainer();
        if (parent instanceof LocationParameter) {
            return;
        }
        if (!loc.getMarkeds().isEmpty()) {
            try {
                CifEvalUtils.evalPreds((List<Expression>)loc.getMarkeds(), false, true);
            }
            catch (UnsupportedException e) {
                if (loc.getName() != null) {
                    violations.add((PositionObject)loc, "location has a marker predicate that can not be evaluated statically");
                } else {
                    violations.add((PositionObject)((Automaton)loc.eContainer()), "automaton has a location with a marker predicate that can not be evaluated statically");
                }
            }
            catch (CifEvalException e) {
                if (loc.getName() != null) {
                    violations.add((PositionObject)loc, "static evaluation of a marker predicate in the location resulted in an evaluation error");
                }
                violations.add((PositionObject)((Automaton)loc.eContainer()), "static evaluation of a marker predicate in the location of the automaton resulted in an evaluation error");
            }
        }
    }
}

