/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common.checkers;

import java.util.Map;
import org.eclipse.escet.cif.common.checkers.CifCheck;
import org.eclipse.escet.cif.common.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class OnlyVarValueMarkerPredsInCompsCheck
extends CifCheck {
    private Map<DiscVariable, Expression> markeds = Maps.map();

    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        for (Expression marked : comp.getMarkeds()) {
            if (!(marked instanceof BinaryExpression)) {
                violations.add((PositionObject)comp, "component has a marker predicate that is not of the form \"discrete_variable = marked_value\"");
                continue;
            }
            BinaryExpression bexpr = (BinaryExpression)marked;
            if (bexpr.getOperator() != BinaryOperator.EQUAL || !(bexpr.getLeft() instanceof DiscVariableExpression)) {
                violations.add((PositionObject)comp, "component has a marker predicate that is not of the form \"discrete_variable = marked_value\"");
                continue;
            }
            DiscVariableExpression vref = (DiscVariableExpression)bexpr.getLeft();
            DiscVariable var = vref.getVariable();
            Expression newValue = bexpr.getRight();
            Expression previousValue = this.markeds.get(var);
            if (previousValue == null) {
                this.markeds.put(var, newValue);
                continue;
            }
            violations.add((PositionObject)var, "discrete variable has multiple predicates to specify its marked values");
        }
    }
}

