/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.ACifObject;
import org.eclipse.escet.cif.parser.ast.AEquation;
import org.eclipse.escet.cif.parser.ast.AEquationDecl;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.declarations.AAlgVariable;
import org.eclipse.escet.cif.parser.ast.declarations.AAlgVariableDecl;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AlgVariableDeclWrap
extends DeclWrap<AlgVariable> {
    private final AAlgVariableDecl astDecls;
    private final AAlgVariable astDecl;

    public AlgVariableDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AAlgVariableDecl astDecls, AAlgVariable astDecl, AlgVariable mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecls = astDecls;
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((AlgVariable)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecls.type, this.scope, this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        CifType ntype = CifTypeUtils.normalizeType((CifType)type);
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Algebraic variable", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((AlgVariable)this.mmDecl).setType(type);
        this.status = CheckStatus.USE;
        CifType vtype = this.checkValue(type);
        if (ntype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ntype))) {
            ((AlgVariable)this.mmDecl).setType((CifType)EMFHelper.deepclone((EObject)vtype));
        }
        this.status = CheckStatus.FULL;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
    }

    private CifType checkValue(CifType declType) {
        boolean inDecl;
        CifType type = null;
        boolean bl = inDecl = this.astDecl.value != null;
        if (inDecl) {
            Expression value = CifExprsTypeChecker.transExpression(this.astDecl.value, declType, this.scope, null, this.tchecker);
            ((AlgVariable)this.mmDecl).setValue(value);
            CifType vtype = value.getType();
            if (!CifTypeUtils.checkTypeCompat((CifType)declType, (CifType)vtype, (RangeCompat)RangeCompat.CONTAINED)) {
                this.tchecker.addProblem(ErrMsg.ALG_VAR_TYPE_VALUE_MISMATCH, this.astDecl.position, CifTextUtils.typeToStr((CifType)vtype), this.getAbsName(), CifTextUtils.typeToStr((CifType)declType));
                throw new SemanticException();
            }
            type = (CifType)EMFHelper.deepclone((EObject)vtype);
        }
        List<AEquation> eqns = this.scope.astEquations.get(this.getName());
        List inComp = Lists.list();
        Map inLocs = Maps.map();
        if (eqns != null) {
            for (AEquation aEquation : eqns) {
                ACifObject parent = aEquation.parent;
                Assert.notNull((Object)parent);
                if (parent instanceof AEquationDecl) {
                    inComp.add(aEquation);
                } else {
                    Assert.check((boolean)(parent instanceof ALocation));
                    List prev = (List)inLocs.get(parent);
                    if (prev == null) {
                        prev = Lists.listc((int)1);
                        inLocs.put((ALocation)parent, prev);
                    }
                    prev.add(aEquation);
                }
                Equation eqn = CifConstructors.newEquation();
                eqn.setPosition(aEquation.createPosition());
                eqn.setDerivative(aEquation.derivative);
                eqn.setVariable((Declaration)this.mmDecl);
                this.scope.mmEquations.put(aEquation, eqn);
                if (aEquation.derivative) {
                    this.tchecker.addProblem(ErrMsg.EQN_ALG_DER, aEquation.position, this.getAbsName());
                }
                Expression value = CifExprsTypeChecker.transExpression(aEquation.value, declType, this.scope, null, this.tchecker);
                eqn.setValue(value);
                CifType vtype = value.getType();
                if (!CifTypeUtils.checkTypeCompat((CifType)declType, (CifType)vtype, (RangeCompat)RangeCompat.CONTAINED)) {
                    this.tchecker.addProblem(ErrMsg.ALG_VAR_TYPE_VALUE_MISMATCH, aEquation.position, CifTextUtils.typeToStr((CifType)vtype), this.getAbsName(), CifTextUtils.typeToStr((CifType)declType));
                    throw new SemanticException();
                }
                type = type == null ? vtype : CifTypeUtils.mergeTypes((CifType)type, (CifType)vtype);
            }
        }
        if (inDecl && !inComp.isEmpty() || inComp.size() > 1) {
            if (inDecl) {
                this.tchecker.addProblem(ErrMsg.DUPL_VALUE_FOR_ALG_VAR, this.astDecl.position, this.getAbsName());
            }
            for (AEquation aEquation : inComp) {
                this.tchecker.addProblem(ErrMsg.DUPL_VALUE_FOR_ALG_VAR, aEquation.position, this.getAbsName());
            }
        }
        for (Map.Entry entry : inLocs.entrySet()) {
            if (!inDecl && inComp.isEmpty() && ((List)entry.getValue()).size() <= 1) continue;
            if (inDecl) {
                this.tchecker.addProblem(ErrMsg.DUPL_VALUE_FOR_ALG_VAR, this.astDecl.position, this.getAbsName());
            }
            for (AEquation eqn : inComp) {
                this.tchecker.addProblem(ErrMsg.DUPL_VALUE_FOR_ALG_VAR, eqn.position, this.getAbsName());
            }
            for (AEquation eqn : (List)entry.getValue()) {
                this.tchecker.addProblem(ErrMsg.DUPL_VALUE_FOR_ALG_VAR, eqn.position, this.getAbsName());
            }
        }
        if (!inDecl && inComp.isEmpty() && inLocs.isEmpty()) {
            this.tchecker.addProblem(ErrMsg.ALG_VAR_NO_VALUE, this.astDecl.position, this.getAbsName());
            throw new SemanticException();
        }
        if (!inLocs.isEmpty() && this.scope.getAstLocs().size() != inLocs.size()) {
            for (ALocation aLocation : this.scope.getAstLocs()) {
                if (inLocs.containsKey(aLocation)) continue;
                this.tchecker.addProblem(ErrMsg.ALG_VAR_NO_VALUE, aLocation.position, this.getAbsName());
            }
        }
        Assert.notNull((Object)type);
        return type;
    }
}

