/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifEventRefTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InvariantInfo;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InvDeclWrap
extends DeclWrap<Invariant> {
    private final InvariantInfo invariantInfo;

    public InvDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, InvariantInfo invariantInfo) {
        super(tchecker, scope, invariantInfo.mmInv);
        this.invariantInfo = invariantInfo;
        Assert.check((((Invariant)this.mmDecl).getName() != null ? 1 : 0) != 0);
    }

    @Override
    public String getName() {
        return ((Invariant)this.mmDecl).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.mmDecl);
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        InvDeclWrap.tcheckFull(this.tchecker, this.scope, this.invariantInfo);
        this.status = CheckStatus.FULL;
    }

    public static void tcheckFull(CifTypeChecker tchecker, ParentScope<?> scope, InvariantInfo invariantInfo) {
        AExpression astPred = invariantInfo.astInv.predicate;
        Expression pred = CifExprsTypeChecker.transExpression(astPred, (CifType)CifExprsTypeChecker.BOOL_TYPE_HINT, scope, null, tchecker);
        invariantInfo.mmInv.setPredicate(pred);
        CifType t = pred.getType();
        CifType nt = CifTypeUtils.normalizeType((CifType)t);
        if (!(nt instanceof BoolType)) {
            tchecker.addProblem(ErrMsg.INV_NON_BOOL, astPred.position, CifTextUtils.typeToStr((CifType)t));
        }
        if (invariantInfo.event != null) {
            Expression eventRef = CifEventRefTypeChecker.checkEventRef(invariantInfo.event, scope, tchecker);
            invariantInfo.mmInv.setEvent(eventRef);
        }
    }
}

