/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.CifParser;
import org.eclipse.escet.cif.parser.ast.ACifObject;
import org.eclipse.escet.cif.parser.ast.ACompDecl;
import org.eclipse.escet.cif.parser.ast.ACompDefDecl;
import org.eclipse.escet.cif.parser.ast.ACompInstDecl;
import org.eclipse.escet.cif.parser.ast.ADecl;
import org.eclipse.escet.cif.parser.ast.AEquationDecl;
import org.eclipse.escet.cif.parser.ast.AFormalAlgParameter;
import org.eclipse.escet.cif.parser.ast.AFormalComponentParameter;
import org.eclipse.escet.cif.parser.ast.AFormalEventParameter;
import org.eclipse.escet.cif.parser.ast.AFormalEventParameterPart;
import org.eclipse.escet.cif.parser.ast.AFormalLocationParameter;
import org.eclipse.escet.cif.parser.ast.AFormalParameter;
import org.eclipse.escet.cif.parser.ast.AFuncDecl;
import org.eclipse.escet.cif.parser.ast.AImport;
import org.eclipse.escet.cif.parser.ast.AImportDecl;
import org.eclipse.escet.cif.parser.ast.AInitialDecl;
import org.eclipse.escet.cif.parser.ast.AInvariant;
import org.eclipse.escet.cif.parser.ast.AInvariantDecl;
import org.eclipse.escet.cif.parser.ast.AMarkedDecl;
import org.eclipse.escet.cif.parser.ast.ANamespaceDecl;
import org.eclipse.escet.cif.parser.ast.ASpecification;
import org.eclipse.escet.cif.parser.ast.automata.AAlphabetDecl;
import org.eclipse.escet.cif.parser.ast.automata.AAutomatonBody;
import org.eclipse.escet.cif.parser.ast.automata.AEquationLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AInvariantLocationElement;
import org.eclipse.escet.cif.parser.ast.automata.ALocation;
import org.eclipse.escet.cif.parser.ast.automata.ALocationElement;
import org.eclipse.escet.cif.parser.ast.automata.AMonitorDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AAlgVariable;
import org.eclipse.escet.cif.parser.ast.declarations.AAlgVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AConstDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AConstant;
import org.eclipse.escet.cif.parser.ast.declarations.AContVariable;
import org.eclipse.escet.cif.parser.ast.declarations.AContVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariable;
import org.eclipse.escet.cif.parser.ast.declarations.ADiscVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AEnumDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AEventDecl;
import org.eclipse.escet.cif.parser.ast.declarations.AInputVariableDecl;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDef;
import org.eclipse.escet.cif.parser.ast.declarations.ATypeDefDecl;
import org.eclipse.escet.cif.parser.ast.functions.AExternalFuncBody;
import org.eclipse.escet.cif.parser.ast.functions.AFuncParam;
import org.eclipse.escet.cif.parser.ast.functions.AInternalFuncBody;
import org.eclipse.escet.cif.parser.ast.iodecls.AIoDecl;
import org.eclipse.escet.cif.parser.ast.tokens.AIdentifier;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SourceFile;
import org.eclipse.escet.cif.typechecker.declwrap.AlgVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ConstDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ContVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DiscVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumLiteralDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalAlgDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalEventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalLocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InputVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InvariantInfo;
import org.eclipse.escet.cif.typechecker.declwrap.LocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.AutScope;
import org.eclipse.escet.cif.typechecker.scopes.CompInstScope;
import org.eclipse.escet.cif.typechecker.scopes.CompParamScope;
import org.eclipse.escet.cif.typechecker.scopes.FunctionScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SpecScope;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.setext.runtime.Token;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class SymbolScopeBuilder {
    private final CifTypeChecker tchecker;
    private final SourceFile sourceFile;
    private final SourceFile mainFile;
    private Map<String, TextPosition> imports = Maps.map();

    private SymbolScopeBuilder(CifTypeChecker tchecker, SourceFile sourceFile, SourceFile mainFile) {
        this.tchecker = tchecker;
        this.sourceFile = sourceFile;
        this.mainFile = mainFile;
    }

    public static SpecScope build(CifTypeChecker tchecker, SourceFile sourceFile, SourceFile mainFile, ASpecification spec) {
        Assert.ifAndOnlyIf((boolean)sourceFile.main, (spec != null ? 1 : 0) != 0);
        if (spec == null) {
            String relPath = sourceFile.getRelativePathFrom(mainFile);
            try {
                CifParser parser;
                block17: {
                    parser = new CifParser();
                    if (PlatformUriUtils.isPlatformUri((String)sourceFile.absPath)) {
                        if (!PlatformUriUtils.exists((String)sourceFile.absPath)) {
                            throw new InvalidInputException(null);
                        }
                        URI uri = URI.createURI((String)sourceFile.absPath);
                        URIConverter converter = URIConverter.INSTANCE;
                        Throwable throwable = null;
                        Object var9_13 = null;
                        try (InputStream stream = converter.createInputStream(uri);){
                            String src = Strings.fmt((String)"Resource \"%s\": ", (Object[])new Object[]{relPath});
                            spec = (ASpecification)parser.parseStream(stream, sourceFile.absPath, src);
                            break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    spec = (ASpecification)parser.parseFile(sourceFile.absPath, relPath);
                }
                if (!parser.getWarnings().isEmpty()) {
                    tchecker.addProblem(ErrMsg.IMPORT_SYNTAX_WARNING, sourceFile.importingPos, relPath);
                }
            }
            catch (InvalidInputException e) {
                tchecker.addProblem(ErrMsg.IMPORT_NOT_FOUND, sourceFile.importingPos, relPath);
                throw new SemanticException();
            }
            catch (IOException | InputOutputException e) {
                tchecker.addProblem(ErrMsg.IMPORT_IO_ERROR, sourceFile.importingPos, relPath);
                throw new SemanticException();
            }
            catch (SyntaxException e) {
                tchecker.addProblem(ErrMsg.IMPORT_SYNTAX_ERROR, sourceFile.importingPos, relPath);
                throw new SemanticException();
            }
        }
        SymbolScopeBuilder builder = new SymbolScopeBuilder(tchecker, sourceFile, mainFile);
        return builder.buildSpecification(spec);
    }

    private SpecScope buildSpecification(ASpecification spec) {
        Specification obj = CifConstructors.newSpecification();
        obj.setName("specification");
        obj.setPosition(spec.createPosition());
        SpecScope specScope = new SpecScope(obj, this.tchecker);
        ParentScope<?> bodyScope = this.processNamespaces(spec, specScope);
        for (ADecl decl : spec.body.decls) {
            this.addGroupDecl(decl, specScope, bodyScope);
        }
        return specScope;
    }

    private ParentScope<?> processNamespaces(ASpecification spec, SpecScope specScope) {
        ParentScope rslt = specScope;
        TextPosition prevNamespacePos = null;
        for (ADecl decl : spec.body.decls) {
            if (!(decl instanceof ANamespaceDecl)) continue;
            ANamespaceDecl nsDecl = (ANamespaceDecl)decl;
            if (prevNamespacePos != null) {
                this.tchecker.addProblem(ErrMsg.DUPL_NAMESPACE, prevNamespacePos, new String[0]);
                this.tchecker.addProblem(ErrMsg.DUPL_NAMESPACE, nsDecl.position, new String[0]);
            }
            prevNamespacePos = nsDecl.position;
            int offset = 0;
            String[] stringArray = StringUtils.split((String)nsDecl.name.name, (char)'.');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupName = stringArray[n2];
                int length = groupName.length();
                Position groupPos = nsDecl.name.createPosition();
                groupPos = PositionUtils.getSubRange((Position)groupPos, (int)offset, (int)groupName.length());
                offset += length + 1;
                Group group = CifConstructors.newGroup();
                group.setName(groupName);
                group.setPosition(groupPos);
                GroupScope groupScope = new GroupScope(group, (ParentScope<?>)rslt, this.tchecker);
                ((ParentScope)rslt).getGroup().getComponents().add((Object)group);
                rslt = groupScope;
                ++n2;
            }
        }
        return rslt;
    }

    private void addComponent(ACompDecl component, ParentScope<?> parent) {
        if (component.body instanceof AAutomatonBody) {
            this.addAutomaton((ADecl)component, parent);
        } else {
            this.addGroup((ADecl)component, parent);
        }
    }

    private void addCompDef(ACompDefDecl compdef, ParentScope<?> parent) {
        if (compdef.body instanceof AAutomatonBody) {
            this.addAutomaton((ADecl)compdef, parent);
        } else {
            this.addGroup((ADecl)compdef, parent);
        }
    }

    private void addGroup(ADecl decl, ParentScope<?> parent) {
        List decls;
        ParentScope scope;
        if (decl instanceof ACompDecl) {
            ACompDecl group1 = (ACompDecl)decl;
            Group group2 = CifConstructors.newGroup();
            group2.setName(group1.name.id);
            group2.setPosition(group1.createPosition());
            Assert.check((group1.kind == null ? 1 : 0) != 0);
            scope = new GroupScope(group2, parent, this.tchecker);
            decls = group1.body.decls;
            parent.getGroup().getComponents().add((Object)group2);
        } else {
            ACompDefDecl compdef1 = (ACompDefDecl)decl;
            ComponentDef compdef2 = CifConstructors.newComponentDef();
            compdef2.setPosition(compdef1.createPosition());
            Group body = CifConstructors.newGroup();
            body.setName(compdef1.name.id);
            body.setPosition(compdef1.createPosition());
            Assert.check((compdef1.kind == null ? 1 : 0) != 0);
            compdef2.setBody((ComplexComponent)body);
            scope = new GroupDefScope(compdef2, parent, this.tchecker);
            decls = compdef1.body.decls;
            parent.getGroup().getDefinitions().add((Object)compdef2);
            this.addFormalParameters(compdef1.parameters, scope);
        }
        for (ADecl d : decls) {
            this.addGroupDecl(d, scope, scope);
        }
    }

    private void addAutomaton(ADecl decl, ParentScope<?> parent) {
        List locs;
        List decls;
        ParentScope scope;
        if (decl instanceof ACompDecl) {
            ACompDecl aut1 = (ACompDecl)decl;
            Automaton aut2 = CifConstructors.newAutomaton();
            aut2.setName(aut1.name.id);
            aut2.setPosition(aut1.createPosition());
            aut2.setKind(this.transAutKind(aut1.kind));
            scope = new AutScope(aut2, aut1, parent, this.tchecker);
            decls = aut1.body.decls;
            locs = ((AAutomatonBody)aut1.body).locations;
            parent.getGroup().getComponents().add((Object)aut2);
        } else {
            ACompDefDecl compdef1 = (ACompDefDecl)decl;
            ComponentDef compdef2 = CifConstructors.newComponentDef();
            compdef2.setPosition(compdef1.createPosition());
            Automaton body = CifConstructors.newAutomaton();
            body.setName(compdef1.name.id);
            body.setPosition(compdef1.createPosition());
            body.setKind(this.transAutKind(compdef1.kind));
            compdef2.setBody((ComplexComponent)body);
            scope = new AutDefScope(compdef2, compdef1, parent, this.tchecker);
            decls = compdef1.body.decls;
            locs = ((AAutomatonBody)compdef1.body).locations;
            parent.getGroup().getDefinitions().add((Object)compdef2);
            this.addFormalParameters(compdef1.parameters, scope);
        }
        for (ADecl d : decls) {
            this.addAutDecl(d, scope);
        }
        for (ALocation loc : locs) {
            this.addLocation(loc, scope);
        }
    }

    private SupKind transAutKind(Token kind) {
        if (kind == null) {
            return SupKind.NONE;
        }
        return SupKind.valueOf((String)kind.text.toUpperCase(Locale.US));
    }

    private void addCompInst(ACompInstDecl compinst, ParentScope<?> parent) {
        ComponentInst obj = CifConstructors.newComponentInst();
        obj.setName(compinst.instName.id);
        obj.setPosition(compinst.createPosition());
        new CompInstScope(obj, compinst, parent, this.tchecker);
        parent.getGroup().getComponents().add((Object)obj);
    }

    private void addDecl(ADecl decl, ParentScope<?> parent) {
        if (decl instanceof AAlgVariableDecl) {
            this.addAlgVars((AAlgVariableDecl)decl, parent);
        } else if (decl instanceof AConstDecl) {
            this.addConstants((AConstDecl)decl, parent);
        } else if (decl instanceof AContVariableDecl) {
            this.addContVars((AContVariableDecl)decl, parent);
        } else if (decl instanceof AEventDecl) {
            this.addEvents((AEventDecl)decl, parent);
        } else if (decl instanceof AEnumDecl) {
            this.addEnum((AEnumDecl)decl, parent);
        } else if (decl instanceof ATypeDefDecl) {
            this.addTypeDefs(((ATypeDefDecl)decl).typeDefs, parent);
        } else if (decl instanceof AInputVariableDecl) {
            this.addInputVars((AInputVariableDecl)decl, parent);
        } else if (decl instanceof AIoDecl) {
            parent.astIoDecls.add((AIoDecl)decl);
        } else if (decl instanceof AInitialDecl) {
            parent.astInitPreds.add((AInitialDecl)decl);
        } else if (decl instanceof AInvariantDecl) {
            this.addInvariants((ACifObject)decl, parent, (EList<Invariant>)parent.getComplexComponent().getInvariants());
        } else if (decl instanceof AMarkedDecl) {
            parent.astMarkerPreds.add((AMarkedDecl)decl);
        } else if (decl instanceof AEquationDecl) {
            parent.addEquations(((AEquationDecl)decl).equations);
        } else {
            throw new RuntimeException("Unknown/unexpected decl: " + decl);
        }
    }

    private void addGroupDecl(ADecl decl, ParentScope<?> sourceParent, ParentScope<?> addParent) {
        if (sourceParent instanceof SpecScope) {
            Assert.check((sourceParent == addParent || addParent instanceof GroupScope ? 1 : 0) != 0);
        } else {
            Assert.check((sourceParent == addParent ? 1 : 0) != 0);
        }
        if (decl instanceof ANamespaceDecl) {
            if (!(sourceParent instanceof SpecScope)) {
                this.tchecker.addProblem(ErrMsg.NAMESPACE_IN_GRP, decl.position, new String[0]);
            }
        } else if (decl instanceof ACompDecl) {
            this.addComponent((ACompDecl)decl, addParent);
        } else if (decl instanceof ACompDefDecl) {
            this.addCompDef((ACompDefDecl)decl, addParent);
        } else if (decl instanceof ACompInstDecl) {
            this.addCompInst((ACompInstDecl)decl, addParent);
        } else if (decl instanceof AFuncDecl) {
            this.addFunction((AFuncDecl)decl, addParent);
        } else if (decl instanceof AImportDecl) {
            if (!(sourceParent instanceof SpecScope)) {
                this.tchecker.addProblem(ErrMsg.IMPORT_IN_GRP, decl.position, new String[0]);
                return;
            }
            Assert.check((boolean)(sourceParent instanceof SpecScope));
            this.addImports((AImportDecl)decl);
        } else {
            this.addDecl(decl, addParent);
        }
    }

    private void addAutDecl(ADecl decl, ParentScope<?> parent) {
        if (!(decl instanceof AAlphabetDecl) && !(decl instanceof AMonitorDecl)) {
            if (decl instanceof ALocation) {
                this.addLocation((ALocation)decl, parent);
            } else if (decl instanceof ADiscVariableDecl) {
                this.addDiscVariables((ADiscVariableDecl)decl, parent);
            } else {
                this.addDecl(decl, parent);
            }
        }
    }

    private void addLocation(ALocation loc, ParentScope<?> parent) {
        Assert.check((parent instanceof AutScope || parent instanceof AutDefScope ? 1 : 0) != 0);
        Location loc2 = CifConstructors.newLocation();
        if (loc.name != null) {
            loc2.setName(loc.name.id);
            loc2.setPosition(loc.name.createPosition());
        } else {
            loc2.setPosition(loc.createPosition());
        }
        parent.getAutomaton().getLocations().add((Object)loc2);
        if (loc.elements != null) {
            for (ALocationElement lelem : loc.elements) {
                if (lelem instanceof AEquationLocationElement) {
                    List eqns = ((AEquationLocationElement)lelem).equations;
                    parent.addEquations(eqns);
                    continue;
                }
                if (!(lelem instanceof AInvariantLocationElement)) continue;
                this.addInvariants((ACifObject)lelem, parent, (EList<Invariant>)loc2.getInvariants());
            }
        }
        if (loc.name != null) {
            LocationDeclWrap wrapper = new LocationDeclWrap(this.tchecker, parent, loc2);
            parent.addDeclaration(wrapper);
        }
    }

    private void addAlgVars(AAlgVariableDecl decls, ParentScope<?> parent) {
        for (AAlgVariable var1 : decls.variables) {
            AlgVariable var2 = CifConstructors.newAlgVariable();
            var2.setName(var1.name.id);
            var2.setPosition(var1.createPosition());
            AlgVariableDeclWrap wrapper = new AlgVariableDeclWrap(this.tchecker, parent, decls, var1, var2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)var2);
        }
    }

    private void addInputVars(AInputVariableDecl decls, ParentScope<?> parent) {
        for (AIdentifier var1 : decls.names) {
            InputVariable var2 = CifConstructors.newInputVariable();
            var2.setName(var1.id);
            var2.setPosition(var1.createPosition());
            InputVariableDeclWrap wrapper = new InputVariableDeclWrap(this.tchecker, parent, decls, var2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)var2);
        }
    }

    private void addContVars(AContVariableDecl decls, ParentScope<?> parent) {
        for (AContVariable var1 : decls.variables) {
            ContVariable var2 = CifConstructors.newContVariable();
            var2.setName(var1.name.id);
            var2.setPosition(var1.createPosition());
            ContVariableDeclWrap wrapper = new ContVariableDeclWrap(this.tchecker, parent, var1, var2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)var2);
        }
    }

    private void addConstants(AConstDecl decls, ParentScope<?> parent) {
        for (AConstant const1 : decls.constants) {
            Constant const2 = CifConstructors.newConstant();
            const2.setName(const1.name.id);
            const2.setPosition(const1.createPosition());
            ConstDeclWrap wrapper = new ConstDeclWrap(this.tchecker, parent, decls, const1, const2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)const2);
        }
    }

    private void addEvents(AEventDecl decls, ParentScope<?> parent) {
        Boolean controllable = null;
        if (decls.controllability != null) {
            controllable = decls.controllability.text.equals("controllable");
        }
        for (AIdentifier event1 : decls.names) {
            Event event2 = CifConstructors.newEvent();
            event2.setName(event1.id);
            event2.setPosition(event1.createPosition());
            event2.setControllable(controllable);
            EventDeclWrap wrapper = new EventDeclWrap(this.tchecker, parent, decls, event2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)event2);
        }
    }

    private void addEnum(AEnumDecl decl, ParentScope<?> parent) {
        EnumDecl enum2 = CifConstructors.newEnumDecl();
        enum2.setName(decl.name);
        enum2.setPosition(decl.createPosition());
        EnumDeclWrap wrapper = new EnumDeclWrap(this.tchecker, parent, enum2);
        parent.addDeclaration(wrapper);
        parent.getComplexComponent().getDeclarations().add((Object)enum2);
        EList enumLits = enum2.getLiterals();
        for (AIdentifier literalId : decl.literals) {
            EnumLiteral literal = CifConstructors.newEnumLiteral();
            literal.setName(literalId.id);
            literal.setPosition(literalId.createPosition());
            EnumLiteralDeclWrap literalWrapper = new EnumLiteralDeclWrap(this.tchecker, parent, literal);
            parent.addDeclaration(literalWrapper);
            enumLits.add(literal);
        }
    }

    private void addTypeDefs(List<ATypeDef> defs, ParentScope<?> parent) {
        for (ATypeDef tdef : defs) {
            TypeDecl tdecl = CifConstructors.newTypeDecl();
            tdecl.setName(tdef.name.id);
            tdecl.setPosition(tdef.createPosition());
            TypeDeclWrap wrapper = new TypeDeclWrap(this.tchecker, parent, tdef, tdecl);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)tdecl);
        }
    }

    private void addDiscVariables(ADiscVariableDecl decls, ParentScope<?> parent) {
        Assert.check((parent instanceof AutScope || parent instanceof AutDefScope ? 1 : 0) != 0);
        for (ADiscVariable var1 : decls.variables) {
            DiscVariable var2 = CifConstructors.newDiscVariable();
            var2.setName(var1.name.id);
            var2.setPosition(var1.createPosition());
            DiscVariableDeclWrap wrapper = new DiscVariableDeclWrap(this.tchecker, parent, decls, var1, var2);
            parent.addDeclaration(wrapper);
            parent.getComplexComponent().getDeclarations().add((Object)var2);
        }
    }

    private void addInvariants(ACifObject invs, ParentScope<?> parent, EList<Invariant> mmInvs) {
        List invariants = null;
        SupKind supKind = null;
        if (invs instanceof AInvariantDecl) {
            invariants = ((AInvariantDecl)invs).invariants;
            supKind = SymbolScopeBuilder.transInvSupKind(((AInvariantDecl)invs).kind);
        } else if (invs instanceof AInvariantLocationElement) {
            invariants = ((AInvariantLocationElement)invs).invariants;
            supKind = SymbolScopeBuilder.transInvSupKind(((AInvariantLocationElement)invs).kind);
        } else {
            throw new RuntimeException("Unknown/unexpected invariants: " + invs);
        }
        for (AInvariant astInv : invariants) {
            int numberOfInvariants;
            AIdentifier invName = astInv.name;
            InvKind invKind = SymbolScopeBuilder.transInvKind(astInv.invKind);
            if (invKind == InvKind.STATE) {
                numberOfInvariants = 1;
            } else {
                numberOfInvariants = astInv.events.size();
                Assert.implies((numberOfInvariants > 1 ? 1 : 0) != 0, (invName == null ? 1 : 0) != 0);
            }
            int i = 0;
            while (i < numberOfInvariants) {
                Position invPos = invName == null ? astInv.createPosition() : invName.createPosition();
                Invariant mmInv = CifConstructors.newInvariant();
                if (invName != null) {
                    mmInv.setName(invName.id);
                }
                mmInv.setInvKind(invKind);
                mmInv.setSupKind(supKind);
                mmInv.setPosition(invPos);
                mmInvs.add((Object)mmInv);
                AName event = astInv.events == null ? null : (AName)astInv.events.get(i);
                InvariantInfo invariantInfo = new InvariantInfo(astInv, event, mmInv);
                parent.addInvariant(invariantInfo);
                ++i;
            }
        }
    }

    private void addFormalParameters(List<AFormalParameter> params, ParentScope<?> parent) {
        for (AFormalParameter param : params) {
            if (param instanceof AFormalAlgParameter) {
                this.addFormalAlgParameters((AFormalAlgParameter)param, parent);
                continue;
            }
            if (param instanceof AFormalComponentParameter) {
                this.addFormalComponentParameters((AFormalComponentParameter)param, parent);
                continue;
            }
            if (param instanceof AFormalEventParameter) {
                this.addFormalEventParameters((AFormalEventParameter)param, parent);
                continue;
            }
            if (param instanceof AFormalLocationParameter) {
                this.addFormalLocationParameters((AFormalLocationParameter)param, parent);
                continue;
            }
            throw new RuntimeException("Unknown formal param: " + param);
        }
    }

    private void addFormalAlgParameters(AFormalAlgParameter params, ParentScope<?> parent) {
        for (AIdentifier id : params.names) {
            AlgVariable var = CifConstructors.newAlgVariable();
            var.setName(id.id);
            var.setPosition(id.createPosition());
            AlgParameter algParam = CifConstructors.newAlgParameter();
            algParam.setVariable(var);
            algParam.setPosition(id.createPosition());
            FormalAlgDeclWrap wrapper = new FormalAlgDeclWrap(this.tchecker, parent, params, algParam);
            parent.addDeclaration(wrapper);
            parent.getComponentDef().getParameters().add((Object)algParam);
        }
    }

    private void addFormalComponentParameters(AFormalComponentParameter params, ParentScope<?> parent) {
        for (AIdentifier id : params.names) {
            ComponentParameter compParam = CifConstructors.newComponentParameter();
            compParam.setName(id.id);
            compParam.setPosition(id.createPosition());
            new CompParamScope(compParam, params.type, parent, this.tchecker);
            parent.getComponentDef().getParameters().add((Object)compParam);
        }
    }

    private void addFormalEventParameters(AFormalEventParameter params, ParentScope<?> parent) {
        Boolean controllable = null;
        if (params.controllability != null) {
            controllable = params.controllability.text.equals("controllable");
        }
        for (AFormalEventParameterPart part : params.parts) {
            Event event = CifConstructors.newEvent();
            event.setName(part.name.id);
            event.setPosition(part.name.createPosition());
            event.setControllable(controllable);
            EventParameter eventParam = CifConstructors.newEventParameter();
            eventParam.setEvent(event);
            eventParam.setPosition(part.name.createPosition());
            FormalEventDeclWrap wrapper = new FormalEventDeclWrap(this.tchecker, parent, params, part, eventParam);
            parent.addDeclaration(wrapper);
            parent.getComponentDef().getParameters().add((Object)eventParam);
        }
    }

    private void addFormalLocationParameters(AFormalLocationParameter params, ParentScope<?> parent) {
        for (AIdentifier id : params.names) {
            Location loc = CifConstructors.newLocation();
            loc.setName(id.id);
            loc.setPosition(id.createPosition());
            LocationParameter locParam = CifConstructors.newLocationParameter();
            locParam.setLocation(loc);
            locParam.setPosition(id.createPosition());
            FormalLocationDeclWrap wrapper = new FormalLocationDeclWrap(this.tchecker, parent, locParam);
            parent.addDeclaration(wrapper);
            parent.getComponentDef().getParameters().add((Object)locParam);
        }
    }

    private void addFunction(AFuncDecl func, ParentScope<?> parent) {
        if (func.body instanceof AInternalFuncBody) {
            AInternalFuncBody body = (AInternalFuncBody)func.body;
            InternalFunction ifunc = CifConstructors.newInternalFunction();
            ifunc.setName(func.name.id);
            ifunc.setPosition(func.createPosition());
            FunctionScope scope = new FunctionScope((Function)ifunc, func, parent, this.tchecker);
            parent.getComplexComponent().getDeclarations().add((Object)ifunc);
            for (AFuncParam param : func.parameters) {
                this.addFunctionParams(param, scope);
            }
            for (ADiscVariableDecl var : body.variables) {
                this.addFunctionLocalVars(var, scope);
            }
        } else {
            Assert.check((boolean)(func.body instanceof AExternalFuncBody));
            AExternalFuncBody body = (AExternalFuncBody)func.body;
            ExternalFunction efunc = CifConstructors.newExternalFunction();
            efunc.setName(func.name.id);
            efunc.setPosition(func.createPosition());
            efunc.setFunction(body.functionRef);
            FunctionScope scope = new FunctionScope((Function)efunc, func, parent, this.tchecker);
            parent.getComplexComponent().getDeclarations().add((Object)efunc);
            for (AFuncParam param : func.parameters) {
                this.addFunctionParams(param, scope);
            }
        }
    }

    private void addFunctionParams(AFuncParam params, FunctionScope parent) {
        for (AIdentifier id : params.names) {
            DiscVariable var = CifConstructors.newDiscVariable();
            var.setName(id.id);
            var.setPosition(id.createPosition());
            FunctionParameter param = CifConstructors.newFunctionParameter();
            param.setPosition(id.createPosition());
            param.setParameter(var);
            FuncParamDeclWrap wrapper = new FuncParamDeclWrap(this.tchecker, parent, params, param);
            parent.addDeclaration(wrapper);
            ((Function)parent.getObject()).getParameters().add((Object)param);
        }
    }

    private void addFunctionLocalVars(ADiscVariableDecl vars, FunctionScope parent) {
        for (ADiscVariable var1 : vars.variables) {
            DiscVariable var2 = CifConstructors.newDiscVariable();
            var2.setName(var1.name.id);
            var2.setPosition(var1.createPosition());
            FuncVariableDeclWrap wrapper = new FuncVariableDeclWrap(this.tchecker, parent, vars, var1, var2);
            parent.addDeclaration(wrapper);
            InternalFunction ifunc = (InternalFunction)parent.getObject();
            ifunc.getVariables().add((Object)var2);
        }
    }

    private void addImports(AImportDecl imports) {
        for (AImport imp : imports.imports) {
            this.addImport(imp);
        }
    }

    private void addImport(AImport imp) {
        SourceFile prevSourceFile;
        TextPosition prevPos;
        String impPath = imp.source.txt;
        String impAbsPath = this.sourceFile.resolve(impPath);
        TextPosition problemPos = this.sourceFile.main ? imp.position : this.sourceFile.problemPos;
        SourceFile newSourceFile = new SourceFile(impAbsPath, false, imp.position, problemPos);
        if (impAbsPath.equals(this.sourceFile.absPath)) {
            this.tchecker.addProblem(ErrMsg.IMPORT_SELF, imp.position, new String[0]);
        }
        if ((prevPos = this.imports.put(impAbsPath, imp.position)) != null) {
            String relPath = newSourceFile.getRelativePathFrom(this.mainFile);
            this.tchecker.addProblem(ErrMsg.DUPL_IMPORT, prevPos, relPath);
            this.tchecker.addProblem(ErrMsg.DUPL_IMPORT, imp.position, relPath);
        }
        if ((prevSourceFile = this.tchecker.sourceFiles.get(impAbsPath)) != null) {
            return;
        }
        this.tchecker.sourceFiles.add(newSourceFile);
    }

    private static InvKind transInvKind(Token kind) {
        if (kind == null) {
            return InvKind.STATE;
        }
        return InvKind.valueOf((String)("EVENT_" + kind.text.toUpperCase(Locale.US)));
    }

    private static SupKind transInvSupKind(Token kind) {
        if (kind == null) {
            return SupKind.NONE;
        }
        return SupKind.valueOf((String)kind.text.toUpperCase(Locale.US));
    }
}

