/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class GridBox
extends Box {
    private final Box[][] cells;
    private final int numRows;
    private final int numCols;
    private final int colSpace;
    private final int rowSpace;

    public GridBox(int numRows, int numCols) {
        this(numRows, numCols, 0, 0);
    }

    public GridBox(int numRows, int numCols, int rowSpace, int colSpace) {
        this.cells = new Box[numRows][numCols];
        this.numRows = numRows;
        this.numCols = numCols;
        this.rowSpace = rowSpace;
        this.colSpace = colSpace;
    }

    public Box get(int row, int col) {
        return this.cells[row][col];
    }

    public void set(int row, int col, Box box) {
        this.cells[row][col] = box;
    }

    public void set(int row, int col, String txt) {
        this.set(row, col, new TextBox(txt));
    }

    @Override
    public List<String> getLines() {
        if (this.numRows == 0) {
            return Lists.list();
        }
        GridBoxLayout layout = this.computeLayout();
        StringBuilder[] buffers = new StringBuilder[layout.totalHeight];
        int lineIdx = 0;
        while (lineIdx < layout.totalHeight) {
            buffers[lineIdx] = new StringBuilder(layout.totalWidth);
            ++lineIdx;
        }
        String colSpaceText = Strings.spaces((int)this.colSpace);
        int colIdx = 0;
        while (colIdx < this.numCols) {
            int lineIdx2 = 0;
            int rowIdx = 0;
            while (rowIdx < this.numRows) {
                String line;
                if (rowIdx > 0) {
                    lineIdx2 += this.rowSpace;
                }
                int count = 0;
                String[] cellLines = layout.txts[rowIdx][colIdx];
                if (cellLines != null) {
                    String[] stringArray = cellLines;
                    int n = cellLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        line = stringArray[n2];
                        if (colIdx > 0) {
                            buffers[lineIdx2].append(colSpaceText);
                        }
                        line = StringUtils.rightPad((String)line, (int)layout.widths[colIdx]);
                        buffers[lineIdx2].append(line);
                        ++lineIdx2;
                        ++count;
                        ++n2;
                    }
                }
                if (count < layout.heights[rowIdx]) {
                    line = Strings.spaces((int)layout.widths[colIdx]);
                    if (colIdx > 0) {
                        line = String.valueOf(colSpaceText) + line;
                    }
                    while (count < layout.heights[rowIdx]) {
                        buffers[lineIdx2].append(line);
                        ++lineIdx2;
                        ++count;
                    }
                }
                ++rowIdx;
            }
            ++colIdx;
        }
        List lines = Lists.list();
        int idx = 0;
        while (idx < layout.totalHeight) {
            lines.add(StringUtils.stripEnd((String)buffers[idx].toString(), (String)" "));
            ++idx;
        }
        return lines;
    }

    public GridBoxLayout computeLayout() {
        GridBoxLayout layout = new GridBoxLayout();
        layout.numCols = this.numCols;
        layout.numRows = this.numRows;
        layout.widths = new int[this.numCols];
        layout.heights = new int[this.numRows];
        layout.txts = new String[this.numRows][this.numCols][];
        int rowIdx = 0;
        while (rowIdx < this.numRows) {
            int colIdx = 0;
            while (colIdx < this.numCols) {
                List<String> lines;
                Box box = this.cells[rowIdx][colIdx];
                String[] cellLines = null;
                if (box != null && !(lines = box.getLines()).isEmpty()) {
                    cellLines = new String[lines.size()];
                    lines.toArray(cellLines);
                    layout.txts[rowIdx][colIdx] = cellLines;
                }
                if (cellLines != null) {
                    layout.heights[rowIdx] = Math.max(layout.heights[rowIdx], cellLines.length);
                    int cellWidth = 0;
                    String[] stringArray = cellLines;
                    int n = cellLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        cellWidth = Math.max(cellWidth, line.length());
                        ++n2;
                    }
                    layout.widths[colIdx] = Math.max(layout.widths[colIdx], cellWidth);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        rowIdx = 0;
        while (rowIdx < this.numRows) {
            if (rowIdx > 0) {
                layout.totalHeight += this.rowSpace;
            }
            layout.totalHeight += layout.heights[rowIdx];
            ++rowIdx;
        }
        int colIdx = 0;
        while (colIdx < this.numCols) {
            if (colIdx > 0) {
                layout.totalWidth += this.colSpace;
            }
            layout.totalWidth += layout.widths[colIdx];
            ++colIdx;
        }
        return layout;
    }

    public static class GridBoxLayout {
        public int numRows;
        public int numCols;
        public int[] widths;
        public int[] heights;
        public int totalWidth;
        public int totalHeight;
        public String[][][] txts;
    }
}

