/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.dsm.ClusterInputData;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ReadMatrix {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern QUOTED_ENTRY_PATTERN = Pattern.compile("\\\"[^\\\"]*\\\"");
    private static final Pattern REGULAR_ENTRY_PATTERN = Pattern.compile("[^, ]*");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");

    private ReadMatrix() {
    }

    private static List<String> parseLine(String line) throws IOException {
        List entries = Lists.list();
        Matcher whitespaceMatcher = WHITESPACE_PATTERN.matcher(line);
        Matcher quotedEntryMatcher = QUOTED_ENTRY_PATTERN.matcher(line);
        Matcher regularEntryMatcher = REGULAR_ENTRY_PATTERN.matcher(line);
        Matcher separatorMatcher = SEPARATOR_PATTERN.matcher(line);
        int index = 0;
        while (true) {
            String entry;
            if (whitespaceMatcher.find(index) && whitespaceMatcher.start() == index) {
                index = whitespaceMatcher.end();
            }
            if (quotedEntryMatcher.find(index) && quotedEntryMatcher.start() == index) {
                entry = Strings.slice((String)quotedEntryMatcher.group(), (Integer)1, (Integer)-1);
                entries.add(entry);
                index = quotedEntryMatcher.end();
            } else {
                Assert.check((boolean)regularEntryMatcher.find(index));
                Assert.areEqual((Object)regularEntryMatcher.start(), (Object)index);
                entry = regularEntryMatcher.group();
                entries.add(entry);
                index = regularEntryMatcher.end();
            }
            if (whitespaceMatcher.find(index) && whitespaceMatcher.start() == index) {
                index = whitespaceMatcher.end();
            }
            if (!separatorMatcher.find(index) || separatorMatcher.start() != index) break;
            index = separatorMatcher.end();
        }
        if (index != line.length()) {
            throw new IOException(Strings.fmt((String)"Failed to parse matrix line at position %d.", (Object[])new Object[]{index + 1}));
        }
        return entries;
    }

    static ClusterInputData convertToMatrix(List<List<String>> matrixLines) throws IOException {
        int firstDataLine;
        int matRowCount = matrixLines.size();
        int matColcount = matrixLines.stream().map(row -> row.size()).max(Math::max).orElseGet(() -> 0);
        if (matRowCount > 1 && matRowCount == matColcount) {
            firstDataLine = 1;
        } else if (matRowCount >= 1 && matRowCount + 1 == matColcount) {
            firstDataLine = 0;
        } else {
            String msg = "Matrix data is not square, found %d rows and %d columns, excluding first label column.";
            throw new IOException(Strings.fmt((String)msg, (Object[])new Object[]{matRowCount, matColcount - 1}));
        }
        int size = matRowCount - firstDataLine;
        BlockRealMatrix adjMat = new BlockRealMatrix(size, size);
        Label[] rowLabels = new Label[size];
        int row2 = 0;
        while (row2 < size) {
            List<String> line = matrixLines.get(firstDataLine + row2);
            rowLabels[row2] = line.size() > 0 ? new Label(line.get(0)) : new Label("");
            int col = 0;
            while (col < size) {
                double value;
                if (line.size() <= col + 1) break;
                String valueText = line.get(col + 1);
                if (valueText.isBlank()) {
                    value = 0.0;
                } else {
                    try {
                        value = Double.parseDouble(valueText);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException(Strings.fmt((String)"Value \"%s\" is not numeric.", (Object[])new Object[]{valueText}));
                    }
                }
                if (value < 0.0) {
                    throw new IOException(Strings.fmt((String)"Value \"%s\" is negative.", (Object[])new Object[]{valueText}));
                }
                if (Double.isNaN(value)) {
                    throw new IOException(Strings.fmt((String)"Value \"%s\" is not a number.", (Object[])new Object[]{valueText}));
                }
                if (Double.isInfinite(value)) {
                    throw new IOException(Strings.fmt((String)"Value \"%s\" is infinite.", (Object[])new Object[]{valueText}));
                }
                adjMat.setEntry(row2, col, value);
                ++col;
            }
            while (col < size) {
                adjMat.setEntry(row2, col, 0.0);
                ++col;
            }
            ++row2;
        }
        if (firstDataLine == 1) {
            List<String> firstLine = matrixLines.get(0);
            String topLeftCell = (String)Lists.first(firstLine);
            if (!topLeftCell.isEmpty()) {
                throw new IOException(Strings.fmt((String)"The top-left cell of the matrix contains \"%s\" rather than being empty.", (Object[])new Object[]{topLeftCell}));
            }
            Label[] colLabels = (Label[])Lists.slice(firstLine, (Integer)1, null).stream().map(l -> new Label((String)l)).toArray(Label[]::new);
            Assert.areEqual((Object)rowLabels.length, (Object)size);
            Assert.areEqual((Object)colLabels.length, (Object)size);
            int i = 0;
            while (i < size) {
                if (!rowLabels[i].equals(colLabels[i])) {
                    throw new IOException(Strings.fmt((String)"Row label \"%s\" is different from column label \"%s\".", (Object[])new Object[]{rowLabels[i], colLabels[i]}));
                }
                ++i;
            }
        }
        return new ClusterInputData((RealMatrix)adjMat, rowLabels);
    }

    static List<List<String>> readMatrixLines(BufferedReader reader) throws IOException {
        List matrixValues = Lists.list();
        int lineNr = 0;
        while (true) {
            List<String> words;
            String line;
            ++lineNr;
            try {
                line = reader.readLine();
            }
            catch (IOException ex) {
                throw new IOException(Strings.fmt((String)"Failed to read matrix line %d.", (Object[])new Object[]{lineNr}), ex);
            }
            if (line == null) break;
            try {
                words = ReadMatrix.parseLine(line);
            }
            catch (IOException ex) {
                throw new IOException(Strings.fmt((String)"Failed to parse matrix line %d.", (Object[])new Object[]{lineNr}), ex);
            }
            matrixValues.add(words);
        }
        return matrixValues;
    }

    public static ClusterInputData readMatrixFile(String filepath) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filepath));){
                List<List<String>> matrixLines = ReadMatrix.readMatrixLines(reader);
                return ReadMatrix.convertToMatrix(matrixLines);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new InputOutputException(Strings.fmt((String)"Failed to read or interpret matrix file \"%s\".", (Object[])new Object[]{filepath}), (Throwable)ex);
        }
    }
}

